/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.sql.app;

import dagger.assisted.AssistedFactory;
import de.ii.xtraplatform.base.domain.LogContext;
import de.ii.xtraplatform.cql.domain.Cql;
import de.ii.xtraplatform.crs.domain.CrsTransformerFactory;
import de.ii.xtraplatform.crs.domain.EpsgCrs;
import de.ii.xtraplatform.crs.domain.OgcCrs;
import de.ii.xtraplatform.features.domain.ConnectorFactory;
import de.ii.xtraplatform.features.domain.FeatureProviderDataV2;
import de.ii.xtraplatform.features.domain.FeatureSchema;
import de.ii.xtraplatform.features.domain.ImmutableFeatureSchema;
import de.ii.xtraplatform.features.domain.ProviderExtensionRegistry;
import de.ii.xtraplatform.features.domain.SchemaBase;
import de.ii.xtraplatform.features.sql.app.FeatureProviderSql;
import de.ii.xtraplatform.features.sql.domain.ConnectionInfoSql;
import de.ii.xtraplatform.features.sql.domain.FeatureProviderSqlData;
import de.ii.xtraplatform.features.sql.domain.ImmutableFeatureProviderSqlData;
import de.ii.xtraplatform.features.sql.domain.SqlConnector;
import de.ii.xtraplatform.features.sql.domain.SqlDialectGpkg;
import de.ii.xtraplatform.features.sql.domain.SqlDialectPostGis;
import de.ii.xtraplatform.features.sql.infra.db.SchemaGeneratorSql;
import de.ii.xtraplatform.store.domain.entities.AbstractEntityFactory;
import de.ii.xtraplatform.store.domain.entities.EntityData;
import de.ii.xtraplatform.store.domain.entities.EntityDataBuilder;
import de.ii.xtraplatform.store.domain.entities.EntityFactory;
import de.ii.xtraplatform.store.domain.entities.EntityRegistry;
import de.ii.xtraplatform.store.domain.entities.PersistentEntity;
import de.ii.xtraplatform.streams.domain.Reactive;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shadow.com.github.azahnen.dagger.annotations.AutoBind;
import shadow.com.google.common.collect.ImmutableList;
import shadow.com.google.common.collect.ImmutableMap;
import shadow.javax.inject.Inject;
import shadow.javax.inject.Singleton;

@Singleton
@AutoBind
public class FeatureProviderSqlFactory
extends AbstractEntityFactory<FeatureProviderDataV2, FeatureProviderSql>
implements EntityFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeatureProviderSqlFactory.class);
    private final ConnectorFactory connectorFactory;

    @Inject
    public FeatureProviderSqlFactory(CrsTransformerFactory crsTransformerFactory, Cql cql, ConnectorFactory connectorFactory, Reactive reactive, EntityRegistry entityRegistry, ProviderExtensionRegistry extensionRegistry, ProviderSqlFactoryAssisted providerSqlFactoryAssisted) {
        super(providerSqlFactoryAssisted);
        this.connectorFactory = connectorFactory;
    }

    @Override
    public String type() {
        return "providers";
    }

    @Override
    public Optional<String> subType() {
        return Optional.of("feature/sql");
    }

    @Override
    public Class<? extends PersistentEntity> entityClass() {
        return FeatureProviderSql.class;
    }

    public EntityDataBuilder<FeatureProviderDataV2> dataBuilder() {
        return new ImmutableFeatureProviderSqlData.Builder();
    }

    @Override
    public Class<? extends EntityData> dataClass() {
        return FeatureProviderSqlData.class;
    }

    @Override
    public EntityData hydrateData(EntityData entityData) {
        FeatureProviderSqlData data = (FeatureProviderSqlData)entityData;
        if (data.isAuto()) {
            LOGGER.info("Feature provider with id '{}' is in auto mode, generating configuration ...", (Object)data.getId());
        }
        try {
            return this.cleanupAutoPersist(this.cleanupAdditionalInfo(this.generateNativeCrsIfNecessary(this.generateTypesIfNecessary(data))));
        }
        catch (Throwable e) {
            LogContext.error(LOGGER, e, "Feature provider with id '{}' could not be hydrated", data.getId());
            throw new IllegalStateException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FeatureProviderSqlData generateTypesIfNecessary(FeatureProviderSqlData data) {
        if (data.isAuto() && data.getTypes().isEmpty()) {
            SqlConnector connector = (SqlConnector)this.connectorFactory.createConnector(data);
            try {
                ConnectionInfoSql connectionInfo = data.getConnectionInfo();
                List<String> schemas = connectionInfo.getSchemas().isEmpty() ? (connectionInfo.getDialect() == ConnectionInfoSql.Dialect.GPKG ? ImmutableList.of() : ImmutableList.of("public")) : connectionInfo.getSchemas();
                SchemaGeneratorSql schemaGeneratorSql = new SchemaGeneratorSql(connector.getSqlClient(), schemas, data.getAutoTypes(), connectionInfo.getDialect() == ConnectionInfoSql.Dialect.GPKG ? new SqlDialectGpkg() : new SqlDialectPostGis());
                List<FeatureSchema> types = schemaGeneratorSql.generate();
                LinkedHashMap idCounter = new LinkedHashMap();
                types.forEach(featureSchema -> featureSchema.getProperties().stream().filter(SchemaBase::isId).map(FeatureSchema::getSourcePath).filter(Optional::isPresent).map(Optional::get).findFirst().ifPresent(path -> {
                    if (!idCounter.containsKey(path)) {
                        idCounter.put(path, 0);
                    }
                    idCounter.put(path, (Integer)idCounter.get(path) + 1);
                }));
                String mostOftenUsedId = idCounter.entrySet().stream().max(Comparator.comparingInt(Map.Entry::getValue)).map(Map.Entry::getKey).orElse("id");
                ImmutableMap<String, FeatureSchema> typeMap = types.stream().map(type -> {
                    Optional<String> differingSortKey = type.getIdProperty().filter(idProperty -> !Objects.equals(idProperty.getName(), mostOftenUsedId)).map(FeatureSchema::getName);
                    if (differingSortKey.isPresent() && type.getSourcePath().isPresent()) {
                        return new ImmutableFeatureSchema.Builder().from((FeatureSchema)type).sourcePath(String.format("%s{sortKey=%s}", type.getSourcePath().get(), differingSortKey.get())).build();
                    }
                    return type;
                }).map(type -> new AbstractMap.SimpleImmutableEntry<String, FeatureSchema>(type.getName(), (FeatureSchema)type)).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
                ImmutableFeatureProviderSqlData.Builder builder = new ImmutableFeatureProviderSqlData.Builder().from(data).types(typeMap);
                if (!Objects.equals(mostOftenUsedId, "id")) {
                    builder.sourcePathDefaultsBuilder().primaryKey(mostOftenUsedId).sortKey(mostOftenUsedId);
                }
                ImmutableFeatureProviderSqlData immutableFeatureProviderSqlData = builder.build();
                return immutableFeatureProviderSqlData;
            }
            finally {
                this.connectorFactory.disposeConnector(connector);
            }
        }
        return data;
    }

    private FeatureProviderSqlData generateNativeCrsIfNecessary(FeatureProviderSqlData data) {
        if (data.isAuto() && !data.getNativeCrs().isPresent()) {
            EpsgCrs nativeCrs = data.getTypes().values().stream().flatMap(type -> type.getProperties().stream()).filter(property -> property.isSpatial() && property.getAdditionalInfo().containsKey("crs")).findFirst().map(property -> EpsgCrs.fromString(property.getAdditionalInfo().get("crs"))).orElseGet(() -> OgcCrs.CRS84);
            return new ImmutableFeatureProviderSqlData.Builder().from(data).nativeCrs(nativeCrs).build();
        }
        return data;
    }

    private FeatureProviderSqlData cleanupAdditionalInfo(FeatureProviderSqlData data) {
        if (data.isAuto()) {
            return new ImmutableFeatureProviderSqlData.Builder().from(data).types((Map<String, FeatureSchema>)data.getTypes().entrySet().stream().map(entry -> new AbstractMap.SimpleImmutableEntry<String, ImmutableFeatureSchema>((String)entry.getKey(), new ImmutableFeatureSchema.Builder().from((FeatureSchema)entry.getValue()).additionalInfo(ImmutableMap.of()).propertyMap((Map<String, FeatureSchema>)((FeatureSchema)entry.getValue()).getPropertyMap().entrySet().stream().map(entry2 -> new AbstractMap.SimpleImmutableEntry<String, ImmutableFeatureSchema>((String)entry2.getKey(), new ImmutableFeatureSchema.Builder().from((FeatureSchema)entry2.getValue()).additionalInfo(ImmutableMap.of()).build())).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue))).build())).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue))).build();
        }
        return data;
    }

    private FeatureProviderSqlData cleanupAutoPersist(FeatureProviderSqlData data) {
        if (data.isAuto() && data.isAutoPersist()) {
            return new ImmutableFeatureProviderSqlData.Builder().from(data).auto(Optional.empty()).autoPersist(Optional.empty()).autoTypes(new ArrayList<String>()).build();
        }
        return data;
    }

    @AssistedFactory
    public static interface ProviderSqlFactoryAssisted
    extends AbstractEntityFactory.FactoryAssisted<FeatureProviderDataV2, FeatureProviderSql> {
        @Override
        public FeatureProviderSql create(FeatureProviderDataV2 var1);
    }
}

