/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.sql.app;

import dagger.assisted.Assisted;
import dagger.assisted.AssistedInject;
import de.ii.xtraplatform.codelists.domain.Codelist;
import de.ii.xtraplatform.cql.domain.Cql;
import de.ii.xtraplatform.crs.domain.BoundingBox;
import de.ii.xtraplatform.crs.domain.CrsInfo;
import de.ii.xtraplatform.crs.domain.CrsTransformerFactory;
import de.ii.xtraplatform.crs.domain.EpsgCrs;
import de.ii.xtraplatform.crs.domain.OgcCrs;
import de.ii.xtraplatform.features.domain.AbstractFeatureProvider;
import de.ii.xtraplatform.features.domain.ConnectionInfo;
import de.ii.xtraplatform.features.domain.ConnectorFactory;
import de.ii.xtraplatform.features.domain.ExtentReader;
import de.ii.xtraplatform.features.domain.FeatureCrs;
import de.ii.xtraplatform.features.domain.FeatureEventHandler;
import de.ii.xtraplatform.features.domain.FeatureExtents;
import de.ii.xtraplatform.features.domain.FeatureProvider2;
import de.ii.xtraplatform.features.domain.FeatureProviderDataV2;
import de.ii.xtraplatform.features.domain.FeatureQueries;
import de.ii.xtraplatform.features.domain.FeatureQuery;
import de.ii.xtraplatform.features.domain.FeatureQueryTransformer;
import de.ii.xtraplatform.features.domain.FeatureSchema;
import de.ii.xtraplatform.features.domain.FeatureStoreAttribute;
import de.ii.xtraplatform.features.domain.FeatureStorePathParser;
import de.ii.xtraplatform.features.domain.FeatureStoreTypeInfo;
import de.ii.xtraplatform.features.domain.FeatureStream;
import de.ii.xtraplatform.features.domain.FeatureTokenDecoder;
import de.ii.xtraplatform.features.domain.FeatureTokenSource;
import de.ii.xtraplatform.features.domain.FeatureTransactions;
import de.ii.xtraplatform.features.domain.ImmutableMutationResult;
import de.ii.xtraplatform.features.domain.ProviderExtensionRegistry;
import de.ii.xtraplatform.features.domain.SchemaMapping;
import de.ii.xtraplatform.features.domain.TypeInfoValidator;
import de.ii.xtraplatform.features.sql.ImmutableSqlPathSyntax;
import de.ii.xtraplatform.features.sql.app.ExtentReaderSql;
import de.ii.xtraplatform.features.sql.app.FeatureDecoderSql;
import de.ii.xtraplatform.features.sql.app.FeatureEncoderSql2;
import de.ii.xtraplatform.features.sql.app.FeatureMutationsSql;
import de.ii.xtraplatform.features.sql.app.FeatureQueryTransformerSql;
import de.ii.xtraplatform.features.sql.app.FeatureSchemaSwapperSql;
import de.ii.xtraplatform.features.sql.app.FeatureSql;
import de.ii.xtraplatform.features.sql.app.FeatureStorePathParserSql;
import de.ii.xtraplatform.features.sql.app.FeatureStoreQueryGeneratorSql;
import de.ii.xtraplatform.features.sql.app.FilterEncoderSql;
import de.ii.xtraplatform.features.sql.app.MutationSchemaBuilderSql;
import de.ii.xtraplatform.features.sql.app.MutationSchemaDeriver;
import de.ii.xtraplatform.features.sql.app.PathParserSql;
import de.ii.xtraplatform.features.sql.app.QuerySchemaDeriver;
import de.ii.xtraplatform.features.sql.app.SqlInsertGenerator2;
import de.ii.xtraplatform.features.sql.app.SqlQueryTemplates;
import de.ii.xtraplatform.features.sql.app.SqlQueryTemplatesDeriver;
import de.ii.xtraplatform.features.sql.domain.ConnectionInfoSql;
import de.ii.xtraplatform.features.sql.domain.FeatureProviderSqlData;
import de.ii.xtraplatform.features.sql.domain.ImmutableSchemaMappingSql;
import de.ii.xtraplatform.features.sql.domain.SchemaSql;
import de.ii.xtraplatform.features.sql.domain.SqlClient;
import de.ii.xtraplatform.features.sql.domain.SqlConnector;
import de.ii.xtraplatform.features.sql.domain.SqlDialect;
import de.ii.xtraplatform.features.sql.domain.SqlDialectGpkg;
import de.ii.xtraplatform.features.sql.domain.SqlDialectPostGis;
import de.ii.xtraplatform.features.sql.domain.SqlPathDefaults;
import de.ii.xtraplatform.features.sql.domain.SqlPathParser;
import de.ii.xtraplatform.features.sql.domain.SqlQueries;
import de.ii.xtraplatform.features.sql.domain.SqlQueryOptions;
import de.ii.xtraplatform.features.sql.domain.SqlRow;
import de.ii.xtraplatform.features.sql.infra.db.SqlTypeInfoValidator;
import de.ii.xtraplatform.store.domain.entities.EntityRegistry;
import de.ii.xtraplatform.streams.domain.Reactive;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shadow.com.fasterxml.jackson.core.JsonParseException;
import shadow.com.google.common.collect.ImmutableList;
import shadow.com.google.common.collect.ImmutableMap;
import shadow.org.postgresql.util.PSQLException;
import shadow.org.threeten.extra.Interval;

public class FeatureProviderSql
extends AbstractFeatureProvider<SqlRow, SqlQueries, SqlQueryOptions>
implements FeatureProvider2,
FeatureQueries,
FeatureExtents,
FeatureCrs,
FeatureTransactions {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeatureProviderSql.class);
    public static final String ENTITY_SUB_TYPE = "feature/sql";
    public static final String PROVIDER_TYPE = "SQL";
    private final CrsTransformerFactory crsTransformerFactory;
    private final Cql cql;
    private final EntityRegistry entityRegistry;
    private FeatureQueryTransformerSql queryTransformer;
    private ExtentReader extentReader;
    private FeatureMutationsSql featureMutationsSql;
    private FeatureSchemaSwapperSql schemaSwapperSql;
    private FeatureStorePathParser pathParser;
    private PathParserSql pathParser2;
    private SqlPathParser pathParser3;
    private TypeInfoValidator typeInfoValidator;
    private Map<String, Optional<BoundingBox>> spatialExtentCache;
    private Map<String, Optional<Interval>> temporalExtentCache;
    private Map<String, List<SchemaSql>> tableSchemas;

    @AssistedInject
    public FeatureProviderSql(CrsTransformerFactory crsTransformerFactory, Cql cql, ConnectorFactory connectorFactory, Reactive reactive, EntityRegistry entityRegistry, ProviderExtensionRegistry extensionRegistry, @Assisted FeatureProviderDataV2 data) {
        super(connectorFactory, reactive, crsTransformerFactory, extensionRegistry, data);
        this.crsTransformerFactory = crsTransformerFactory;
        this.cql = cql;
        this.entityRegistry = entityRegistry;
    }

    public static FeatureStorePathParser createPathParser(SqlPathDefaults sqlPathDefaults, Cql cql) {
        ImmutableSqlPathSyntax syntax = ImmutableSqlPathSyntax.builder().options(sqlPathDefaults).build();
        return new FeatureStorePathParserSql(syntax, cql);
    }

    private static FeatureSchemaSwapperSql createSchemaSwapper(SqlPathDefaults sqlPathDefaults, Cql cql) {
        ImmutableSqlPathSyntax syntax = ImmutableSqlPathSyntax.builder().options(sqlPathDefaults).build();
        return new FeatureSchemaSwapperSql(syntax, cql);
    }

    private static PathParserSql createPathParser2(SqlPathDefaults sqlPathDefaults, Cql cql) {
        ImmutableSqlPathSyntax syntax = ImmutableSqlPathSyntax.builder().options(sqlPathDefaults).build();
        return new PathParserSql(syntax, cql);
    }

    private static SqlPathParser createPathParser3(SqlPathDefaults sqlPathDefaults, Cql cql) {
        return new SqlPathParser(sqlPathDefaults, cql);
    }

    @Override
    protected boolean onStartup() throws InterruptedException {
        this.pathParser = FeatureProviderSql.createPathParser(this.getData().getSourcePathDefaults(), this.cql);
        List<String> validationSchemas = this.getData().getConnectionInfo().getDialect() == ConnectionInfoSql.Dialect.PGIS && this.getData().getConnectionInfo().getSchemas().isEmpty() ? ImmutableList.of("public") : this.getData().getConnectionInfo().getSchemas();
        this.typeInfoValidator = new SqlTypeInfoValidator(validationSchemas, this::getSqlClient);
        boolean success = super.onStartup();
        if (!success) {
            return false;
        }
        SqlDialect sqlDialect = this.getData().getConnectionInfo().getDialect() == ConnectionInfoSql.Dialect.PGIS ? new SqlDialectPostGis() : new SqlDialectGpkg();
        String accentiCollation = Objects.nonNull(this.getData().getQueryGeneration()) ? (String)this.getData().getQueryGeneration().getAccentiCollation().orElse(null) : null;
        FilterEncoderSql filterEncoder = new FilterEncoderSql(this.getData().getNativeCrs().orElse(OgcCrs.CRS84), sqlDialect, this.crsTransformerFactory, this.cql, accentiCollation);
        FeatureStoreQueryGeneratorSql queryGeneratorSql = new FeatureStoreQueryGeneratorSql(sqlDialect, this.getData().getNativeCrs().orElse(OgcCrs.CRS84), this.crsTransformerFactory);
        this.pathParser3 = FeatureProviderSql.createPathParser3(this.getData().getSourcePathDefaults(), this.cql);
        QuerySchemaDeriver querySchemaDeriver = new QuerySchemaDeriver(this.pathParser3);
        SqlQueryTemplatesDeriver queryTemplatesDeriver = new SqlQueryTemplatesDeriver(filterEncoder, sqlDialect, this.getData().getQueryGeneration().getComputeNumberMatched());
        this.tableSchemas = this.getData().getTypes().entrySet().stream().map(entry -> new AbstractMap.SimpleImmutableEntry<String, List<SchemaSql>>((String)entry.getKey(), ((FeatureSchema)entry.getValue()).accept(querySchemaDeriver))).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        Map schemas = this.getData().getTypes().entrySet().stream().map(entry -> new AbstractMap.SimpleImmutableEntry<String, ImmutableList<SqlQueryTemplates>>((String)entry.getKey(), ImmutableList.of(((FeatureSchema)entry.getValue()).accept(querySchemaDeriver).get(0).accept(queryTemplatesDeriver)))).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        this.queryTransformer = new FeatureQueryTransformerSql(schemas, this.getTypeInfos());
        this.extentReader = new ExtentReaderSql(this::getSqlClient, queryGeneratorSql, sqlDialect, this.getData().getNativeCrs().orElse(OgcCrs.CRS84));
        this.featureMutationsSql = new FeatureMutationsSql(this::getSqlClient, new SqlInsertGenerator2(this.getData().getNativeCrs().orElse(OgcCrs.CRS84), this.crsTransformerFactory, this.getData().getSourcePathDefaults()));
        this.schemaSwapperSql = FeatureProviderSql.createSchemaSwapper(this.getData().getSourcePathDefaults(), this.cql);
        this.pathParser2 = FeatureProviderSql.createPathParser2(this.getData().getSourcePathDefaults(), this.cql);
        this.spatialExtentCache = new HashMap<String, Optional<BoundingBox>>();
        this.temporalExtentCache = new HashMap<String, Optional<Interval>>();
        return true;
    }

    @Override
    protected void onStarted() {
        super.onStarted();
        if (Runtime.getRuntime().availableProcessors() > this.getStreamRunner().getCapacity()) {
            LOGGER.info("Recommended max connections for optimal performance under load: {}", (Object)(this.getMaxQueries() * Runtime.getRuntime().availableProcessors()));
        }
        LinkedHashMap<String, List<SchemaSql>> sourceSchema = new LinkedHashMap<String, List<SchemaSql>>();
        try {
            for (FeatureSchema fs : this.getData().getTypes().values()) {
                sourceSchema.put(fs.getName(), fs.accept(new MutationSchemaDeriver(this.pathParser2, this.pathParser3)));
            }
        }
        finally {
            boolean br = true;
        }
        {
        }
    }

    @Override
    protected int getRunnerCapacity(ConnectionInfo connectionInfo) {
        ConnectionInfoSql connectionInfoSql = (ConnectionInfoSql)connectionInfo;
        int maxConnections = connectionInfoSql.getPool().getMaxConnections();
        int runnerCapacity = Runtime.getRuntime().availableProcessors();
        if (maxConnections > 0) {
            for (FeatureStoreTypeInfo typeInfo : this.getTypeInfos().values()) {
                int numberOfQueries = typeInfo.getInstanceContainers().get(0).getAllAttributesContainers().size();
                int capacity = maxConnections / numberOfQueries;
                if (capacity < 0 || capacity >= runnerCapacity) continue;
                runnerCapacity = capacity;
            }
        }
        return runnerCapacity;
    }

    @Override
    protected int getRunnerQueueSize(ConnectionInfo connectionInfo) {
        ConnectionInfoSql connectionInfoSql = (ConnectionInfoSql)connectionInfo;
        int maxQueries = this.getMaxQueries();
        int maxConnections = connectionInfoSql.getPool().getMaxConnections() > 0 ? connectionInfoSql.getPool().getMaxConnections() : maxQueries * Runtime.getRuntime().availableProcessors();
        int capacity = maxConnections / maxQueries;
        int queueSize = Math.max(1024, maxConnections * capacity * 2) / maxQueries;
        return queueSize;
    }

    private int getMaxQueries() {
        int maxQueries = 0;
        for (FeatureStoreTypeInfo typeInfo : this.getTypeInfos().values()) {
            int numberOfQueries = typeInfo.getInstanceContainers().get(0).getAllAttributesContainers().size();
            if (numberOfQueries <= maxQueries) continue;
            maxQueries = numberOfQueries;
        }
        return maxQueries <= 0 ? 1 : maxQueries;
    }

    @Override
    protected Optional<String> getRunnerError(ConnectionInfo connectionInfo) {
        if (this.getStreamRunner().getCapacity() == 0) {
            ConnectionInfoSql connectionInfoSql = (ConnectionInfoSql)connectionInfo;
            int maxConnections = connectionInfoSql.getPool().getMaxConnections();
            int minRequired = 0;
            for (FeatureStoreTypeInfo typeInfo : this.getTypeInfos().values()) {
                int numberOfQueries = typeInfo.getInstanceContainers().get(0).getAllAttributesContainers().size();
                if (numberOfQueries <= minRequired) continue;
                minRequired = numberOfQueries;
            }
            return Optional.of(String.format("maxConnections=%d is too low, a minimum of %d is required", maxConnections, minRequired));
        }
        return Optional.empty();
    }

    @Override
    protected FeatureStorePathParser getPathParser() {
        return this.pathParser;
    }

    @Override
    protected Optional<Map<String, String>> getStartupInfo() {
        String parallelism = String.valueOf(this.getStreamRunner().getCapacity());
        ImmutableMap.Builder<String, String> info = new ImmutableMap.Builder<String, String>().put("min connections", String.valueOf(this.getConnector().getMinConnections())).put("max connections", String.valueOf(this.getConnector().getMaxConnections())).put("stream capacity", parallelism);
        if (this.getData().getConnectionInfo().isShared()) {
            info.put("shared", "true");
        }
        return Optional.of(info.build());
    }

    @Override
    protected Optional<TypeInfoValidator> getTypeInfoValidator() {
        return Optional.ofNullable(this.typeInfoValidator);
    }

    @Override
    protected FeatureTokenDecoder<SqlRow, FeatureSchema, SchemaMapping, FeatureEventHandler.ModifiableContext<FeatureSchema, SchemaMapping>> getDecoder(FeatureQuery query) {
        return new FeatureDecoderSql(ImmutableList.of(this.getTypeInfos().get(query.getType())), this.tableSchemas.get(query.getType()), (FeatureSchema)this.getData().getTypes().get(query.getType()), query);
    }

    @Override
    protected Map<String, Codelist> getCodelists() {
        this.getData().getCodelists();
        return this.entityRegistry.getEntitiesForType(Codelist.class).stream().map(codelist -> new AbstractMap.SimpleImmutableEntry<String, Codelist>(codelist.getId(), (Codelist)codelist)).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Override
    public FeatureProviderSqlData getData() {
        return (FeatureProviderSqlData)super.getData();
    }

    @Override
    protected FeatureQueryTransformer<SqlQueries, SqlQueryOptions> getQueryTransformer() {
        return this.queryTransformer;
    }

    protected SqlConnector getConnector() {
        return (SqlConnector)super.getConnector();
    }

    private SqlClient getSqlClient() {
        return this.getConnector().getSqlClient();
    }

    @Override
    public boolean supportsCrs() {
        return super.supportsCrs() && this.getData().getNativeCrs().isPresent();
    }

    @Override
    public EpsgCrs getNativeCrs() {
        return this.getData().getNativeCrs().get();
    }

    @Override
    public boolean isCrsSupported(EpsgCrs crs) {
        return Objects.equals(this.getNativeCrs(), crs) || this.crsTransformerFactory.isSupported(crs);
    }

    @Override
    public boolean is3dSupported() {
        return ((CrsInfo)((Object)this.crsTransformerFactory)).is3d(this.getNativeCrs());
    }

    @Override
    public Optional<BoundingBox> getSpatialExtent(String typeName) {
        return this.spatialExtentCache.computeIfAbsent(typeName, ignore -> {
            Optional<FeatureStoreTypeInfo> typeInfo = Optional.ofNullable(this.getTypeInfos().get(typeName));
            if (!typeInfo.isPresent()) {
                return Optional.empty();
            }
            typeInfo.get().getInstanceContainers().get(0).getSpatialAttribute().map(FeatureStoreAttribute::getName).ifPresent(spatialProperty -> LOGGER.debug("Computing spatial extent for '{}.{}'", (Object)typeName, spatialProperty));
            try {
                Reactive.Stream<Optional<BoundingBox>> extentGraph = this.extentReader.getExtent(typeInfo.get());
                return extentGraph.on(this.getStreamRunner()).run().exceptionally(throwable -> Optional.empty()).toCompletableFuture().join();
            }
            catch (Throwable throwable2) {
                return Optional.empty();
            }
        });
    }

    @Override
    public Optional<BoundingBox> getSpatialExtent(String typeName, EpsgCrs crs) {
        return this.spatialExtentCache.computeIfAbsent(typeName + crs.toSimpleString(), ignore -> this.getSpatialExtent(typeName).flatMap(boundingBox -> this.crsTransformerFactory.getTransformer(this.getNativeCrs(), crs, true).flatMap(crsTransformer -> {
            try {
                return Optional.of(crsTransformer.transformBoundingBox((BoundingBox)boundingBox));
            }
            catch (Exception e) {
                return Optional.empty();
            }
        })));
    }

    @Override
    public Optional<Interval> getTemporalExtent(String typeName, String property) {
        return this.temporalExtentCache.computeIfAbsent(typeName + property, ignore -> {
            Optional<FeatureStoreTypeInfo> typeInfo = Optional.ofNullable(this.getTypeInfos().get(typeName));
            if (!typeInfo.isPresent()) {
                return Optional.empty();
            }
            LOGGER.debug("Computing temporal extent for '{}.{}'", (Object)typeName, (Object)property);
            try {
                Reactive.Stream<Optional<Interval>> extentGraph = this.extentReader.getTemporalExtent(typeInfo.get(), property);
                return this.computeTemporalExtent(extentGraph);
            }
            catch (Throwable throwable) {
                return Optional.empty();
            }
        });
    }

    @Override
    public Optional<Interval> getTemporalExtent(String typeName, String startProperty, String endProperty) {
        return this.temporalExtentCache.computeIfAbsent(typeName + startProperty + endProperty, ignore -> {
            Optional<FeatureStoreTypeInfo> typeInfo = Optional.ofNullable(this.getTypeInfos().get(typeName));
            if (!typeInfo.isPresent()) {
                return Optional.empty();
            }
            LOGGER.debug("Computing temporal extent for '{}.{}' and '{}.{}'", typeName, startProperty, typeName, endProperty);
            try {
                Reactive.Stream<Optional<Interval>> extentGraph = this.extentReader.getTemporalExtent(typeInfo.get(), startProperty, endProperty);
                return this.computeTemporalExtent(extentGraph);
            }
            catch (Throwable throwable) {
                return Optional.empty();
            }
        });
    }

    private Optional<Interval> computeTemporalExtent(Reactive.Stream<Optional<Interval>> extentComputation) {
        return this.getStreamRunner().run(extentComputation).exceptionally(throwable -> {
            LOGGER.warn("Cannot compute temporal extent: {}", (Object)(Objects.nonNull(throwable.getCause()) ? throwable.getCause().getMessage() : throwable.getMessage()));
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Stacktrace:", (Throwable)throwable);
            }
            return Optional.empty();
        }).toCompletableFuture().join();
    }

    @Override
    public FeatureTransactions.MutationResult createFeatures(String featureType, FeatureTokenSource featureTokenSource) {
        return this.writeFeatures(featureType, featureTokenSource, Optional.empty());
    }

    @Override
    public FeatureTransactions.MutationResult updateFeature(String featureType, String featureId, FeatureTokenSource featureTokenSource) {
        return this.writeFeatures(featureType, featureTokenSource, Optional.of(featureId));
    }

    @Override
    public FeatureTransactions.MutationResult deleteFeature(String featureType, String id) {
        Optional<FeatureSchema> schema = Optional.ofNullable((FeatureSchema)this.getData().getTypes().get(featureType));
        Optional<FeatureStoreTypeInfo> typeInfo = Optional.ofNullable(this.getTypeInfos().get(featureType));
        if (!schema.isPresent() || !typeInfo.isPresent()) {
            throw new IllegalArgumentException(String.format("Feature type '%s' not found.", featureType));
        }
        FeatureSchema migrated = schema.get();
        List<SchemaSql> sqlSchema = migrated.accept(new MutationSchemaDeriver(this.pathParser2, null));
        if (sqlSchema.isEmpty()) {
            throw new IllegalStateException("Mutation mapping could not be derived from provider schema.");
        }
        SchemaSql mutationSchemaSql = sqlSchema.get(0).accept(new MutationSchemaBuilderSql());
        Reactive.Source<SqlRow> deletionSource = this.featureMutationsSql.getDeletionSource(mutationSchemaSql, id);
        Reactive.RunnableStream<FeatureTransactions.MutationResult> deletionStream = deletionSource.to(Reactive.Sink.ignore()).withResult(ImmutableMutationResult.builder()).handleError(ImmutableMutationResult.Builder::error).handleEnd(FeatureStream.ResultBase.Builder::build).on(this.getStreamRunner());
        return deletionStream.run().toCompletableFuture().join();
    }

    private FeatureTransactions.MutationResult writeFeatures(String featureType, FeatureTokenSource featureTokenSource, Optional<String> featureId) {
        Optional<FeatureSchema> schema = Optional.ofNullable((FeatureSchema)this.getData().getTypes().get(featureType));
        Optional<FeatureStoreTypeInfo> typeInfo = Optional.ofNullable(this.getTypeInfos().get(featureType));
        if (!schema.isPresent() || !typeInfo.isPresent()) {
            throw new IllegalArgumentException(String.format("Feature type '%s' not found.", featureType));
        }
        FeatureSchema migrated = schema.get();
        List<SchemaSql> sqlSchema = migrated.accept(new MutationSchemaDeriver(this.pathParser2, null));
        if (sqlSchema.isEmpty()) {
            throw new IllegalStateException("Mutation mapping could not be derived from provider schema.");
        }
        SchemaSql mutationSchemaSql = sqlSchema.get(0).accept(new MutationSchemaBuilderSql());
        ImmutableSchemaMappingSql mapping4 = new ImmutableSchemaMappingSql.Builder().targetSchema(mutationSchemaSql).build();
        Reactive.Transformer<FeatureSql, String> featureWriter = featureId.isPresent() ? this.featureMutationsSql.getUpdaterFlow(mutationSchemaSql, null, featureId.get()) : this.featureMutationsSql.getCreatorFlow(mutationSchemaSql, null);
        Reactive.RunnableStream<FeatureTransactions.MutationResult> mutationStream = featureTokenSource.via(new FeatureEncoderSql2(mapping4)).via(Reactive.Transformer.map(feature -> (FeatureSql)feature)).via(featureWriter).to(Reactive.Sink.ignore()).withResult(ImmutableMutationResult.builder()).handleError((result, throwable) -> {
            Throwable error = throwable instanceof PSQLException || throwable instanceof JsonParseException ? new IllegalArgumentException(throwable.getMessage()) : throwable;
            return (FeatureTransactions.MutationResult.Builder)result.error(error);
        }).handleItem((rec$, xva$0) -> ((FeatureTransactions.MutationResult.Builder)rec$).addIds((String)xva$0)).handleEnd(FeatureStream.ResultBase.Builder::build).on(this.getStreamRunner());
        return mutationStream.run().toCompletableFuture().join();
    }

    @Override
    public boolean supportsSorting() {
        return true;
    }

    @Override
    public boolean supportsHighLoad() {
        return true;
    }

    @Override
    public boolean supportsAccenti() {
        if (Objects.nonNull(this.getData().getQueryGeneration())) {
            return this.getData().getQueryGeneration().getAccentiCollation().isPresent();
        }
        return false;
    }
}

