/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.sql.app;

import de.ii.xtraplatform.features.domain.FeatureStoreInstanceContainer;
import de.ii.xtraplatform.features.domain.SchemaBase;
import de.ii.xtraplatform.features.domain.SchemaVisitor;
import de.ii.xtraplatform.features.domain.Tuple;
import de.ii.xtraplatform.features.sql.app.FeatureSql;
import de.ii.xtraplatform.features.sql.app.FeatureStoreInsertGenerator;
import de.ii.xtraplatform.features.sql.app.RowCursor;
import de.ii.xtraplatform.features.sql.domain.ImmutableSqlQueryOptions;
import de.ii.xtraplatform.features.sql.domain.SchemaSql;
import de.ii.xtraplatform.features.sql.domain.SqlClient;
import de.ii.xtraplatform.features.sql.domain.SqlRelation;
import de.ii.xtraplatform.features.sql.domain.SqlRow;
import de.ii.xtraplatform.streams.domain.Reactive;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shadow.com.google.common.collect.ImmutableList;

public class FeatureMutationsSql {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeatureMutationsSql.class);
    private final Supplier<SqlClient> sqlClient;
    private final FeatureStoreInsertGenerator generator;

    public FeatureMutationsSql(Supplier<SqlClient> sqlClient, FeatureStoreInsertGenerator generator) {
        this.sqlClient = sqlClient;
        this.generator = generator;
    }

    public Reactive.Transformer<FeatureSql, String> getCreatorFlow(SchemaSql schema, Object executionContext) {
        RowCursor rowCursor = new RowCursor(schema.getPath());
        return this.sqlClient.get().getMutationFlow(feature -> this.createInstanceInserts(schema, feature.getRowCounts(), rowCursor, Optional.empty()), executionContext, Optional.empty());
    }

    public Reactive.Transformer<FeatureSql, String> getUpdaterFlow(SchemaSql schema, Object executionContext, String id) {
        RowCursor rowCursor = new RowCursor(schema.getPath());
        return this.sqlClient.get().getMutationFlow(feature -> this.createInstanceInserts(schema, feature.getRowCounts(), rowCursor, Optional.of(id)), executionContext, Optional.of(id));
    }

    public Reactive.Source<SqlRow> getDeletionSource(SchemaSql schema, String id) {
        Tuple<String, Consumer<String>> delete = this.createInstanceDelete(schema, id).apply(null);
        return this.sqlClient.get().getSourceStream(delete.first(), new ImmutableSqlQueryOptions.Builder().build());
    }

    public Object getUpdater(FeatureStoreInstanceContainer instanceContainer, String id) {
        return null;
    }

    List<Function<FeatureSql, Tuple<String, Consumer<String>>>> createInstanceInserts(SchemaSql schema, Map<List<String>, List<Integer>> rowNesting, RowCursor rowCursor, Optional<String> id) {
        boolean withId = id.isPresent();
        Stream instance = withId ? Stream.concat(Stream.of(this.createInstanceDelete(schema, id.get())), this.createObjectInserts(schema, rowNesting, rowCursor, id).stream()) : this.createObjectInserts(schema, rowNesting, rowCursor, id).stream();
        return Stream.concat(instance, schema.getProperties().stream().filter(SchemaBase::isObject).flatMap(childSchema -> this.createInstanceInserts((SchemaSql)childSchema, rowNesting, rowCursor, Optional.empty()).stream())).collect(Collectors.toList());
    }

    Function<FeatureSql, Tuple<String, Consumer<String>>> createInstanceDelete(SchemaSql schema, String id) {
        String table = schema.getName();
        String idColumn = schema.getIdProperty().map(SchemaBase::getName).orElseThrow(() -> new IllegalStateException("No property with role ID found for '" + schema.getSourcePath().orElse(schema.getName()) + "'."));
        return featureSql -> Tuple.of(String.format("DELETE FROM %s WHERE %s=%s RETURNING %2$s", table, idColumn, id), ignore -> {});
    }

    List<Function<FeatureSql, Tuple<String, Consumer<String>>>> createObjectInserts(SchemaSql schema, Map<List<String>, List<Integer>> rowNesting, RowCursor rowCursor, Optional<String> id) {
        if (schema.isFeature()) {
            return this.createAttributesInserts(schema, rowCursor.get(schema.getPath()), id);
        }
        if (schema.getRelation().isEmpty()) {
            return ImmutableList.of();
        }
        SqlRelation relation = schema.getRelation().get(0);
        String parentName = relation.getSourceContainer();
        if (!relation.isM2N() && !relation.isOne2N()) {
            List<Integer> newParentRows = rowCursor.track(schema.getFullPath(), schema.getParentPath(), 0);
            return this.createAttributesInserts(schema, newParentRows, id);
        }
        if (!rowNesting.containsKey(schema.getFullPath())) {
            return ImmutableList.of();
        }
        List<Integer> numberOfRowsPerParentRow = rowNesting.get(schema.getFullPath());
        int currentParentRow = rowCursor.getCurrent(schema.getParentPath());
        int rowCount = numberOfRowsPerParentRow.get(currentParentRow);
        return IntStream.range(0, rowCount).mapToObj(currentRow -> {
            List<Integer> newParentRows = rowCursor.track(schema.getFullPath(), schema.getParentPath(), currentRow);
            return this.createAttributesInserts(schema, newParentRows, id);
        }).flatMap(Collection::stream).collect(Collectors.toList());
    }

    List<Function<FeatureSql, Tuple<String, Consumer<String>>>> createAttributesInserts(SchemaSql schema, List<Integer> parentRows, Optional<String> id) {
        ImmutableList.Builder queries = ImmutableList.builder();
        queries.add(this.generator.createInsert(schema, parentRows, id));
        if (!schema.getRelation().isEmpty()) {
            boolean isOne2OneWithForeignKey;
            SqlRelation relation = schema.getRelation().get(0);
            if (relation.isM2N()) {
                queries.add(this.generator.createJunctionInsert(schema, parentRows));
            }
            boolean bl = isOne2OneWithForeignKey = relation.isOne2One() && !Objects.equals(relation.getSourceSortKey().orElse("id"), relation.getSourceField());
            if (isOne2OneWithForeignKey) {
                queries.add(this.generator.createForeignKeyUpdate(schema, parentRows));
            }
        }
        return queries.build();
    }

    class StatementsVisitor
    implements SchemaVisitor<SchemaSql, List<Function<FeatureSql, Tuple<String, Consumer<String>>>>> {
        private final Map<List<String>, List<Integer>> rowNesting;
        private final RowCursor rowCursor;
        private final Optional<String> id;

        StatementsVisitor(Map<List<String>, List<Integer>> rowNesting, RowCursor rowCursor, Optional<String> id) {
            this.rowNesting = rowNesting;
            this.rowCursor = rowCursor;
            this.id = id;
        }

        @Override
        public List<Function<FeatureSql, Tuple<String, Consumer<String>>>> visit(SchemaSql schema, List<List<Function<FeatureSql, Tuple<String, Consumer<String>>>>> visitedProperties) {
            if (!schema.isObject()) {
                return ImmutableList.of();
            }
            ArrayList before = new ArrayList();
            ArrayList<Function<FeatureSql, Tuple<String, Consumer<String>>>> after = new ArrayList<Function<FeatureSql, Tuple<String, Consumer<String>>>>();
            after.addAll(FeatureMutationsSql.this.createObjectInserts(schema, this.rowNesting, this.rowCursor, this.id));
            for (int i = 0; i < schema.getProperties().size(); ++i) {
                if (!schema.isObject()) continue;
                if (this.isMain(schema)) {
                    before.addAll(0, visitedProperties.get(i));
                    continue;
                }
                if (this.isMerge(schema)) {
                    before.addAll(visitedProperties.get(i));
                    continue;
                }
                after.addAll((Collection)visitedProperties.get(i));
            }
            return Stream.concat(before.stream(), after.stream()).collect(ImmutableList.toImmutableList());
        }

        private boolean isMain(SchemaSql schemaSql) {
            return schemaSql.getProperties().stream().anyMatch(property -> property.getRole().isPresent() && property.getRole().get() == SchemaBase.Role.ID);
        }

        private boolean isMerge(SchemaSql schemaSql) {
            return !schemaSql.getRelation().isEmpty() && schemaSql.getRelation().get(0).isOne2One() && Objects.equals(schemaSql.getRelation().get(0).getSourceSortKey().get(), schemaSql.getRelation().get(0).getSourceField());
        }
    }
}

