/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.sql.app;

import de.ii.xtraplatform.features.domain.FeatureEventHandler;
import de.ii.xtraplatform.features.domain.FeatureQuery;
import de.ii.xtraplatform.features.domain.FeatureSchema;
import de.ii.xtraplatform.features.domain.FeatureStoreMultiplicityTracker;
import de.ii.xtraplatform.features.domain.FeatureStoreTypeInfo;
import de.ii.xtraplatform.features.domain.FeatureTokenDecoder;
import de.ii.xtraplatform.features.domain.ImmutableSchemaMapping;
import de.ii.xtraplatform.features.domain.NestingTracker;
import de.ii.xtraplatform.features.domain.SchemaBase;
import de.ii.xtraplatform.features.domain.SchemaMapping;
import de.ii.xtraplatform.features.sql.app.GeometryDecoderWkt;
import de.ii.xtraplatform.features.sql.app.SqlMultiplicityTracker;
import de.ii.xtraplatform.features.sql.domain.SchemaSql;
import de.ii.xtraplatform.features.sql.domain.SqlRow;
import de.ii.xtraplatform.features.sql.domain.SqlRowMeta;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureDecoderSql
extends FeatureTokenDecoder<SqlRow, FeatureSchema, SchemaMapping, FeatureEventHandler.ModifiableContext<FeatureSchema, SchemaMapping>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeatureDecoderSql.class);
    private final FeatureSchema featureSchema;
    private final FeatureQuery featureQuery;
    private final List<String> mainTablePath;
    private final FeatureStoreMultiplicityTracker multiplicityTracker;
    private final boolean isSingleFeature;
    private boolean started;
    private boolean featureStarted;
    private Object currentId;
    private boolean isAtLeastOneFeatureWritten;
    private FeatureEventHandler.ModifiableContext<FeatureSchema, SchemaMapping> context;
    private GeometryDecoderWkt geometryDecoder;
    private NestingTracker nestingTracker;

    public FeatureDecoderSql(List<FeatureStoreTypeInfo> typeInfos, List<SchemaSql> tableSchemas, FeatureSchema featureSchema, FeatureQuery query) {
        this.featureSchema = featureSchema;
        this.featureQuery = query;
        SchemaSql tableSchema = tableSchemas.get(0);
        this.mainTablePath = tableSchema.getFullPath();
        List<List<String>> multiTables = tableSchema.getAllObjects().stream().filter(schema -> !schema.getRelation().isEmpty()).map(SchemaBase::getFullPath).collect(Collectors.toList());
        this.multiplicityTracker = new SqlMultiplicityTracker(multiTables);
        this.isSingleFeature = query.returnsSingleFeature();
    }

    @Override
    protected void init() {
        this.context = this.createContext().setMapping((ImmutableSchemaMapping)new ImmutableSchemaMapping.Builder().targetSchema(this.featureSchema).build()).setQuery(this.featureQuery);
        this.geometryDecoder = new GeometryDecoderWkt(this.getDownstream(), this.context);
        this.nestingTracker = new NestingTracker(this.getDownstream(), this.context, this.mainTablePath, false, false, false);
    }

    @Override
    protected void cleanup() {
        while (this.nestingTracker.isNested()) {
            this.nestingTracker.close();
        }
        if (this.isAtLeastOneFeatureWritten) {
            this.getDownstream().onFeatureEnd(this.context);
        }
        this.getDownstream().onEnd(this.context);
    }

    @Override
    public void onPush(SqlRow sqlRow) {
        if (sqlRow instanceof SqlRowMeta) {
            this.handleMetaRow((SqlRowMeta)sqlRow);
            return;
        }
        if (!this.started) {
            return;
        }
        this.handleValueRow(sqlRow);
    }

    private void handleMetaRow(SqlRowMeta sqlRow) {
        this.context.metadata().numberReturned(sqlRow.getNumberReturned());
        this.context.metadata().numberMatched(sqlRow.getNumberMatched());
        this.context.metadata().isSingleFeature(this.isSingleFeature);
        this.getDownstream().onStart(this.context);
        this.started = true;
    }

    private void handleValueRow(SqlRow sqlRow) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Sql row: {}", (Object)sqlRow);
        }
        Comparable<?> featureId = sqlRow.getIds().get(0);
        if (this.nestingTracker.isNotMain(sqlRow.getPath())) {
            this.multiplicityTracker.track(sqlRow.getPath(), sqlRow.getIds());
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Multiplicities {} {}", (Object)sqlRow.getPath(), (Object)this.multiplicityTracker.getMultiplicitiesForPath(sqlRow.getPath()));
            }
        }
        if (!Objects.equals(this.currentId, featureId)) {
            if (this.featureStarted) {
                this.getDownstream().onFeatureEnd(this.context);
                this.featureStarted = false;
                this.multiplicityTracker.reset();
            }
            this.context.pathTracker().track(sqlRow.getPath());
            this.getDownstream().onFeatureStart(this.context);
            this.featureStarted = true;
            this.currentId = featureId;
        }
        this.handleNesting(sqlRow, this.multiplicityTracker.getMultiplicitiesForPath(sqlRow.getPath()));
        this.handleColumns(sqlRow);
        if (!this.isAtLeastOneFeatureWritten) {
            this.isAtLeastOneFeatureWritten = true;
        }
    }

    private void handleNesting(SqlRow sqlRow, List<Integer> indexes) {
        while (this.nestingTracker.isNested() && (this.nestingTracker.doesNotStartWithPreviousPath(sqlRow.getPath()) || this.nestingTracker.inObject() && this.nestingTracker.isSamePath(sqlRow.getPath()) || this.nestingTracker.inArray() && this.nestingTracker.isSamePath(sqlRow.getPath()) && this.nestingTracker.hasParentIndexChanged(indexes))) {
            this.nestingTracker.close();
        }
        if (this.nestingTracker.inObject() && this.context.inArray() && this.nestingTracker.doesStartWithPreviousPath(sqlRow.getPath()) && this.nestingTracker.hasIndexChanged(indexes)) {
            this.nestingTracker.closeObject();
            this.nestingTracker.openObject();
        }
        if (this.nestingTracker.isNotMain(sqlRow.getPath())) {
            this.context.pathTracker().track(sqlRow.getPath());
            if (this.nestingTracker.isFirst(indexes)) {
                this.nestingTracker.openArray();
            }
            this.context.setIndexes(indexes);
            this.nestingTracker.openObject();
        }
    }

    private void handleColumns(SqlRow sqlRow) {
        HashMap<List<String>, Integer> schemaIndexes = new HashMap<List<String>, Integer>();
        for (int i = 0; i < sqlRow.getValues().size() && i < sqlRow.getColumnPaths().size(); ++i) {
            if (!Objects.nonNull(sqlRow.getValues().get(i))) continue;
            this.context.pathTracker().track(sqlRow.getColumnPaths().get(i));
            if (!schemaIndexes.containsKey(sqlRow.getColumnPaths().get(i))) {
                schemaIndexes.put(sqlRow.getColumnPaths().get(i), 0);
            } else {
                schemaIndexes.put(sqlRow.getColumnPaths().get(i), (Integer)schemaIndexes.get(sqlRow.getColumnPaths().get(i)) + 1);
            }
            if (sqlRow.getSpatialAttributes().size() > i && Objects.equals(sqlRow.getSpatialAttributes().get(i), true)) {
                try {
                    this.context.setSchemaIndex(-1);
                    this.geometryDecoder.decode((String)sqlRow.getValues().get(i));
                    continue;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Error parsing WKT geometry", e);
                }
            }
            this.context.setValueType(SchemaBase.Type.STRING);
            this.context.setValue((String)sqlRow.getValues().get(i));
            this.context.setSchemaIndex((Integer)schemaIndexes.get(sqlRow.getColumnPaths().get(i)));
            this.getDownstream().onValue(this.context);
        }
        this.context.setSchemaIndex(-1);
        if (this.nestingTracker.isNotMain(sqlRow.getPath())) {
            this.context.pathTracker().track(sqlRow.getPath());
        }
    }
}

