/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.sql.app;

import de.ii.xtraplatform.features.sql.domain.SchemaSql;
import de.ii.xtraplatform.features.sql.domain.SqlRelation;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import shadow.com.google.common.collect.ImmutableList;

class AliasGenerator {
    AliasGenerator() {
    }

    public List<String> getAliases(List<SchemaSql> parents, SchemaSql schema) {
        char alias = 'A';
        if (parents.isEmpty() && schema.getRelation().isEmpty()) {
            return ImmutableList.of(String.valueOf(alias));
        }
        ImmutableList.Builder aliases = new ImmutableList.Builder();
        List relations = Stream.concat(parents.stream().flatMap(parent -> parent.getRelation().stream()), schema.getRelation().stream()).collect(Collectors.toList());
        for (SqlRelation relation : relations) {
            char c = alias;
            alias = (char)(alias + '\u0001');
            aliases.add(String.valueOf(c));
            if (!relation.isM2N()) continue;
            char c2 = alias;
            alias = (char)(alias + '\u0001');
            aliases.add(String.valueOf(c2));
        }
        char c = alias;
        alias = (char)(alias + '\u0001');
        aliases.add(String.valueOf(c));
        return aliases.build();
    }

    public List<String> getAliases(SchemaSql schema) {
        char alias = 'A';
        if (schema.getParentPath().isEmpty()) {
            return ImmutableList.of(String.valueOf(alias));
        }
        ImmutableList.Builder aliases = new ImmutableList.Builder();
        for (String relation : schema.getParentPath()) {
            char c = alias;
            alias = (char)(alias + '\u0001');
            aliases.add(String.valueOf(c));
        }
        char c = alias;
        alias = (char)(alias + '\u0001');
        aliases.add(String.valueOf(c));
        return aliases.build();
    }

    public List<String> getAliases(SchemaSql schema, int level) {
        if (level > 0) {
            String prefix = IntStream.range(0, level).mapToObj(i -> "A").collect(Collectors.joining());
            return this.getAliases(schema).stream().map(s -> prefix + s).collect(Collectors.toList());
        }
        return this.getAliases(schema);
    }

    public List<String> getAliases(List<SchemaSql> parents, SchemaSql schema, int level) {
        if (level > 0) {
            String prefix = IntStream.range(0, level).mapToObj(i -> "A").collect(Collectors.joining());
            return this.getAliases(parents, schema).stream().map(s -> prefix + s).collect(Collectors.toList());
        }
        return this.getAliases(schema);
    }
}

