/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.sql;

import de.ii.xtraplatform.features.sql.ImmutableOptions;
import de.ii.xtraplatform.features.sql.domain.ImmutableSqlPathDefaults;
import de.ii.xtraplatform.features.sql.domain.SqlPathDefaults;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import shadow.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.com.google.common.base.Joiner;
import shadow.com.google.common.base.Splitter;
import shadow.org.immutables.value.Value;

@Value.Immutable
@Value.Style(deepImmutablesDetection=true)
public interface SqlPathSyntax {
    default public List<String> asList(String path) {
        return this.getPathSplitter().splitToList(path);
    }

    default public boolean isJunctionTable(String pathElement) {
        return this.getOptions().getJunctionTablePattern().map(Pattern::compile).orElse(this.getJunctionTablePattern()).matcher(pathElement).find();
    }

    default public String asPath(List<String> pathElements) {
        StringBuilder path = new StringBuilder();
        if (!pathElements.isEmpty() && !pathElements.get(0).startsWith(this.getPathSeparator())) {
            path.append(this.getPathSeparator());
        }
        this.getPathJoiner().appendTo(path, (Iterable<? extends Object>)pathElements);
        return path.toString();
    }

    default public String asPath(String ... pathAndPathElements) {
        return this.asPath(Arrays.asList(pathAndPathElements));
    }

    default public boolean getOidFlag(String path) {
        Matcher matcher = Pattern.compile(this.getOidFlagPattern()).matcher(path);
        return matcher.find();
    }

    default public String setOidFlag(String path) {
        return String.format("%s{oid}", path);
    }

    default public boolean getSpatialFlag(String path) {
        Matcher matcher = Pattern.compile(this.getSpatialFlagPattern()).matcher(path);
        return matcher.find();
    }

    default public String setSpatialFlag(String path) {
        return String.format("%s{spatial}", path);
    }

    default public boolean getTemporalFlag(String path) {
        Matcher matcher = Pattern.compile(this.getTemporalFlagPattern()).matcher(path);
        return matcher.find();
    }

    default public String setTemporalFlag(String path) {
        return String.format("%s{temporal}", path);
    }

    default public OptionalInt getPriorityFlag(String path) {
        Matcher matcher = Pattern.compile(this.getPriorityFlagPattern()).matcher(path);
        if (matcher.find()) {
            return OptionalInt.of(Integer.parseInt(matcher.group("priority")));
        }
        return OptionalInt.empty();
    }

    default public String setPriorityFlag(String path, int priority) {
        return String.format("%s{priority=%d}", path, priority);
    }

    default public Optional<String> getQueryableFlag(String flags) {
        Matcher matcher = Pattern.compile(this.getQueryableFlagPattern()).matcher(flags);
        if (matcher.find()) {
            return Optional.of(matcher.group("queryable"));
        }
        return Optional.empty();
    }

    default public Optional<String> getConstantFlag(String flags) {
        Matcher matcher = Pattern.compile(this.getConstantFlagPattern()).matcher(flags);
        if (matcher.find()) {
            return Optional.of(matcher.group("constant"));
        }
        return Optional.empty();
    }

    default public Optional<String> getSortKeyFlag(String flags) {
        Matcher matcher = Pattern.compile(this.getSortKeyFlagPattern()).matcher(flags);
        if (matcher.find()) {
            return Optional.of(matcher.group("sortKey"));
        }
        return Optional.empty();
    }

    default public String setQueryableFlag(String path, String queryable) {
        return String.format("%s{queryable=%s}", path, queryable);
    }

    default public Optional<String> getFilterFlag(String flags) {
        Matcher matcher = Pattern.compile(this.getFilterFlagPattern()).matcher(flags);
        if (matcher.find()) {
            return Optional.of(matcher.group("filter"));
        }
        return Optional.empty();
    }

    default public Optional<String> getFilterFlagExpression(String flags) {
        Matcher matcher = Pattern.compile(this.getFilterFlagPattern()).matcher(flags);
        if (matcher.find()) {
            return Optional.of(matcher.group());
        }
        return Optional.empty();
    }

    @Value.Derived
    default public String getPriorityFlagPattern() {
        return "\\{priority=(?<priority>[0-9]+)\\}";
    }

    @Value.Derived
    default public String getOidFlagPattern() {
        return "\\{oid\\}";
    }

    @Value.Derived
    default public String getSpatialFlagPattern() {
        return "\\{spatial\\}";
    }

    @Value.Derived
    default public String getTemporalFlagPattern() {
        return "\\{temporal\\}";
    }

    @Value.Derived
    default public String getQueryableFlagPattern() {
        return "\\{queryable=(?<queryable>.+?)\\}";
    }

    @Value.Derived
    default public String getConstantFlagPattern() {
        return "\\{constant=(?<constant>.+?)\\}";
    }

    @Value.Derived
    default public String getSortKeyFlagPattern() {
        return "\\{sortKey=(?<sortKey>.+?)\\}";
    }

    @Value.Derived
    default public String getFilterFlagPattern() {
        return "\\{filter=(?<filter>.+?)\\}";
    }

    @Value.Derived
    default public String getFlagsPattern() {
        return "(?:\\{[a-z_]+.*?\\})*";
    }

    @Value.Default
    default public String getPathSeparator() {
        return "/";
    }

    @Value.Derived
    default public Splitter getPathSplitter() {
        return Splitter.on(this.getPathSeparator()).omitEmptyStrings();
    }

    @Value.Derived
    default public Joiner getPathJoiner() {
        return Joiner.on(this.getPathSeparator()).skipNulls();
    }

    @Value.Default
    default public String getMultiColumnSeparator() {
        return ":";
    }

    @Value.Derived
    default public Splitter getMultiColumnSplitter() {
        return Splitter.on(this.getMultiColumnSeparator()).omitEmptyStrings();
    }

    @Value.Default
    default public String getIdentifierPattern() {
        return "[a-zA-Z_]{1}[a-zA-Z0-9_]*";
    }

    @Value.Derived
    default public String getColumnPattern() {
        return this.getIdentifierPattern() + "(?:" + this.getMultiColumnSeparator() + this.getIdentifierPattern() + ")*";
    }

    @Value.Default
    default public String getJoinConditionStart() {
        return "[";
    }

    @Value.Default
    default public String getJoinConditionSeparator() {
        return "=";
    }

    @Value.Default
    default public String getJoinConditionEnd() {
        return "]";
    }

    @Value.Derived
    default public String getJoinConditionPattern() {
        return Pattern.quote(this.getJoinConditionStart()) + "(?<sourceField>" + this.getIdentifierPattern() + ")" + Pattern.quote(this.getJoinConditionSeparator()) + "(?<targetField>" + this.getIdentifierPattern() + ")" + Pattern.quote(this.getJoinConditionEnd());
    }

    @Value.Derived
    default public String getJoinConditionPlainPattern() {
        return Pattern.quote(this.getJoinConditionStart()) + "(?:" + this.getIdentifierPattern() + ")" + Pattern.quote(this.getJoinConditionSeparator()) + "(?:" + this.getIdentifierPattern() + ")" + Pattern.quote(this.getJoinConditionEnd());
    }

    @Value.Derived
    default public String getTablePatternString() {
        return "(?:" + this.getJoinConditionPattern() + ")?(?<table>" + this.getIdentifierPattern() + ")(?<tableFlags>" + this.getFlagsPattern() + ")?";
    }

    @Value.Derived
    default public String getTablePatternPlainString() {
        return "(?:" + this.getJoinConditionPlainPattern() + ")?(?:" + this.getIdentifierPattern() + ")(?:" + this.getFlagsPattern() + ")?";
    }

    @Value.Derived
    default public Pattern getTablePattern() {
        return Pattern.compile(this.getTablePatternString());
    }

    @Value.Derived
    default public Pattern getJoinedTablePattern() {
        return Pattern.compile(this.getJoinConditionPattern() + "(?<table>" + this.getIdentifierPattern() + ")");
    }

    @Value.Derived
    default public Pattern getColumnPathPattern() {
        return Pattern.compile("^(?<path>(?:" + this.getPathSeparator() + this.getTablePatternString() + ")+)" + this.getPathSeparator() + "(?<columns>" + this.getColumnPattern() + ")?(?<pathFlags>" + this.getFlagsPattern() + ")?$");
    }

    @Value.Derived
    default public Pattern getPartialColumnPathPattern() {
        return Pattern.compile(this.getPathPatternString() + "(?:" + this.getPathSeparator() + "(?<columns>" + this.getColumnPattern() + "))(?<pathFlags>" + this.getFlagsPattern() + ")?$");
    }

    @Value.Derived
    default public Pattern getPathPattern() {
        return Pattern.compile(this.getPathPatternString());
    }

    @Value.Derived
    default public String getPathPatternString() {
        return "(?<path>" + this.getPathSeparator() + "?" + this.getTablePatternPlainString() + "(?:" + this.getPathSeparator() + this.getTablePatternPlainString() + ")*)";
    }

    @Value.Default
    default public SqlPathDefaults getOptions() {
        return new ImmutableSqlPathDefaults.Builder().build();
    }

    @Value.Derived
    default public Pattern getJunctionTablePattern() {
        return Pattern.compile(".+_2_.+");
    }

    public static interface MatcherGroups {
        public static final String PATH = "path";
        public static final String TABLE = "table";
        public static final String COLUMNS = "columns";
        public static final String SOURCE_FIELD = "sourceField";
        public static final String TARGET_FIELD = "targetField";
        public static final String PRIORITY = "priority";
        public static final String PATH_FLAGS = "pathFlags";
        public static final String TABLE_FLAGS = "tableFlags";
        public static final String QUERYABLE = "queryable";
        public static final String CONSTANT = "constant";
        public static final String SORT_KEY = "sortKey";
        public static final String FILTER = "filter";
    }

    @JsonDeserialize(builder=ImmutableOptions.Builder.class)
    @Value.Immutable
    @Value.Style(builder="new")
    public static interface Options {
        @Value.Default
        default public String getDefaultPrimaryKey() {
            return "id";
        }

        @Value.Default
        default public String getDefaultSortKey() {
            return this.getDefaultPrimaryKey();
        }

        @Value.Default
        default public String getJunctionTablePattern() {
            return ".+_2_.+";
        }

        @Value.Default
        default public String getJunctionTableFlag() {
            return "{junction}";
        }
    }
}

