/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.sql;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import shadow.javax.annotation.Nullable;
import shadow.org.immutables.value.Value;

@Value.Immutable
public interface SqlPath {
    @Nullable
    public SqlPath getParent();

    public String getTablePath();

    public List<String> getColumns();

    @Value.Default
    default public boolean isRoot() {
        return false;
    }

    @Value.Default
    default public boolean isJunction() {
        return false;
    }

    @Value.Default
    default public boolean hasOid() {
        return false;
    }

    public OptionalInt getSortPriority();

    public String getQueryable();

    @Value.Default
    default public boolean isSpatial() {
        return false;
    }

    @Value.Default
    default public boolean isTemporal() {
        return false;
    }

    public Optional<String> getConstantValue();

    public Map<String, String> getTableFlags();

    @Value.Derived
    default public String getTablePathWithFlags() {
        String tablePathWithFlags = this.getTablePath();
        for (Map.Entry<String, String> entry : this.getTableFlags().entrySet()) {
            String table = entry.getKey();
            String flags = entry.getValue();
            tablePathWithFlags = tablePathWithFlags.replaceFirst("(\\/|])(" + table + ")(\\/|$)", "$1$2" + flags + "$3");
        }
        return tablePathWithFlags;
    }
}

