/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.sql;

import de.ii.xtraplatform.features.domain.FeatureSchema;
import de.ii.xtraplatform.features.domain.FeatureTypeV2;
import de.ii.xtraplatform.features.domain.SchemaBase;
import de.ii.xtraplatform.features.sql.SqlPathSyntax;
import java.util.List;
import shadow.com.google.common.collect.ImmutableList;

public class SqlFeatureTypeParser2 {
    private final SqlPathSyntax syntax;

    public SqlFeatureTypeParser2(SqlPathSyntax syntax) {
        this.syntax = syntax;
    }

    public List<String> parse(FeatureTypeV2 featureType) {
        return featureType.getProperties().values().stream().map(this::toPathWithFlags).collect(ImmutableList.toImmutableList());
    }

    private String toPathWithFlags(FeatureSchema property) {
        boolean isSpatial;
        String path = property.getSourcePath().orElse("");
        path = this.syntax.setQueryableFlag(path, property.getName());
        boolean isOid = property.isId();
        boolean bl = isSpatial = property.getType() == SchemaBase.Type.GEOMETRY;
        if (isOid) {
            path = this.syntax.setOidFlag(path);
        }
        if (isSpatial) {
            path = this.syntax.setSpatialFlag(path);
        }
        return path;
    }
}

