/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.sql;

import de.ii.xtraplatform.features.domain.FeatureSchema;
import de.ii.xtraplatform.features.domain.SchemaBase;
import de.ii.xtraplatform.features.domain.SchemaToSourcePathsVisitor;
import de.ii.xtraplatform.features.sql.SqlPathSyntax;
import java.util.AbstractMap;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shadow.com.google.common.collect.ImmutableMap;
import shadow.com.google.common.collect.Lists;
import shadow.com.google.common.collect.Multimap;

public class SqlFeatureTypeParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(SqlFeatureTypeParser.class);
    private final SqlPathSyntax syntax;

    public SqlFeatureTypeParser(SqlPathSyntax syntax) {
        this.syntax = syntax;
    }

    public List<String> parse(FeatureSchema schema) {
        Map accept = ((Multimap)schema.accept(new SchemaToSourcePathsVisitor())).asMap().entrySet().stream().sorted(Comparator.comparing(entry -> this.syntax.getPriorityFlag((String)((List)entry.getKey()).get(((List)entry.getKey()).size() - 1)).orElse(10000))).map(entry -> new AbstractMap.SimpleImmutableEntry((List)entry.getKey(), Lists.newArrayList((Iterable)entry.getValue()))).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        HashMap pathCounter = new HashMap();
        List<String> collect1 = accept.entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream().filter(SchemaBase::isValue).map(property -> this.toPathWithFlags2((List)entry.getKey(), (FeatureSchema)property, pathCounter))).collect(Collectors.toList());
        return collect1;
    }

    private String toPathWithFlags2(List<String> path, FeatureSchema property, Map<List<String>, Integer> pathCounter) {
        boolean isTemporal;
        pathCounter.computeIfPresent(property.getFullPath(), (p, i) -> i + 1);
        pathCounter.putIfAbsent(property.getFullPath(), 0);
        int index = pathCounter.get(property.getFullPath());
        if (property.getEffectiveSourcePaths().size() <= index) {
            LOGGER.warn("No source path found: {} {}", (Object)property.getFullPath(), (Object)index);
            return "";
        }
        String current = property.getEffectiveSourcePaths().get(index);
        String current2 = current.indexOf(123) > -1 ? current.substring(0, current.indexOf(123)) : current;
        String[] split = current2.split("/");
        Object sourcePath = "/" + String.join((CharSequence)"/", path.subList(0, path.size() - split.length)) + "/" + current;
        sourcePath = this.syntax.setQueryableFlag((String)sourcePath, String.join((CharSequence)".", property.getFullPath()));
        boolean isOid = property.isId();
        boolean isSpatial = property.isSpatial();
        if (isOid) {
            sourcePath = this.syntax.setOidFlag((String)sourcePath);
        }
        if (isSpatial) {
            sourcePath = this.syntax.setSpatialFlag((String)sourcePath);
        }
        if (isTemporal = property.isTemporal()) {
            sourcePath = this.syntax.setTemporalFlag((String)sourcePath);
        }
        return sourcePath;
    }
}

