/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.sql;

import de.ii.xtraplatform.features.sql.SqlPathSyntax;
import de.ii.xtraplatform.features.sql.domain.ImmutableSqlPathDefaults;
import de.ii.xtraplatform.features.sql.domain.SqlPathDefaults;
import java.util.ArrayList;
import java.util.Objects;
import java.util.regex.Pattern;
import shadow.com.google.common.base.Joiner;
import shadow.com.google.common.base.MoreObjects;
import shadow.com.google.common.base.Splitter;
import shadow.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.javax.annotation.CheckReturnValue;
import shadow.javax.annotation.Nullable;
import shadow.javax.annotation.ParametersAreNonnullByDefault;
import shadow.javax.annotation.concurrent.Immutable;
import shadow.javax.annotation.concurrent.NotThreadSafe;
import shadow.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="SqlPathSyntax", generator="Immutables")
@Immutable
public final class ImmutableSqlPathSyntax
implements SqlPathSyntax {
    private final transient String priorityFlagPattern;
    private final transient String oidFlagPattern;
    private final transient String spatialFlagPattern;
    private final transient String temporalFlagPattern;
    private final transient String queryableFlagPattern;
    private final transient String constantFlagPattern;
    private final transient String sortKeyFlagPattern;
    private final transient String filterFlagPattern;
    private final transient String flagsPattern;
    private final String pathSeparator;
    private final transient Splitter pathSplitter;
    private final transient Joiner pathJoiner;
    private final String multiColumnSeparator;
    private final transient Splitter multiColumnSplitter;
    private final String identifierPattern;
    private final transient String columnPattern;
    private final String joinConditionStart;
    private final String joinConditionSeparator;
    private final String joinConditionEnd;
    private final transient String joinConditionPattern;
    private final transient String joinConditionPlainPattern;
    private final transient String tablePatternString;
    private final transient String tablePatternPlainString;
    private final transient Pattern tablePattern;
    private final transient Pattern joinedTablePattern;
    private final transient Pattern columnPathPattern;
    private final transient Pattern partialColumnPathPattern;
    private final transient Pattern pathPattern;
    private final transient String pathPatternString;
    private final ImmutableSqlPathDefaults options;
    private final transient Pattern junctionTablePattern;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableSqlPathSyntax(Builder builder) {
        if (builder.pathSeparator != null) {
            this.initShim.pathSeparator(builder.pathSeparator);
        }
        if (builder.multiColumnSeparator != null) {
            this.initShim.multiColumnSeparator(builder.multiColumnSeparator);
        }
        if (builder.identifierPattern != null) {
            this.initShim.identifierPattern(builder.identifierPattern);
        }
        if (builder.joinConditionStart != null) {
            this.initShim.joinConditionStart(builder.joinConditionStart);
        }
        if (builder.joinConditionSeparator != null) {
            this.initShim.joinConditionSeparator(builder.joinConditionSeparator);
        }
        if (builder.joinConditionEnd != null) {
            this.initShim.joinConditionEnd(builder.joinConditionEnd);
        }
        if (builder.options != null) {
            this.initShim.options(ImmutableSqlPathDefaults.copyOf(builder.options));
        }
        this.priorityFlagPattern = this.initShim.getPriorityFlagPattern();
        this.oidFlagPattern = this.initShim.getOidFlagPattern();
        this.spatialFlagPattern = this.initShim.getSpatialFlagPattern();
        this.temporalFlagPattern = this.initShim.getTemporalFlagPattern();
        this.queryableFlagPattern = this.initShim.getQueryableFlagPattern();
        this.constantFlagPattern = this.initShim.getConstantFlagPattern();
        this.sortKeyFlagPattern = this.initShim.getSortKeyFlagPattern();
        this.filterFlagPattern = this.initShim.getFilterFlagPattern();
        this.flagsPattern = this.initShim.getFlagsPattern();
        this.pathSeparator = this.initShim.getPathSeparator();
        this.pathSplitter = this.initShim.getPathSplitter();
        this.pathJoiner = this.initShim.getPathJoiner();
        this.multiColumnSeparator = this.initShim.getMultiColumnSeparator();
        this.multiColumnSplitter = this.initShim.getMultiColumnSplitter();
        this.identifierPattern = this.initShim.getIdentifierPattern();
        this.columnPattern = this.initShim.getColumnPattern();
        this.joinConditionStart = this.initShim.getJoinConditionStart();
        this.joinConditionSeparator = this.initShim.getJoinConditionSeparator();
        this.joinConditionEnd = this.initShim.getJoinConditionEnd();
        this.joinConditionPattern = this.initShim.getJoinConditionPattern();
        this.joinConditionPlainPattern = this.initShim.getJoinConditionPlainPattern();
        this.tablePatternString = this.initShim.getTablePatternString();
        this.tablePatternPlainString = this.initShim.getTablePatternPlainString();
        this.tablePattern = this.initShim.getTablePattern();
        this.joinedTablePattern = this.initShim.getJoinedTablePattern();
        this.columnPathPattern = this.initShim.getColumnPathPattern();
        this.partialColumnPathPattern = this.initShim.getPartialColumnPathPattern();
        this.pathPattern = this.initShim.getPathPattern();
        this.pathPatternString = this.initShim.getPathPatternString();
        this.options = this.initShim.getOptions();
        this.junctionTablePattern = this.initShim.getJunctionTablePattern();
        this.initShim = null;
    }

    private ImmutableSqlPathSyntax(String pathSeparator, String multiColumnSeparator, String identifierPattern, String joinConditionStart, String joinConditionSeparator, String joinConditionEnd, ImmutableSqlPathDefaults options) {
        this.initShim.pathSeparator(pathSeparator);
        this.initShim.multiColumnSeparator(multiColumnSeparator);
        this.initShim.identifierPattern(identifierPattern);
        this.initShim.joinConditionStart(joinConditionStart);
        this.initShim.joinConditionSeparator(joinConditionSeparator);
        this.initShim.joinConditionEnd(joinConditionEnd);
        this.initShim.options(options);
        this.priorityFlagPattern = this.initShim.getPriorityFlagPattern();
        this.oidFlagPattern = this.initShim.getOidFlagPattern();
        this.spatialFlagPattern = this.initShim.getSpatialFlagPattern();
        this.temporalFlagPattern = this.initShim.getTemporalFlagPattern();
        this.queryableFlagPattern = this.initShim.getQueryableFlagPattern();
        this.constantFlagPattern = this.initShim.getConstantFlagPattern();
        this.sortKeyFlagPattern = this.initShim.getSortKeyFlagPattern();
        this.filterFlagPattern = this.initShim.getFilterFlagPattern();
        this.flagsPattern = this.initShim.getFlagsPattern();
        this.pathSeparator = this.initShim.getPathSeparator();
        this.pathSplitter = this.initShim.getPathSplitter();
        this.pathJoiner = this.initShim.getPathJoiner();
        this.multiColumnSeparator = this.initShim.getMultiColumnSeparator();
        this.multiColumnSplitter = this.initShim.getMultiColumnSplitter();
        this.identifierPattern = this.initShim.getIdentifierPattern();
        this.columnPattern = this.initShim.getColumnPattern();
        this.joinConditionStart = this.initShim.getJoinConditionStart();
        this.joinConditionSeparator = this.initShim.getJoinConditionSeparator();
        this.joinConditionEnd = this.initShim.getJoinConditionEnd();
        this.joinConditionPattern = this.initShim.getJoinConditionPattern();
        this.joinConditionPlainPattern = this.initShim.getJoinConditionPlainPattern();
        this.tablePatternString = this.initShim.getTablePatternString();
        this.tablePatternPlainString = this.initShim.getTablePatternPlainString();
        this.tablePattern = this.initShim.getTablePattern();
        this.joinedTablePattern = this.initShim.getJoinedTablePattern();
        this.columnPathPattern = this.initShim.getColumnPathPattern();
        this.partialColumnPathPattern = this.initShim.getPartialColumnPathPattern();
        this.pathPattern = this.initShim.getPathPattern();
        this.pathPatternString = this.initShim.getPathPatternString();
        this.options = this.initShim.getOptions();
        this.junctionTablePattern = this.initShim.getJunctionTablePattern();
        this.initShim = null;
    }

    private String getPriorityFlagPatternInitialize() {
        return SqlPathSyntax.super.getPriorityFlagPattern();
    }

    private String getOidFlagPatternInitialize() {
        return SqlPathSyntax.super.getOidFlagPattern();
    }

    private String getSpatialFlagPatternInitialize() {
        return SqlPathSyntax.super.getSpatialFlagPattern();
    }

    private String getTemporalFlagPatternInitialize() {
        return SqlPathSyntax.super.getTemporalFlagPattern();
    }

    private String getQueryableFlagPatternInitialize() {
        return SqlPathSyntax.super.getQueryableFlagPattern();
    }

    private String getConstantFlagPatternInitialize() {
        return SqlPathSyntax.super.getConstantFlagPattern();
    }

    private String getSortKeyFlagPatternInitialize() {
        return SqlPathSyntax.super.getSortKeyFlagPattern();
    }

    private String getFilterFlagPatternInitialize() {
        return SqlPathSyntax.super.getFilterFlagPattern();
    }

    private String getFlagsPatternInitialize() {
        return SqlPathSyntax.super.getFlagsPattern();
    }

    private String getPathSeparatorInitialize() {
        return SqlPathSyntax.super.getPathSeparator();
    }

    private Splitter getPathSplitterInitialize() {
        return SqlPathSyntax.super.getPathSplitter();
    }

    private Joiner getPathJoinerInitialize() {
        return SqlPathSyntax.super.getPathJoiner();
    }

    private String getMultiColumnSeparatorInitialize() {
        return SqlPathSyntax.super.getMultiColumnSeparator();
    }

    private Splitter getMultiColumnSplitterInitialize() {
        return SqlPathSyntax.super.getMultiColumnSplitter();
    }

    private String getIdentifierPatternInitialize() {
        return SqlPathSyntax.super.getIdentifierPattern();
    }

    private String getColumnPatternInitialize() {
        return SqlPathSyntax.super.getColumnPattern();
    }

    private String getJoinConditionStartInitialize() {
        return SqlPathSyntax.super.getJoinConditionStart();
    }

    private String getJoinConditionSeparatorInitialize() {
        return SqlPathSyntax.super.getJoinConditionSeparator();
    }

    private String getJoinConditionEndInitialize() {
        return SqlPathSyntax.super.getJoinConditionEnd();
    }

    private String getJoinConditionPatternInitialize() {
        return SqlPathSyntax.super.getJoinConditionPattern();
    }

    private String getJoinConditionPlainPatternInitialize() {
        return SqlPathSyntax.super.getJoinConditionPlainPattern();
    }

    private String getTablePatternStringInitialize() {
        return SqlPathSyntax.super.getTablePatternString();
    }

    private String getTablePatternPlainStringInitialize() {
        return SqlPathSyntax.super.getTablePatternPlainString();
    }

    private Pattern getTablePatternInitialize() {
        return SqlPathSyntax.super.getTablePattern();
    }

    private Pattern getJoinedTablePatternInitialize() {
        return SqlPathSyntax.super.getJoinedTablePattern();
    }

    private Pattern getColumnPathPatternInitialize() {
        return SqlPathSyntax.super.getColumnPathPattern();
    }

    private Pattern getPartialColumnPathPatternInitialize() {
        return SqlPathSyntax.super.getPartialColumnPathPattern();
    }

    private Pattern getPathPatternInitialize() {
        return SqlPathSyntax.super.getPathPattern();
    }

    private String getPathPatternStringInitialize() {
        return SqlPathSyntax.super.getPathPatternString();
    }

    private SqlPathDefaults getOptionsInitialize() {
        return SqlPathSyntax.super.getOptions();
    }

    private Pattern getJunctionTablePatternInitialize() {
        return SqlPathSyntax.super.getJunctionTablePattern();
    }

    @Override
    public String getPriorityFlagPattern() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getPriorityFlagPattern() : this.priorityFlagPattern;
    }

    @Override
    public String getOidFlagPattern() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getOidFlagPattern() : this.oidFlagPattern;
    }

    @Override
    public String getSpatialFlagPattern() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getSpatialFlagPattern() : this.spatialFlagPattern;
    }

    @Override
    public String getTemporalFlagPattern() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getTemporalFlagPattern() : this.temporalFlagPattern;
    }

    @Override
    public String getQueryableFlagPattern() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getQueryableFlagPattern() : this.queryableFlagPattern;
    }

    @Override
    public String getConstantFlagPattern() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getConstantFlagPattern() : this.constantFlagPattern;
    }

    @Override
    public String getSortKeyFlagPattern() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getSortKeyFlagPattern() : this.sortKeyFlagPattern;
    }

    @Override
    public String getFilterFlagPattern() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getFilterFlagPattern() : this.filterFlagPattern;
    }

    @Override
    public String getFlagsPattern() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getFlagsPattern() : this.flagsPattern;
    }

    @Override
    public String getPathSeparator() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getPathSeparator() : this.pathSeparator;
    }

    @Override
    public Splitter getPathSplitter() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getPathSplitter() : this.pathSplitter;
    }

    @Override
    public Joiner getPathJoiner() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getPathJoiner() : this.pathJoiner;
    }

    @Override
    public String getMultiColumnSeparator() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getMultiColumnSeparator() : this.multiColumnSeparator;
    }

    @Override
    public Splitter getMultiColumnSplitter() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getMultiColumnSplitter() : this.multiColumnSplitter;
    }

    @Override
    public String getIdentifierPattern() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getIdentifierPattern() : this.identifierPattern;
    }

    @Override
    public String getColumnPattern() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getColumnPattern() : this.columnPattern;
    }

    @Override
    public String getJoinConditionStart() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getJoinConditionStart() : this.joinConditionStart;
    }

    @Override
    public String getJoinConditionSeparator() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getJoinConditionSeparator() : this.joinConditionSeparator;
    }

    @Override
    public String getJoinConditionEnd() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getJoinConditionEnd() : this.joinConditionEnd;
    }

    @Override
    public String getJoinConditionPattern() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getJoinConditionPattern() : this.joinConditionPattern;
    }

    @Override
    public String getJoinConditionPlainPattern() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getJoinConditionPlainPattern() : this.joinConditionPlainPattern;
    }

    @Override
    public String getTablePatternString() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getTablePatternString() : this.tablePatternString;
    }

    @Override
    public String getTablePatternPlainString() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getTablePatternPlainString() : this.tablePatternPlainString;
    }

    @Override
    public Pattern getTablePattern() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getTablePattern() : this.tablePattern;
    }

    @Override
    public Pattern getJoinedTablePattern() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getJoinedTablePattern() : this.joinedTablePattern;
    }

    @Override
    public Pattern getColumnPathPattern() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getColumnPathPattern() : this.columnPathPattern;
    }

    @Override
    public Pattern getPartialColumnPathPattern() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getPartialColumnPathPattern() : this.partialColumnPathPattern;
    }

    @Override
    public Pattern getPathPattern() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getPathPattern() : this.pathPattern;
    }

    @Override
    public String getPathPatternString() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getPathPatternString() : this.pathPatternString;
    }

    @Override
    public ImmutableSqlPathDefaults getOptions() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getOptions() : this.options;
    }

    @Override
    public Pattern getJunctionTablePattern() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getJunctionTablePattern() : this.junctionTablePattern;
    }

    public final ImmutableSqlPathSyntax withPathSeparator(String value) {
        String newValue = Objects.requireNonNull(value, "pathSeparator");
        if (this.pathSeparator.equals(newValue)) {
            return this;
        }
        return new ImmutableSqlPathSyntax(newValue, this.multiColumnSeparator, this.identifierPattern, this.joinConditionStart, this.joinConditionSeparator, this.joinConditionEnd, this.options);
    }

    public final ImmutableSqlPathSyntax withMultiColumnSeparator(String value) {
        String newValue = Objects.requireNonNull(value, "multiColumnSeparator");
        if (this.multiColumnSeparator.equals(newValue)) {
            return this;
        }
        return new ImmutableSqlPathSyntax(this.pathSeparator, newValue, this.identifierPattern, this.joinConditionStart, this.joinConditionSeparator, this.joinConditionEnd, this.options);
    }

    public final ImmutableSqlPathSyntax withIdentifierPattern(String value) {
        String newValue = Objects.requireNonNull(value, "identifierPattern");
        if (this.identifierPattern.equals(newValue)) {
            return this;
        }
        return new ImmutableSqlPathSyntax(this.pathSeparator, this.multiColumnSeparator, newValue, this.joinConditionStart, this.joinConditionSeparator, this.joinConditionEnd, this.options);
    }

    public final ImmutableSqlPathSyntax withJoinConditionStart(String value) {
        String newValue = Objects.requireNonNull(value, "joinConditionStart");
        if (this.joinConditionStart.equals(newValue)) {
            return this;
        }
        return new ImmutableSqlPathSyntax(this.pathSeparator, this.multiColumnSeparator, this.identifierPattern, newValue, this.joinConditionSeparator, this.joinConditionEnd, this.options);
    }

    public final ImmutableSqlPathSyntax withJoinConditionSeparator(String value) {
        String newValue = Objects.requireNonNull(value, "joinConditionSeparator");
        if (this.joinConditionSeparator.equals(newValue)) {
            return this;
        }
        return new ImmutableSqlPathSyntax(this.pathSeparator, this.multiColumnSeparator, this.identifierPattern, this.joinConditionStart, newValue, this.joinConditionEnd, this.options);
    }

    public final ImmutableSqlPathSyntax withJoinConditionEnd(String value) {
        String newValue = Objects.requireNonNull(value, "joinConditionEnd");
        if (this.joinConditionEnd.equals(newValue)) {
            return this;
        }
        return new ImmutableSqlPathSyntax(this.pathSeparator, this.multiColumnSeparator, this.identifierPattern, this.joinConditionStart, this.joinConditionSeparator, newValue, this.options);
    }

    public final ImmutableSqlPathSyntax withOptions(SqlPathDefaults value) {
        if (this.options == value) {
            return this;
        }
        ImmutableSqlPathDefaults newValue = ImmutableSqlPathDefaults.copyOf(value);
        return new ImmutableSqlPathSyntax(this.pathSeparator, this.multiColumnSeparator, this.identifierPattern, this.joinConditionStart, this.joinConditionSeparator, this.joinConditionEnd, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSqlPathSyntax && this.equalTo((ImmutableSqlPathSyntax)another);
    }

    private boolean equalTo(ImmutableSqlPathSyntax another) {
        return this.priorityFlagPattern.equals(another.priorityFlagPattern) && this.oidFlagPattern.equals(another.oidFlagPattern) && this.spatialFlagPattern.equals(another.spatialFlagPattern) && this.temporalFlagPattern.equals(another.temporalFlagPattern) && this.queryableFlagPattern.equals(another.queryableFlagPattern) && this.constantFlagPattern.equals(another.constantFlagPattern) && this.sortKeyFlagPattern.equals(another.sortKeyFlagPattern) && this.filterFlagPattern.equals(another.filterFlagPattern) && this.flagsPattern.equals(another.flagsPattern) && this.pathSeparator.equals(another.pathSeparator) && this.pathSplitter.equals(another.pathSplitter) && this.pathJoiner.equals(another.pathJoiner) && this.multiColumnSeparator.equals(another.multiColumnSeparator) && this.multiColumnSplitter.equals(another.multiColumnSplitter) && this.identifierPattern.equals(another.identifierPattern) && this.columnPattern.equals(another.columnPattern) && this.joinConditionStart.equals(another.joinConditionStart) && this.joinConditionSeparator.equals(another.joinConditionSeparator) && this.joinConditionEnd.equals(another.joinConditionEnd) && this.joinConditionPattern.equals(another.joinConditionPattern) && this.joinConditionPlainPattern.equals(another.joinConditionPlainPattern) && this.tablePatternString.equals(another.tablePatternString) && this.tablePatternPlainString.equals(another.tablePatternPlainString) && this.tablePattern.equals(another.tablePattern) && this.joinedTablePattern.equals(another.joinedTablePattern) && this.columnPathPattern.equals(another.columnPathPattern) && this.partialColumnPathPattern.equals(another.partialColumnPathPattern) && this.pathPattern.equals(another.pathPattern) && this.pathPatternString.equals(another.pathPatternString) && this.options.equals(another.options) && this.junctionTablePattern.equals(another.junctionTablePattern);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.priorityFlagPattern.hashCode();
        h += (h << 5) + this.oidFlagPattern.hashCode();
        h += (h << 5) + this.spatialFlagPattern.hashCode();
        h += (h << 5) + this.temporalFlagPattern.hashCode();
        h += (h << 5) + this.queryableFlagPattern.hashCode();
        h += (h << 5) + this.constantFlagPattern.hashCode();
        h += (h << 5) + this.sortKeyFlagPattern.hashCode();
        h += (h << 5) + this.filterFlagPattern.hashCode();
        h += (h << 5) + this.flagsPattern.hashCode();
        h += (h << 5) + this.pathSeparator.hashCode();
        h += (h << 5) + this.pathSplitter.hashCode();
        h += (h << 5) + this.pathJoiner.hashCode();
        h += (h << 5) + this.multiColumnSeparator.hashCode();
        h += (h << 5) + this.multiColumnSplitter.hashCode();
        h += (h << 5) + this.identifierPattern.hashCode();
        h += (h << 5) + this.columnPattern.hashCode();
        h += (h << 5) + this.joinConditionStart.hashCode();
        h += (h << 5) + this.joinConditionSeparator.hashCode();
        h += (h << 5) + this.joinConditionEnd.hashCode();
        h += (h << 5) + this.joinConditionPattern.hashCode();
        h += (h << 5) + this.joinConditionPlainPattern.hashCode();
        h += (h << 5) + this.tablePatternString.hashCode();
        h += (h << 5) + this.tablePatternPlainString.hashCode();
        h += (h << 5) + this.tablePattern.hashCode();
        h += (h << 5) + this.joinedTablePattern.hashCode();
        h += (h << 5) + this.columnPathPattern.hashCode();
        h += (h << 5) + this.partialColumnPathPattern.hashCode();
        h += (h << 5) + this.pathPattern.hashCode();
        h += (h << 5) + this.pathPatternString.hashCode();
        h += (h << 5) + this.options.hashCode();
        h += (h << 5) + this.junctionTablePattern.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("SqlPathSyntax").omitNullValues().add("priorityFlagPattern", this.priorityFlagPattern).add("oidFlagPattern", this.oidFlagPattern).add("spatialFlagPattern", this.spatialFlagPattern).add("temporalFlagPattern", this.temporalFlagPattern).add("queryableFlagPattern", this.queryableFlagPattern).add("constantFlagPattern", this.constantFlagPattern).add("sortKeyFlagPattern", this.sortKeyFlagPattern).add("filterFlagPattern", this.filterFlagPattern).add("flagsPattern", this.flagsPattern).add("pathSeparator", this.pathSeparator).add("pathSplitter", this.pathSplitter).add("pathJoiner", this.pathJoiner).add("multiColumnSeparator", this.multiColumnSeparator).add("multiColumnSplitter", this.multiColumnSplitter).add("identifierPattern", this.identifierPattern).add("columnPattern", this.columnPattern).add("joinConditionStart", this.joinConditionStart).add("joinConditionSeparator", this.joinConditionSeparator).add("joinConditionEnd", this.joinConditionEnd).add("joinConditionPattern", this.joinConditionPattern).add("joinConditionPlainPattern", this.joinConditionPlainPattern).add("tablePatternString", this.tablePatternString).add("tablePatternPlainString", this.tablePatternPlainString).add("tablePattern", this.tablePattern).add("joinedTablePattern", this.joinedTablePattern).add("columnPathPattern", this.columnPathPattern).add("partialColumnPathPattern", this.partialColumnPathPattern).add("pathPattern", this.pathPattern).add("pathPatternString", this.pathPatternString).add("options", this.options).add("junctionTablePattern", this.junctionTablePattern).toString();
    }

    public static ImmutableSqlPathSyntax copyOf(SqlPathSyntax instance) {
        if (instance instanceof ImmutableSqlPathSyntax) {
            return (ImmutableSqlPathSyntax)instance;
        }
        return ImmutableSqlPathSyntax.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="SqlPathSyntax", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String pathSeparator;
        @Nullable
        private String multiColumnSeparator;
        @Nullable
        private String identifierPattern;
        @Nullable
        private String joinConditionStart;
        @Nullable
        private String joinConditionSeparator;
        @Nullable
        private String joinConditionEnd;
        @Nullable
        private SqlPathDefaults options;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(SqlPathSyntax instance) {
            Objects.requireNonNull(instance, "instance");
            this.pathSeparator(instance.getPathSeparator());
            this.multiColumnSeparator(instance.getMultiColumnSeparator());
            this.identifierPattern(instance.getIdentifierPattern());
            this.joinConditionStart(instance.getJoinConditionStart());
            this.joinConditionSeparator(instance.getJoinConditionSeparator());
            this.joinConditionEnd(instance.getJoinConditionEnd());
            this.options(instance.getOptions());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder pathSeparator(String pathSeparator) {
            this.pathSeparator = Objects.requireNonNull(pathSeparator, "pathSeparator");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder multiColumnSeparator(String multiColumnSeparator) {
            this.multiColumnSeparator = Objects.requireNonNull(multiColumnSeparator, "multiColumnSeparator");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder identifierPattern(String identifierPattern) {
            this.identifierPattern = Objects.requireNonNull(identifierPattern, "identifierPattern");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder joinConditionStart(String joinConditionStart) {
            this.joinConditionStart = Objects.requireNonNull(joinConditionStart, "joinConditionStart");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder joinConditionSeparator(String joinConditionSeparator) {
            this.joinConditionSeparator = Objects.requireNonNull(joinConditionSeparator, "joinConditionSeparator");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder joinConditionEnd(String joinConditionEnd) {
            this.joinConditionEnd = Objects.requireNonNull(joinConditionEnd, "joinConditionEnd");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder options(SqlPathDefaults options) {
            this.options = ImmutableSqlPathDefaults.copyOf(options);
            return this;
        }

        public ImmutableSqlPathSyntax build() {
            return new ImmutableSqlPathSyntax(this);
        }
    }

    @Generated(from="SqlPathSyntax", generator="Immutables")
    private final class InitShim {
        private byte priorityFlagPatternBuildStage = 0;
        private String priorityFlagPattern;
        private byte oidFlagPatternBuildStage = 0;
        private String oidFlagPattern;
        private byte spatialFlagPatternBuildStage = 0;
        private String spatialFlagPattern;
        private byte temporalFlagPatternBuildStage = 0;
        private String temporalFlagPattern;
        private byte queryableFlagPatternBuildStage = 0;
        private String queryableFlagPattern;
        private byte constantFlagPatternBuildStage = 0;
        private String constantFlagPattern;
        private byte sortKeyFlagPatternBuildStage = 0;
        private String sortKeyFlagPattern;
        private byte filterFlagPatternBuildStage = 0;
        private String filterFlagPattern;
        private byte flagsPatternBuildStage = 0;
        private String flagsPattern;
        private byte pathSeparatorBuildStage = 0;
        private String pathSeparator;
        private byte pathSplitterBuildStage = 0;
        private Splitter pathSplitter;
        private byte pathJoinerBuildStage = 0;
        private Joiner pathJoiner;
        private byte multiColumnSeparatorBuildStage = 0;
        private String multiColumnSeparator;
        private byte multiColumnSplitterBuildStage = 0;
        private Splitter multiColumnSplitter;
        private byte identifierPatternBuildStage = 0;
        private String identifierPattern;
        private byte columnPatternBuildStage = 0;
        private String columnPattern;
        private byte joinConditionStartBuildStage = 0;
        private String joinConditionStart;
        private byte joinConditionSeparatorBuildStage = 0;
        private String joinConditionSeparator;
        private byte joinConditionEndBuildStage = 0;
        private String joinConditionEnd;
        private byte joinConditionPatternBuildStage = 0;
        private String joinConditionPattern;
        private byte joinConditionPlainPatternBuildStage = 0;
        private String joinConditionPlainPattern;
        private byte tablePatternStringBuildStage = 0;
        private String tablePatternString;
        private byte tablePatternPlainStringBuildStage = 0;
        private String tablePatternPlainString;
        private byte tablePatternBuildStage = 0;
        private Pattern tablePattern;
        private byte joinedTablePatternBuildStage = 0;
        private Pattern joinedTablePattern;
        private byte columnPathPatternBuildStage = 0;
        private Pattern columnPathPattern;
        private byte partialColumnPathPatternBuildStage = 0;
        private Pattern partialColumnPathPattern;
        private byte pathPatternBuildStage = 0;
        private Pattern pathPattern;
        private byte pathPatternStringBuildStage = 0;
        private String pathPatternString;
        private byte optionsBuildStage = 0;
        private ImmutableSqlPathDefaults options;
        private byte junctionTablePatternBuildStage = 0;
        private Pattern junctionTablePattern;

        private InitShim() {
        }

        String getPriorityFlagPattern() {
            if (this.priorityFlagPatternBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.priorityFlagPatternBuildStage == 0) {
                this.priorityFlagPatternBuildStage = (byte)-1;
                this.priorityFlagPattern = Objects.requireNonNull(ImmutableSqlPathSyntax.this.getPriorityFlagPatternInitialize(), "priorityFlagPattern");
                this.priorityFlagPatternBuildStage = 1;
            }
            return this.priorityFlagPattern;
        }

        String getOidFlagPattern() {
            if (this.oidFlagPatternBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.oidFlagPatternBuildStage == 0) {
                this.oidFlagPatternBuildStage = (byte)-1;
                this.oidFlagPattern = Objects.requireNonNull(ImmutableSqlPathSyntax.this.getOidFlagPatternInitialize(), "oidFlagPattern");
                this.oidFlagPatternBuildStage = 1;
            }
            return this.oidFlagPattern;
        }

        String getSpatialFlagPattern() {
            if (this.spatialFlagPatternBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.spatialFlagPatternBuildStage == 0) {
                this.spatialFlagPatternBuildStage = (byte)-1;
                this.spatialFlagPattern = Objects.requireNonNull(ImmutableSqlPathSyntax.this.getSpatialFlagPatternInitialize(), "spatialFlagPattern");
                this.spatialFlagPatternBuildStage = 1;
            }
            return this.spatialFlagPattern;
        }

        String getTemporalFlagPattern() {
            if (this.temporalFlagPatternBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.temporalFlagPatternBuildStage == 0) {
                this.temporalFlagPatternBuildStage = (byte)-1;
                this.temporalFlagPattern = Objects.requireNonNull(ImmutableSqlPathSyntax.this.getTemporalFlagPatternInitialize(), "temporalFlagPattern");
                this.temporalFlagPatternBuildStage = 1;
            }
            return this.temporalFlagPattern;
        }

        String getQueryableFlagPattern() {
            if (this.queryableFlagPatternBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.queryableFlagPatternBuildStage == 0) {
                this.queryableFlagPatternBuildStage = (byte)-1;
                this.queryableFlagPattern = Objects.requireNonNull(ImmutableSqlPathSyntax.this.getQueryableFlagPatternInitialize(), "queryableFlagPattern");
                this.queryableFlagPatternBuildStage = 1;
            }
            return this.queryableFlagPattern;
        }

        String getConstantFlagPattern() {
            if (this.constantFlagPatternBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.constantFlagPatternBuildStage == 0) {
                this.constantFlagPatternBuildStage = (byte)-1;
                this.constantFlagPattern = Objects.requireNonNull(ImmutableSqlPathSyntax.this.getConstantFlagPatternInitialize(), "constantFlagPattern");
                this.constantFlagPatternBuildStage = 1;
            }
            return this.constantFlagPattern;
        }

        String getSortKeyFlagPattern() {
            if (this.sortKeyFlagPatternBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sortKeyFlagPatternBuildStage == 0) {
                this.sortKeyFlagPatternBuildStage = (byte)-1;
                this.sortKeyFlagPattern = Objects.requireNonNull(ImmutableSqlPathSyntax.this.getSortKeyFlagPatternInitialize(), "sortKeyFlagPattern");
                this.sortKeyFlagPatternBuildStage = 1;
            }
            return this.sortKeyFlagPattern;
        }

        String getFilterFlagPattern() {
            if (this.filterFlagPatternBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.filterFlagPatternBuildStage == 0) {
                this.filterFlagPatternBuildStage = (byte)-1;
                this.filterFlagPattern = Objects.requireNonNull(ImmutableSqlPathSyntax.this.getFilterFlagPatternInitialize(), "filterFlagPattern");
                this.filterFlagPatternBuildStage = 1;
            }
            return this.filterFlagPattern;
        }

        String getFlagsPattern() {
            if (this.flagsPatternBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsPatternBuildStage == 0) {
                this.flagsPatternBuildStage = (byte)-1;
                this.flagsPattern = Objects.requireNonNull(ImmutableSqlPathSyntax.this.getFlagsPatternInitialize(), "flagsPattern");
                this.flagsPatternBuildStage = 1;
            }
            return this.flagsPattern;
        }

        String getPathSeparator() {
            if (this.pathSeparatorBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.pathSeparatorBuildStage == 0) {
                this.pathSeparatorBuildStage = (byte)-1;
                this.pathSeparator = Objects.requireNonNull(ImmutableSqlPathSyntax.this.getPathSeparatorInitialize(), "pathSeparator");
                this.pathSeparatorBuildStage = 1;
            }
            return this.pathSeparator;
        }

        void pathSeparator(String pathSeparator) {
            this.pathSeparator = pathSeparator;
            this.pathSeparatorBuildStage = 1;
        }

        Splitter getPathSplitter() {
            if (this.pathSplitterBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.pathSplitterBuildStage == 0) {
                this.pathSplitterBuildStage = (byte)-1;
                this.pathSplitter = Objects.requireNonNull(ImmutableSqlPathSyntax.this.getPathSplitterInitialize(), "pathSplitter");
                this.pathSplitterBuildStage = 1;
            }
            return this.pathSplitter;
        }

        Joiner getPathJoiner() {
            if (this.pathJoinerBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.pathJoinerBuildStage == 0) {
                this.pathJoinerBuildStage = (byte)-1;
                this.pathJoiner = Objects.requireNonNull(ImmutableSqlPathSyntax.this.getPathJoinerInitialize(), "pathJoiner");
                this.pathJoinerBuildStage = 1;
            }
            return this.pathJoiner;
        }

        String getMultiColumnSeparator() {
            if (this.multiColumnSeparatorBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.multiColumnSeparatorBuildStage == 0) {
                this.multiColumnSeparatorBuildStage = (byte)-1;
                this.multiColumnSeparator = Objects.requireNonNull(ImmutableSqlPathSyntax.this.getMultiColumnSeparatorInitialize(), "multiColumnSeparator");
                this.multiColumnSeparatorBuildStage = 1;
            }
            return this.multiColumnSeparator;
        }

        void multiColumnSeparator(String multiColumnSeparator) {
            this.multiColumnSeparator = multiColumnSeparator;
            this.multiColumnSeparatorBuildStage = 1;
        }

        Splitter getMultiColumnSplitter() {
            if (this.multiColumnSplitterBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.multiColumnSplitterBuildStage == 0) {
                this.multiColumnSplitterBuildStage = (byte)-1;
                this.multiColumnSplitter = Objects.requireNonNull(ImmutableSqlPathSyntax.this.getMultiColumnSplitterInitialize(), "multiColumnSplitter");
                this.multiColumnSplitterBuildStage = 1;
            }
            return this.multiColumnSplitter;
        }

        String getIdentifierPattern() {
            if (this.identifierPatternBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierPatternBuildStage == 0) {
                this.identifierPatternBuildStage = (byte)-1;
                this.identifierPattern = Objects.requireNonNull(ImmutableSqlPathSyntax.this.getIdentifierPatternInitialize(), "identifierPattern");
                this.identifierPatternBuildStage = 1;
            }
            return this.identifierPattern;
        }

        void identifierPattern(String identifierPattern) {
            this.identifierPattern = identifierPattern;
            this.identifierPatternBuildStage = 1;
        }

        String getColumnPattern() {
            if (this.columnPatternBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.columnPatternBuildStage == 0) {
                this.columnPatternBuildStage = (byte)-1;
                this.columnPattern = Objects.requireNonNull(ImmutableSqlPathSyntax.this.getColumnPatternInitialize(), "columnPattern");
                this.columnPatternBuildStage = 1;
            }
            return this.columnPattern;
        }

        String getJoinConditionStart() {
            if (this.joinConditionStartBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.joinConditionStartBuildStage == 0) {
                this.joinConditionStartBuildStage = (byte)-1;
                this.joinConditionStart = Objects.requireNonNull(ImmutableSqlPathSyntax.this.getJoinConditionStartInitialize(), "joinConditionStart");
                this.joinConditionStartBuildStage = 1;
            }
            return this.joinConditionStart;
        }

        void joinConditionStart(String joinConditionStart) {
            this.joinConditionStart = joinConditionStart;
            this.joinConditionStartBuildStage = 1;
        }

        String getJoinConditionSeparator() {
            if (this.joinConditionSeparatorBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.joinConditionSeparatorBuildStage == 0) {
                this.joinConditionSeparatorBuildStage = (byte)-1;
                this.joinConditionSeparator = Objects.requireNonNull(ImmutableSqlPathSyntax.this.getJoinConditionSeparatorInitialize(), "joinConditionSeparator");
                this.joinConditionSeparatorBuildStage = 1;
            }
            return this.joinConditionSeparator;
        }

        void joinConditionSeparator(String joinConditionSeparator) {
            this.joinConditionSeparator = joinConditionSeparator;
            this.joinConditionSeparatorBuildStage = 1;
        }

        String getJoinConditionEnd() {
            if (this.joinConditionEndBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.joinConditionEndBuildStage == 0) {
                this.joinConditionEndBuildStage = (byte)-1;
                this.joinConditionEnd = Objects.requireNonNull(ImmutableSqlPathSyntax.this.getJoinConditionEndInitialize(), "joinConditionEnd");
                this.joinConditionEndBuildStage = 1;
            }
            return this.joinConditionEnd;
        }

        void joinConditionEnd(String joinConditionEnd) {
            this.joinConditionEnd = joinConditionEnd;
            this.joinConditionEndBuildStage = 1;
        }

        String getJoinConditionPattern() {
            if (this.joinConditionPatternBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.joinConditionPatternBuildStage == 0) {
                this.joinConditionPatternBuildStage = (byte)-1;
                this.joinConditionPattern = Objects.requireNonNull(ImmutableSqlPathSyntax.this.getJoinConditionPatternInitialize(), "joinConditionPattern");
                this.joinConditionPatternBuildStage = 1;
            }
            return this.joinConditionPattern;
        }

        String getJoinConditionPlainPattern() {
            if (this.joinConditionPlainPatternBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.joinConditionPlainPatternBuildStage == 0) {
                this.joinConditionPlainPatternBuildStage = (byte)-1;
                this.joinConditionPlainPattern = Objects.requireNonNull(ImmutableSqlPathSyntax.this.getJoinConditionPlainPatternInitialize(), "joinConditionPlainPattern");
                this.joinConditionPlainPatternBuildStage = 1;
            }
            return this.joinConditionPlainPattern;
        }

        String getTablePatternString() {
            if (this.tablePatternStringBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.tablePatternStringBuildStage == 0) {
                this.tablePatternStringBuildStage = (byte)-1;
                this.tablePatternString = Objects.requireNonNull(ImmutableSqlPathSyntax.this.getTablePatternStringInitialize(), "tablePatternString");
                this.tablePatternStringBuildStage = 1;
            }
            return this.tablePatternString;
        }

        String getTablePatternPlainString() {
            if (this.tablePatternPlainStringBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.tablePatternPlainStringBuildStage == 0) {
                this.tablePatternPlainStringBuildStage = (byte)-1;
                this.tablePatternPlainString = Objects.requireNonNull(ImmutableSqlPathSyntax.this.getTablePatternPlainStringInitialize(), "tablePatternPlainString");
                this.tablePatternPlainStringBuildStage = 1;
            }
            return this.tablePatternPlainString;
        }

        Pattern getTablePattern() {
            if (this.tablePatternBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.tablePatternBuildStage == 0) {
                this.tablePatternBuildStage = (byte)-1;
                this.tablePattern = Objects.requireNonNull(ImmutableSqlPathSyntax.this.getTablePatternInitialize(), "tablePattern");
                this.tablePatternBuildStage = 1;
            }
            return this.tablePattern;
        }

        Pattern getJoinedTablePattern() {
            if (this.joinedTablePatternBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.joinedTablePatternBuildStage == 0) {
                this.joinedTablePatternBuildStage = (byte)-1;
                this.joinedTablePattern = Objects.requireNonNull(ImmutableSqlPathSyntax.this.getJoinedTablePatternInitialize(), "joinedTablePattern");
                this.joinedTablePatternBuildStage = 1;
            }
            return this.joinedTablePattern;
        }

        Pattern getColumnPathPattern() {
            if (this.columnPathPatternBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.columnPathPatternBuildStage == 0) {
                this.columnPathPatternBuildStage = (byte)-1;
                this.columnPathPattern = Objects.requireNonNull(ImmutableSqlPathSyntax.this.getColumnPathPatternInitialize(), "columnPathPattern");
                this.columnPathPatternBuildStage = 1;
            }
            return this.columnPathPattern;
        }

        Pattern getPartialColumnPathPattern() {
            if (this.partialColumnPathPatternBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.partialColumnPathPatternBuildStage == 0) {
                this.partialColumnPathPatternBuildStage = (byte)-1;
                this.partialColumnPathPattern = Objects.requireNonNull(ImmutableSqlPathSyntax.this.getPartialColumnPathPatternInitialize(), "partialColumnPathPattern");
                this.partialColumnPathPatternBuildStage = 1;
            }
            return this.partialColumnPathPattern;
        }

        Pattern getPathPattern() {
            if (this.pathPatternBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.pathPatternBuildStage == 0) {
                this.pathPatternBuildStage = (byte)-1;
                this.pathPattern = Objects.requireNonNull(ImmutableSqlPathSyntax.this.getPathPatternInitialize(), "pathPattern");
                this.pathPatternBuildStage = 1;
            }
            return this.pathPattern;
        }

        String getPathPatternString() {
            if (this.pathPatternStringBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.pathPatternStringBuildStage == 0) {
                this.pathPatternStringBuildStage = (byte)-1;
                this.pathPatternString = Objects.requireNonNull(ImmutableSqlPathSyntax.this.getPathPatternStringInitialize(), "pathPatternString");
                this.pathPatternStringBuildStage = 1;
            }
            return this.pathPatternString;
        }

        ImmutableSqlPathDefaults getOptions() {
            if (this.optionsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.optionsBuildStage == 0) {
                this.optionsBuildStage = (byte)-1;
                this.options = ImmutableSqlPathDefaults.copyOf(ImmutableSqlPathSyntax.this.getOptionsInitialize());
                this.optionsBuildStage = 1;
            }
            return this.options;
        }

        void options(ImmutableSqlPathDefaults options) {
            this.options = options;
            this.optionsBuildStage = 1;
        }

        Pattern getJunctionTablePattern() {
            if (this.junctionTablePatternBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.junctionTablePatternBuildStage == 0) {
                this.junctionTablePatternBuildStage = (byte)-1;
                this.junctionTablePattern = Objects.requireNonNull(ImmutableSqlPathSyntax.this.getJunctionTablePatternInitialize(), "junctionTablePattern");
                this.junctionTablePatternBuildStage = 1;
            }
            return this.junctionTablePattern;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.priorityFlagPatternBuildStage == -1) {
                attributes.add("priorityFlagPattern");
            }
            if (this.oidFlagPatternBuildStage == -1) {
                attributes.add("oidFlagPattern");
            }
            if (this.spatialFlagPatternBuildStage == -1) {
                attributes.add("spatialFlagPattern");
            }
            if (this.temporalFlagPatternBuildStage == -1) {
                attributes.add("temporalFlagPattern");
            }
            if (this.queryableFlagPatternBuildStage == -1) {
                attributes.add("queryableFlagPattern");
            }
            if (this.constantFlagPatternBuildStage == -1) {
                attributes.add("constantFlagPattern");
            }
            if (this.sortKeyFlagPatternBuildStage == -1) {
                attributes.add("sortKeyFlagPattern");
            }
            if (this.filterFlagPatternBuildStage == -1) {
                attributes.add("filterFlagPattern");
            }
            if (this.flagsPatternBuildStage == -1) {
                attributes.add("flagsPattern");
            }
            if (this.pathSeparatorBuildStage == -1) {
                attributes.add("pathSeparator");
            }
            if (this.pathSplitterBuildStage == -1) {
                attributes.add("pathSplitter");
            }
            if (this.pathJoinerBuildStage == -1) {
                attributes.add("pathJoiner");
            }
            if (this.multiColumnSeparatorBuildStage == -1) {
                attributes.add("multiColumnSeparator");
            }
            if (this.multiColumnSplitterBuildStage == -1) {
                attributes.add("multiColumnSplitter");
            }
            if (this.identifierPatternBuildStage == -1) {
                attributes.add("identifierPattern");
            }
            if (this.columnPatternBuildStage == -1) {
                attributes.add("columnPattern");
            }
            if (this.joinConditionStartBuildStage == -1) {
                attributes.add("joinConditionStart");
            }
            if (this.joinConditionSeparatorBuildStage == -1) {
                attributes.add("joinConditionSeparator");
            }
            if (this.joinConditionEndBuildStage == -1) {
                attributes.add("joinConditionEnd");
            }
            if (this.joinConditionPatternBuildStage == -1) {
                attributes.add("joinConditionPattern");
            }
            if (this.joinConditionPlainPatternBuildStage == -1) {
                attributes.add("joinConditionPlainPattern");
            }
            if (this.tablePatternStringBuildStage == -1) {
                attributes.add("tablePatternString");
            }
            if (this.tablePatternPlainStringBuildStage == -1) {
                attributes.add("tablePatternPlainString");
            }
            if (this.tablePatternBuildStage == -1) {
                attributes.add("tablePattern");
            }
            if (this.joinedTablePatternBuildStage == -1) {
                attributes.add("joinedTablePattern");
            }
            if (this.columnPathPatternBuildStage == -1) {
                attributes.add("columnPathPattern");
            }
            if (this.partialColumnPathPatternBuildStage == -1) {
                attributes.add("partialColumnPathPattern");
            }
            if (this.pathPatternBuildStage == -1) {
                attributes.add("pathPattern");
            }
            if (this.pathPatternStringBuildStage == -1) {
                attributes.add("pathPatternString");
            }
            if (this.optionsBuildStage == -1) {
                attributes.add("options");
            }
            if (this.junctionTablePatternBuildStage == -1) {
                attributes.add("junctionTablePattern");
            }
            return "Cannot build SqlPathSyntax, attribute initializers form cycle " + attributes;
        }
    }
}

