/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.sql;

import de.ii.xtraplatform.features.sql.SqlPath;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import shadow.com.google.common.base.MoreObjects;
import shadow.com.google.common.collect.ImmutableList;
import shadow.com.google.common.collect.ImmutableMap;
import shadow.com.google.common.primitives.Booleans;
import shadow.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.javax.annotation.CheckReturnValue;
import shadow.javax.annotation.Nullable;
import shadow.javax.annotation.ParametersAreNonnullByDefault;
import shadow.javax.annotation.concurrent.Immutable;
import shadow.javax.annotation.concurrent.NotThreadSafe;
import shadow.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="SqlPath", generator="Immutables")
@Immutable
public final class ImmutableSqlPath
implements SqlPath {
    @Nullable
    private final ImmutableSqlPath parent;
    private final String tablePath;
    private final ImmutableList<String> columns;
    private final boolean isRoot;
    private final boolean isJunction;
    private final boolean hasOid;
    @Nullable
    private final Integer sortPriority;
    private final String queryable;
    private final boolean isSpatial;
    private final boolean isTemporal;
    @Nullable
    private final String constantValue;
    private final ImmutableMap<String, String> tableFlags;
    private final transient String tablePathWithFlags;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableSqlPath(Builder builder) {
        this.parent = builder.parent == null ? null : ImmutableSqlPath.convertToValueTypede_ii_xtraplatform_features_sql_ImmutableSqlPath(builder.parent);
        this.tablePath = builder.tablePath;
        this.columns = builder.columns.build();
        this.sortPriority = builder.sortPriority;
        this.queryable = builder.queryable;
        this.constantValue = builder.constantValue;
        this.tableFlags = builder.tableFlags.build();
        if (builder.isRootIsSet()) {
            this.initShim.isRoot(builder.isRoot);
        }
        if (builder.isJunctionIsSet()) {
            this.initShim.isJunction(builder.isJunction);
        }
        if (builder.hasOidIsSet()) {
            this.initShim.hasOid(builder.hasOid);
        }
        if (builder.isSpatialIsSet()) {
            this.initShim.isSpatial(builder.isSpatial);
        }
        if (builder.isTemporalIsSet()) {
            this.initShim.isTemporal(builder.isTemporal);
        }
        this.isRoot = this.initShim.isRoot();
        this.isJunction = this.initShim.isJunction();
        this.hasOid = this.initShim.hasOid();
        this.isSpatial = this.initShim.isSpatial();
        this.isTemporal = this.initShim.isTemporal();
        this.tablePathWithFlags = this.initShim.getTablePathWithFlags();
        this.initShim = null;
    }

    private ImmutableSqlPath(@Nullable ImmutableSqlPath parent, String tablePath, ImmutableList<String> columns, boolean isRoot, boolean isJunction, boolean hasOid, @Nullable Integer sortPriority, String queryable, boolean isSpatial, boolean isTemporal, @Nullable String constantValue, ImmutableMap<String, String> tableFlags) {
        this.parent = parent;
        this.tablePath = tablePath;
        this.columns = columns;
        this.initShim.isRoot(isRoot);
        this.initShim.isJunction(isJunction);
        this.initShim.hasOid(hasOid);
        this.sortPriority = sortPriority;
        this.queryable = queryable;
        this.initShim.isSpatial(isSpatial);
        this.initShim.isTemporal(isTemporal);
        this.constantValue = constantValue;
        this.tableFlags = tableFlags;
        this.isRoot = this.initShim.isRoot();
        this.isJunction = this.initShim.isJunction();
        this.hasOid = this.initShim.hasOid();
        this.isSpatial = this.initShim.isSpatial();
        this.isTemporal = this.initShim.isTemporal();
        this.tablePathWithFlags = this.initShim.getTablePathWithFlags();
        this.initShim = null;
    }

    private boolean isRootInitialize() {
        return SqlPath.super.isRoot();
    }

    private boolean isJunctionInitialize() {
        return SqlPath.super.isJunction();
    }

    private boolean hasOidInitialize() {
        return SqlPath.super.hasOid();
    }

    private boolean isSpatialInitialize() {
        return SqlPath.super.isSpatial();
    }

    private boolean isTemporalInitialize() {
        return SqlPath.super.isTemporal();
    }

    private String getTablePathWithFlagsInitialize() {
        return SqlPath.super.getTablePathWithFlags();
    }

    @Override
    @Nullable
    public ImmutableSqlPath getParent() {
        return this.parent;
    }

    @Override
    public String getTablePath() {
        return this.tablePath;
    }

    public ImmutableList<String> getColumns() {
        return this.columns;
    }

    @Override
    public boolean isRoot() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isRoot() : this.isRoot;
    }

    @Override
    public boolean isJunction() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isJunction() : this.isJunction;
    }

    @Override
    public boolean hasOid() {
        InitShim shim = this.initShim;
        return shim != null ? shim.hasOid() : this.hasOid;
    }

    @Override
    public OptionalInt getSortPriority() {
        return this.sortPriority != null ? OptionalInt.of(this.sortPriority) : OptionalInt.empty();
    }

    @Override
    public String getQueryable() {
        return this.queryable;
    }

    @Override
    public boolean isSpatial() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isSpatial() : this.isSpatial;
    }

    @Override
    public boolean isTemporal() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isTemporal() : this.isTemporal;
    }

    @Override
    public Optional<String> getConstantValue() {
        return Optional.ofNullable(this.constantValue);
    }

    public ImmutableMap<String, String> getTableFlags() {
        return this.tableFlags;
    }

    @Override
    public String getTablePathWithFlags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getTablePathWithFlags() : this.tablePathWithFlags;
    }

    public final ImmutableSqlPath withParent(@Nullable SqlPath value) {
        if (this.parent == value) {
            return this;
        }
        ImmutableSqlPath newValue = new Builder().from(value).build();
        return new ImmutableSqlPath(newValue, this.tablePath, this.columns, this.isRoot, this.isJunction, this.hasOid, this.sortPriority, this.queryable, this.isSpatial, this.isTemporal, this.constantValue, this.tableFlags);
    }

    public final ImmutableSqlPath withTablePath(String value) {
        String newValue = Objects.requireNonNull(value, "tablePath");
        if (this.tablePath.equals(newValue)) {
            return this;
        }
        return new ImmutableSqlPath(this.parent, newValue, this.columns, this.isRoot, this.isJunction, this.hasOid, this.sortPriority, this.queryable, this.isSpatial, this.isTemporal, this.constantValue, this.tableFlags);
    }

    public final ImmutableSqlPath withColumns(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableSqlPath(this.parent, this.tablePath, newValue, this.isRoot, this.isJunction, this.hasOid, this.sortPriority, this.queryable, this.isSpatial, this.isTemporal, this.constantValue, this.tableFlags);
    }

    public final ImmutableSqlPath withColumns(Iterable<String> elements) {
        if (this.columns == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableSqlPath(this.parent, this.tablePath, newValue, this.isRoot, this.isJunction, this.hasOid, this.sortPriority, this.queryable, this.isSpatial, this.isTemporal, this.constantValue, this.tableFlags);
    }

    public final ImmutableSqlPath withIsRoot(boolean value) {
        if (this.isRoot == value) {
            return this;
        }
        return new ImmutableSqlPath(this.parent, this.tablePath, this.columns, value, this.isJunction, this.hasOid, this.sortPriority, this.queryable, this.isSpatial, this.isTemporal, this.constantValue, this.tableFlags);
    }

    public final ImmutableSqlPath withIsJunction(boolean value) {
        if (this.isJunction == value) {
            return this;
        }
        return new ImmutableSqlPath(this.parent, this.tablePath, this.columns, this.isRoot, value, this.hasOid, this.sortPriority, this.queryable, this.isSpatial, this.isTemporal, this.constantValue, this.tableFlags);
    }

    public final ImmutableSqlPath withHasOid(boolean value) {
        if (this.hasOid == value) {
            return this;
        }
        return new ImmutableSqlPath(this.parent, this.tablePath, this.columns, this.isRoot, this.isJunction, value, this.sortPriority, this.queryable, this.isSpatial, this.isTemporal, this.constantValue, this.tableFlags);
    }

    public final ImmutableSqlPath withSortPriority(int value) {
        Integer newValue = value;
        if (Objects.equals(this.sortPriority, newValue)) {
            return this;
        }
        return new ImmutableSqlPath(this.parent, this.tablePath, this.columns, this.isRoot, this.isJunction, this.hasOid, newValue, this.queryable, this.isSpatial, this.isTemporal, this.constantValue, this.tableFlags);
    }

    public final ImmutableSqlPath withSortPriority(OptionalInt optional) {
        Integer value;
        Integer n = value = optional.isPresent() ? Integer.valueOf(optional.getAsInt()) : null;
        if (Objects.equals(this.sortPriority, value)) {
            return this;
        }
        return new ImmutableSqlPath(this.parent, this.tablePath, this.columns, this.isRoot, this.isJunction, this.hasOid, value, this.queryable, this.isSpatial, this.isTemporal, this.constantValue, this.tableFlags);
    }

    public final ImmutableSqlPath withQueryable(String value) {
        String newValue = Objects.requireNonNull(value, "queryable");
        if (this.queryable.equals(newValue)) {
            return this;
        }
        return new ImmutableSqlPath(this.parent, this.tablePath, this.columns, this.isRoot, this.isJunction, this.hasOid, this.sortPriority, newValue, this.isSpatial, this.isTemporal, this.constantValue, this.tableFlags);
    }

    public final ImmutableSqlPath withIsSpatial(boolean value) {
        if (this.isSpatial == value) {
            return this;
        }
        return new ImmutableSqlPath(this.parent, this.tablePath, this.columns, this.isRoot, this.isJunction, this.hasOid, this.sortPriority, this.queryable, value, this.isTemporal, this.constantValue, this.tableFlags);
    }

    public final ImmutableSqlPath withIsTemporal(boolean value) {
        if (this.isTemporal == value) {
            return this;
        }
        return new ImmutableSqlPath(this.parent, this.tablePath, this.columns, this.isRoot, this.isJunction, this.hasOid, this.sortPriority, this.queryable, this.isSpatial, value, this.constantValue, this.tableFlags);
    }

    public final ImmutableSqlPath withConstantValue(String value) {
        String newValue = Objects.requireNonNull(value, "constantValue");
        if (Objects.equals(this.constantValue, newValue)) {
            return this;
        }
        return new ImmutableSqlPath(this.parent, this.tablePath, this.columns, this.isRoot, this.isJunction, this.hasOid, this.sortPriority, this.queryable, this.isSpatial, this.isTemporal, newValue, this.tableFlags);
    }

    public final ImmutableSqlPath withConstantValue(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.constantValue, value)) {
            return this;
        }
        return new ImmutableSqlPath(this.parent, this.tablePath, this.columns, this.isRoot, this.isJunction, this.hasOid, this.sortPriority, this.queryable, this.isSpatial, this.isTemporal, value, this.tableFlags);
    }

    public final ImmutableSqlPath withTableFlags(Map<String, ? extends String> entries) {
        if (this.tableFlags == entries) {
            return this;
        }
        ImmutableMap<String, String> newValue = ImmutableMap.copyOf(entries);
        return new ImmutableSqlPath(this.parent, this.tablePath, this.columns, this.isRoot, this.isJunction, this.hasOid, this.sortPriority, this.queryable, this.isSpatial, this.isTemporal, this.constantValue, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSqlPath && this.equalTo((ImmutableSqlPath)another);
    }

    private boolean equalTo(ImmutableSqlPath another) {
        return Objects.equals(this.parent, another.parent) && this.tablePath.equals(another.tablePath) && this.columns.equals(another.columns) && this.isRoot == another.isRoot && this.isJunction == another.isJunction && this.hasOid == another.hasOid && Objects.equals(this.sortPriority, another.sortPriority) && this.queryable.equals(another.queryable) && this.isSpatial == another.isSpatial && this.isTemporal == another.isTemporal && Objects.equals(this.constantValue, another.constantValue) && this.tableFlags.equals(another.tableFlags) && this.tablePathWithFlags.equals(another.tablePathWithFlags);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.parent);
        h += (h << 5) + this.tablePath.hashCode();
        h += (h << 5) + this.columns.hashCode();
        h += (h << 5) + Booleans.hashCode(this.isRoot);
        h += (h << 5) + Booleans.hashCode(this.isJunction);
        h += (h << 5) + Booleans.hashCode(this.hasOid);
        h += (h << 5) + Objects.hashCode(this.sortPriority);
        h += (h << 5) + this.queryable.hashCode();
        h += (h << 5) + Booleans.hashCode(this.isSpatial);
        h += (h << 5) + Booleans.hashCode(this.isTemporal);
        h += (h << 5) + Objects.hashCode(this.constantValue);
        h += (h << 5) + this.tableFlags.hashCode();
        h += (h << 5) + this.tablePathWithFlags.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("SqlPath").omitNullValues().add("parent", this.parent).add("tablePath", this.tablePath).add("columns", this.columns).add("isRoot", this.isRoot).add("isJunction", this.isJunction).add("hasOid", this.hasOid).add("sortPriority", this.sortPriority).add("queryable", this.queryable).add("isSpatial", this.isSpatial).add("isTemporal", this.isTemporal).add("constantValue", this.constantValue).add("tableFlags", this.tableFlags).add("tablePathWithFlags", this.tablePathWithFlags).toString();
    }

    public static ImmutableSqlPath copyOf(SqlPath instance) {
        if (instance instanceof ImmutableSqlPath) {
            return (ImmutableSqlPath)instance;
        }
        return new Builder().from(instance).build();
    }

    @Nullable
    private static ImmutableSqlPath convertToValueTypede_ii_xtraplatform_features_sql_ImmutableSqlPath(@Nullable Builder builder) {
        if (builder == null) {
            return null;
        }
        return builder.build();
    }

    @Nullable
    private static SqlPath convertToValueTypede_ii_xtraplatform_features_sql_ImmutableSqlPath(@Nullable SqlPath value) {
        if (value == null) {
            return null;
        }
        return new Builder().from(value).build();
    }

    @Nullable
    private static Builder convertToBuilderTypede_ii_xtraplatform_features_sql_ImmutableSqlPath(@Nullable SqlPath value) {
        if (value == null) {
            return null;
        }
        return new Builder().from(value);
    }

    @Generated(from="SqlPath", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TABLE_PATH = 1L;
        private static final long INIT_BIT_QUERYABLE = 2L;
        private static final long OPT_BIT_IS_ROOT = 1L;
        private static final long OPT_BIT_IS_JUNCTION = 2L;
        private static final long OPT_BIT_HAS_OID = 4L;
        private static final long OPT_BIT_IS_SPATIAL = 8L;
        private static final long OPT_BIT_IS_TEMPORAL = 16L;
        private long initBits = 3L;
        private long optBits;
        @Nullable
        private Builder parent;
        @Nullable
        private String tablePath;
        private ImmutableList.Builder<String> columns = ImmutableList.builder();
        private boolean isRoot;
        private boolean isJunction;
        private boolean hasOid;
        @Nullable
        private Integer sortPriority;
        @Nullable
        private String queryable;
        private boolean isSpatial;
        private boolean isTemporal;
        @Nullable
        private String constantValue;
        private ImmutableMap.Builder<String, String> tableFlags = ImmutableMap.builder();

        @CanIgnoreReturnValue
        public final Builder from(SqlPath instance) {
            Objects.requireNonNull(instance, "instance");
            SqlPath parentValue = instance.getParent();
            if (parentValue != null) {
                this.parent(parentValue);
            }
            this.tablePath(instance.getTablePath());
            this.addAllColumns(instance.getColumns());
            this.isRoot(instance.isRoot());
            this.isJunction(instance.isJunction());
            this.hasOid(instance.hasOid());
            OptionalInt sortPriorityOptional = instance.getSortPriority();
            if (sortPriorityOptional.isPresent()) {
                this.sortPriority(sortPriorityOptional);
            }
            this.queryable(instance.getQueryable());
            this.isSpatial(instance.isSpatial());
            this.isTemporal(instance.isTemporal());
            Optional<String> constantValueOptional = instance.getConstantValue();
            if (constantValueOptional.isPresent()) {
                this.constantValue(constantValueOptional);
            }
            this.putAllTableFlags(instance.getTableFlags());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder parent(@Nullable SqlPath parent) {
            this.parent = new Builder().from(parent == null ? null : Builder.convertToValueTypede_ii_xtraplatform_features_sql_ImmutableSqlPath(parent));
            return this;
        }

        public final Builder parentBuilder() {
            if (this.parent == null) {
                this.parent = new Builder();
            }
            return this.parent;
        }

        @CanIgnoreReturnValue
        public final Builder parentBuilder(@Nullable Builder parent) {
            this.parent = parent;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder tablePath(String tablePath) {
            this.tablePath = Objects.requireNonNull(tablePath, "tablePath");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addColumns(String element) {
            this.columns.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addColumns(String ... elements) {
            this.columns.add(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder columns(Iterable<String> elements) {
            this.columns = ImmutableList.builder();
            return this.addAllColumns(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllColumns(Iterable<String> elements) {
            this.columns.addAll((Iterable)elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder isRoot(boolean isRoot) {
            this.isRoot = isRoot;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder isJunction(boolean isJunction) {
            this.isJunction = isJunction;
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder hasOid(boolean hasOid) {
            this.hasOid = hasOid;
            this.optBits |= 4L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sortPriority(int sortPriority) {
            this.sortPriority = sortPriority;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sortPriority(OptionalInt sortPriority) {
            this.sortPriority = sortPriority.isPresent() ? Integer.valueOf(sortPriority.getAsInt()) : null;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder queryable(String queryable) {
            this.queryable = Objects.requireNonNull(queryable, "queryable");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder isSpatial(boolean isSpatial) {
            this.isSpatial = isSpatial;
            this.optBits |= 8L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder isTemporal(boolean isTemporal) {
            this.isTemporal = isTemporal;
            this.optBits |= 0x10L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder constantValue(String constantValue) {
            this.constantValue = Objects.requireNonNull(constantValue, "constantValue");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder constantValue(Optional<String> constantValue) {
            this.constantValue = constantValue.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putTableFlags(String key, String value) {
            this.tableFlags.put(key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putTableFlags(Map.Entry<String, ? extends String> entry) {
            this.tableFlags.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder tableFlags(Map<String, ? extends String> entries) {
            this.tableFlags = ImmutableMap.builder();
            return this.putAllTableFlags(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllTableFlags(Map<String, ? extends String> entries) {
            this.tableFlags.putAll(entries);
            return this;
        }

        public ImmutableSqlPath build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSqlPath(this);
        }

        private boolean isRootIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean isJunctionIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean hasOidIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean isSpatialIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean isTemporalIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("tablePath");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("queryable");
            }
            return "Cannot build SqlPath, some of required attributes are not set " + attributes;
        }

        @Nullable
        private static ImmutableSqlPath convertToValueTypede_ii_xtraplatform_features_sql_ImmutableSqlPath(@Nullable Builder builder) {
            if (builder == null) {
                return null;
            }
            return builder.build();
        }

        @Nullable
        private static SqlPath convertToValueTypede_ii_xtraplatform_features_sql_ImmutableSqlPath(@Nullable SqlPath value) {
            if (value == null) {
                return null;
            }
            return new Builder().from(value).build();
        }

        @Nullable
        private static Builder convertToBuilderTypede_ii_xtraplatform_features_sql_ImmutableSqlPath(@Nullable SqlPath value) {
            if (value == null) {
                return null;
            }
            return new Builder().from(value);
        }
    }

    @Generated(from="SqlPath", generator="Immutables")
    private final class InitShim {
        private byte isRootBuildStage = 0;
        private boolean isRoot;
        private byte isJunctionBuildStage = 0;
        private boolean isJunction;
        private byte hasOidBuildStage = 0;
        private boolean hasOid;
        private byte isSpatialBuildStage = 0;
        private boolean isSpatial;
        private byte isTemporalBuildStage = 0;
        private boolean isTemporal;
        private byte tablePathWithFlagsBuildStage = 0;
        private String tablePathWithFlags;

        private InitShim() {
        }

        boolean isRoot() {
            if (this.isRootBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isRootBuildStage == 0) {
                this.isRootBuildStage = (byte)-1;
                this.isRoot = ImmutableSqlPath.this.isRootInitialize();
                this.isRootBuildStage = 1;
            }
            return this.isRoot;
        }

        void isRoot(boolean isRoot) {
            this.isRoot = isRoot;
            this.isRootBuildStage = 1;
        }

        boolean isJunction() {
            if (this.isJunctionBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isJunctionBuildStage == 0) {
                this.isJunctionBuildStage = (byte)-1;
                this.isJunction = ImmutableSqlPath.this.isJunctionInitialize();
                this.isJunctionBuildStage = 1;
            }
            return this.isJunction;
        }

        void isJunction(boolean isJunction) {
            this.isJunction = isJunction;
            this.isJunctionBuildStage = 1;
        }

        boolean hasOid() {
            if (this.hasOidBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hasOidBuildStage == 0) {
                this.hasOidBuildStage = (byte)-1;
                this.hasOid = ImmutableSqlPath.this.hasOidInitialize();
                this.hasOidBuildStage = 1;
            }
            return this.hasOid;
        }

        void hasOid(boolean hasOid) {
            this.hasOid = hasOid;
            this.hasOidBuildStage = 1;
        }

        boolean isSpatial() {
            if (this.isSpatialBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isSpatialBuildStage == 0) {
                this.isSpatialBuildStage = (byte)-1;
                this.isSpatial = ImmutableSqlPath.this.isSpatialInitialize();
                this.isSpatialBuildStage = 1;
            }
            return this.isSpatial;
        }

        void isSpatial(boolean isSpatial) {
            this.isSpatial = isSpatial;
            this.isSpatialBuildStage = 1;
        }

        boolean isTemporal() {
            if (this.isTemporalBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isTemporalBuildStage == 0) {
                this.isTemporalBuildStage = (byte)-1;
                this.isTemporal = ImmutableSqlPath.this.isTemporalInitialize();
                this.isTemporalBuildStage = 1;
            }
            return this.isTemporal;
        }

        void isTemporal(boolean isTemporal) {
            this.isTemporal = isTemporal;
            this.isTemporalBuildStage = 1;
        }

        String getTablePathWithFlags() {
            if (this.tablePathWithFlagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.tablePathWithFlagsBuildStage == 0) {
                this.tablePathWithFlagsBuildStage = (byte)-1;
                this.tablePathWithFlags = Objects.requireNonNull(ImmutableSqlPath.this.getTablePathWithFlagsInitialize(), "tablePathWithFlags");
                this.tablePathWithFlagsBuildStage = 1;
            }
            return this.tablePathWithFlags;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.isRootBuildStage == -1) {
                attributes.add("isRoot");
            }
            if (this.isJunctionBuildStage == -1) {
                attributes.add("isJunction");
            }
            if (this.hasOidBuildStage == -1) {
                attributes.add("hasOid");
            }
            if (this.isSpatialBuildStage == -1) {
                attributes.add("isSpatial");
            }
            if (this.isTemporalBuildStage == -1) {
                attributes.add("isTemporal");
            }
            if (this.tablePathWithFlagsBuildStage == -1) {
                attributes.add("tablePathWithFlags");
            }
            return "Cannot build SqlPath, attribute initializers form cycle " + attributes;
        }
    }
}

