/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.domain.transform;

import de.ii.xtraplatform.codelists.domain.Codelist;
import de.ii.xtraplatform.features.domain.FeatureSchema;
import de.ii.xtraplatform.features.domain.SchemaBase;
import de.ii.xtraplatform.features.domain.SchemaMapping;
import de.ii.xtraplatform.features.domain.transform.ContextTransformerChain;
import de.ii.xtraplatform.features.domain.transform.FeaturePropertyValueTransformer;
import de.ii.xtraplatform.features.domain.transform.ImmutableFeaturePropertyTransformerCodelist;
import de.ii.xtraplatform.features.domain.transform.ImmutableFeaturePropertyTransformerDateFormat;
import de.ii.xtraplatform.features.domain.transform.ImmutableFeaturePropertyTransformerNullValue;
import de.ii.xtraplatform.features.domain.transform.ImmutableFeaturePropertyTransformerStringFormat;
import de.ii.xtraplatform.features.domain.transform.PropertyTransformation;
import de.ii.xtraplatform.features.domain.transform.TransformerChain;
import java.time.ZoneId;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import shadow.com.google.common.collect.ImmutableList;
import shadow.com.google.common.collect.ImmutableMap;
import shadow.javax.annotation.Nullable;

public class ValueTransformerChain
implements TransformerChain<String, FeaturePropertyValueTransformer> {
    public static final String VALUE_TYPE_WILDCARD = "*{valueType=";
    private final Map<String, List<FeaturePropertyValueTransformer>> transformers;

    public ValueTransformerChain(Map<String, List<PropertyTransformation>> allTransformations, SchemaMapping schemaMapping, Map<String, Codelist> codelists, Optional<ZoneId> defaultTimeZone, Function<String, String> substitutionLookup) {
        this.transformers = allTransformations.entrySet().stream().flatMap(entry -> {
            String propertyPath = (String)entry.getKey();
            List transformation = (List)entry.getValue();
            if (this.hasWildcard(propertyPath, VALUE_TYPE_WILDCARD)) {
                return this.createContextTransformersForValueType(propertyPath, schemaMapping, transformation, codelists, defaultTimeZone, substitutionLookup).entrySet().stream();
            }
            if (this.hasWildcard(propertyPath, "*{objectType=")) {
                return this.createContextTransformersForObjectType(propertyPath, schemaMapping, transformation, codelists, defaultTimeZone, substitutionLookup).entrySet().stream();
            }
            return Stream.of(new AbstractMap.SimpleEntry<String, List<FeaturePropertyValueTransformer>>(propertyPath, this.createValueTransformers(propertyPath, transformation, codelists, defaultTimeZone, substitutionLookup)));
        }).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue, (first, second) -> ((ImmutableList.Builder)((ImmutableList.Builder)new ImmutableList.Builder().addAll((Iterable)first)).addAll((Iterable)second)).build()));
    }

    @Override
    @Nullable
    public String transform(String path, String value) {
        String transformed = value;
        transformed = this.run(this.transformers, path, path, value);
        return transformed;
    }

    @Override
    public boolean has(String path) {
        return this.transformers.containsKey(path);
    }

    @Override
    public List<FeaturePropertyValueTransformer> get(String path) {
        return this.transformers.get(path);
    }

    private String run(Map<String, List<FeaturePropertyValueTransformer>> valueTransformations, String keyPath, String propertyPath, String value) {
        String transformed = value;
        if (valueTransformations.containsKey(keyPath) && !valueTransformations.get(keyPath).isEmpty()) {
            for (FeaturePropertyValueTransformer valueTransformer : valueTransformations.get(keyPath)) {
                transformed = valueTransformer.transform(propertyPath, transformed);
            }
        }
        return transformed;
    }

    private List<FeaturePropertyValueTransformer> createValueTransformers(String path, List<PropertyTransformation> propertyTransformations, Map<String, Codelist> codelists, Optional<ZoneId> defaultTimeZone, Function<String, String> substitutionLookup) {
        ArrayList<FeaturePropertyValueTransformer> transformers = new ArrayList<FeaturePropertyValueTransformer>();
        propertyTransformations.forEach(propertyTransformation -> {
            propertyTransformation.getNullify().forEach(nullValue -> transformers.add(ImmutableFeaturePropertyTransformerNullValue.builder().propertyPath(path).parameter((String)nullValue).build()));
            propertyTransformation.getStringFormat().ifPresent(stringFormat -> transformers.add(ImmutableFeaturePropertyTransformerStringFormat.builder().propertyPath(path).parameter((String)stringFormat).substitutionLookup(substitutionLookup).build()));
            propertyTransformation.getReduceStringFormat().ifPresent(stringFormat -> transformers.add(ImmutableFeaturePropertyTransformerStringFormat.builder().propertyPath(path).parameter((String)stringFormat).substitutionLookup(substitutionLookup).build()));
            propertyTransformation.getDateFormat().ifPresent(dateFormat -> transformers.add(ImmutableFeaturePropertyTransformerDateFormat.builder().propertyPath(path).parameter((String)dateFormat).defaultTimeZone(defaultTimeZone).build()));
            propertyTransformation.getCodelist().ifPresent(codelist -> transformers.add(ImmutableFeaturePropertyTransformerCodelist.builder().propertyPath(path).parameter((String)codelist).codelists(codelists).build()));
        });
        return transformers;
    }

    private Map<String, List<FeaturePropertyValueTransformer>> createContextTransformersForValueType(String transformationKey, SchemaMapping schemaMapping, List<PropertyTransformation> propertyTransformation, Map<String, Codelist> codelists, Optional<ZoneId> defaultTimeZone, Function<String, String> substitutionLookup) {
        return this.explodeWildcard(transformationKey, VALUE_TYPE_WILDCARD, schemaMapping, this::matchesValueType).stream().map(propertyPath -> new AbstractMap.SimpleEntry<String, List<FeaturePropertyValueTransformer>>((String)propertyPath, this.createValueTransformers((String)propertyPath, propertyTransformation, codelists, defaultTimeZone, substitutionLookup))).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private boolean matchesValueType(FeatureSchema schema, String valueType) {
        return schema.isValue() && Objects.equals((Object)schema.getValueType().orElse(schema.getType()), (Object)SchemaBase.Type.valueOf(valueType));
    }

    private Map<String, List<FeaturePropertyValueTransformer>> createContextTransformersForObjectType(String transformationKey, SchemaMapping schemaMapping, List<PropertyTransformation> propertyTransformation, Map<String, Codelist> codelists, Optional<ZoneId> defaultTimeZone, Function<String, String> substitutionLookup) {
        return this.explodeWildcard(transformationKey, "*{objectType=", schemaMapping, ContextTransformerChain::matchesObjectType).stream().map(propertyPath -> new AbstractMap.SimpleEntry<String, List<FeaturePropertyValueTransformer>>((String)propertyPath, this.createValueTransformers((String)propertyPath, propertyTransformation, codelists, defaultTimeZone, substitutionLookup))).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

