/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.domain.transform;

import de.ii.xtraplatform.features.domain.FeatureSchema;
import de.ii.xtraplatform.features.domain.SchemaMapping;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import shadow.com.google.common.collect.ImmutableList;
import shadow.javax.annotation.Nullable;

public interface TransformerChain<T, U> {
    @Nullable
    public T transform(String var1, T var2);

    public boolean has(String var1);

    public List<U> get(String var1);

    default public boolean hasWildcard(String propertyPath, String wildcardParameter) {
        return propertyPath.startsWith(wildcardParameter) && propertyPath.length() > wildcardParameter.length() + 1;
    }

    default public String extractWildcardParameter(String propertyPath, String wildcardParameter) {
        return propertyPath.substring(wildcardParameter.length(), propertyPath.length() - 1);
    }

    default public List<String> explodeWildcard(String transformationKey, String wildcardPattern, SchemaMapping schemaMapping, BiPredicate<FeatureSchema, String> filter) {
        if (!this.hasWildcard(transformationKey, wildcardPattern)) {
            return ImmutableList.of();
        }
        return schemaMapping.getTargetSchemasByPath().entrySet().stream().filter(entry -> ((List)entry.getValue()).stream().anyMatch(schema -> filter.test((FeatureSchema)schema, this.extractWildcardParameter(transformationKey, wildcardPattern)))).map(entry -> String.join((CharSequence)".", (Iterable)entry.getKey())).collect(Collectors.toList());
    }
}

