/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.domain.transform;

import de.ii.xtraplatform.features.domain.FeatureSchema;
import de.ii.xtraplatform.features.domain.SchemaMapping;
import de.ii.xtraplatform.features.domain.transform.FeaturePropertySchemaTransformer;
import de.ii.xtraplatform.features.domain.transform.ImmutableFeaturePropertyTransformerFlatten;
import de.ii.xtraplatform.features.domain.transform.ImmutableFeaturePropertyTransformerRemove;
import de.ii.xtraplatform.features.domain.transform.ImmutableFeaturePropertyTransformerRename;
import de.ii.xtraplatform.features.domain.transform.PropertyTransformation;
import de.ii.xtraplatform.features.domain.transform.TransformerChain;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import shadow.com.google.common.collect.ImmutableList;
import shadow.com.google.common.collect.ImmutableMap;
import shadow.javax.annotation.Nullable;

public class SchemaTransformerChain
implements TransformerChain<FeatureSchema, FeaturePropertySchemaTransformer> {
    public static final String OBJECT_TYPE_WILDCARD = "*{objectType=";
    private final List<String> currentParentProperties = new ArrayList<String>();
    private final Map<String, List<FeaturePropertySchemaTransformer>> transformers;

    public SchemaTransformerChain(Map<String, List<PropertyTransformation>> allTransformations, SchemaMapping schemaMapping, boolean inCollection, BiFunction<String, String, String> flattenedPathProvider) {
        this.transformers = allTransformations.entrySet().stream().flatMap(entry -> {
            String propertyPath = (String)entry.getKey();
            List transformation = (List)entry.getValue();
            if (this.hasWildcard(propertyPath, OBJECT_TYPE_WILDCARD)) {
                return this.createSchemaTransformersForObjectType(propertyPath, schemaMapping, transformation, inCollection, flattenedPathProvider).entrySet().stream();
            }
            return Stream.of(new AbstractMap.SimpleEntry<String, List<FeaturePropertySchemaTransformer>>(propertyPath, this.createSchemaTransformers(propertyPath, transformation, inCollection, flattenedPathProvider)));
        }).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue, (first, second) -> ((ImmutableList.Builder)((ImmutableList.Builder)new ImmutableList.Builder().addAll((Iterable)first)).addAll((Iterable)second)).build()));
    }

    @Override
    @Nullable
    public FeatureSchema transform(String path, FeatureSchema schema) {
        FeatureSchema transformed = schema;
        for (int i = this.currentParentProperties.size() - 1; i >= 0; --i) {
            String parentPath = this.currentParentProperties.get(i);
            if (!path.startsWith(parentPath)) {
                this.currentParentProperties.remove(i);
                continue;
            }
            if (!this.transformers.containsKey(parentPath) || !Objects.isNull(transformed = this.run(this.transformers, parentPath, path, schema))) continue;
            return null;
        }
        if (!(schema.isValue() || !this.currentParentProperties.isEmpty() && Objects.equals(this.currentParentProperties.get(this.currentParentProperties.size() - 1), path))) {
            this.currentParentProperties.add(path);
        }
        transformed = this.run(this.transformers, path, path, schema);
        return transformed;
    }

    @Override
    public boolean has(String path) {
        return this.transformers.containsKey(path);
    }

    @Override
    public List<FeaturePropertySchemaTransformer> get(String path) {
        return this.transformers.get(path);
    }

    private FeatureSchema run(Map<String, List<FeaturePropertySchemaTransformer>> schemaTransformations, String keyPath, String propertyPath, FeatureSchema schema) {
        FeatureSchema transformed;
        block3: {
            block2: {
                transformed = schema;
                if (!schemaTransformations.containsKey(keyPath) || schemaTransformations.get(keyPath).isEmpty()) break block2;
                for (FeaturePropertySchemaTransformer schemaTransformer : schemaTransformations.get(keyPath)) {
                    transformed = schemaTransformer.transform(propertyPath, transformed);
                    if (!Objects.isNull(transformed)) continue;
                    return null;
                }
                break block3;
            }
            if (!schemaTransformations.containsKey("*") || schemaTransformations.get("*").isEmpty()) break block3;
            for (FeaturePropertySchemaTransformer schemaTransformer : (List)schemaTransformations.getOrDefault("*", ImmutableList.of())) {
                transformed = schemaTransformer.transform(propertyPath, transformed);
                if (!Objects.isNull(transformed)) continue;
                return null;
            }
        }
        return transformed;
    }

    private List<FeaturePropertySchemaTransformer> createSchemaTransformers(String path, List<PropertyTransformation> propertyTransformations, boolean inCollection, BiFunction<String, String, String> flattenedPathProvider) {
        ArrayList<FeaturePropertySchemaTransformer> transformers = new ArrayList<FeaturePropertySchemaTransformer>();
        propertyTransformations.forEach(propertyTransformation -> {
            propertyTransformation.getRename().ifPresent(rename -> transformers.add(ImmutableFeaturePropertyTransformerRename.builder().propertyPath(path).parameter((String)rename).build()));
            propertyTransformation.getRemove().ifPresent(remove -> transformers.add(ImmutableFeaturePropertyTransformerRemove.builder().propertyPath(path).parameter((String)remove).inCollection(inCollection).build()));
            propertyTransformation.getFlatten().ifPresent(flatten -> transformers.add(ImmutableFeaturePropertyTransformerFlatten.builder().propertyPath(path).parameter((String)flatten).flattenedPathProvider(flattenedPathProvider).build()));
        });
        return transformers;
    }

    private Map<String, List<FeaturePropertySchemaTransformer>> createSchemaTransformersForObjectType(String transformationKey, SchemaMapping schemaMapping, List<PropertyTransformation> propertyTransformation, boolean inCollection, BiFunction<String, String, String> flattenedPathProvider) {
        return this.explodeWildcard(transformationKey, OBJECT_TYPE_WILDCARD, schemaMapping, this::matchesObjectType).stream().map(propertyPath -> new AbstractMap.SimpleEntry<String, List<FeaturePropertySchemaTransformer>>((String)propertyPath, this.createSchemaTransformers((String)propertyPath, propertyTransformation, inCollection, flattenedPathProvider))).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private boolean matchesObjectType(FeatureSchema schema, String objectType) {
        return schema.getObjectType().isPresent() && Objects.equals(schema.getObjectType().get(), objectType);
    }
}

