/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.domain.transform;

import de.ii.xtraplatform.codelists.domain.Codelist;
import de.ii.xtraplatform.features.domain.FeatureEventHandler;
import de.ii.xtraplatform.features.domain.FeatureSchema;
import de.ii.xtraplatform.features.domain.SchemaMapping;
import de.ii.xtraplatform.features.domain.transform.ContextTransformerChain;
import de.ii.xtraplatform.features.domain.transform.FeaturePropertyContextTransformer;
import de.ii.xtraplatform.features.domain.transform.FeaturePropertySchemaTransformer;
import de.ii.xtraplatform.features.domain.transform.FeaturePropertyValueTransformer;
import de.ii.xtraplatform.features.domain.transform.PropertyTransformation;
import de.ii.xtraplatform.features.domain.transform.SchemaTransformerChain;
import de.ii.xtraplatform.features.domain.transform.TransformerChain;
import de.ii.xtraplatform.features.domain.transform.ValueTransformerChain;
import java.time.ZoneId;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shadow.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.com.google.common.collect.ImmutableList;
import shadow.com.google.common.collect.ImmutableMap;
import shadow.org.immutables.value.Value;

public interface PropertyTransformations {
    public static final Logger LOGGER = LoggerFactory.getLogger(PropertyTransformations.class);
    public static final String WILDCARD = "*";

    public Map<String, List<PropertyTransformation>> getTransformations();

    default public boolean hasTransformation(String key, Predicate<PropertyTransformation> predicate) {
        return this.getTransformations().containsKey(key) && this.getTransformations().get(key).stream().anyMatch(predicate);
    }

    default public Map<String, List<PropertyTransformation>> withTransformation(String key, PropertyTransformation transformation) {
        LinkedHashMap<String, List<PropertyTransformation>> transformations = new LinkedHashMap<String, List<PropertyTransformation>>(this.getTransformations());
        transformations.compute(key, (ignore, existingTransformations) -> Objects.isNull(existingTransformations) ? ImmutableList.of(transformation) : Stream.concat(existingTransformations.stream(), Stream.of(transformation)).collect(Collectors.toList()));
        return transformations;
    }

    default public PropertyTransformations withSubstitutions(final Map<String, String> substitutions) {
        final Map<String, List<PropertyTransformation>> transformations = this.getTransformations();
        return new PropertyTransformations(){

            @Override
            public Map<String, List<PropertyTransformation>> getTransformations() {
                return transformations;
            }

            @Override
            public TransformerChain<String, FeaturePropertyValueTransformer> getValueTransformations(SchemaMapping schemaMapping, Map<String, Codelist> codelists, Optional<ZoneId> defaultTimeZone) {
                return PropertyTransformations.super.getValueTransformations(schemaMapping, codelists, defaultTimeZone, substitutions::get);
            }

            @Override
            public TransformerChain<String, FeaturePropertyValueTransformer> getValueTransformations(SchemaMapping schemaMapping, Map<String, Codelist> codelists, Optional<ZoneId> defaultTimeZone, Function<String, String> substitutionLookup) {
                return PropertyTransformations.super.getValueTransformations(schemaMapping, codelists, defaultTimeZone, key -> substitutions.containsKey(key) ? (String)substitutions.get(key) : (String)substitutionLookup.apply((String)key));
            }

            @Override
            public PropertyTransformations mergeInto(PropertyTransformations source) {
                return PropertyTransformations.super.mergeInto(source).withSubstitutions(substitutions);
            }
        };
    }

    default public TransformerChain<FeatureSchema, FeaturePropertySchemaTransformer> getSchemaTransformations(SchemaMapping schemaMapping, boolean inCollection, BiFunction<String, String, String> flattenedPathProvider) {
        return new SchemaTransformerChain(this.getTransformations(), schemaMapping, inCollection, flattenedPathProvider);
    }

    default public TransformerChain<FeatureEventHandler.ModifiableContext<FeatureSchema, SchemaMapping>, FeaturePropertyContextTransformer> getContextTransformations(SchemaMapping schemaMapping) {
        return new ContextTransformerChain(this.getTransformations(), schemaMapping);
    }

    default public TransformerChain<String, FeaturePropertyValueTransformer> getValueTransformations(SchemaMapping schemaMapping, Map<String, Codelist> codelists, Optional<ZoneId> defaultTimeZone) {
        return this.getValueTransformations(schemaMapping, codelists, defaultTimeZone, key -> null);
    }

    default public TransformerChain<String, FeaturePropertyValueTransformer> getValueTransformations(SchemaMapping schemaMapping, Map<String, Codelist> codelists, Optional<ZoneId> defaultTimeZone, Function<String, String> substitutionLookup) {
        return new ValueTransformerChain(this.getTransformations(), schemaMapping, codelists, defaultTimeZone, substitutionLookup);
    }

    @JsonIgnore
    @Value.Derived
    @Value.Auxiliary
    default public boolean hasDeprecatedTransformationKeys() {
        return this.getTransformations().keySet().stream().anyMatch(key -> key.matches(".*\\[[^\\]]*\\].*"));
    }

    default public Map<String, List<PropertyTransformation>> normalizeTransformationKeys(String buildingBlock, String collectionId) {
        return this.getTransformations().entrySet().stream().map(transformation -> {
            if (((String)transformation.getKey()).matches(".*\\[[^\\]]*\\].*")) {
                LOGGER.info("The transformation key '{}' in collection '{}' uses a deprecated style that includes square brackets for arrays. The brackets have been dropped during hydration. Building block: {}.", transformation.getKey(), collectionId, buildingBlock);
            }
            return new AbstractMap.SimpleEntry<String, List>(((String)transformation.getKey()).replaceAll("\\[[^\\]]*\\]", ""), (List)transformation.getValue());
        }).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    default public PropertyTransformations mergeInto(PropertyTransformations source) {
        LinkedHashMap<String, List<PropertyTransformation>> mergedTransformations = new LinkedHashMap<String, List<PropertyTransformation>>(source.getTransformations());
        this.getTransformations().forEach((key, transformation) -> {
            if (mergedTransformations.containsKey(key) && !Objects.equals(mergedTransformations.get(key), transformation)) {
                ArrayList chained = new ArrayList();
                chained.addAll((Collection)mergedTransformations.get(key));
                chained.addAll(transformation);
                mergedTransformations.put((String)key, chained);
            } else {
                mergedTransformations.put((String)key, (List<PropertyTransformation>)transformation);
            }
        });
        return () -> mergedTransformations;
    }
}

