/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.domain.transform;

import de.ii.xtraplatform.features.domain.transform.FeaturePropertyTransformerRemove;
import de.ii.xtraplatform.features.domain.transform.ImmutablePropertyTransformation;
import de.ii.xtraplatform.store.domain.entities.ImmutableValidationResult;
import de.ii.xtraplatform.store.domain.entities.Mergeable;
import de.ii.xtraplatform.store.domain.entities.maptobuilder.Buildable;
import de.ii.xtraplatform.store.domain.entities.maptobuilder.BuildableBuilder;
import java.text.MessageFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import shadow.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.com.google.common.collect.ImmutableList;
import shadow.org.immutables.value.Value;

@JsonDeserialize(builder=ImmutablePropertyTransformation.Builder.class)
@Value.Immutable
@Value.Style(builder="new")
public interface PropertyTransformation
extends Buildable<PropertyTransformation>,
Mergeable<PropertyTransformation> {
    default public Builder getBuilder() {
        return new ImmutablePropertyTransformation.Builder().from(this);
    }

    public Optional<String> getRename();

    public Optional<String> getRemove();

    public Optional<String> getFlatten();

    public Optional<String> getReduceStringFormat();

    public Optional<String> getStringFormat();

    public Optional<String> getDateFormat();

    public Optional<String> getCodelist();

    @Deprecated
    @JsonProperty(value="null", access=JsonProperty.Access.WRITE_ONLY)
    public Optional<String> getNull();

    @Value.Default
    default public List<String> getNullify() {
        return this.getNull().map(ImmutableList::of).orElse(ImmutableList.of());
    }

    @Override
    default public PropertyTransformation mergeInto(PropertyTransformation source) {
        return new ImmutablePropertyTransformation.Builder().from(source).from(this).nullify(Stream.concat(source.getNullify().stream(), this.getNullify().stream()).distinct().collect(Collectors.toList())).build();
    }

    default public ImmutableValidationResult.Builder validate(ImmutableValidationResult.Builder builder, String collectionId, String property, Collection<String> codelists) {
        Optional<String> null_;
        Optional<String> codelist;
        Optional<String> dateFormat;
        Optional<String> remove = this.getRemove();
        if (remove.isPresent() && !FeaturePropertyTransformerRemove.CONDITION_VALUES.contains(remove.get())) {
            builder.addStrictErrors(MessageFormat.format("The remove transformation in collection ''{0}'' for property ''{1}'' is invalid. The value ''{2}'' is not one of the known values: {3}.", collectionId, property, remove.get(), FeaturePropertyTransformerRemove.CONDITION_VALUES));
        }
        if ((dateFormat = this.getDateFormat()).isPresent()) {
            try {
                LocalDate.now().format(DateTimeFormatter.ofPattern(dateFormat.get()));
            }
            catch (Exception e) {
                builder.addWarnings(MessageFormat.format("The dateFormat transformation in collection ''{0}'' for property ''{1}'' with  value ''{2}'' is invalid, if used with a timestamp: {3}.", collectionId, property, dateFormat.get(), e.getMessage()));
            }
        }
        if ((codelist = this.getCodelist()).isPresent() && !codelists.contains(codelist.get())) {
            builder.addStrictErrors(MessageFormat.format("The codelist transformation in collection ''{0}'' for property ''{1}'' is invalid. The codelist ''{2}'' is not one of the known values: {3}.", collectionId, property, codelist.get(), codelists));
        }
        if ((null_ = this.getNull()).isPresent()) {
            try {
                Pattern.compile(null_.get());
            }
            catch (Exception e) {
                builder.addStrictErrors(MessageFormat.format("The null transformation in collection ''{0}'' for property ''{1}'' with  value ''{2}'' is invalid: {3}.", collectionId, property, null_.get(), e.getMessage()));
            }
        }
        return builder;
    }

    public static abstract class Builder
    implements BuildableBuilder<PropertyTransformation> {
    }
}

