/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.domain.transform;

import de.ii.xtraplatform.codelists.domain.Codelist;
import de.ii.xtraplatform.features.domain.SchemaBase;
import de.ii.xtraplatform.features.domain.transform.FeaturePropertyTransformerCodelist;
import de.ii.xtraplatform.features.domain.transform.FeaturePropertyValueTransformer;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import shadow.com.google.common.base.MoreObjects;
import shadow.com.google.common.collect.ImmutableList;
import shadow.com.google.common.collect.ImmutableMap;
import shadow.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.javax.annotation.CheckReturnValue;
import shadow.javax.annotation.Nullable;
import shadow.javax.annotation.ParametersAreNonnullByDefault;
import shadow.javax.annotation.concurrent.Immutable;
import shadow.javax.annotation.concurrent.NotThreadSafe;
import shadow.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="FeaturePropertyTransformerCodelist", generator="Immutables")
@Immutable
public final class ImmutableFeaturePropertyTransformerCodelist
implements FeaturePropertyTransformerCodelist {
    private final String propertyPath;
    private final String parameter;
    private final ImmutableList<SchemaBase.Type> supportedPropertyTypes;
    private final ImmutableMap<String, Codelist> codelists;

    private ImmutableFeaturePropertyTransformerCodelist(String propertyPath, String parameter, ImmutableList<SchemaBase.Type> supportedPropertyTypes, ImmutableMap<String, Codelist> codelists) {
        this.propertyPath = propertyPath;
        this.parameter = parameter;
        this.supportedPropertyTypes = supportedPropertyTypes;
        this.codelists = codelists;
    }

    @Override
    public String getPropertyPath() {
        return this.propertyPath;
    }

    @Override
    public String getParameter() {
        return this.parameter;
    }

    public ImmutableList<SchemaBase.Type> getSupportedPropertyTypes() {
        return this.supportedPropertyTypes;
    }

    public ImmutableMap<String, Codelist> getCodelists() {
        return this.codelists;
    }

    public final ImmutableFeaturePropertyTransformerCodelist withPropertyPath(String value) {
        String newValue = Objects.requireNonNull(value, "propertyPath");
        if (this.propertyPath.equals(newValue)) {
            return this;
        }
        return new ImmutableFeaturePropertyTransformerCodelist(newValue, this.parameter, this.supportedPropertyTypes, this.codelists);
    }

    public final ImmutableFeaturePropertyTransformerCodelist withParameter(String value) {
        String newValue = Objects.requireNonNull(value, "parameter");
        if (this.parameter.equals(newValue)) {
            return this;
        }
        return new ImmutableFeaturePropertyTransformerCodelist(this.propertyPath, newValue, this.supportedPropertyTypes, this.codelists);
    }

    public final ImmutableFeaturePropertyTransformerCodelist withSupportedPropertyTypes(SchemaBase.Type ... elements) {
        ImmutableList<SchemaBase.Type> newValue = ImmutableList.copyOf(elements);
        return new ImmutableFeaturePropertyTransformerCodelist(this.propertyPath, this.parameter, newValue, this.codelists);
    }

    public final ImmutableFeaturePropertyTransformerCodelist withSupportedPropertyTypes(Iterable<? extends SchemaBase.Type> elements) {
        if (this.supportedPropertyTypes == elements) {
            return this;
        }
        ImmutableList<SchemaBase.Type> newValue = ImmutableList.copyOf(elements);
        return new ImmutableFeaturePropertyTransformerCodelist(this.propertyPath, this.parameter, newValue, this.codelists);
    }

    public final ImmutableFeaturePropertyTransformerCodelist withCodelists(Map<String, ? extends Codelist> entries) {
        if (this.codelists == entries) {
            return this;
        }
        ImmutableMap<String, Codelist> newValue = ImmutableMap.copyOf(entries);
        return new ImmutableFeaturePropertyTransformerCodelist(this.propertyPath, this.parameter, this.supportedPropertyTypes, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFeaturePropertyTransformerCodelist && this.equalTo((ImmutableFeaturePropertyTransformerCodelist)another);
    }

    private boolean equalTo(ImmutableFeaturePropertyTransformerCodelist another) {
        return this.propertyPath.equals(another.propertyPath) && this.parameter.equals(another.parameter) && this.supportedPropertyTypes.equals(another.supportedPropertyTypes) && this.codelists.equals(another.codelists);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.propertyPath.hashCode();
        h += (h << 5) + this.parameter.hashCode();
        h += (h << 5) + this.supportedPropertyTypes.hashCode();
        h += (h << 5) + this.codelists.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("FeaturePropertyTransformerCodelist").omitNullValues().add("propertyPath", this.propertyPath).add("parameter", this.parameter).add("supportedPropertyTypes", this.supportedPropertyTypes).add("codelists", this.codelists).toString();
    }

    public static ImmutableFeaturePropertyTransformerCodelist copyOf(FeaturePropertyTransformerCodelist instance) {
        if (instance instanceof ImmutableFeaturePropertyTransformerCodelist) {
            return (ImmutableFeaturePropertyTransformerCodelist)instance;
        }
        return ImmutableFeaturePropertyTransformerCodelist.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="FeaturePropertyTransformerCodelist", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_PROPERTY_PATH = 1L;
        private static final long INIT_BIT_PARAMETER = 2L;
        private long initBits = 3L;
        @Nullable
        private String propertyPath;
        @Nullable
        private String parameter;
        private ImmutableList.Builder<SchemaBase.Type> supportedPropertyTypes = ImmutableList.builder();
        private ImmutableMap.Builder<String, Codelist> codelists = ImmutableMap.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(FeaturePropertyTransformerCodelist instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(FeaturePropertyValueTransformer instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            FeaturePropertyValueTransformer instance;
            if (object instanceof FeaturePropertyTransformerCodelist) {
                instance = (FeaturePropertyTransformerCodelist)object;
                this.propertyPath(instance.getPropertyPath());
                this.putAllCodelists(instance.getCodelists());
                this.parameter(instance.getParameter());
            }
            if (object instanceof FeaturePropertyValueTransformer) {
                instance = (FeaturePropertyValueTransformer)object;
                this.addAllSupportedPropertyTypes(instance.getSupportedPropertyTypes());
            }
        }

        @CanIgnoreReturnValue
        public final Builder propertyPath(String propertyPath) {
            this.propertyPath = Objects.requireNonNull(propertyPath, "propertyPath");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder parameter(String parameter) {
            this.parameter = Objects.requireNonNull(parameter, "parameter");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSupportedPropertyTypes(SchemaBase.Type element) {
            this.supportedPropertyTypes.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSupportedPropertyTypes(SchemaBase.Type ... elements) {
            this.supportedPropertyTypes.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder supportedPropertyTypes(Iterable<? extends SchemaBase.Type> elements) {
            this.supportedPropertyTypes = ImmutableList.builder();
            return this.addAllSupportedPropertyTypes(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllSupportedPropertyTypes(Iterable<? extends SchemaBase.Type> elements) {
            this.supportedPropertyTypes.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putCodelists(String key, Codelist value) {
            this.codelists.put(key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putCodelists(Map.Entry<String, ? extends Codelist> entry) {
            this.codelists.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder codelists(Map<String, ? extends Codelist> entries) {
            this.codelists = ImmutableMap.builder();
            return this.putAllCodelists(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllCodelists(Map<String, ? extends Codelist> entries) {
            this.codelists.putAll(entries);
            return this;
        }

        public ImmutableFeaturePropertyTransformerCodelist build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableFeaturePropertyTransformerCodelist(this.propertyPath, this.parameter, (ImmutableList<SchemaBase.Type>)this.supportedPropertyTypes.build(), this.codelists.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("propertyPath");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("parameter");
            }
            return "Cannot build FeaturePropertyTransformerCodelist, some of required attributes are not set " + attributes;
        }
    }
}

