/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.domain.transform;

import de.ii.xtraplatform.features.domain.transform.FeaturePropertyValueTransformer;
import de.ii.xtraplatform.strings.domain.StringTemplateFilters;
import java.util.Objects;
import java.util.function.Function;
import shadow.org.immutables.value.Value;

@Value.Immutable
public interface FeaturePropertyTransformerStringFormat
extends FeaturePropertyValueTransformer {
    public static final String TYPE = "STRING_FORMAT";
    public static final String DEFAULT_SUBSTITUTION_KEY = "value";

    @Override
    default public String getType() {
        return TYPE;
    }

    public Function<String, String> getSubstitutionLookup();

    @Override
    default public String transform(String currentPropertyPath, String input) {
        Function<String, String> lookup = key -> {
            if (Objects.isNull(key)) {
                return null;
            }
            if (Objects.equals(key, DEFAULT_SUBSTITUTION_KEY) || Objects.equals(this.getPropertyPath(), key)) {
                return input;
            }
            String lookupWithKey = this.getSubstitutionLookup().apply((String)key);
            if (Objects.nonNull(lookupWithKey)) {
                return lookupWithKey;
            }
            return this.getSubstitutionLookup().apply(currentPropertyPath + "." + key);
        };
        return StringTemplateFilters.applyTemplate(this.getParameter(), lookup);
    }
}

