/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.domain.transform;

import de.ii.xtraplatform.features.domain.FeatureSchema;
import de.ii.xtraplatform.features.domain.transform.FeaturePropertySchemaTransformer;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shadow.org.immutables.value.Value;

@Value.Immutable
public interface FeaturePropertyTransformerRemove
extends FeaturePropertySchemaTransformer {
    public static final Logger LOGGER = LoggerFactory.getLogger(FeaturePropertyTransformerRemove.class);
    public static final String IN_COLLECTION_DEPRECATED = "OVERVIEW";
    public static final String TYPE = "REMOVE";
    public static final Set<String> CONDITION_VALUES = Stream.concat(Stream.of("OVERVIEW"), Arrays.stream(Condition.values()).map(Enum::name)).collect(Collectors.toSet());

    @Override
    default public String getType() {
        return TYPE;
    }

    public boolean inCollection();

    @Override
    default public FeatureSchema transform(String currentPropertyPath, FeatureSchema schema) {
        Condition condition = Condition.NEVER;
        String parameter = this.getParameter().toUpperCase();
        if (Objects.equals(parameter, IN_COLLECTION_DEPRECATED)) {
            LOGGER.warn("Condition '{}' in {} transformation for property '{}' is deprecated, use '{}' instead.", new Object[]{IN_COLLECTION_DEPRECATED, this.getType(), this.getPropertyPath(), Condition.IN_COLLECTION});
            condition = Condition.IN_COLLECTION;
        } else {
            try {
                condition = Condition.valueOf(parameter);
            }
            catch (Throwable e) {
                LOGGER.warn("Skipping {} transformation for property '{}', condition '{}' is not supported. Supported types: {}", new Object[]{this.getType(), this.getPropertyPath(), this.getParameter(), Condition.values()});
                return schema;
            }
        }
        if (condition == Condition.ALWAYS || condition == Condition.IN_COLLECTION && this.inCollection() && currentPropertyPath.startsWith(this.getPropertyPath())) {
            return null;
        }
        return schema;
    }

    public static enum Condition {
        ALWAYS,
        IN_COLLECTION,
        NEVER;

    }
}

