/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.domain.transform;

import de.ii.xtraplatform.features.domain.FeatureEventHandler;
import de.ii.xtraplatform.features.domain.FeatureSchema;
import de.ii.xtraplatform.features.domain.ImmutableFeatureSchema;
import de.ii.xtraplatform.features.domain.SchemaBase;
import de.ii.xtraplatform.features.domain.SchemaMapping;
import de.ii.xtraplatform.features.domain.transform.FeaturePropertyContextTransformer;
import java.util.Objects;
import java.util.Optional;
import shadow.com.google.common.collect.ImmutableMap;
import shadow.org.immutables.value.Value;

@Value.Immutable
public interface FeaturePropertyTransformerObjectReduce
extends FeaturePropertyContextTransformer {
    public static final String TYPE = "REDUCE";

    @Override
    default public String getType() {
        return TYPE;
    }

    @Override
    default public FeatureEventHandler.ModifiableContext<FeatureSchema, SchemaMapping> transform(String currentPropertyPath, FeatureEventHandler.ModifiableContext<FeatureSchema, SchemaMapping> context) {
        if (Objects.equals(currentPropertyPath, this.getPropertyPath()) && context.currentSchema().filter(SchemaBase::isObject).isPresent()) {
            if (((FeatureSchema)context.currentSchema().get()).isArray() && !context.inArray()) {
                return context;
            }
            if (!context.transformed().containsKey(this.getPropertyPath())) {
                context.putTransformed(this.getPropertyPath(), TYPE);
                context.setIsBuffering(true);
            } else {
                context.transformed().remove(this.getPropertyPath());
                context.setIsBuffering(false);
                context.setCustomSchema(new ImmutableFeatureSchema.Builder().from((FeatureSchema)context.currentSchema().get()).type(((FeatureSchema)context.currentSchema().get()).isArray() ? SchemaBase.Type.VALUE_ARRAY : SchemaBase.Type.STRING).valueType(SchemaBase.Type.STRING).objectType(Optional.empty()).propertyMap(ImmutableMap.of()).build());
            }
        } else if (currentPropertyPath.startsWith(this.getPropertyPath()) && context.currentSchema().filter(SchemaBase::isValue).isPresent() && context.transformed().containsKey(this.getPropertyPath())) {
            context.putValueBuffer(currentPropertyPath, context.value());
            if (context.transformed().get(this.getPropertyPath()).equals(TYPE)) {
                // empty if block
            }
        }
        return context;
    }
}

