/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.domain.transform;

import de.ii.xtraplatform.features.domain.SchemaBase;
import de.ii.xtraplatform.features.domain.transform.FeaturePropertyValueTransformer;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shadow.com.google.common.collect.ImmutableList;
import shadow.org.immutables.value.Value;

@Value.Immutable
public interface FeaturePropertyTransformerDateFormat
extends FeaturePropertyValueTransformer {
    public static final Logger LOGGER = LoggerFactory.getLogger(FeaturePropertyTransformerDateFormat.class);
    public static final String TYPE = "DATE_FORMAT";
    public static final ZoneId UTC = ZoneId.of("UTC");
    public static final String DATETIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ssZZZZZ";
    public static final String DATE_FORMAT = "yyyy-MM-dd";

    @Override
    default public String getType() {
        return TYPE;
    }

    @Override
    default public List<SchemaBase.Type> getSupportedPropertyTypes() {
        return ImmutableList.of(SchemaBase.Type.DATETIME);
    }

    public Optional<ZoneId> getDefaultTimeZone();

    @Override
    default public String transform(String currentPropertyPath, String input) {
        try {
            DateTimeFormatter parser = DateTimeFormatter.ofPattern("yyyy-MM-dd[['T'][' ']HH:mm:ss][.SSS][X]");
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(this.getParameter());
            TemporalAccessor ta = parser.parseBest(input, OffsetDateTime::from, LocalDateTime::from, LocalDate::from);
            if (ta instanceof OffsetDateTime) {
                ta = ((OffsetDateTime)ta).atZoneSameInstant(UTC);
            } else if (ta instanceof LocalDateTime) {
                ta = ((LocalDateTime)ta).atZone(this.getDefaultTimeZone().orElse(UTC)).withZoneSameInstant(UTC);
            } else if (ta instanceof LocalDate) {
                ta = ((LocalDate)ta).atStartOfDay(this.getDefaultTimeZone().orElse(UTC)).withZoneSameInstant(UTC);
            }
            return formatter.format(ta);
        }
        catch (Exception e) {
            LOGGER.warn("{} transformation for property '{}' with value '{}' failed: {}", this.getType(), this.getPropertyPath(), input, e.getMessage());
            return input;
        }
    }
}

