/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.domain.transform;

import de.ii.xtraplatform.codelists.domain.Codelist;
import de.ii.xtraplatform.codelists.domain.CodelistData;
import de.ii.xtraplatform.features.domain.transform.FeaturePropertyValueTransformer;
import de.ii.xtraplatform.strings.domain.StringTemplateFilters;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shadow.org.immutables.value.Value;

@Value.Immutable
public interface FeaturePropertyTransformerCodelist
extends FeaturePropertyValueTransformer {
    public static final Logger LOGGER = LoggerFactory.getLogger(FeaturePropertyTransformerCodelist.class);
    public static final String TYPE = "CODELIST";

    @Override
    default public String getType() {
        return TYPE;
    }

    public Map<String, Codelist> getCodelists();

    @Override
    default public String transform(String currentPropertyPath, String input) {
        if (!this.getCodelists().containsKey(this.getParameter())) {
            LOGGER.warn("Skipping {} transformation for property '{}', codelist '{}' not found.", this.getType(), this.getPropertyPath(), this.getParameter());
            return input;
        }
        Codelist cl = this.getCodelists().get(this.getParameter());
        String resolvedValue = cl.getValue(input);
        if (cl.getData().getSourceType() == CodelistData.IMPORT_TYPE.TEMPLATES) {
            resolvedValue = StringTemplateFilters.applyFilterMarkdown(StringTemplateFilters.applyTemplate(resolvedValue, input));
        }
        return resolvedValue;
    }
}

