/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.domain.transform;

import de.ii.xtraplatform.features.domain.FeatureEventHandler;
import de.ii.xtraplatform.features.domain.FeatureSchema;
import de.ii.xtraplatform.features.domain.SchemaBase;
import de.ii.xtraplatform.features.domain.SchemaMapping;
import de.ii.xtraplatform.features.domain.transform.FeaturePropertyContextTransformer;
import de.ii.xtraplatform.features.domain.transform.ImmutableFeaturePropertyTransformerObjectReduce;
import de.ii.xtraplatform.features.domain.transform.PropertyTransformation;
import de.ii.xtraplatform.features.domain.transform.TransformerChain;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import shadow.com.google.common.collect.ImmutableList;
import shadow.com.google.common.collect.ImmutableMap;
import shadow.javax.annotation.Nullable;

public class ContextTransformerChain
implements TransformerChain<FeatureEventHandler.ModifiableContext<FeatureSchema, SchemaMapping>, FeaturePropertyContextTransformer> {
    public static final String OBJECT_TYPE_WILDCARD = "*{objectType=";
    private final List<String> currentParentProperties = new ArrayList<String>();
    private final Map<String, List<FeaturePropertyContextTransformer>> transformers;

    public ContextTransformerChain(Map<String, List<PropertyTransformation>> allTransformations, SchemaMapping schemaMapping) {
        this.transformers = allTransformations.entrySet().stream().flatMap(entry -> {
            String propertyPath = (String)entry.getKey();
            List transformation = (List)entry.getValue();
            if (this.hasWildcard(propertyPath, OBJECT_TYPE_WILDCARD)) {
                return this.createContextTransformersForObjectType(propertyPath, schemaMapping, transformation).entrySet().stream();
            }
            return Stream.of(new AbstractMap.SimpleEntry<String, List<FeaturePropertyContextTransformer>>(propertyPath, this.createContextTransformers(propertyPath, transformation)));
        }).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue, (first, second) -> ((ImmutableList.Builder)((ImmutableList.Builder)new ImmutableList.Builder().addAll((Iterable)first)).addAll((Iterable)second)).build()));
    }

    @Override
    @Nullable
    public FeatureEventHandler.ModifiableContext<FeatureSchema, SchemaMapping> transform(String path, FeatureEventHandler.ModifiableContext<FeatureSchema, SchemaMapping> context) {
        boolean ran = false;
        for (int i = this.currentParentProperties.size() - 1; i >= 0; --i) {
            String parentPath = this.currentParentProperties.get(i);
            if (!path.startsWith(parentPath + ".")) {
                this.currentParentProperties.remove(i);
                continue;
            }
            if (ran) continue;
            ran = this.run(this.transformers, parentPath, path, context);
        }
        if (context.currentSchema().filter(SchemaBase::isObject).isPresent() && (this.currentParentProperties.isEmpty() || !Objects.equals(this.currentParentProperties.get(this.currentParentProperties.size() - 1), path))) {
            this.currentParentProperties.add(path);
        }
        if (!ran) {
            this.run(this.transformers, path, path, context);
        }
        return context;
    }

    @Override
    public boolean has(String path) {
        return this.transformers.containsKey(path);
    }

    @Override
    public List<FeaturePropertyContextTransformer> get(String path) {
        return this.transformers.get(path);
    }

    private boolean run(Map<String, List<FeaturePropertyContextTransformer>> contextTransformers, String keyPath, String propertyPath, FeatureEventHandler.ModifiableContext<FeatureSchema, SchemaMapping> context) {
        boolean ran;
        block3: {
            block2: {
                ran = false;
                if (!contextTransformers.containsKey(keyPath) || contextTransformers.get(keyPath).isEmpty()) break block2;
                for (FeaturePropertyContextTransformer contextTransformer : contextTransformers.get(keyPath)) {
                    FeatureEventHandler.ModifiableContext<FeatureSchema, SchemaMapping> transformed = contextTransformer.transform(propertyPath, context);
                    ran = true;
                    if (!Objects.isNull(transformed)) continue;
                    return ran;
                }
                break block3;
            }
            if (!contextTransformers.containsKey("*") || contextTransformers.get("*").isEmpty()) break block3;
            for (FeaturePropertyContextTransformer contextTransformer : (List)contextTransformers.getOrDefault("*", ImmutableList.of())) {
                FeatureEventHandler.ModifiableContext<FeatureSchema, SchemaMapping> transformed = contextTransformer.transform(propertyPath, context);
                ran = true;
                if (!Objects.isNull(transformed)) continue;
                return ran;
            }
        }
        return ran;
    }

    private List<FeaturePropertyContextTransformer> createContextTransformers(String path, List<PropertyTransformation> propertyTransformations) {
        ArrayList<FeaturePropertyContextTransformer> transformers = new ArrayList<FeaturePropertyContextTransformer>();
        propertyTransformations.forEach(propertyTransformation -> propertyTransformation.getReduceStringFormat().ifPresent(ignore -> transformers.add(ImmutableFeaturePropertyTransformerObjectReduce.builder().propertyPath(path).parameter("").build())));
        return transformers;
    }

    private Map<String, List<FeaturePropertyContextTransformer>> createContextTransformersForObjectType(String transformationKey, SchemaMapping schemaMapping, List<PropertyTransformation> propertyTransformation) {
        return this.explodeWildcard(transformationKey, OBJECT_TYPE_WILDCARD, schemaMapping, ContextTransformerChain::matchesObjectType).stream().map(propertyPath -> new AbstractMap.SimpleEntry<String, List<FeaturePropertyContextTransformer>>((String)propertyPath, this.createContextTransformers((String)propertyPath, propertyTransformation))).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    static boolean matchesObjectType(FeatureSchema schema, String objectType) {
        return schema.getObjectType().isPresent() && Objects.equals(schema.getObjectType().get(), objectType);
    }
}

