/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.domain;

import de.ii.xtraplatform.features.domain.SchemaBase;
import de.ii.xtraplatform.features.domain.SchemaVisitor;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import shadow.com.google.common.base.Splitter;
import shadow.com.google.common.collect.ImmutableList;
import shadow.com.google.common.collect.ImmutableListMultimap;
import shadow.com.google.common.collect.Multimap;

public class SchemaToSourcePathsVisitor<T extends SchemaBase<T>>
implements SchemaVisitor<T, Multimap<List<String>, T>> {
    static final Splitter SPLITTER = Splitter.on('/').omitEmptyStrings();
    private final boolean useTargetPath;
    private int counter;

    public SchemaToSourcePathsVisitor() {
        this(false);
    }

    public SchemaToSourcePathsVisitor(boolean useTargetPath) {
        this.useTargetPath = useTargetPath;
        this.counter = 0;
    }

    @Override
    public Multimap<List<String>, T> visit(T schema, List<Multimap<List<String>, T>> visitedProperties) {
        ImmutableList<List<String>> paths = this.useTargetPath ? ImmutableList.of(schema.getPath()) : schema.getEffectiveSourcePaths().stream().map(sourcePath -> {
            int i = sourcePath.indexOf(123);
            if (i > 0) {
                ArrayList<String> p = new ArrayList<String>(SPLITTER.splitToList(sourcePath.substring(0, i)));
                p.set(p.size() - 1, (String)p.get(p.size() - 1) + sourcePath.substring(i).replaceAll("\\{sortKey=.*?\\}", "").replaceAll("\\{primaryKey=.*?\\}", "") + (String)(schema.isValue() ? "{priority=" + this.counter++ + "}" : ""));
                return p.stream().flatMap(s -> SPLITTER.splitToList((CharSequence)s).stream()).collect(Collectors.toList());
            }
            return SPLITTER.splitToList(sourcePath + (String)(schema.isValue() ? "{priority=" + this.counter++ + "}" : ""));
        }).collect(Collectors.toList());
        return (paths.isEmpty() ? visitedProperties.stream().flatMap(map -> map.asMap().entrySet().stream().flatMap(entry -> this.prependToKey((Map.Entry<List<String>, Collection<T>>)entry, (List<String>)ImmutableList.of()))) : paths.stream().flatMap(path -> Stream.concat(Stream.of(new AbstractMap.SimpleImmutableEntry<List, SchemaBase>((List)path, (SchemaBase)schema)), visitedProperties.stream().flatMap(map -> map.asMap().entrySet().stream().flatMap(entry -> this.prependToKey((Map.Entry<List<String>, Collection<T>>)entry, (List<String>)path)))))).collect(ImmutableListMultimap.toImmutableListMultimap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Stream<Map.Entry<List<String>, T>> prependToKey(Map.Entry<List<String>, Collection<T>> property, List<String> parentPath) {
        return property.getValue().stream().map(value -> new AbstractMap.SimpleImmutableEntry<List<String>, SchemaBase>(this.merge(parentPath, (List)property.getKey()), (SchemaBase)value));
    }

    private List<String> merge(List<String> parentPath, List<String> path) {
        if (parentPath.isEmpty()) {
            return path;
        }
        return ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(parentPath)).addAll(path)).build();
    }
}

