/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.domain;

import de.ii.xtraplatform.features.domain.SchemaBase;
import de.ii.xtraplatform.features.domain.SchemaVisitor;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import shadow.com.google.common.base.Splitter;
import shadow.com.google.common.collect.ImmutableList;
import shadow.com.google.common.collect.ImmutableListMultimap;
import shadow.com.google.common.collect.Multimap;

public class SchemaToMappingVisitor<T extends SchemaBase<T>>
implements SchemaVisitor<T, Multimap<List<String>, T>> {
    static final Splitter SPLITTER = Splitter.on('/').omitEmptyStrings();
    private final boolean useTargetPath;

    public SchemaToMappingVisitor() {
        this(false);
    }

    public SchemaToMappingVisitor(boolean useTargetPath) {
        this.useTargetPath = useTargetPath;
    }

    @Override
    public Multimap<List<String>, T> visit(T schema, List<Multimap<List<String>, T>> visitedProperties) {
        List<String> path = this.useTargetPath ? schema.getPath() : SPLITTER.splitToList(schema.getSourcePath().map(sourcePath -> sourcePath.replaceAll("\\{constant=.*?\\}", "")).orElse(""));
        return Stream.concat(path.isEmpty() ? Stream.empty() : Stream.of(new AbstractMap.SimpleImmutableEntry<List<String>, T>(path, schema)), visitedProperties.stream().flatMap(map -> map.asMap().entrySet().stream().flatMap(entry -> this.prependToKey((Map.Entry<List<String>, Collection<T>>)entry, path)))).collect(ImmutableListMultimap.toImmutableListMultimap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Stream<Map.Entry<List<String>, T>> prependToKey(Map.Entry<List<String>, Collection<T>> property, List<String> parentPath) {
        return property.getValue().stream().map(value -> new AbstractMap.SimpleImmutableEntry<List<String>, SchemaBase>(this.merge(parentPath, (List)property.getKey()), (SchemaBase)value));
    }

    private List<String> merge(List<String> parentPath, List<String> path) {
        if (parentPath.isEmpty()) {
            return path;
        }
        return ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(parentPath)).addAll(path)).build();
    }
}

