/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.domain;

import de.ii.xtraplatform.features.domain.SchemaBase;
import de.ii.xtraplatform.geometries.domain.SimpleFeatureGeometry;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import shadow.com.google.common.collect.ImmutableList;
import shadow.com.google.common.collect.ImmutableMap;
import shadow.org.immutables.value.Value;

public interface SchemaMappingBase<T extends SchemaBase<T>> {
    public T getTargetSchema();

    public Map<List<String>, List<T>> getTargetSchemasByPath();

    @Value.Derived
    @Value.Auxiliary
    default public Map<List<String>, List<List<T>>> getParentSchemasByPath() {
        return this.getTargetSchemasByPath().entrySet().stream().map(entry -> {
            List parentSchemas = ((List)entry.getValue()).stream().map(this::findParentSchemas).collect(Collectors.toList());
            return new AbstractMap.SimpleImmutableEntry((List)entry.getKey(), parentSchemas);
        }).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Value.Derived
    @Value.Auxiliary
    default public List<T> getAllSchemas() {
        return this.getTargetSchema().accept((schema1, visitedProperties) -> Stream.concat(Stream.of(schema1), visitedProperties.stream().flatMap(Collection::stream)).collect(Collectors.toList()));
    }

    default public List<T> getTargetSchemas(List<String> path) {
        return this.getTargetSchemasByPath().getOrDefault(path, ImmutableList.of());
    }

    default public Optional<T> getTargetSchema(SchemaBase.Type type) {
        return this.getTargetSchemasByPath().values().stream().flatMap(Collection::stream).filter(ts -> ts.getType() == type).findFirst();
    }

    default public Optional<T> getTargetSchema(SchemaBase.Role role) {
        return this.getTargetSchemasByPath().values().stream().flatMap(Collection::stream).filter(ts -> ts.getRole().isPresent() && ts.getRole().get() == role).findFirst();
    }

    default public List<List<T>> getParentSchemas(List<String> path) {
        return this.getParentSchemasByPath().getOrDefault(path, ImmutableList.of());
    }

    default public Optional<T> findParentSchema(T schema) {
        return this.getAllSchemas().stream().filter(parent -> parent.getProperties().contains(schema)).findFirst();
    }

    default public List<T> findParentSchemas(T schema) {
        ArrayList parents = new ArrayList();
        Optional<Object> current = Optional.ofNullable(schema);
        while (current.isPresent()) {
            current = this.findParentSchema((SchemaBase)current.get());
            current.ifPresent(parents::add);
        }
        return parents;
    }

    public T schemaWithGeometryType(T var1, SimpleFeatureGeometry var2);

    default public Optional<String> getPathSeparator() {
        return Optional.empty();
    }
}

