/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.domain;

import de.ii.xtraplatform.features.domain.FeatureSchema;
import de.ii.xtraplatform.features.domain.ImmutableFeatureSchema;
import de.ii.xtraplatform.features.domain.ImmutableSchemaMapping;
import de.ii.xtraplatform.features.domain.SchemaMappingBase;
import de.ii.xtraplatform.features.domain.SchemaToMappingVisitor;
import de.ii.xtraplatform.features.domain.SchemaToSourcePathsVisitor;
import de.ii.xtraplatform.features.domain.transform.PropertyTransformation;
import de.ii.xtraplatform.geometries.domain.SimpleFeatureGeometry;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import shadow.com.google.common.collect.ImmutableMap;
import shadow.com.google.common.collect.Lists;
import shadow.com.google.common.collect.Multimap;
import shadow.org.immutables.value.Value;

@Value.Immutable
@Value.Style(deepImmutablesDetection=true, builder="new", attributeBuilderDetection=true)
public interface SchemaMapping
extends SchemaMappingBase<FeatureSchema> {
    @Override
    default public FeatureSchema schemaWithGeometryType(FeatureSchema schema, SimpleFeatureGeometry geometryType) {
        return new ImmutableFeatureSchema.Builder().from(schema).geometryType(geometryType).build();
    }

    default public SchemaMapping mappingWithTargetPaths() {
        Multimap accept = (Multimap)((FeatureSchema)this.getTargetSchema()).accept(new SchemaToMappingVisitor(true));
        return null;
    }

    @Value.Default
    default public boolean useTargetPaths() {
        return false;
    }

    public static SchemaMapping withTargetPaths(SchemaMapping mapping) {
        return new ImmutableSchemaMapping.Builder().from(mapping).useTargetPaths(true).build();
    }

    @Override
    @Value.Derived
    @Value.Auxiliary
    default public Map<List<String>, List<FeatureSchema>> getTargetSchemasByPath() {
        ImmutableMap<List<String>, List<FeatureSchema>> original = ((Multimap)((FeatureSchema)this.getTargetSchema()).accept(new SchemaToMappingVisitor(this.useTargetPaths()))).asMap().entrySet().stream().map(entry -> new AbstractMap.SimpleImmutableEntry((List)entry.getKey(), Lists.newArrayList((Iterable)entry.getValue()))).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        ImmutableMap<List<String>, List<FeatureSchema>> newer = ((Multimap)((FeatureSchema)this.getTargetSchema()).accept(new SchemaToSourcePathsVisitor())).asMap().entrySet().stream().map(entry -> new AbstractMap.SimpleImmutableEntry(this.cleanPath((List)entry.getKey()), Lists.newArrayList((Iterable)entry.getValue()))).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue, (first, second) -> {
            ArrayList featureSchemas = new ArrayList(first);
            featureSchemas.addAll(second);
            return featureSchemas;
        }));
        if (this.useTargetPaths()) {
            return original;
        }
        return newer;
    }

    default public List<String> cleanPath(List<String> path) {
        if (path.get(path.size() - 1).contains("{")) {
            ArrayList<String> key = new ArrayList<String>(path.subList(0, path.size() - 1));
            key.add(this.cleanPath(path.get(path.size() - 1)));
            return key;
        }
        return path;
    }

    default public String cleanPath(String path) {
        if (path.contains("{")) {
            int i = path.indexOf("{");
            if (path.startsWith("filter", i + 1)) {
                return path.substring(0, i + 2) + this.cleanPath(path.substring(i + 2));
            }
            return path.substring(0, path.indexOf("{"));
        }
        return path;
    }

    @Override
    default public Optional<String> getPathSeparator() {
        if (this.useTargetPaths()) {
            return ((FeatureSchema)this.getTargetSchema()).getTransformations().stream().filter(transformation -> transformation.getFlatten().isPresent()).findFirst().flatMap(PropertyTransformation::getFlatten);
        }
        return Optional.empty();
    }
}

