/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.domain;

import de.ii.xtraplatform.features.domain.ImmutableSchemaConstraints;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import shadow.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.org.immutables.value.Value;

@JsonDeserialize(builder=ImmutableSchemaConstraints.Builder.class)
@Value.Immutable
@Value.Style(deepImmutablesDetection=true, builder="new", attributeBuilderDetection=true)
public interface SchemaConstraints {
    public Optional<String> getCodelist();

    @JsonProperty(value="enum")
    public List<String> getEnumValues();

    public Optional<String> getRegex();

    public Optional<Boolean> getRequired();

    public Optional<Double> getMin();

    public Optional<Double> getMax();

    public Optional<Integer> getMinOccurrence();

    public Optional<Integer> getMaxOccurrence();

    @JsonIgnore
    @Value.Derived
    @Value.Auxiliary
    default public boolean isRequired() {
        return this.getRequired().filter(required -> Objects.equals(required, true)).isPresent();
    }
}

