/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.domain;

import de.ii.xtraplatform.features.domain.SchemaConstraints;
import de.ii.xtraplatform.features.domain.SchemaVisitor;
import de.ii.xtraplatform.features.domain.SchemaVisitorTopDown;
import de.ii.xtraplatform.features.domain.SchemaVisitorWithFinalizer;
import de.ii.xtraplatform.features.domain.Tuple;
import de.ii.xtraplatform.geometries.domain.SimpleFeatureGeometry;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import shadow.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.com.google.common.collect.ImmutableList;
import shadow.com.google.common.collect.ImmutableSet;
import shadow.org.immutables.value.Value;

public interface SchemaBase<T extends SchemaBase<T>> {
    public String getName();

    public Type getType();

    public Optional<Role> getRole();

    public Optional<Type> getValueType();

    public Optional<SimpleFeatureGeometry> getGeometryType();

    public List<String> getPath();

    public List<String> getParentPath();

    public Optional<String> getSourcePath();

    public List<String> getSourcePaths();

    @JsonIgnore
    @Value.Derived
    @Value.Auxiliary
    default public List<String> getEffectiveSourcePaths() {
        return this.getSourcePath().map(element -> ImmutableList.of(element)).orElse(this.getSourcePaths());
    }

    public Optional<SchemaConstraints> getConstraints();

    public Optional<Boolean> getForcePolygonCCW();

    @JsonIgnore
    @Value.Derived
    @Value.Auxiliary
    default public boolean isForcePolygonCCW() {
        return this.getForcePolygonCCW().filter(force -> force == false).isEmpty();
    }

    public List<T> getProperties();

    @JsonIgnore
    @Value.Derived
    @Value.Auxiliary
    default public List<T> getAllNestedProperties() {
        return this.getProperties().stream().flatMap(t -> Stream.concat(Stream.of(t), t.getAllNestedProperties().stream())).collect(Collectors.toList());
    }

    @JsonIgnore
    @Value.Derived
    @Value.Auxiliary
    default public List<T> getAllObjects() {
        return Stream.concat(Stream.of(this), this.getAllNestedProperties().stream().filter(SchemaBase::isObject).filter(obj -> obj.getProperties().stream().anyMatch(SchemaBase::isValue))).collect(Collectors.toList());
    }

    @JsonIgnore
    @Value.Derived
    @Value.Auxiliary
    default public Optional<T> getIdProperty() {
        return this.getProperties().stream().filter(t -> t.getRole().filter(role -> role == Role.ID).isPresent()).findFirst();
    }

    @JsonIgnore
    @Value.Derived
    @Value.Auxiliary
    default public Optional<T> getPrimaryGeometry() {
        return this.getProperties().stream().filter(t -> t.getRole().filter(role -> role == Role.PRIMARY_GEOMETRY).isPresent()).findFirst().or(() -> this.getProperties().stream().filter(SchemaBase::isSpatial).findFirst());
    }

    @JsonIgnore
    @Value.Derived
    @Value.Auxiliary
    default public Optional<T> getPrimaryInstant() {
        return this.getProperties().stream().filter(t -> t.getRole().filter(role -> role == Role.PRIMARY_INSTANT).isPresent()).findFirst().or(() -> this.getPrimaryInterval().isEmpty() ? this.getProperties().stream().filter(SchemaBase::isTemporal).findFirst() : Optional.empty());
    }

    @JsonIgnore
    @Value.Derived
    @Value.Auxiliary
    default public Optional<Tuple<T, T>> getPrimaryInterval() {
        Optional<SchemaBase> start = this.getProperties().stream().filter(t -> t.getRole().filter(role -> role == Role.PRIMARY_INTERVAL_START).isPresent()).findFirst();
        Optional<SchemaBase> end = this.getProperties().stream().filter(t -> t.getRole().filter(role -> role == Role.PRIMARY_INTERVAL_END).isPresent()).findFirst();
        return start.isPresent() && end.isPresent() ? Optional.of(Tuple.of(start.get(), end.get())) : Optional.empty();
    }

    @JsonIgnore
    @Value.Derived
    @Value.Auxiliary
    default public List<String> getFullPath() {
        return ((ImmutableList.Builder)((ImmutableList.Builder)new ImmutableList.Builder().addAll(this.getParentPath())).addAll(this.getPath())).build();
    }

    @JsonIgnore
    @Value.Derived
    @Value.Auxiliary
    default public String getFullPathAsString() {
        return String.join((CharSequence)".", this.getFullPath());
    }

    @JsonIgnore
    @Value.Derived
    @Value.Auxiliary
    default public Set<String> getValueNames() {
        return this.getProperties().stream().filter(SchemaBase::isValue).map(SchemaBase::getName).collect(ImmutableSet.toImmutableSet());
    }

    @JsonIgnore
    @Value.Derived
    @Value.Auxiliary
    default public boolean isObject() {
        return this.getType() == Type.OBJECT || this.getType() == Type.OBJECT_ARRAY;
    }

    @JsonIgnore
    @Value.Derived
    @Value.Auxiliary
    default public boolean isArray() {
        return this.getType() == Type.OBJECT_ARRAY || this.getType() == Type.VALUE_ARRAY;
    }

    @JsonIgnore
    @Value.Derived
    @Value.Auxiliary
    default public boolean isValue() {
        return !this.isObject();
    }

    @JsonIgnore
    @Value.Derived
    @Value.Auxiliary
    default public boolean isFeature() {
        return this.isObject() && this.getParentPath().isEmpty();
    }

    @JsonIgnore
    @Value.Derived
    @Value.Auxiliary
    default public boolean isSpatial() {
        return this.getType() == Type.GEOMETRY;
    }

    @JsonIgnore
    @Value.Derived
    @Value.Auxiliary
    default public boolean isTemporal() {
        return this.getType() == Type.DATETIME || this.getType() == Type.DATE;
    }

    @JsonIgnore
    @Value.Derived
    @Value.Auxiliary
    default public boolean isId() {
        return this.getRole().filter(role -> role == Role.ID).isPresent();
    }

    @JsonIgnore
    @Value.Derived
    @Value.Auxiliary
    default public boolean isPrimaryGeometry() {
        return this.getRole().filter(role -> role == Role.PRIMARY_GEOMETRY).isPresent();
    }

    @JsonIgnore
    @Value.Derived
    @Value.Auxiliary
    default public boolean isPrimaryInstant() {
        return this.getRole().filter(role -> role == Role.PRIMARY_INSTANT).isPresent();
    }

    @JsonIgnore
    @Value.Derived
    @Value.Auxiliary
    default public boolean isPrimaryIntervalStart() {
        return this.getRole().filter(role -> role == Role.PRIMARY_INTERVAL_START).isPresent();
    }

    @JsonIgnore
    @Value.Derived
    @Value.Auxiliary
    default public boolean isPrimaryIntervalEnd() {
        return this.getRole().filter(role -> role == Role.PRIMARY_INTERVAL_END).isPresent();
    }

    @JsonIgnore
    @Value.Derived
    @Value.Auxiliary
    default public boolean isType() {
        return this.getRole().filter(role -> role == Role.TYPE).isPresent();
    }

    @JsonIgnore
    @Value.Derived
    @Value.Auxiliary
    default public boolean isRequired() {
        return this.getConstraints().filter(SchemaConstraints::isRequired).isPresent();
    }

    default public <U> U accept(SchemaVisitor<T, U> visitor) {
        return visitor.visit(this, this.getProperties().stream().map(property -> property.accept(visitor)).collect(Collectors.toList()));
    }

    default public <U> U accept(SchemaVisitorTopDown<T, U> visitor) {
        return this.accept(visitor, ImmutableList.of());
    }

    default public <U, V> V accept(SchemaVisitorWithFinalizer<T, U, V> visitor) {
        return visitor.finalize(this, this.accept(visitor, ImmutableList.of()));
    }

    default public <U> U accept(SchemaVisitorTopDown<T, U> visitor, List<T> parents) {
        return visitor.visit(this, parents, this.getProperties().stream().map(property -> property.accept(visitor, (List<T>)((Object)((ImmutableList.Builder)((ImmutableList.Builder)new ImmutableList.Builder().addAll(parents)).add(this)).build()))).collect(Collectors.toList()));
    }

    public static enum Type {
        INTEGER,
        FLOAT,
        STRING,
        BOOLEAN,
        DATETIME,
        DATE,
        GEOMETRY,
        OBJECT,
        VALUE_ARRAY,
        OBJECT_ARRAY,
        UNKNOWN;

    }

    public static enum Role {
        ID,
        TYPE,
        PRIMARY_GEOMETRY,
        PRIMARY_INSTANT,
        PRIMARY_INTERVAL_START,
        PRIMARY_INTERVAL_END;

    }
}

