/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.domain;

import de.ii.xtraplatform.features.domain.FeatureSchema;
import de.ii.xtraplatform.features.domain.SchemaBase;
import de.ii.xtraplatform.features.domain.SchemaVisitor;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import shadow.com.google.common.base.Splitter;
import shadow.com.google.common.collect.ImmutableList;

public interface ReverseSchemaDeriver<T extends SchemaBase<T>>
extends SchemaVisitor<FeatureSchema, List<T>> {
    public static final Splitter SPLITTER = Splitter.on('/').omitEmptyStrings();

    @Override
    default public List<T> visit(FeatureSchema schema, List<List<T>> visitedProperties) {
        if (schema.isConstant()) {
            return ImmutableList.of();
        }
        List<String> currentPath = this.splitPath(schema.getSourcePath().orElse(this.ignore()));
        LinkedHashMap objectCache = new LinkedHashMap();
        List properties = visitedProperties.stream().flatMap(Collection::stream).map(sourceSchema -> {
            List<String> parentPath = sourceSchema.getParentPath();
            if (parentPath.isEmpty()) {
                return sourceSchema;
            }
            String parentParentPath = (String)currentPath.get(currentPath.size() - 1);
            List<SchemaBase> parents = this.createParents(parentParentPath, sourceSchema, objectCache);
            if (!parents.isEmpty()) {
                parents.forEach(t -> objectCache.put(t.getPath(), t));
                return parents.get(0);
            }
            return sourceSchema;
        }).collect(Collectors.toList());
        properties = properties.stream().map(sourceSchema -> objectCache.getOrDefault(sourceSchema.getPath(), sourceSchema)).distinct().map(sourceSchema -> this.prependToParentPath(currentPath, sourceSchema)).collect(Collectors.toList());
        if (this.shouldIgnore(currentPath)) {
            return properties.stream().map(sourceSchema -> this.prependToSourcePath(schema.getName(), sourceSchema)).collect(Collectors.toList());
        }
        T current = this.create(currentPath, schema);
        return ImmutableList.of(this.addChildren(current, properties));
    }

    public List<T> createParents(String var1, T var2, Map<List<String>, T> var3);

    public T create(List<String> var1, FeatureSchema var2);

    public T create(String var1, FeatureSchema var2);

    public T addChildren(T var1, List<T> var2);

    public T prependToParentPath(List<String> var1, T var2);

    public T prependToSourcePath(String var1, T var2);

    default public List<String> splitPath(String path) {
        return SPLITTER.splitToList(path);
    }

    public String ignore();

    public boolean shouldIgnore(List<String> var1);
}

