/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.domain;

import de.ii.xtraplatform.features.domain.SchemaBase;
import de.ii.xtraplatform.geometries.domain.SimpleFeatureGeometry;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import shadow.javax.annotation.Nullable;
import shadow.org.immutables.value.Value;

public interface PropertyBase<T extends PropertyBase<T, U>, U extends SchemaBase<U>> {
    public Type getType();

    public Optional<U> getSchema();

    @Value.Default
    default public String getName() {
        return this.getSchema().map(SchemaBase::getName).orElse("");
    }

    @Nullable
    public String getValue();

    @Value.Auxiliary
    public Optional<T> getParent();

    public List<T> getNestedProperties();

    public List<String> getPropertyPath();

    @Value.Default
    default public int getLevel() {
        return this.getPropertyPath().size();
    }

    public Map<String, String> getTransformed();

    @Value.Derived
    default public boolean isValue() {
        return this.getType() == Type.VALUE;
    }

    @Value.Derived
    default public boolean isObject() {
        return this.getType() == Type.OBJECT;
    }

    @Value.Derived
    default public boolean isArray() {
        return this.getType() == Type.ARRAY;
    }

    public Optional<SimpleFeatureGeometry> getGeometryType();

    public PropertyBase<T, U> schema(Optional<U> var1);

    public PropertyBase<T, U> schema(U var1);

    public PropertyBase<T, U> name(String var1);

    public PropertyBase<T, U> type(Type var1);

    public PropertyBase<T, U> value(String var1);

    public PropertyBase<T, U> parent(T var1);

    public PropertyBase<T, U> addNestedProperties(T var1);

    public PropertyBase<T, U> propertyPath(Iterable<String> var1);

    public PropertyBase<T, U> level(int var1);

    public PropertyBase<T, U> transformed(Map<String, ? extends String> var1);

    public PropertyBase<T, U> geometryType(Optional<SimpleFeatureGeometry> var1);

    public PropertyBase<T, U> geometryType(SimpleFeatureGeometry var1);

    public static enum Type {
        VALUE,
        ARRAY,
        OBJECT;

    }
}

