/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.domain;

import de.ii.xtraplatform.features.domain.FeatureEventHandler;
import de.ii.xtraplatform.features.domain.SchemaBase;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shadow.com.google.common.base.Joiner;
import shadow.com.google.common.collect.ImmutableList;

public class NestingTracker {
    private static final Logger LOGGER = LoggerFactory.getLogger(NestingTracker.class);
    private final FeatureEventHandler<?, ?, FeatureEventHandler.ModifiableContext<?, ?>> downstream;
    private final FeatureEventHandler.ModifiableContext<?, ?> context;
    private final List<String> mainPath;
    private final boolean flattenObjects;
    private final boolean flattenArrays;
    private final List<String> nestingStack;
    private final List<List<String>> pathStack;
    private final List<String> flattened;
    private final boolean skippable;

    public <T extends FeatureEventHandler.ModifiableContext<?, ?>> NestingTracker(FeatureEventHandler<?, ?, T> downstream, T context, List<String> mainPath, boolean flattenObjects, boolean flattenArrays, boolean skippable) {
        this.downstream = downstream;
        this.context = context;
        this.mainPath = mainPath;
        this.flattenObjects = flattenObjects;
        this.flattenArrays = flattenArrays;
        this.skippable = skippable;
        this.nestingStack = new ArrayList<String>();
        this.pathStack = new ArrayList<List<String>>();
        this.flattened = new ArrayList<String>();
    }

    public void openArray() {
        if (this.flattenArrays) {
            this.flattened.add(((SchemaBase)this.context.currentSchema().get()).getName());
        } else if (!this.skippable || !this.context.shouldSkip()) {
            this.downstream.onArrayStart(this.context);
        }
        this.push("A", this.context.pathTracker().asList());
        this.context.setInArray(true);
    }

    public void openObject() {
        if (this.flattenArrays && this.inArray()) {
            this.flattened.add(String.valueOf(this.context.index()));
        } else if (this.flattenObjects && (this.flattenArrays || !this.inArray())) {
            this.flattened.add(((SchemaBase)this.context.currentSchema().get()).getName());
        } else if (!this.skippable || !this.context.shouldSkip()) {
            this.downstream.onObjectStart(this.context);
        }
        this.push("O", this.context.pathTracker().asList());
        this.context.setInObject(true);
    }

    public void closeObject() {
        if (this.nestingStack.isEmpty() || !Objects.equals(this.nestingStack.get(this.nestingStack.size() - 1), "O")) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("No object to close");
            }
            return;
        }
        this.context.pathTracker().track(this.getCurrentNestingPath());
        if (this.flattenArrays && this.isObjectInArray()) {
            this.flattened.remove(this.flattened.size() - 1);
        } else if (this.flattenObjects && (this.flattenArrays || !this.isObjectInArray())) {
            this.flattened.remove(this.flattened.size() - 1);
        } else if (!this.skippable || !this.context.shouldSkip()) {
            this.downstream.onObjectEnd(this.context);
        }
        this.pop();
        if (!this.nestingStack.contains("O")) {
            this.context.setInObject(false);
        }
        if (!this.pathStack.isEmpty()) {
            this.context.pathTracker().track(this.getCurrentNestingPath());
        } else {
            this.context.pathTracker().track(ImmutableList.of());
        }
    }

    public void closeArray() {
        if (this.nestingStack.isEmpty() || !Objects.equals(this.nestingStack.get(this.nestingStack.size() - 1), "A")) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("No array to close");
            }
            return;
        }
        this.context.pathTracker().track(this.getCurrentNestingPath());
        if (this.flattenArrays) {
            this.flattened.remove(this.flattened.size() - 1);
        } else if (!this.skippable || !this.context.shouldSkip()) {
            this.downstream.onArrayEnd(this.context);
        }
        this.pop();
        if (!this.nestingStack.contains("A")) {
            this.context.setInArray(false);
        }
        if (!this.pathStack.isEmpty()) {
            this.context.pathTracker().track(this.getCurrentNestingPath());
        }
    }

    public void close() {
        if (this.nestingStack.isEmpty()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("No object or array to close");
            }
            return;
        }
        if (this.inObject()) {
            this.closeObject();
        } else if (this.inArray()) {
            this.closeArray();
        }
    }

    private void push(String type, List<String> path) {
        this.nestingStack.add(type);
        this.pathStack.add(path);
    }

    private void pop() {
        this.nestingStack.remove(this.nestingStack.size() - 1);
        this.pathStack.remove(this.pathStack.size() - 1);
    }

    public List<String> getCurrentNestingPath() {
        if (this.pathStack.isEmpty()) {
            return null;
        }
        return this.pathStack.get(this.pathStack.size() - 1);
    }

    public boolean isNested() {
        return Objects.nonNull(this.getCurrentNestingPath());
    }

    public boolean inArray() {
        return this.isNested() && Objects.equals(this.nestingStack.get(this.nestingStack.size() - 1), "A");
    }

    public boolean inObject() {
        return this.isNested() && Objects.equals(this.nestingStack.get(this.nestingStack.size() - 1), "O");
    }

    public boolean isObjectInArray() {
        return this.inObject() && this.nestingStack.size() > 1 && Objects.equals(this.nestingStack.get(this.nestingStack.size() - 2), "A");
    }

    public boolean isNotMain(List<String> nextPath) {
        return !Objects.equals(nextPath, this.mainPath);
    }

    public boolean isFirst(List<Integer> indexes) {
        return indexes.size() > 0 && indexes.get(indexes.size() - 1) == 1;
    }

    public boolean isSamePath(List<String> nextPath) {
        return Objects.equals(this.getCurrentNestingPath(), nextPath);
    }

    public boolean doesNotStartWithPreviousPath(List<String> nextPath) {
        return !NestingTracker.startsWith(nextPath, this.getCurrentNestingPath());
    }

    public boolean doesStartWithPreviousPath(List<String> nextPath) {
        if (Objects.equals(nextPath, this.getCurrentNestingPath())) {
            return false;
        }
        return NestingTracker.startsWith(nextPath, this.getCurrentNestingPath());
    }

    public boolean hasIndexChanged(List<Integer> nextIndexes) {
        return !NestingTracker.startsWith(nextIndexes, this.context.indexes());
    }

    public boolean hasParentIndexChanged(List<Integer> nextIndexes) {
        return nextIndexes.size() > 1 && this.context.indexes().size() >= nextIndexes.size() - 1 && nextIndexes.get(nextIndexes.size() - 2) > this.context.indexes().get(nextIndexes.size() - 2);
    }

    private static <T> boolean startsWith(List<T> longer, List<T> shorter) {
        if (Objects.isNull(longer) || Objects.isNull(shorter) || longer.size() < shorter.size()) {
            return false;
        }
        return Objects.equals(longer.subList(0, shorter.size()), shorter);
    }

    public String getFlattenedPropertyPath(String separator, String name) {
        if (this.inArray() && !this.context.indexes().isEmpty()) {
            this.flattened.add(String.valueOf(this.context.index()));
        } else {
            this.flattened.add(name);
        }
        String path = Joiner.on(separator).join(this.flattened);
        this.flattened.remove(this.flattened.size() - 1);
        return path;
    }
}

