/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.domain;

import de.ii.xtraplatform.features.domain.Tuple;
import java.util.Objects;
import shadow.com.google.common.base.MoreObjects;
import shadow.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.javax.annotation.CheckReturnValue;
import shadow.javax.annotation.Nullable;
import shadow.javax.annotation.ParametersAreNonnullByDefault;
import shadow.javax.annotation.concurrent.Immutable;
import shadow.javax.annotation.concurrent.NotThreadSafe;
import shadow.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Tuple", generator="Immutables")
@Immutable
public final class ImmutableTuple<T, U>
implements Tuple<T, U> {
    @Nullable
    private final T first;
    @Nullable
    private final U second;

    private ImmutableTuple(@Nullable T first, @Nullable U second) {
        this.first = first;
        this.second = second;
    }

    @Override
    @Nullable
    public T first() {
        return this.first;
    }

    @Override
    @Nullable
    public U second() {
        return this.second;
    }

    public final ImmutableTuple<T, U> withFirst(@Nullable T value) {
        if (this.first == value) {
            return this;
        }
        return new ImmutableTuple<T, U>(value, this.second);
    }

    public final ImmutableTuple<T, U> withSecond(@Nullable U value) {
        if (this.second == value) {
            return this;
        }
        return new ImmutableTuple<T, U>(this.first, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTuple && this.equalTo((ImmutableTuple)another);
    }

    private boolean equalTo(ImmutableTuple<?, ?> another) {
        return Objects.equals(this.first, another.first) && Objects.equals(this.second, another.second);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.first);
        h += (h << 5) + Objects.hashCode(this.second);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("Tuple").omitNullValues().add("first", this.first).add("second", this.second).toString();
    }

    public static <T, U> ImmutableTuple<T, U> of(@Nullable T first, @Nullable U second) {
        return new ImmutableTuple<T, U>(first, second);
    }

    public static <T, U> ImmutableTuple<T, U> copyOf(Tuple<T, U> instance) {
        if (instance instanceof ImmutableTuple) {
            return (ImmutableTuple)instance;
        }
        return ImmutableTuple.builder().from(instance).build();
    }

    public static <T, U> Builder<T, U> builder() {
        return new Builder();
    }

    @Generated(from="Tuple", generator="Immutables")
    @NotThreadSafe
    public static final class Builder<T, U> {
        @Nullable
        private T first;
        @Nullable
        private U second;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder<T, U> from(Tuple<T, U> instance) {
            U secondValue;
            Objects.requireNonNull(instance, "instance");
            T firstValue = instance.first();
            if (firstValue != null) {
                this.first(firstValue);
            }
            if ((secondValue = instance.second()) != null) {
                this.second(secondValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T, U> first(@Nullable T first) {
            this.first = first;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T, U> second(@Nullable U second) {
            this.second = second;
            return this;
        }

        public ImmutableTuple<T, U> build() {
            return new ImmutableTuple<T, U>(this.first, this.second);
        }
    }
}

