/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.domain;

import de.ii.xtraplatform.features.domain.FeatureStream;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import shadow.com.google.common.base.MoreObjects;
import shadow.com.google.common.primitives.Booleans;
import shadow.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.javax.annotation.CheckReturnValue;
import shadow.javax.annotation.Nullable;
import shadow.javax.annotation.ParametersAreNonnullByDefault;
import shadow.javax.annotation.concurrent.Immutable;
import shadow.javax.annotation.concurrent.NotThreadSafe;
import shadow.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="FeatureStream.ResultReduced", generator="Immutables")
@Immutable
public final class ImmutableResultReduced<T>
implements FeatureStream.ResultReduced<T> {
    private final transient boolean isSuccess;
    private final boolean isEmpty;
    @Nullable
    private final Throwable error;
    private final T reduced;

    private ImmutableResultReduced(boolean isEmpty, @Nullable Throwable error, T reduced) {
        this.isEmpty = isEmpty;
        this.error = error;
        this.reduced = reduced;
        this.isSuccess = FeatureStream.ResultReduced.super.isSuccess();
    }

    @Override
    public boolean isSuccess() {
        return this.isSuccess;
    }

    @Override
    public boolean isEmpty() {
        return this.isEmpty;
    }

    @Override
    public Optional<Throwable> getError() {
        return Optional.ofNullable(this.error);
    }

    @Override
    public T reduced() {
        return this.reduced;
    }

    public final ImmutableResultReduced<T> withIsEmpty(boolean value) {
        if (this.isEmpty == value) {
            return this;
        }
        return new ImmutableResultReduced<T>(value, this.error, this.reduced);
    }

    public final ImmutableResultReduced<T> withError(Throwable value) {
        Throwable newValue = Objects.requireNonNull(value, "error");
        if (this.error == newValue) {
            return this;
        }
        return new ImmutableResultReduced<T>(this.isEmpty, newValue, this.reduced);
    }

    public final ImmutableResultReduced<T> withError(Optional<? extends Throwable> optional) {
        Throwable value = optional.orElse(null);
        if (this.error == value) {
            return this;
        }
        return new ImmutableResultReduced<T>(this.isEmpty, value, this.reduced);
    }

    public final ImmutableResultReduced<T> withReduced(T value) {
        if (this.reduced == value) {
            return this;
        }
        T newValue = Objects.requireNonNull(value, "reduced");
        return new ImmutableResultReduced<T>(this.isEmpty, this.error, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableResultReduced && this.equalTo((ImmutableResultReduced)another);
    }

    private boolean equalTo(ImmutableResultReduced<?> another) {
        return this.isSuccess == another.isSuccess && this.isEmpty == another.isEmpty && Objects.equals(this.error, another.error) && this.reduced.equals(another.reduced);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Booleans.hashCode(this.isSuccess);
        h += (h << 5) + Booleans.hashCode(this.isEmpty);
        h += (h << 5) + Objects.hashCode(this.error);
        h += (h << 5) + this.reduced.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("ResultReduced").omitNullValues().add("isSuccess", this.isSuccess).add("isEmpty", this.isEmpty).add("error", this.error).add("reduced", this.reduced).toString();
    }

    public static <T> ImmutableResultReduced<T> copyOf(FeatureStream.ResultReduced<T> instance) {
        if (instance instanceof ImmutableResultReduced) {
            return (ImmutableResultReduced)instance;
        }
        return ImmutableResultReduced.builder().from(instance).build();
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    @Generated(from="FeatureStream.ResultReduced", generator="Immutables")
    @NotThreadSafe
    public static final class Builder<T>
    extends FeatureStream.ResultReduced.Builder<T> {
        private static final long INIT_BIT_IS_EMPTY = 1L;
        private static final long INIT_BIT_REDUCED = 2L;
        private long initBits = 3L;
        private boolean isEmpty;
        @Nullable
        private Throwable error;
        @Nullable
        private T reduced;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder<T> from(FeatureStream.ResultBase instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> from(FeatureStream.ResultReduced<T> instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            FeatureStream.ResultBase instance;
            if (object instanceof FeatureStream.ResultBase) {
                instance = (FeatureStream.ResultBase)object;
                this.isEmpty(instance.isEmpty());
                Optional<Throwable> errorOptional = instance.getError();
                if (errorOptional.isPresent()) {
                    this.error(errorOptional);
                }
            }
            if (object instanceof FeatureStream.ResultReduced) {
                instance = (FeatureStream.ResultReduced)object;
                this.reduced(instance.reduced());
            }
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder<T> isEmpty(boolean isEmpty) {
            this.isEmpty = isEmpty;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder<T> error(Throwable error) {
            this.error = Objects.requireNonNull(error, "error");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> error(Optional<? extends Throwable> error) {
            this.error = error.orElse(null);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder<T> reduced(T reduced) {
            this.reduced = Objects.requireNonNull(reduced, "reduced");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @Override
        public ImmutableResultReduced<T> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableResultReduced<T>(this.isEmpty, this.error, this.reduced);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("isEmpty");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("reduced");
            }
            return "Cannot build ResultReduced, some of required attributes are not set " + attributes;
        }
    }
}

