/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.domain;

import de.ii.xtraplatform.features.domain.FeatureStream;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import shadow.com.google.common.base.MoreObjects;
import shadow.com.google.common.primitives.Booleans;
import shadow.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.javax.annotation.CheckReturnValue;
import shadow.javax.annotation.Nullable;
import shadow.javax.annotation.ParametersAreNonnullByDefault;
import shadow.javax.annotation.concurrent.Immutable;
import shadow.javax.annotation.concurrent.NotThreadSafe;
import shadow.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="FeatureStream.Result", generator="Immutables")
@Immutable
public final class ImmutableResult
implements FeatureStream.Result {
    private final transient boolean isSuccess;
    private final boolean isEmpty;
    @Nullable
    private final Throwable error;

    private ImmutableResult(boolean isEmpty, @Nullable Throwable error) {
        this.isEmpty = isEmpty;
        this.error = error;
        this.isSuccess = FeatureStream.Result.super.isSuccess();
    }

    @Override
    public boolean isSuccess() {
        return this.isSuccess;
    }

    @Override
    public boolean isEmpty() {
        return this.isEmpty;
    }

    @Override
    public Optional<Throwable> getError() {
        return Optional.ofNullable(this.error);
    }

    public final ImmutableResult withIsEmpty(boolean value) {
        if (this.isEmpty == value) {
            return this;
        }
        return new ImmutableResult(value, this.error);
    }

    public final ImmutableResult withError(Throwable value) {
        Throwable newValue = Objects.requireNonNull(value, "error");
        if (this.error == newValue) {
            return this;
        }
        return new ImmutableResult(this.isEmpty, newValue);
    }

    public final ImmutableResult withError(Optional<? extends Throwable> optional) {
        Throwable value = optional.orElse(null);
        if (this.error == value) {
            return this;
        }
        return new ImmutableResult(this.isEmpty, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableResult && this.equalTo((ImmutableResult)another);
    }

    private boolean equalTo(ImmutableResult another) {
        return this.isSuccess == another.isSuccess && this.isEmpty == another.isEmpty && Objects.equals(this.error, another.error);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Booleans.hashCode(this.isSuccess);
        h += (h << 5) + Booleans.hashCode(this.isEmpty);
        h += (h << 5) + Objects.hashCode(this.error);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("Result").omitNullValues().add("isSuccess", this.isSuccess).add("isEmpty", this.isEmpty).add("error", this.error).toString();
    }

    public static ImmutableResult copyOf(FeatureStream.Result instance) {
        if (instance instanceof ImmutableResult) {
            return (ImmutableResult)instance;
        }
        return ImmutableResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="FeatureStream.Result", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    extends FeatureStream.Result.Builder {
        private static final long INIT_BIT_IS_EMPTY = 1L;
        private long initBits = 1L;
        private boolean isEmpty;
        @Nullable
        private Throwable error;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(FeatureStream.ResultBase instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(FeatureStream.Result instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            if (object instanceof FeatureStream.ResultBase) {
                FeatureStream.ResultBase instance = (FeatureStream.ResultBase)object;
                this.isEmpty(instance.isEmpty());
                Optional<Throwable> errorOptional = instance.getError();
                if (errorOptional.isPresent()) {
                    this.error(errorOptional);
                }
            }
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder isEmpty(boolean isEmpty) {
            this.isEmpty = isEmpty;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder error(Throwable error) {
            this.error = Objects.requireNonNull(error, "error");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder error(Optional<? extends Throwable> error) {
            this.error = error.orElse(null);
            return this;
        }

        @Override
        public ImmutableResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableResult(this.isEmpty, this.error);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("isEmpty");
            }
            return "Cannot build Result, some of required attributes are not set " + attributes;
        }
    }
}

