/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.domain;

import de.ii.xtraplatform.features.domain.FeatureStream;
import de.ii.xtraplatform.features.domain.FeatureTransactions;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import shadow.com.google.common.base.MoreObjects;
import shadow.com.google.common.collect.ImmutableList;
import shadow.com.google.common.primitives.Booleans;
import shadow.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.javax.annotation.CheckReturnValue;
import shadow.javax.annotation.Nullable;
import shadow.javax.annotation.ParametersAreNonnullByDefault;
import shadow.javax.annotation.concurrent.Immutable;
import shadow.javax.annotation.concurrent.NotThreadSafe;
import shadow.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="FeatureTransactions.MutationResult", generator="Immutables")
@Immutable
public final class ImmutableMutationResult
implements FeatureTransactions.MutationResult {
    private final transient boolean isSuccess;
    @Nullable
    private final Throwable error;
    private final ImmutableList<String> ids;
    private final boolean isEmpty;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableMutationResult(Builder builder) {
        this.error = builder.error;
        this.ids = builder.ids.build();
        if (builder.isEmptyIsSet()) {
            this.initShim.isEmpty(builder.isEmpty);
        }
        this.isSuccess = this.initShim.isSuccess();
        this.isEmpty = this.initShim.isEmpty();
        this.initShim = null;
    }

    private ImmutableMutationResult(@Nullable Throwable error, ImmutableList<String> ids, boolean isEmpty) {
        this.error = error;
        this.ids = ids;
        this.initShim.isEmpty(isEmpty);
        this.isSuccess = this.initShim.isSuccess();
        this.isEmpty = this.initShim.isEmpty();
        this.initShim = null;
    }

    private boolean isSuccessInitialize() {
        return FeatureTransactions.MutationResult.super.isSuccess();
    }

    private boolean isEmptyInitialize() {
        return FeatureTransactions.MutationResult.super.isEmpty();
    }

    @Override
    public boolean isSuccess() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isSuccess() : this.isSuccess;
    }

    @Override
    public Optional<Throwable> getError() {
        return Optional.ofNullable(this.error);
    }

    public ImmutableList<String> getIds() {
        return this.ids;
    }

    @Override
    public boolean isEmpty() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isEmpty() : this.isEmpty;
    }

    public final ImmutableMutationResult withError(Throwable value) {
        Throwable newValue = Objects.requireNonNull(value, "error");
        if (this.error == newValue) {
            return this;
        }
        return new ImmutableMutationResult(newValue, this.ids, this.isEmpty);
    }

    public final ImmutableMutationResult withError(Optional<? extends Throwable> optional) {
        Throwable value = optional.orElse(null);
        if (this.error == value) {
            return this;
        }
        return new ImmutableMutationResult(value, this.ids, this.isEmpty);
    }

    public final ImmutableMutationResult withIds(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableMutationResult(this.error, newValue, this.isEmpty);
    }

    public final ImmutableMutationResult withIds(Iterable<String> elements) {
        if (this.ids == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableMutationResult(this.error, newValue, this.isEmpty);
    }

    public final ImmutableMutationResult withIsEmpty(boolean value) {
        if (this.isEmpty == value) {
            return this;
        }
        return new ImmutableMutationResult(this.error, this.ids, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMutationResult && this.equalTo((ImmutableMutationResult)another);
    }

    private boolean equalTo(ImmutableMutationResult another) {
        return this.isSuccess == another.isSuccess && Objects.equals(this.error, another.error) && this.ids.equals(another.ids) && this.isEmpty == another.isEmpty;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Booleans.hashCode(this.isSuccess);
        h += (h << 5) + Objects.hashCode(this.error);
        h += (h << 5) + this.ids.hashCode();
        h += (h << 5) + Booleans.hashCode(this.isEmpty);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("MutationResult").omitNullValues().add("isSuccess", this.isSuccess).add("error", this.error).add("ids", this.ids).add("isEmpty", this.isEmpty).toString();
    }

    public static ImmutableMutationResult copyOf(FeatureTransactions.MutationResult instance) {
        if (instance instanceof ImmutableMutationResult) {
            return (ImmutableMutationResult)instance;
        }
        return ImmutableMutationResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="FeatureTransactions.MutationResult", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    extends FeatureTransactions.MutationResult.Builder {
        private static final long OPT_BIT_IS_EMPTY = 1L;
        private long optBits;
        @Nullable
        private Throwable error;
        private ImmutableList.Builder<String> ids = ImmutableList.builder();
        private boolean isEmpty;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(FeatureStream.ResultBase instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(FeatureTransactions.MutationResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            FeatureStream.ResultBase instance;
            long bits = 0L;
            if (object instanceof FeatureStream.ResultBase) {
                Optional<Throwable> errorOptional;
                instance = (FeatureStream.ResultBase)object;
                if ((bits & 1L) == 0L) {
                    this.isEmpty(instance.isEmpty());
                    bits |= 1L;
                }
                if ((errorOptional = instance.getError()).isPresent()) {
                    this.error(errorOptional);
                }
            }
            if (object instanceof FeatureTransactions.MutationResult) {
                instance = (FeatureTransactions.MutationResult)object;
                if ((bits & 1L) == 0L) {
                    this.isEmpty(instance.isEmpty());
                    bits |= 1L;
                }
                this.addAllIds(instance.getIds());
            }
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder error(Throwable error) {
            this.error = Objects.requireNonNull(error, "error");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder error(Optional<? extends Throwable> error) {
            this.error = error.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addIds(String element) {
            this.ids.add((Object)element);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder addIds(String ... elements) {
            this.ids.add(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ids(Iterable<String> elements) {
            this.ids = ImmutableList.builder();
            return this.addAllIds(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllIds(Iterable<String> elements) {
            this.ids.addAll((Iterable)elements);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder isEmpty(boolean isEmpty) {
            this.isEmpty = isEmpty;
            this.optBits |= 1L;
            return this;
        }

        @Override
        public ImmutableMutationResult build() {
            return new ImmutableMutationResult(this);
        }

        private boolean isEmptyIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }

    @Generated(from="FeatureTransactions.MutationResult", generator="Immutables")
    private final class InitShim {
        private byte isSuccessBuildStage = 0;
        private boolean isSuccess;
        private byte isEmptyBuildStage = 0;
        private boolean isEmpty;

        private InitShim() {
        }

        boolean isSuccess() {
            if (this.isSuccessBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isSuccessBuildStage == 0) {
                this.isSuccessBuildStage = (byte)-1;
                this.isSuccess = ImmutableMutationResult.this.isSuccessInitialize();
                this.isSuccessBuildStage = 1;
            }
            return this.isSuccess;
        }

        boolean isEmpty() {
            if (this.isEmptyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isEmptyBuildStage == 0) {
                this.isEmptyBuildStage = (byte)-1;
                this.isEmpty = ImmutableMutationResult.this.isEmptyInitialize();
                this.isEmptyBuildStage = 1;
            }
            return this.isEmpty;
        }

        void isEmpty(boolean isEmpty) {
            this.isEmpty = isEmpty;
            this.isEmptyBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.isSuccessBuildStage == -1) {
                attributes.add("isSuccess");
            }
            if (this.isEmptyBuildStage == -1) {
                attributes.add("isEmpty");
            }
            return "Cannot build MutationResult, attribute initializers form cycle " + attributes;
        }
    }
}

