/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.domain;

import de.ii.xtraplatform.crs.domain.BoundingBox;
import de.ii.xtraplatform.features.domain.Metadata;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import shadow.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.com.google.common.base.MoreObjects;
import shadow.com.google.common.collect.ImmutableList;
import shadow.com.google.common.collect.ImmutableMap;
import shadow.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.javax.annotation.CheckReturnValue;
import shadow.javax.annotation.Nullable;
import shadow.javax.annotation.ParametersAreNonnullByDefault;
import shadow.javax.annotation.concurrent.Immutable;
import shadow.javax.annotation.concurrent.NotThreadSafe;
import shadow.javax.xml.namespace.QName;
import shadow.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Metadata", generator="Immutables")
@Immutable
public final class ImmutableMetadata
implements Metadata {
    @Nullable
    private final String version;
    @Nullable
    private final String label;
    @Nullable
    private final String description;
    private final ImmutableList<String> keywords;
    @Nullable
    private final String fees;
    @Nullable
    private final String accessConstraints;
    @Nullable
    private final String contactName;
    @Nullable
    private final String contactUrl;
    @Nullable
    private final String contactEmail;
    private final ImmutableList<QName> featureTypes;
    private final ImmutableMap<QName, String> featureTypesCrs;
    private final ImmutableMap<String, BoundingBox> featureTypesBoundingBox;
    private final ImmutableMap<String, String> namespaces;

    private ImmutableMetadata(@Nullable String version, @Nullable String label, @Nullable String description, ImmutableList<String> keywords, @Nullable String fees, @Nullable String accessConstraints, @Nullable String contactName, @Nullable String contactUrl, @Nullable String contactEmail, ImmutableList<QName> featureTypes, ImmutableMap<QName, String> featureTypesCrs, ImmutableMap<String, BoundingBox> featureTypesBoundingBox, ImmutableMap<String, String> namespaces) {
        this.version = version;
        this.label = label;
        this.description = description;
        this.keywords = keywords;
        this.fees = fees;
        this.accessConstraints = accessConstraints;
        this.contactName = contactName;
        this.contactUrl = contactUrl;
        this.contactEmail = contactEmail;
        this.featureTypes = featureTypes;
        this.featureTypesCrs = featureTypesCrs;
        this.featureTypesBoundingBox = featureTypesBoundingBox;
        this.namespaces = namespaces;
    }

    @Override
    @JsonProperty(value="version")
    public Optional<String> getVersion() {
        return Optional.ofNullable(this.version);
    }

    @Override
    @JsonProperty(value="label")
    public Optional<String> getLabel() {
        return Optional.ofNullable(this.label);
    }

    @Override
    @JsonProperty(value="description")
    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    @JsonProperty(value="keywords")
    public ImmutableList<String> getKeywords() {
        return this.keywords;
    }

    @Override
    @JsonProperty(value="fees")
    public Optional<String> getFees() {
        return Optional.ofNullable(this.fees);
    }

    @Override
    @JsonProperty(value="accessConstraints")
    public Optional<String> getAccessConstraints() {
        return Optional.ofNullable(this.accessConstraints);
    }

    @Override
    @JsonProperty(value="contactName")
    public Optional<String> getContactName() {
        return Optional.ofNullable(this.contactName);
    }

    @Override
    @JsonProperty(value="contactUrl")
    public Optional<String> getContactUrl() {
        return Optional.ofNullable(this.contactUrl);
    }

    @Override
    @JsonProperty(value="contactEmail")
    public Optional<String> getContactEmail() {
        return Optional.ofNullable(this.contactEmail);
    }

    @JsonProperty(value="featureTypes")
    public ImmutableList<QName> getFeatureTypes() {
        return this.featureTypes;
    }

    @JsonProperty(value="featureTypesCrs")
    public ImmutableMap<QName, String> getFeatureTypesCrs() {
        return this.featureTypesCrs;
    }

    @JsonProperty(value="featureTypesBoundingBox")
    public ImmutableMap<String, BoundingBox> getFeatureTypesBoundingBox() {
        return this.featureTypesBoundingBox;
    }

    @JsonProperty(value="namespaces")
    public ImmutableMap<String, String> getNamespaces() {
        return this.namespaces;
    }

    public final ImmutableMetadata withVersion(String value) {
        String newValue = Objects.requireNonNull(value, "version");
        if (Objects.equals(this.version, newValue)) {
            return this;
        }
        return new ImmutableMetadata(newValue, this.label, this.description, this.keywords, this.fees, this.accessConstraints, this.contactName, this.contactUrl, this.contactEmail, this.featureTypes, this.featureTypesCrs, this.featureTypesBoundingBox, this.namespaces);
    }

    public final ImmutableMetadata withVersion(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.version, value)) {
            return this;
        }
        return new ImmutableMetadata(value, this.label, this.description, this.keywords, this.fees, this.accessConstraints, this.contactName, this.contactUrl, this.contactEmail, this.featureTypes, this.featureTypesCrs, this.featureTypesBoundingBox, this.namespaces);
    }

    public final ImmutableMetadata withLabel(String value) {
        String newValue = Objects.requireNonNull(value, "label");
        if (Objects.equals(this.label, newValue)) {
            return this;
        }
        return new ImmutableMetadata(this.version, newValue, this.description, this.keywords, this.fees, this.accessConstraints, this.contactName, this.contactUrl, this.contactEmail, this.featureTypes, this.featureTypesCrs, this.featureTypesBoundingBox, this.namespaces);
    }

    public final ImmutableMetadata withLabel(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.label, value)) {
            return this;
        }
        return new ImmutableMetadata(this.version, value, this.description, this.keywords, this.fees, this.accessConstraints, this.contactName, this.contactUrl, this.contactEmail, this.featureTypes, this.featureTypesCrs, this.featureTypesBoundingBox, this.namespaces);
    }

    public final ImmutableMetadata withDescription(String value) {
        String newValue = Objects.requireNonNull(value, "description");
        if (Objects.equals(this.description, newValue)) {
            return this;
        }
        return new ImmutableMetadata(this.version, this.label, newValue, this.keywords, this.fees, this.accessConstraints, this.contactName, this.contactUrl, this.contactEmail, this.featureTypes, this.featureTypesCrs, this.featureTypesBoundingBox, this.namespaces);
    }

    public final ImmutableMetadata withDescription(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.description, value)) {
            return this;
        }
        return new ImmutableMetadata(this.version, this.label, value, this.keywords, this.fees, this.accessConstraints, this.contactName, this.contactUrl, this.contactEmail, this.featureTypes, this.featureTypesCrs, this.featureTypesBoundingBox, this.namespaces);
    }

    public final ImmutableMetadata withKeywords(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableMetadata(this.version, this.label, this.description, newValue, this.fees, this.accessConstraints, this.contactName, this.contactUrl, this.contactEmail, this.featureTypes, this.featureTypesCrs, this.featureTypesBoundingBox, this.namespaces);
    }

    public final ImmutableMetadata withKeywords(Iterable<String> elements) {
        if (this.keywords == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableMetadata(this.version, this.label, this.description, newValue, this.fees, this.accessConstraints, this.contactName, this.contactUrl, this.contactEmail, this.featureTypes, this.featureTypesCrs, this.featureTypesBoundingBox, this.namespaces);
    }

    public final ImmutableMetadata withFees(String value) {
        String newValue = Objects.requireNonNull(value, "fees");
        if (Objects.equals(this.fees, newValue)) {
            return this;
        }
        return new ImmutableMetadata(this.version, this.label, this.description, this.keywords, newValue, this.accessConstraints, this.contactName, this.contactUrl, this.contactEmail, this.featureTypes, this.featureTypesCrs, this.featureTypesBoundingBox, this.namespaces);
    }

    public final ImmutableMetadata withFees(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.fees, value)) {
            return this;
        }
        return new ImmutableMetadata(this.version, this.label, this.description, this.keywords, value, this.accessConstraints, this.contactName, this.contactUrl, this.contactEmail, this.featureTypes, this.featureTypesCrs, this.featureTypesBoundingBox, this.namespaces);
    }

    public final ImmutableMetadata withAccessConstraints(String value) {
        String newValue = Objects.requireNonNull(value, "accessConstraints");
        if (Objects.equals(this.accessConstraints, newValue)) {
            return this;
        }
        return new ImmutableMetadata(this.version, this.label, this.description, this.keywords, this.fees, newValue, this.contactName, this.contactUrl, this.contactEmail, this.featureTypes, this.featureTypesCrs, this.featureTypesBoundingBox, this.namespaces);
    }

    public final ImmutableMetadata withAccessConstraints(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.accessConstraints, value)) {
            return this;
        }
        return new ImmutableMetadata(this.version, this.label, this.description, this.keywords, this.fees, value, this.contactName, this.contactUrl, this.contactEmail, this.featureTypes, this.featureTypesCrs, this.featureTypesBoundingBox, this.namespaces);
    }

    public final ImmutableMetadata withContactName(String value) {
        String newValue = Objects.requireNonNull(value, "contactName");
        if (Objects.equals(this.contactName, newValue)) {
            return this;
        }
        return new ImmutableMetadata(this.version, this.label, this.description, this.keywords, this.fees, this.accessConstraints, newValue, this.contactUrl, this.contactEmail, this.featureTypes, this.featureTypesCrs, this.featureTypesBoundingBox, this.namespaces);
    }

    public final ImmutableMetadata withContactName(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.contactName, value)) {
            return this;
        }
        return new ImmutableMetadata(this.version, this.label, this.description, this.keywords, this.fees, this.accessConstraints, value, this.contactUrl, this.contactEmail, this.featureTypes, this.featureTypesCrs, this.featureTypesBoundingBox, this.namespaces);
    }

    public final ImmutableMetadata withContactUrl(String value) {
        String newValue = Objects.requireNonNull(value, "contactUrl");
        if (Objects.equals(this.contactUrl, newValue)) {
            return this;
        }
        return new ImmutableMetadata(this.version, this.label, this.description, this.keywords, this.fees, this.accessConstraints, this.contactName, newValue, this.contactEmail, this.featureTypes, this.featureTypesCrs, this.featureTypesBoundingBox, this.namespaces);
    }

    public final ImmutableMetadata withContactUrl(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.contactUrl, value)) {
            return this;
        }
        return new ImmutableMetadata(this.version, this.label, this.description, this.keywords, this.fees, this.accessConstraints, this.contactName, value, this.contactEmail, this.featureTypes, this.featureTypesCrs, this.featureTypesBoundingBox, this.namespaces);
    }

    public final ImmutableMetadata withContactEmail(String value) {
        String newValue = Objects.requireNonNull(value, "contactEmail");
        if (Objects.equals(this.contactEmail, newValue)) {
            return this;
        }
        return new ImmutableMetadata(this.version, this.label, this.description, this.keywords, this.fees, this.accessConstraints, this.contactName, this.contactUrl, newValue, this.featureTypes, this.featureTypesCrs, this.featureTypesBoundingBox, this.namespaces);
    }

    public final ImmutableMetadata withContactEmail(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.contactEmail, value)) {
            return this;
        }
        return new ImmutableMetadata(this.version, this.label, this.description, this.keywords, this.fees, this.accessConstraints, this.contactName, this.contactUrl, value, this.featureTypes, this.featureTypesCrs, this.featureTypesBoundingBox, this.namespaces);
    }

    public final ImmutableMetadata withFeatureTypes(QName ... elements) {
        ImmutableList<QName> newValue = ImmutableList.copyOf(elements);
        return new ImmutableMetadata(this.version, this.label, this.description, this.keywords, this.fees, this.accessConstraints, this.contactName, this.contactUrl, this.contactEmail, newValue, this.featureTypesCrs, this.featureTypesBoundingBox, this.namespaces);
    }

    public final ImmutableMetadata withFeatureTypes(Iterable<? extends QName> elements) {
        if (this.featureTypes == elements) {
            return this;
        }
        ImmutableList<QName> newValue = ImmutableList.copyOf(elements);
        return new ImmutableMetadata(this.version, this.label, this.description, this.keywords, this.fees, this.accessConstraints, this.contactName, this.contactUrl, this.contactEmail, newValue, this.featureTypesCrs, this.featureTypesBoundingBox, this.namespaces);
    }

    public final ImmutableMetadata withFeatureTypesCrs(Map<? extends QName, ? extends String> entries) {
        if (this.featureTypesCrs == entries) {
            return this;
        }
        ImmutableMap<QName, String> newValue = ImmutableMap.copyOf(entries);
        return new ImmutableMetadata(this.version, this.label, this.description, this.keywords, this.fees, this.accessConstraints, this.contactName, this.contactUrl, this.contactEmail, this.featureTypes, newValue, this.featureTypesBoundingBox, this.namespaces);
    }

    public final ImmutableMetadata withFeatureTypesBoundingBox(Map<String, ? extends BoundingBox> entries) {
        if (this.featureTypesBoundingBox == entries) {
            return this;
        }
        ImmutableMap<String, BoundingBox> newValue = ImmutableMap.copyOf(entries);
        return new ImmutableMetadata(this.version, this.label, this.description, this.keywords, this.fees, this.accessConstraints, this.contactName, this.contactUrl, this.contactEmail, this.featureTypes, this.featureTypesCrs, newValue, this.namespaces);
    }

    public final ImmutableMetadata withNamespaces(Map<String, ? extends String> entries) {
        if (this.namespaces == entries) {
            return this;
        }
        ImmutableMap<String, String> newValue = ImmutableMap.copyOf(entries);
        return new ImmutableMetadata(this.version, this.label, this.description, this.keywords, this.fees, this.accessConstraints, this.contactName, this.contactUrl, this.contactEmail, this.featureTypes, this.featureTypesCrs, this.featureTypesBoundingBox, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMetadata && this.equalTo((ImmutableMetadata)another);
    }

    private boolean equalTo(ImmutableMetadata another) {
        return Objects.equals(this.version, another.version) && Objects.equals(this.label, another.label) && Objects.equals(this.description, another.description) && this.keywords.equals(another.keywords) && Objects.equals(this.fees, another.fees) && Objects.equals(this.accessConstraints, another.accessConstraints) && Objects.equals(this.contactName, another.contactName) && Objects.equals(this.contactUrl, another.contactUrl) && Objects.equals(this.contactEmail, another.contactEmail) && this.featureTypes.equals(another.featureTypes) && this.featureTypesCrs.equals(another.featureTypesCrs) && this.featureTypesBoundingBox.equals(another.featureTypesBoundingBox) && this.namespaces.equals(another.namespaces);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.version);
        h += (h << 5) + Objects.hashCode(this.label);
        h += (h << 5) + Objects.hashCode(this.description);
        h += (h << 5) + this.keywords.hashCode();
        h += (h << 5) + Objects.hashCode(this.fees);
        h += (h << 5) + Objects.hashCode(this.accessConstraints);
        h += (h << 5) + Objects.hashCode(this.contactName);
        h += (h << 5) + Objects.hashCode(this.contactUrl);
        h += (h << 5) + Objects.hashCode(this.contactEmail);
        h += (h << 5) + this.featureTypes.hashCode();
        h += (h << 5) + this.featureTypesCrs.hashCode();
        h += (h << 5) + this.featureTypesBoundingBox.hashCode();
        h += (h << 5) + this.namespaces.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("Metadata").omitNullValues().add("version", this.version).add("label", this.label).add("description", this.description).add("keywords", this.keywords).add("fees", this.fees).add("accessConstraints", this.accessConstraints).add("contactName", this.contactName).add("contactUrl", this.contactUrl).add("contactEmail", this.contactEmail).add("featureTypes", this.featureTypes).add("featureTypesCrs", this.featureTypesCrs).add("featureTypesBoundingBox", this.featureTypesBoundingBox).add("namespaces", this.namespaces).toString();
    }

    public static ImmutableMetadata copyOf(Metadata instance) {
        if (instance instanceof ImmutableMetadata) {
            return (ImmutableMetadata)instance;
        }
        return new Builder().from(instance).build();
    }

    @Generated(from="Metadata", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String version;
        @Nullable
        private String label;
        @Nullable
        private String description;
        private ImmutableList.Builder<String> keywords = ImmutableList.builder();
        @Nullable
        private String fees;
        @Nullable
        private String accessConstraints;
        @Nullable
        private String contactName;
        @Nullable
        private String contactUrl;
        @Nullable
        private String contactEmail;
        private ImmutableList.Builder<QName> featureTypes = ImmutableList.builder();
        private ImmutableMap.Builder<QName, String> featureTypesCrs = ImmutableMap.builder();
        private ImmutableMap.Builder<String, BoundingBox> featureTypesBoundingBox = ImmutableMap.builder();
        private ImmutableMap.Builder<String, String> namespaces = ImmutableMap.builder();

        @CanIgnoreReturnValue
        public final Builder from(Metadata instance) {
            Optional<String> contactEmailOptional;
            Optional<String> contactUrlOptional;
            Optional<String> contactNameOptional;
            Optional<String> accessConstraintsOptional;
            Optional<String> descriptionOptional;
            Optional<String> labelOptional;
            Objects.requireNonNull(instance, "instance");
            Optional<String> versionOptional = instance.getVersion();
            if (versionOptional.isPresent()) {
                this.version(versionOptional);
            }
            if ((labelOptional = instance.getLabel()).isPresent()) {
                this.label(labelOptional);
            }
            if ((descriptionOptional = instance.getDescription()).isPresent()) {
                this.description(descriptionOptional);
            }
            this.addAllKeywords(instance.getKeywords());
            Optional<String> feesOptional = instance.getFees();
            if (feesOptional.isPresent()) {
                this.fees(feesOptional);
            }
            if ((accessConstraintsOptional = instance.getAccessConstraints()).isPresent()) {
                this.accessConstraints(accessConstraintsOptional);
            }
            if ((contactNameOptional = instance.getContactName()).isPresent()) {
                this.contactName(contactNameOptional);
            }
            if ((contactUrlOptional = instance.getContactUrl()).isPresent()) {
                this.contactUrl(contactUrlOptional);
            }
            if ((contactEmailOptional = instance.getContactEmail()).isPresent()) {
                this.contactEmail(contactEmailOptional);
            }
            this.addAllFeatureTypes(instance.getFeatureTypes());
            this.putAllFeatureTypesCrs(instance.getFeatureTypesCrs());
            this.putAllFeatureTypesBoundingBox(instance.getFeatureTypesBoundingBox());
            this.putAllNamespaces(instance.getNamespaces());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder version(String version) {
            this.version = Objects.requireNonNull(version, "version");
            return this;
        }

        @JsonProperty(value="version")
        @CanIgnoreReturnValue
        public final Builder version(Optional<String> version) {
            this.version = version.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder label(String label) {
            this.label = Objects.requireNonNull(label, "label");
            return this;
        }

        @JsonProperty(value="label")
        @CanIgnoreReturnValue
        public final Builder label(Optional<String> label) {
            this.label = label.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder description(String description) {
            this.description = Objects.requireNonNull(description, "description");
            return this;
        }

        @JsonProperty(value="description")
        @CanIgnoreReturnValue
        public final Builder description(Optional<String> description) {
            this.description = description.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addKeywords(String element) {
            this.keywords.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addKeywords(String ... elements) {
            this.keywords.add(elements);
            return this;
        }

        @JsonProperty(value="keywords")
        @CanIgnoreReturnValue
        public final Builder keywords(Iterable<String> elements) {
            this.keywords = ImmutableList.builder();
            return this.addAllKeywords(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllKeywords(Iterable<String> elements) {
            this.keywords.addAll((Iterable)elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder fees(String fees) {
            this.fees = Objects.requireNonNull(fees, "fees");
            return this;
        }

        @JsonProperty(value="fees")
        @CanIgnoreReturnValue
        public final Builder fees(Optional<String> fees) {
            this.fees = fees.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder accessConstraints(String accessConstraints) {
            this.accessConstraints = Objects.requireNonNull(accessConstraints, "accessConstraints");
            return this;
        }

        @JsonProperty(value="accessConstraints")
        @CanIgnoreReturnValue
        public final Builder accessConstraints(Optional<String> accessConstraints) {
            this.accessConstraints = accessConstraints.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder contactName(String contactName) {
            this.contactName = Objects.requireNonNull(contactName, "contactName");
            return this;
        }

        @JsonProperty(value="contactName")
        @CanIgnoreReturnValue
        public final Builder contactName(Optional<String> contactName) {
            this.contactName = contactName.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder contactUrl(String contactUrl) {
            this.contactUrl = Objects.requireNonNull(contactUrl, "contactUrl");
            return this;
        }

        @JsonProperty(value="contactUrl")
        @CanIgnoreReturnValue
        public final Builder contactUrl(Optional<String> contactUrl) {
            this.contactUrl = contactUrl.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder contactEmail(String contactEmail) {
            this.contactEmail = Objects.requireNonNull(contactEmail, "contactEmail");
            return this;
        }

        @JsonProperty(value="contactEmail")
        @CanIgnoreReturnValue
        public final Builder contactEmail(Optional<String> contactEmail) {
            this.contactEmail = contactEmail.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addFeatureTypes(QName element) {
            this.featureTypes.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addFeatureTypes(QName ... elements) {
            this.featureTypes.add(elements);
            return this;
        }

        @JsonProperty(value="featureTypes")
        @CanIgnoreReturnValue
        public final Builder featureTypes(Iterable<? extends QName> elements) {
            this.featureTypes = ImmutableList.builder();
            return this.addAllFeatureTypes(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllFeatureTypes(Iterable<? extends QName> elements) {
            this.featureTypes.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putFeatureTypesCrs(QName key, String value) {
            this.featureTypesCrs.put(key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putFeatureTypesCrs(Map.Entry<? extends QName, ? extends String> entry) {
            this.featureTypesCrs.put(entry);
            return this;
        }

        @JsonProperty(value="featureTypesCrs")
        @CanIgnoreReturnValue
        public final Builder featureTypesCrs(Map<? extends QName, ? extends String> entries) {
            this.featureTypesCrs = ImmutableMap.builder();
            return this.putAllFeatureTypesCrs(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllFeatureTypesCrs(Map<? extends QName, ? extends String> entries) {
            this.featureTypesCrs.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putFeatureTypesBoundingBox(String key, BoundingBox value) {
            this.featureTypesBoundingBox.put(key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putFeatureTypesBoundingBox(Map.Entry<String, ? extends BoundingBox> entry) {
            this.featureTypesBoundingBox.put(entry);
            return this;
        }

        @JsonProperty(value="featureTypesBoundingBox")
        @CanIgnoreReturnValue
        public final Builder featureTypesBoundingBox(Map<String, ? extends BoundingBox> entries) {
            this.featureTypesBoundingBox = ImmutableMap.builder();
            return this.putAllFeatureTypesBoundingBox(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllFeatureTypesBoundingBox(Map<String, ? extends BoundingBox> entries) {
            this.featureTypesBoundingBox.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putNamespaces(String key, String value) {
            this.namespaces.put(key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putNamespaces(Map.Entry<String, ? extends String> entry) {
            this.namespaces.put(entry);
            return this;
        }

        @JsonProperty(value="namespaces")
        @CanIgnoreReturnValue
        public final Builder namespaces(Map<String, ? extends String> entries) {
            this.namespaces = ImmutableMap.builder();
            return this.putAllNamespaces(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllNamespaces(Map<String, ? extends String> entries) {
            this.namespaces.putAll(entries);
            return this;
        }

        public ImmutableMetadata build() {
            return new ImmutableMetadata(this.version, this.label, this.description, (ImmutableList<String>)this.keywords.build(), this.fees, this.accessConstraints, this.contactName, this.contactUrl, this.contactEmail, (ImmutableList<QName>)this.featureTypes.build(), this.featureTypesCrs.build(), this.featureTypesBoundingBox.build(), this.namespaces.build());
        }
    }
}

