/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.domain;

import de.ii.xtraplatform.features.domain.FeatureSchema;
import de.ii.xtraplatform.features.domain.FeatureTypeV2;
import de.ii.xtraplatform.features.domain.ImmutableFeatureSchema;
import de.ii.xtraplatform.store.domain.entities.maptobuilder.BuildableMap;
import de.ii.xtraplatform.store.domain.entities.maptobuilder.ImmutableBuildableMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import shadow.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.com.fasterxml.jackson.annotation.JsonMerge;
import shadow.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.com.google.common.base.MoreObjects;
import shadow.com.google.common.collect.ImmutableMap;
import shadow.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.javax.annotation.CheckReturnValue;
import shadow.javax.annotation.Nullable;
import shadow.javax.annotation.ParametersAreNonnullByDefault;
import shadow.javax.annotation.concurrent.Immutable;
import shadow.javax.annotation.concurrent.NotThreadSafe;
import shadow.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="FeatureTypeV2", generator="Immutables")
@Immutable
public final class ImmutableFeatureTypeV2
implements FeatureTypeV2 {
    private final String name;
    private final String path;
    @Nullable
    private final String label;
    @Nullable
    private final String description;
    private final BuildableMap<FeatureSchema, ImmutableFeatureSchema.Builder> properties;
    private final ImmutableMap<String, String> additionalInfo;
    private final transient Map<List<String>, List<FeatureSchema>> propertiesByPath;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableFeatureTypeV2(String name, String path, @Nullable String label, @Nullable String description, BuildableMap<FeatureSchema, ImmutableFeatureSchema.Builder> properties, ImmutableMap<String, String> additionalInfo) {
        this.name = name;
        this.path = path;
        this.label = label;
        this.description = description;
        this.properties = properties;
        this.additionalInfo = additionalInfo;
        this.propertiesByPath = this.initShim.getPropertiesByPath();
        this.initShim = null;
    }

    private Map<List<String>, List<FeatureSchema>> getPropertiesByPathInitialize() {
        return FeatureTypeV2.super.getPropertiesByPath();
    }

    @Override
    @JsonProperty(value="name")
    @JsonIgnore
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="path")
    public String getPath() {
        return this.path;
    }

    @Override
    @JsonProperty(value="label")
    public Optional<String> getLabel() {
        return Optional.ofNullable(this.label);
    }

    @Override
    @JsonProperty(value="description")
    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    @Override
    @JsonProperty(value="properties")
    @JsonMerge
    public BuildableMap<FeatureSchema, ImmutableFeatureSchema.Builder> getProperties() {
        return this.properties;
    }

    @JsonProperty(value="additionalInfo")
    public ImmutableMap<String, String> getAdditionalInfo() {
        return this.additionalInfo;
    }

    @Override
    @JsonProperty(value="propertiesByPath")
    @JsonIgnore
    public Map<List<String>, List<FeatureSchema>> getPropertiesByPath() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getPropertiesByPath() : this.propertiesByPath;
    }

    public final ImmutableFeatureTypeV2 withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableFeatureTypeV2(newValue, this.path, this.label, this.description, this.properties, this.additionalInfo);
    }

    public final ImmutableFeatureTypeV2 withPath(String value) {
        String newValue = Objects.requireNonNull(value, "path");
        if (this.path.equals(newValue)) {
            return this;
        }
        return new ImmutableFeatureTypeV2(this.name, newValue, this.label, this.description, this.properties, this.additionalInfo);
    }

    public final ImmutableFeatureTypeV2 withLabel(String value) {
        String newValue = Objects.requireNonNull(value, "label");
        if (Objects.equals(this.label, newValue)) {
            return this;
        }
        return new ImmutableFeatureTypeV2(this.name, this.path, newValue, this.description, this.properties, this.additionalInfo);
    }

    public final ImmutableFeatureTypeV2 withLabel(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.label, value)) {
            return this;
        }
        return new ImmutableFeatureTypeV2(this.name, this.path, value, this.description, this.properties, this.additionalInfo);
    }

    public final ImmutableFeatureTypeV2 withDescription(String value) {
        String newValue = Objects.requireNonNull(value, "description");
        if (Objects.equals(this.description, newValue)) {
            return this;
        }
        return new ImmutableFeatureTypeV2(this.name, this.path, this.label, newValue, this.properties, this.additionalInfo);
    }

    public final ImmutableFeatureTypeV2 withDescription(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.description, value)) {
            return this;
        }
        return new ImmutableFeatureTypeV2(this.name, this.path, this.label, value, this.properties, this.additionalInfo);
    }

    public ImmutableFeatureTypeV2 withProperties(BuildableMap<FeatureSchema, ImmutableFeatureSchema.Builder> value) {
        BuildableMap<FeatureSchema, ImmutableFeatureSchema.Builder> newValue = value;
        if (this.properties == newValue) {
            return this;
        }
        return new ImmutableFeatureTypeV2(this.name, this.path, this.label, this.description, newValue, this.additionalInfo);
    }

    public final ImmutableFeatureTypeV2 withAdditionalInfo(Map<String, ? extends String> entries) {
        if (this.additionalInfo == entries) {
            return this;
        }
        ImmutableMap<String, String> newValue = ImmutableMap.copyOf(entries);
        return new ImmutableFeatureTypeV2(this.name, this.path, this.label, this.description, this.properties, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFeatureTypeV2 && this.equalTo((ImmutableFeatureTypeV2)another);
    }

    private boolean equalTo(ImmutableFeatureTypeV2 another) {
        return this.name.equals(another.name) && this.path.equals(another.path) && Objects.equals(this.label, another.label) && Objects.equals(this.description, another.description) && this.getProperties().equals(another.getProperties()) && this.additionalInfo.equals(another.additionalInfo) && this.propertiesByPath.equals(another.propertiesByPath);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.path.hashCode();
        h += (h << 5) + Objects.hashCode(this.label);
        h += (h << 5) + Objects.hashCode(this.description);
        h += (h << 5) + this.getProperties().hashCode();
        h += (h << 5) + this.additionalInfo.hashCode();
        h += (h << 5) + this.propertiesByPath.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("FeatureTypeV2").omitNullValues().add("name", this.name).add("path", this.path).add("label", this.label).add("description", this.description).add("properties", this.getProperties().toString()).add("additionalInfo", this.additionalInfo).add("propertiesByPath", this.propertiesByPath).toString();
    }

    public static ImmutableFeatureTypeV2 copyOf(FeatureTypeV2 instance) {
        if (instance instanceof ImmutableFeatureTypeV2) {
            return (ImmutableFeatureTypeV2)instance;
        }
        return new Builder().from(instance).build();
    }

    @Generated(from="FeatureTypeV2", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    extends FeatureTypeV2.Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_PATH = 2L;
        private long initBits = 3L;
        private Map<String, ImmutableFeatureSchema.Builder> properties_builderMap = new LinkedHashMap<String, ImmutableFeatureSchema.Builder>();
        @Nullable
        private String name;
        @Nullable
        private String path;
        @Nullable
        private String label;
        @Nullable
        private String description;
        private ImmutableMap.Builder<String, String> additionalInfo = ImmutableMap.builder();

        @Override
        @CanIgnoreReturnValue
        public final Builder from(FeatureTypeV2 instance) {
            Optional<String> descriptionOptional;
            Objects.requireNonNull(instance, "instance");
            this.name(instance.getName());
            this.path(instance.getPath());
            Optional<String> labelOptional = instance.getLabel();
            if (labelOptional.isPresent()) {
                this.label(labelOptional);
            }
            if ((descriptionOptional = instance.getDescription()).isPresent()) {
                this.description(descriptionOptional);
            }
            this.properties(instance.getProperties());
            this.putAllAdditionalInfo(instance.getAdditionalInfo());
            return this;
        }

        @JsonProperty(value="name")
        @JsonIgnore
        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="path")
        @CanIgnoreReturnValue
        public final Builder path(String path) {
            this.path = Objects.requireNonNull(path, "path");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder label(String label) {
            this.label = Objects.requireNonNull(label, "label");
            return this;
        }

        @JsonProperty(value="label")
        @CanIgnoreReturnValue
        public final Builder label(Optional<String> label) {
            this.label = label.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder description(String description) {
            this.description = Objects.requireNonNull(description, "description");
            return this;
        }

        @JsonProperty(value="description")
        @CanIgnoreReturnValue
        public final Builder description(Optional<String> description) {
            this.description = description.orElse(null);
            return this;
        }

        @JsonIgnore
        @JsonProperty(value="properties")
        @JsonMerge
        @CanIgnoreReturnValue
        public Builder properties(Map<String, FeatureSchema> values) {
            this.properties_builderMap = new LinkedHashMap<String, ImmutableFeatureSchema.Builder>();
            values.forEach(this::putProperties);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder putProperties(String key, FeatureSchema value) {
            this.properties_builderMap.put(key, value.getBuilder());
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder putProperties(String key, ImmutableFeatureSchema.Builder builder) {
            this.properties_builderMap.put(key, builder);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder putAllProperties(Map<String, FeatureSchema> values) {
            values.forEach(this::putProperties);
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public Builder setProperties(Map<String, ImmutableFeatureSchema.Builder> builders) {
            this.properties_builderMap.putAll(builders);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putAdditionalInfo(String key, String value) {
            this.additionalInfo.put(key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putAdditionalInfo(Map.Entry<String, ? extends String> entry) {
            this.additionalInfo.put(entry);
            return this;
        }

        @JsonProperty(value="additionalInfo")
        @CanIgnoreReturnValue
        public final Builder additionalInfo(Map<String, ? extends String> entries) {
            this.additionalInfo = ImmutableMap.builder();
            return this.putAllAdditionalInfo(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllAdditionalInfo(Map<String, ? extends String> entries) {
            this.additionalInfo.putAll(entries);
            return this;
        }

        @Override
        public ImmutableFeatureTypeV2 build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableFeatureTypeV2(this.name, this.path, this.label, this.description, this.properties_build(), this.additionalInfo.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("path");
            }
            return "Cannot build FeatureTypeV2, some of required attributes are not set " + attributes;
        }

        private BuildableMap<FeatureSchema, ImmutableFeatureSchema.Builder> properties_build() {
            return new ImmutableBuildableMap.Builder().builders(this.properties_builderMap).build();
        }

        @JsonProperty
        public Map<String, ImmutableFeatureSchema.Builder> getProperties() {
            return this.properties_builderMap;
        }
    }

    @Generated(from="FeatureTypeV2", generator="Immutables")
    private final class InitShim {
        private byte propertiesByPathBuildStage = 0;
        private Map<List<String>, List<FeatureSchema>> propertiesByPath;

        private InitShim() {
        }

        Map<List<String>, List<FeatureSchema>> getPropertiesByPath() {
            if (this.propertiesByPathBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.propertiesByPathBuildStage == 0) {
                this.propertiesByPathBuildStage = (byte)-1;
                this.propertiesByPath = Objects.requireNonNull(ImmutableFeatureTypeV2.this.getPropertiesByPathInitialize(), "propertiesByPath");
                this.propertiesByPathBuildStage = 1;
            }
            return this.propertiesByPath;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.propertiesByPathBuildStage == -1) {
                attributes.add("propertiesByPath");
            }
            return "Cannot build FeatureTypeV2, attribute initializers form cycle " + attributes;
        }
    }
}

