/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.domain;

import de.ii.xtraplatform.features.domain.FeatureProperty;
import de.ii.xtraplatform.features.domain.FeatureType;
import de.ii.xtraplatform.features.domain.ImmutableFeatureProperty;
import de.ii.xtraplatform.store.domain.entities.maptobuilder.BuildableMap;
import de.ii.xtraplatform.store.domain.entities.maptobuilder.ImmutableBuildableMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import shadow.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.com.fasterxml.jackson.annotation.JsonMerge;
import shadow.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.com.google.common.base.MoreObjects;
import shadow.com.google.common.collect.ImmutableMap;
import shadow.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.javax.annotation.CheckReturnValue;
import shadow.javax.annotation.Nullable;
import shadow.javax.annotation.ParametersAreNonnullByDefault;
import shadow.javax.annotation.concurrent.Immutable;
import shadow.javax.annotation.concurrent.NotThreadSafe;
import shadow.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="FeatureType", generator="Immutables")
@Immutable
public final class ImmutableFeatureType
implements FeatureType {
    private final BuildableMap<FeatureProperty, ImmutableFeatureProperty.Builder> properties;
    private final String name;
    private final transient Map<List<String>, List<FeatureProperty>> propertiesByPath;
    private final ImmutableMap<String, String> additionalInfo;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableFeatureType(BuildableMap<FeatureProperty, ImmutableFeatureProperty.Builder> properties, String name, ImmutableMap<String, String> additionalInfo) {
        this.properties = properties;
        this.name = name;
        this.additionalInfo = additionalInfo;
        this.propertiesByPath = this.initShim.getPropertiesByPath();
        this.initShim = null;
    }

    private Map<List<String>, List<FeatureProperty>> getPropertiesByPathInitialize() {
        return FeatureType.super.getPropertiesByPath();
    }

    @Override
    @JsonProperty(value="properties")
    @JsonMerge
    public BuildableMap<FeatureProperty, ImmutableFeatureProperty.Builder> getProperties() {
        return this.properties;
    }

    @Override
    @JsonProperty(value="name")
    @JsonIgnore
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="propertiesByPath")
    @JsonIgnore
    public Map<List<String>, List<FeatureProperty>> getPropertiesByPath() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getPropertiesByPath() : this.propertiesByPath;
    }

    @JsonProperty(value="additionalInfo")
    public ImmutableMap<String, String> getAdditionalInfo() {
        return this.additionalInfo;
    }

    public ImmutableFeatureType withProperties(BuildableMap<FeatureProperty, ImmutableFeatureProperty.Builder> value) {
        BuildableMap<FeatureProperty, ImmutableFeatureProperty.Builder> newValue = value;
        if (this.properties == newValue) {
            return this;
        }
        return new ImmutableFeatureType(newValue, this.name, this.additionalInfo);
    }

    public final ImmutableFeatureType withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableFeatureType(this.properties, newValue, this.additionalInfo);
    }

    public final ImmutableFeatureType withAdditionalInfo(Map<String, ? extends String> entries) {
        if (this.additionalInfo == entries) {
            return this;
        }
        ImmutableMap<String, String> newValue = ImmutableMap.copyOf(entries);
        return new ImmutableFeatureType(this.properties, this.name, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFeatureType && this.equalTo((ImmutableFeatureType)another);
    }

    private boolean equalTo(ImmutableFeatureType another) {
        return this.getProperties().equals(another.getProperties()) && this.name.equals(another.name) && this.propertiesByPath.equals(another.propertiesByPath) && this.additionalInfo.equals(another.additionalInfo);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.getProperties().hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.propertiesByPath.hashCode();
        h += (h << 5) + this.additionalInfo.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("FeatureType").omitNullValues().add("properties", this.getProperties().toString()).add("name", this.name).add("propertiesByPath", this.propertiesByPath).add("additionalInfo", this.additionalInfo).toString();
    }

    public static ImmutableFeatureType copyOf(FeatureType instance) {
        if (instance instanceof ImmutableFeatureType) {
            return (ImmutableFeatureType)instance;
        }
        return new Builder().from(instance).build();
    }

    @Generated(from="FeatureType", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    extends FeatureType.Builder {
        private static final long INIT_BIT_NAME = 1L;
        private long initBits = 1L;
        private Map<String, ImmutableFeatureProperty.Builder> properties_builderMap = new LinkedHashMap<String, ImmutableFeatureProperty.Builder>();
        @Nullable
        private String name;
        private ImmutableMap.Builder<String, String> additionalInfo = ImmutableMap.builder();

        @Override
        @CanIgnoreReturnValue
        public final Builder from(FeatureType instance) {
            Objects.requireNonNull(instance, "instance");
            this.properties(instance.getProperties());
            this.name(instance.getName());
            this.putAllAdditionalInfo(instance.getAdditionalInfo());
            return this;
        }

        @JsonIgnore
        @JsonProperty(value="properties")
        @JsonMerge
        @CanIgnoreReturnValue
        public Builder properties(Map<String, FeatureProperty> values) {
            this.properties_builderMap = new LinkedHashMap<String, ImmutableFeatureProperty.Builder>();
            values.forEach(this::putProperties);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder putProperties(String key, FeatureProperty value) {
            this.properties_builderMap.put(key, value.getBuilder());
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder putProperties(String key, ImmutableFeatureProperty.Builder builder) {
            this.properties_builderMap.put(key, builder);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder putAllProperties(Map<String, FeatureProperty> values) {
            values.forEach(this::putProperties);
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public Builder setProperties(Map<String, ImmutableFeatureProperty.Builder> builders) {
            this.properties_builderMap.putAll(builders);
            return this;
        }

        @JsonProperty(value="name")
        @JsonIgnore
        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putAdditionalInfo(String key, String value) {
            this.additionalInfo.put(key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putAdditionalInfo(Map.Entry<String, ? extends String> entry) {
            this.additionalInfo.put(entry);
            return this;
        }

        @JsonProperty(value="additionalInfo")
        @CanIgnoreReturnValue
        public final Builder additionalInfo(Map<String, ? extends String> entries) {
            this.additionalInfo = ImmutableMap.builder();
            return this.putAllAdditionalInfo(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllAdditionalInfo(Map<String, ? extends String> entries) {
            this.additionalInfo.putAll(entries);
            return this;
        }

        @Override
        public ImmutableFeatureType build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableFeatureType(this.properties_build(), this.name, this.additionalInfo.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build FeatureType, some of required attributes are not set " + attributes;
        }

        private BuildableMap<FeatureProperty, ImmutableFeatureProperty.Builder> properties_build() {
            return new ImmutableBuildableMap.Builder().builders(this.properties_builderMap).build();
        }

        @JsonProperty
        public Map<String, ImmutableFeatureProperty.Builder> getProperties() {
            return this.properties_builderMap;
        }
    }

    @Generated(from="FeatureType", generator="Immutables")
    private final class InitShim {
        private byte propertiesByPathBuildStage = 0;
        private Map<List<String>, List<FeatureProperty>> propertiesByPath;

        private InitShim() {
        }

        Map<List<String>, List<FeatureProperty>> getPropertiesByPath() {
            if (this.propertiesByPathBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.propertiesByPathBuildStage == 0) {
                this.propertiesByPathBuildStage = (byte)-1;
                this.propertiesByPath = Objects.requireNonNull(ImmutableFeatureType.this.getPropertiesByPathInitialize(), "propertiesByPath");
                this.propertiesByPathBuildStage = 1;
            }
            return this.propertiesByPath;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.propertiesByPathBuildStage == -1) {
                attributes.add("propertiesByPath");
            }
            return "Cannot build FeatureType, attribute initializers form cycle " + attributes;
        }
    }
}

