/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.domain;

import de.ii.xtraplatform.features.domain.FeatureStoreInstanceContainer;
import de.ii.xtraplatform.features.domain.FeatureStoreTypeInfo;
import de.ii.xtraplatform.features.domain.ImmutableFeatureStoreInstanceContainer;
import java.util.ArrayList;
import java.util.Objects;
import shadow.com.google.common.base.MoreObjects;
import shadow.com.google.common.collect.ImmutableList;
import shadow.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.javax.annotation.CheckReturnValue;
import shadow.javax.annotation.Nullable;
import shadow.javax.annotation.ParametersAreNonnullByDefault;
import shadow.javax.annotation.concurrent.Immutable;
import shadow.javax.annotation.concurrent.NotThreadSafe;
import shadow.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="FeatureStoreTypeInfo", generator="Immutables")
@Immutable
public final class ImmutableFeatureStoreTypeInfo
implements FeatureStoreTypeInfo {
    private final String name;
    private final ImmutableList<FeatureStoreInstanceContainer> instanceContainers;

    private ImmutableFeatureStoreTypeInfo(String name, ImmutableList<FeatureStoreInstanceContainer> instanceContainers) {
        this.name = name;
        this.instanceContainers = instanceContainers;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public ImmutableList<FeatureStoreInstanceContainer> getInstanceContainers() {
        return this.instanceContainers;
    }

    public final ImmutableFeatureStoreTypeInfo withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableFeatureStoreTypeInfo(newValue, this.instanceContainers);
    }

    public final ImmutableFeatureStoreTypeInfo withInstanceContainers(FeatureStoreInstanceContainer ... elements) {
        ImmutableList<FeatureStoreInstanceContainer> newValue = ImmutableList.copyOf(elements);
        return new ImmutableFeatureStoreTypeInfo(this.name, newValue);
    }

    public final ImmutableFeatureStoreTypeInfo withInstanceContainers(Iterable<? extends FeatureStoreInstanceContainer> elements) {
        if (this.instanceContainers == elements) {
            return this;
        }
        ImmutableList<FeatureStoreInstanceContainer> newValue = ImmutableList.copyOf(elements);
        return new ImmutableFeatureStoreTypeInfo(this.name, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFeatureStoreTypeInfo && this.equalTo((ImmutableFeatureStoreTypeInfo)another);
    }

    private boolean equalTo(ImmutableFeatureStoreTypeInfo another) {
        return this.name.equals(another.name) && this.instanceContainers.equals(another.instanceContainers);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.instanceContainers.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("FeatureStoreTypeInfo").omitNullValues().add("name", this.name).add("instanceContainers", this.instanceContainers).toString();
    }

    public static ImmutableFeatureStoreTypeInfo copyOf(FeatureStoreTypeInfo instance) {
        if (instance instanceof ImmutableFeatureStoreTypeInfo) {
            return (ImmutableFeatureStoreTypeInfo)instance;
        }
        return ImmutableFeatureStoreTypeInfo.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="FeatureStoreTypeInfo", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private long initBits = 1L;
        @Nullable
        private String name;
        private ImmutableList.Builder<FeatureStoreInstanceContainer> instanceContainers = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(FeatureStoreTypeInfo instance) {
            Objects.requireNonNull(instance, "instance");
            this.name(instance.getName());
            this.addAllInstanceContainers(instance.getInstanceContainers());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addInstanceContainers(FeatureStoreInstanceContainer element) {
            element = ImmutableFeatureStoreInstanceContainer.copyOf(element);
            this.instanceContainers.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addInstanceContainers(FeatureStoreInstanceContainer ... elements) {
            for (FeatureStoreInstanceContainer element : elements) {
                element = ImmutableFeatureStoreInstanceContainer.copyOf(element);
                this.instanceContainers.add((Object)Objects.requireNonNull(element, "instanceContainers element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder instanceContainers(Iterable<? extends FeatureStoreInstanceContainer> elements) {
            this.instanceContainers = ImmutableList.builder();
            return this.addAllInstanceContainers(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllInstanceContainers(Iterable<? extends FeatureStoreInstanceContainer> elements) {
            for (FeatureStoreInstanceContainer featureStoreInstanceContainer : elements) {
                ImmutableFeatureStoreInstanceContainer immutableFeatureStoreInstanceContainer = ImmutableFeatureStoreInstanceContainer.copyOf(featureStoreInstanceContainer);
                this.instanceContainers.add((Object)Objects.requireNonNull(immutableFeatureStoreInstanceContainer, "instanceContainers element"));
            }
            return this;
        }

        public ImmutableFeatureStoreTypeInfo build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableFeatureStoreTypeInfo(this.name, (ImmutableList<FeatureStoreInstanceContainer>)this.instanceContainers.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build FeatureStoreTypeInfo, some of required attributes are not set " + attributes;
        }
    }
}

