/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.domain;

import de.ii.xtraplatform.cql.domain.CqlFilter;
import de.ii.xtraplatform.features.domain.FeatureStoreRelation;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import shadow.com.google.common.base.MoreObjects;
import shadow.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.javax.annotation.CheckReturnValue;
import shadow.javax.annotation.Nullable;
import shadow.javax.annotation.ParametersAreNonnullByDefault;
import shadow.javax.annotation.concurrent.Immutable;
import shadow.javax.annotation.concurrent.NotThreadSafe;
import shadow.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="FeatureStoreRelation", generator="Immutables")
@Immutable
public final class ImmutableFeatureStoreRelation
implements FeatureStoreRelation {
    private final FeatureStoreRelation.CARDINALITY cardinality;
    private final String sourceContainer;
    private final String sourceField;
    @Nullable
    private final String sourceFilter;
    private final String sourceSortKey;
    private final String targetContainer;
    private final String targetField;
    @Nullable
    private final String targetFilter;
    @Nullable
    private final String junction;
    @Nullable
    private final String junctionSource;
    @Nullable
    private final String junctionTarget;
    @Nullable
    private final CqlFilter filter;
    private final transient List<String> asPath;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private volatile transient long lazyInitBitmap;
    private static final long IS_ONE2_ONE_LAZY_INIT_BIT = 1L;
    private transient boolean isOne2One;
    private static final long IS_ONE2_N_LAZY_INIT_BIT = 2L;
    private transient boolean isOne2N;
    private static final long IS_M2_N_LAZY_INIT_BIT = 4L;
    private transient boolean isM2N;

    private ImmutableFeatureStoreRelation(Builder builder) {
        this.cardinality = builder.cardinality;
        this.sourceContainer = builder.sourceContainer;
        this.sourceField = builder.sourceField;
        this.sourceFilter = builder.sourceFilter;
        this.targetContainer = builder.targetContainer;
        this.targetField = builder.targetField;
        this.targetFilter = builder.targetFilter;
        this.junction = builder.junction;
        this.junctionSource = builder.junctionSource;
        this.junctionTarget = builder.junctionTarget;
        this.filter = builder.filter;
        if (builder.sourceSortKey != null) {
            this.initShim.sourceSortKey(builder.sourceSortKey);
        }
        this.sourceSortKey = this.initShim.getSourceSortKey();
        this.asPath = this.initShim.asPath();
        this.initShim = null;
    }

    private ImmutableFeatureStoreRelation(FeatureStoreRelation.CARDINALITY cardinality, String sourceContainer, String sourceField, @Nullable String sourceFilter, String sourceSortKey, String targetContainer, String targetField, @Nullable String targetFilter, @Nullable String junction, @Nullable String junctionSource, @Nullable String junctionTarget, @Nullable CqlFilter filter) {
        this.cardinality = cardinality;
        this.sourceContainer = sourceContainer;
        this.sourceField = sourceField;
        this.sourceFilter = sourceFilter;
        this.initShim.sourceSortKey(sourceSortKey);
        this.targetContainer = targetContainer;
        this.targetField = targetField;
        this.targetFilter = targetFilter;
        this.junction = junction;
        this.junctionSource = junctionSource;
        this.junctionTarget = junctionTarget;
        this.filter = filter;
        this.sourceSortKey = this.initShim.getSourceSortKey();
        this.asPath = this.initShim.asPath();
        this.initShim = null;
    }

    private String getSourceSortKeyInitialize() {
        return FeatureStoreRelation.super.getSourceSortKey();
    }

    private List<String> asPathInitialize() {
        return FeatureStoreRelation.super.asPath();
    }

    @Override
    public FeatureStoreRelation.CARDINALITY getCardinality() {
        return this.cardinality;
    }

    @Override
    public String getSourceContainer() {
        return this.sourceContainer;
    }

    @Override
    public String getSourceField() {
        return this.sourceField;
    }

    @Override
    public Optional<String> getSourceFilter() {
        return Optional.ofNullable(this.sourceFilter);
    }

    @Override
    public String getSourceSortKey() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getSourceSortKey() : this.sourceSortKey;
    }

    @Override
    public String getTargetContainer() {
        return this.targetContainer;
    }

    @Override
    public String getTargetField() {
        return this.targetField;
    }

    @Override
    public Optional<String> getTargetFilter() {
        return Optional.ofNullable(this.targetFilter);
    }

    @Override
    public Optional<String> getJunction() {
        return Optional.ofNullable(this.junction);
    }

    @Override
    public Optional<String> getJunctionSource() {
        return Optional.ofNullable(this.junctionSource);
    }

    @Override
    public Optional<String> getJunctionTarget() {
        return Optional.ofNullable(this.junctionTarget);
    }

    @Override
    public Optional<CqlFilter> getFilter() {
        return Optional.ofNullable(this.filter);
    }

    @Override
    public List<String> asPath() {
        InitShim shim = this.initShim;
        return shim != null ? shim.asPath() : this.asPath;
    }

    public final ImmutableFeatureStoreRelation withCardinality(FeatureStoreRelation.CARDINALITY value) {
        if (this.cardinality == value) {
            return this;
        }
        FeatureStoreRelation.CARDINALITY newValue = Objects.requireNonNull(value, "cardinality");
        if (this.cardinality.equals((Object)newValue)) {
            return this;
        }
        return ImmutableFeatureStoreRelation.validate(new ImmutableFeatureStoreRelation(newValue, this.sourceContainer, this.sourceField, this.sourceFilter, this.sourceSortKey, this.targetContainer, this.targetField, this.targetFilter, this.junction, this.junctionSource, this.junctionTarget, this.filter));
    }

    public final ImmutableFeatureStoreRelation withSourceContainer(String value) {
        String newValue = Objects.requireNonNull(value, "sourceContainer");
        if (this.sourceContainer.equals(newValue)) {
            return this;
        }
        return ImmutableFeatureStoreRelation.validate(new ImmutableFeatureStoreRelation(this.cardinality, newValue, this.sourceField, this.sourceFilter, this.sourceSortKey, this.targetContainer, this.targetField, this.targetFilter, this.junction, this.junctionSource, this.junctionTarget, this.filter));
    }

    public final ImmutableFeatureStoreRelation withSourceField(String value) {
        String newValue = Objects.requireNonNull(value, "sourceField");
        if (this.sourceField.equals(newValue)) {
            return this;
        }
        return ImmutableFeatureStoreRelation.validate(new ImmutableFeatureStoreRelation(this.cardinality, this.sourceContainer, newValue, this.sourceFilter, this.sourceSortKey, this.targetContainer, this.targetField, this.targetFilter, this.junction, this.junctionSource, this.junctionTarget, this.filter));
    }

    public final ImmutableFeatureStoreRelation withSourceFilter(String value) {
        String newValue = Objects.requireNonNull(value, "sourceFilter");
        if (Objects.equals(this.sourceFilter, newValue)) {
            return this;
        }
        return ImmutableFeatureStoreRelation.validate(new ImmutableFeatureStoreRelation(this.cardinality, this.sourceContainer, this.sourceField, newValue, this.sourceSortKey, this.targetContainer, this.targetField, this.targetFilter, this.junction, this.junctionSource, this.junctionTarget, this.filter));
    }

    public final ImmutableFeatureStoreRelation withSourceFilter(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.sourceFilter, value)) {
            return this;
        }
        return ImmutableFeatureStoreRelation.validate(new ImmutableFeatureStoreRelation(this.cardinality, this.sourceContainer, this.sourceField, value, this.sourceSortKey, this.targetContainer, this.targetField, this.targetFilter, this.junction, this.junctionSource, this.junctionTarget, this.filter));
    }

    public final ImmutableFeatureStoreRelation withSourceSortKey(String value) {
        String newValue = Objects.requireNonNull(value, "sourceSortKey");
        if (this.sourceSortKey.equals(newValue)) {
            return this;
        }
        return ImmutableFeatureStoreRelation.validate(new ImmutableFeatureStoreRelation(this.cardinality, this.sourceContainer, this.sourceField, this.sourceFilter, newValue, this.targetContainer, this.targetField, this.targetFilter, this.junction, this.junctionSource, this.junctionTarget, this.filter));
    }

    public final ImmutableFeatureStoreRelation withTargetContainer(String value) {
        String newValue = Objects.requireNonNull(value, "targetContainer");
        if (this.targetContainer.equals(newValue)) {
            return this;
        }
        return ImmutableFeatureStoreRelation.validate(new ImmutableFeatureStoreRelation(this.cardinality, this.sourceContainer, this.sourceField, this.sourceFilter, this.sourceSortKey, newValue, this.targetField, this.targetFilter, this.junction, this.junctionSource, this.junctionTarget, this.filter));
    }

    public final ImmutableFeatureStoreRelation withTargetField(String value) {
        String newValue = Objects.requireNonNull(value, "targetField");
        if (this.targetField.equals(newValue)) {
            return this;
        }
        return ImmutableFeatureStoreRelation.validate(new ImmutableFeatureStoreRelation(this.cardinality, this.sourceContainer, this.sourceField, this.sourceFilter, this.sourceSortKey, this.targetContainer, newValue, this.targetFilter, this.junction, this.junctionSource, this.junctionTarget, this.filter));
    }

    public final ImmutableFeatureStoreRelation withTargetFilter(String value) {
        String newValue = Objects.requireNonNull(value, "targetFilter");
        if (Objects.equals(this.targetFilter, newValue)) {
            return this;
        }
        return ImmutableFeatureStoreRelation.validate(new ImmutableFeatureStoreRelation(this.cardinality, this.sourceContainer, this.sourceField, this.sourceFilter, this.sourceSortKey, this.targetContainer, this.targetField, newValue, this.junction, this.junctionSource, this.junctionTarget, this.filter));
    }

    public final ImmutableFeatureStoreRelation withTargetFilter(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.targetFilter, value)) {
            return this;
        }
        return ImmutableFeatureStoreRelation.validate(new ImmutableFeatureStoreRelation(this.cardinality, this.sourceContainer, this.sourceField, this.sourceFilter, this.sourceSortKey, this.targetContainer, this.targetField, value, this.junction, this.junctionSource, this.junctionTarget, this.filter));
    }

    public final ImmutableFeatureStoreRelation withJunction(String value) {
        String newValue = Objects.requireNonNull(value, "junction");
        if (Objects.equals(this.junction, newValue)) {
            return this;
        }
        return ImmutableFeatureStoreRelation.validate(new ImmutableFeatureStoreRelation(this.cardinality, this.sourceContainer, this.sourceField, this.sourceFilter, this.sourceSortKey, this.targetContainer, this.targetField, this.targetFilter, newValue, this.junctionSource, this.junctionTarget, this.filter));
    }

    public final ImmutableFeatureStoreRelation withJunction(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.junction, value)) {
            return this;
        }
        return ImmutableFeatureStoreRelation.validate(new ImmutableFeatureStoreRelation(this.cardinality, this.sourceContainer, this.sourceField, this.sourceFilter, this.sourceSortKey, this.targetContainer, this.targetField, this.targetFilter, value, this.junctionSource, this.junctionTarget, this.filter));
    }

    public final ImmutableFeatureStoreRelation withJunctionSource(String value) {
        String newValue = Objects.requireNonNull(value, "junctionSource");
        if (Objects.equals(this.junctionSource, newValue)) {
            return this;
        }
        return ImmutableFeatureStoreRelation.validate(new ImmutableFeatureStoreRelation(this.cardinality, this.sourceContainer, this.sourceField, this.sourceFilter, this.sourceSortKey, this.targetContainer, this.targetField, this.targetFilter, this.junction, newValue, this.junctionTarget, this.filter));
    }

    public final ImmutableFeatureStoreRelation withJunctionSource(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.junctionSource, value)) {
            return this;
        }
        return ImmutableFeatureStoreRelation.validate(new ImmutableFeatureStoreRelation(this.cardinality, this.sourceContainer, this.sourceField, this.sourceFilter, this.sourceSortKey, this.targetContainer, this.targetField, this.targetFilter, this.junction, value, this.junctionTarget, this.filter));
    }

    public final ImmutableFeatureStoreRelation withJunctionTarget(String value) {
        String newValue = Objects.requireNonNull(value, "junctionTarget");
        if (Objects.equals(this.junctionTarget, newValue)) {
            return this;
        }
        return ImmutableFeatureStoreRelation.validate(new ImmutableFeatureStoreRelation(this.cardinality, this.sourceContainer, this.sourceField, this.sourceFilter, this.sourceSortKey, this.targetContainer, this.targetField, this.targetFilter, this.junction, this.junctionSource, newValue, this.filter));
    }

    public final ImmutableFeatureStoreRelation withJunctionTarget(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.junctionTarget, value)) {
            return this;
        }
        return ImmutableFeatureStoreRelation.validate(new ImmutableFeatureStoreRelation(this.cardinality, this.sourceContainer, this.sourceField, this.sourceFilter, this.sourceSortKey, this.targetContainer, this.targetField, this.targetFilter, this.junction, this.junctionSource, value, this.filter));
    }

    public final ImmutableFeatureStoreRelation withFilter(CqlFilter value) {
        CqlFilter newValue = Objects.requireNonNull(value, "filter");
        if (this.filter == newValue) {
            return this;
        }
        return ImmutableFeatureStoreRelation.validate(new ImmutableFeatureStoreRelation(this.cardinality, this.sourceContainer, this.sourceField, this.sourceFilter, this.sourceSortKey, this.targetContainer, this.targetField, this.targetFilter, this.junction, this.junctionSource, this.junctionTarget, newValue));
    }

    public final ImmutableFeatureStoreRelation withFilter(Optional<? extends CqlFilter> optional) {
        CqlFilter value = optional.orElse(null);
        if (this.filter == value) {
            return this;
        }
        return ImmutableFeatureStoreRelation.validate(new ImmutableFeatureStoreRelation(this.cardinality, this.sourceContainer, this.sourceField, this.sourceFilter, this.sourceSortKey, this.targetContainer, this.targetField, this.targetFilter, this.junction, this.junctionSource, this.junctionTarget, value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFeatureStoreRelation && this.equalTo((ImmutableFeatureStoreRelation)another);
    }

    private boolean equalTo(ImmutableFeatureStoreRelation another) {
        return this.cardinality.equals((Object)another.cardinality) && this.sourceContainer.equals(another.sourceContainer) && this.sourceField.equals(another.sourceField) && Objects.equals(this.sourceFilter, another.sourceFilter) && this.sourceSortKey.equals(another.sourceSortKey) && this.targetContainer.equals(another.targetContainer) && this.targetField.equals(another.targetField) && Objects.equals(this.targetFilter, another.targetFilter) && Objects.equals(this.junction, another.junction) && Objects.equals(this.junctionSource, another.junctionSource) && Objects.equals(this.junctionTarget, another.junctionTarget) && Objects.equals(this.filter, another.filter) && this.asPath.equals(another.asPath);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.cardinality.hashCode();
        h += (h << 5) + this.sourceContainer.hashCode();
        h += (h << 5) + this.sourceField.hashCode();
        h += (h << 5) + Objects.hashCode(this.sourceFilter);
        h += (h << 5) + this.sourceSortKey.hashCode();
        h += (h << 5) + this.targetContainer.hashCode();
        h += (h << 5) + this.targetField.hashCode();
        h += (h << 5) + Objects.hashCode(this.targetFilter);
        h += (h << 5) + Objects.hashCode(this.junction);
        h += (h << 5) + Objects.hashCode(this.junctionSource);
        h += (h << 5) + Objects.hashCode(this.junctionTarget);
        h += (h << 5) + Objects.hashCode(this.filter);
        h += (h << 5) + this.asPath.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("FeatureStoreRelation").omitNullValues().add("cardinality", (Object)this.cardinality).add("sourceContainer", this.sourceContainer).add("sourceField", this.sourceField).add("sourceFilter", this.sourceFilter).add("sourceSortKey", this.sourceSortKey).add("targetContainer", this.targetContainer).add("targetField", this.targetField).add("targetFilter", this.targetFilter).add("junction", this.junction).add("junctionSource", this.junctionSource).add("junctionTarget", this.junctionTarget).add("filter", this.filter).add("asPath", this.asPath).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOne2One() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableFeatureStoreRelation immutableFeatureStoreRelation = this;
            synchronized (immutableFeatureStoreRelation) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.isOne2One = FeatureStoreRelation.super.isOne2One();
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.isOne2One;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOne2N() {
        if ((this.lazyInitBitmap & 2L) == 0L) {
            ImmutableFeatureStoreRelation immutableFeatureStoreRelation = this;
            synchronized (immutableFeatureStoreRelation) {
                if ((this.lazyInitBitmap & 2L) == 0L) {
                    this.isOne2N = FeatureStoreRelation.super.isOne2N();
                    this.lazyInitBitmap |= 2L;
                }
            }
        }
        return this.isOne2N;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isM2N() {
        if ((this.lazyInitBitmap & 4L) == 0L) {
            ImmutableFeatureStoreRelation immutableFeatureStoreRelation = this;
            synchronized (immutableFeatureStoreRelation) {
                if ((this.lazyInitBitmap & 4L) == 0L) {
                    this.isM2N = FeatureStoreRelation.super.isM2N();
                    this.lazyInitBitmap |= 4L;
                }
            }
        }
        return this.isM2N;
    }

    private static ImmutableFeatureStoreRelation validate(ImmutableFeatureStoreRelation instance) {
        instance.check();
        return instance;
    }

    public static ImmutableFeatureStoreRelation copyOf(FeatureStoreRelation instance) {
        if (instance instanceof ImmutableFeatureStoreRelation) {
            return (ImmutableFeatureStoreRelation)instance;
        }
        return ImmutableFeatureStoreRelation.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="FeatureStoreRelation", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CARDINALITY = 1L;
        private static final long INIT_BIT_SOURCE_CONTAINER = 2L;
        private static final long INIT_BIT_SOURCE_FIELD = 4L;
        private static final long INIT_BIT_TARGET_CONTAINER = 8L;
        private static final long INIT_BIT_TARGET_FIELD = 16L;
        private long initBits = 31L;
        @Nullable
        private FeatureStoreRelation.CARDINALITY cardinality;
        @Nullable
        private String sourceContainer;
        @Nullable
        private String sourceField;
        @Nullable
        private String sourceFilter;
        @Nullable
        private String sourceSortKey;
        @Nullable
        private String targetContainer;
        @Nullable
        private String targetField;
        @Nullable
        private String targetFilter;
        @Nullable
        private String junction;
        @Nullable
        private String junctionSource;
        @Nullable
        private String junctionTarget;
        @Nullable
        private CqlFilter filter;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(FeatureStoreRelation instance) {
            Optional<CqlFilter> filterOptional;
            Optional<String> junctionTargetOptional;
            Optional<String> junctionSourceOptional;
            Optional<String> junctionOptional;
            Objects.requireNonNull(instance, "instance");
            this.cardinality(instance.getCardinality());
            this.sourceContainer(instance.getSourceContainer());
            this.sourceField(instance.getSourceField());
            Optional<String> sourceFilterOptional = instance.getSourceFilter();
            if (sourceFilterOptional.isPresent()) {
                this.sourceFilter(sourceFilterOptional);
            }
            this.sourceSortKey(instance.getSourceSortKey());
            this.targetContainer(instance.getTargetContainer());
            this.targetField(instance.getTargetField());
            Optional<String> targetFilterOptional = instance.getTargetFilter();
            if (targetFilterOptional.isPresent()) {
                this.targetFilter(targetFilterOptional);
            }
            if ((junctionOptional = instance.getJunction()).isPresent()) {
                this.junction(junctionOptional);
            }
            if ((junctionSourceOptional = instance.getJunctionSource()).isPresent()) {
                this.junctionSource(junctionSourceOptional);
            }
            if ((junctionTargetOptional = instance.getJunctionTarget()).isPresent()) {
                this.junctionTarget(junctionTargetOptional);
            }
            if ((filterOptional = instance.getFilter()).isPresent()) {
                this.filter(filterOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder cardinality(FeatureStoreRelation.CARDINALITY cardinality) {
            this.cardinality = Objects.requireNonNull(cardinality, "cardinality");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sourceContainer(String sourceContainer) {
            this.sourceContainer = Objects.requireNonNull(sourceContainer, "sourceContainer");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sourceField(String sourceField) {
            this.sourceField = Objects.requireNonNull(sourceField, "sourceField");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sourceFilter(String sourceFilter) {
            this.sourceFilter = Objects.requireNonNull(sourceFilter, "sourceFilter");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sourceFilter(Optional<String> sourceFilter) {
            this.sourceFilter = sourceFilter.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sourceSortKey(String sourceSortKey) {
            this.sourceSortKey = Objects.requireNonNull(sourceSortKey, "sourceSortKey");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder targetContainer(String targetContainer) {
            this.targetContainer = Objects.requireNonNull(targetContainer, "targetContainer");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder targetField(String targetField) {
            this.targetField = Objects.requireNonNull(targetField, "targetField");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder targetFilter(String targetFilter) {
            this.targetFilter = Objects.requireNonNull(targetFilter, "targetFilter");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder targetFilter(Optional<String> targetFilter) {
            this.targetFilter = targetFilter.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder junction(String junction) {
            this.junction = Objects.requireNonNull(junction, "junction");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder junction(Optional<String> junction) {
            this.junction = junction.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder junctionSource(String junctionSource) {
            this.junctionSource = Objects.requireNonNull(junctionSource, "junctionSource");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder junctionSource(Optional<String> junctionSource) {
            this.junctionSource = junctionSource.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder junctionTarget(String junctionTarget) {
            this.junctionTarget = Objects.requireNonNull(junctionTarget, "junctionTarget");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder junctionTarget(Optional<String> junctionTarget) {
            this.junctionTarget = junctionTarget.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder filter(CqlFilter filter) {
            this.filter = Objects.requireNonNull(filter, "filter");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder filter(Optional<? extends CqlFilter> filter) {
            this.filter = filter.orElse(null);
            return this;
        }

        public ImmutableFeatureStoreRelation build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableFeatureStoreRelation.validate(new ImmutableFeatureStoreRelation(this));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("cardinality");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("sourceContainer");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("sourceField");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("targetContainer");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("targetField");
            }
            return "Cannot build FeatureStoreRelation, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="FeatureStoreRelation", generator="Immutables")
    private final class InitShim {
        private byte sourceSortKeyBuildStage = 0;
        private String sourceSortKey;
        private byte asPathBuildStage = 0;
        private List<String> asPath;

        private InitShim() {
        }

        String getSourceSortKey() {
            if (this.sourceSortKeyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sourceSortKeyBuildStage == 0) {
                this.sourceSortKeyBuildStage = (byte)-1;
                this.sourceSortKey = Objects.requireNonNull(ImmutableFeatureStoreRelation.this.getSourceSortKeyInitialize(), "sourceSortKey");
                this.sourceSortKeyBuildStage = 1;
            }
            return this.sourceSortKey;
        }

        void sourceSortKey(String sourceSortKey) {
            this.sourceSortKey = sourceSortKey;
            this.sourceSortKeyBuildStage = 1;
        }

        List<String> asPath() {
            if (this.asPathBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.asPathBuildStage == 0) {
                this.asPathBuildStage = (byte)-1;
                this.asPath = Objects.requireNonNull(ImmutableFeatureStoreRelation.this.asPathInitialize(), "asPath");
                this.asPathBuildStage = 1;
            }
            return this.asPath;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.sourceSortKeyBuildStage == -1) {
                attributes.add("sourceSortKey");
            }
            if (this.asPathBuildStage == -1) {
                attributes.add("asPath");
            }
            return "Cannot build FeatureStoreRelation, attribute initializers form cycle " + attributes;
        }
    }
}

