/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.domain;

import de.ii.xtraplatform.features.domain.FeatureStoreAttribute;
import de.ii.xtraplatform.features.domain.FeatureStoreAttributesContainer;
import de.ii.xtraplatform.features.domain.FeatureStoreRelatedContainer;
import de.ii.xtraplatform.features.domain.FeatureStoreRelation;
import de.ii.xtraplatform.features.domain.ImmutableFeatureStoreAttribute;
import de.ii.xtraplatform.features.domain.ImmutableFeatureStoreRelation;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import shadow.com.google.common.base.MoreObjects;
import shadow.com.google.common.collect.ImmutableList;
import shadow.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.javax.annotation.CheckReturnValue;
import shadow.javax.annotation.Nullable;
import shadow.javax.annotation.ParametersAreNonnullByDefault;
import shadow.javax.annotation.concurrent.Immutable;
import shadow.javax.annotation.concurrent.NotThreadSafe;
import shadow.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="FeatureStoreRelatedContainer", generator="Immutables")
@Immutable
public final class ImmutableFeatureStoreRelatedContainer
implements FeatureStoreRelatedContainer {
    private final String name;
    private final String sortKey;
    private final ImmutableList<FeatureStoreAttribute> attributes;
    private final transient String pathString;
    private final transient List<List<String>> attributePaths;
    private final transient boolean isSpatial;
    private final transient Optional<FeatureStoreAttribute> spatialAttribute;
    private final transient boolean isMain;
    private final transient Optional<FeatureStoreAttribute> idAttribute;
    private final transient List<String> path;
    private final ImmutableList<FeatureStoreRelation> instanceConnection;
    private final transient String instanceContainerName;
    private final transient List<String> sortKeys;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableFeatureStoreRelatedContainer(String name, String sortKey, ImmutableList<FeatureStoreAttribute> attributes, ImmutableList<FeatureStoreRelation> instanceConnection) {
        this.name = name;
        this.sortKey = sortKey;
        this.attributes = attributes;
        this.instanceConnection = instanceConnection;
        this.pathString = this.initShim.getPathString();
        this.attributePaths = this.initShim.getAttributePaths();
        this.isSpatial = this.initShim.isSpatial();
        this.spatialAttribute = this.initShim.getSpatialAttribute();
        this.isMain = this.initShim.isMain();
        this.idAttribute = this.initShim.getIdAttribute();
        this.path = this.initShim.getPath();
        this.instanceContainerName = this.initShim.getInstanceContainerName();
        this.sortKeys = this.initShim.getSortKeys();
        this.initShim = null;
    }

    private String getPathStringInitialize() {
        return FeatureStoreRelatedContainer.super.getPathString();
    }

    private List<List<String>> getAttributePathsInitialize() {
        return FeatureStoreRelatedContainer.super.getAttributePaths();
    }

    private boolean isSpatialInitialize() {
        return FeatureStoreRelatedContainer.super.isSpatial();
    }

    private Optional<FeatureStoreAttribute> getSpatialAttributeInitialize() {
        return FeatureStoreRelatedContainer.super.getSpatialAttribute();
    }

    private boolean isMainInitialize() {
        return FeatureStoreRelatedContainer.super.isMain();
    }

    private Optional<FeatureStoreAttribute> getIdAttributeInitialize() {
        return FeatureStoreRelatedContainer.super.getIdAttribute();
    }

    private List<String> getPathInitialize() {
        return FeatureStoreRelatedContainer.super.getPath();
    }

    private String getInstanceContainerNameInitialize() {
        return FeatureStoreRelatedContainer.super.getInstanceContainerName();
    }

    private List<String> getSortKeysInitialize() {
        return FeatureStoreRelatedContainer.super.getSortKeys();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getSortKey() {
        return this.sortKey;
    }

    public ImmutableList<FeatureStoreAttribute> getAttributes() {
        return this.attributes;
    }

    @Override
    public String getPathString() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getPathString() : this.pathString;
    }

    @Override
    public List<List<String>> getAttributePaths() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getAttributePaths() : this.attributePaths;
    }

    @Override
    public boolean isSpatial() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isSpatial() : this.isSpatial;
    }

    @Override
    public Optional<FeatureStoreAttribute> getSpatialAttribute() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getSpatialAttribute() : this.spatialAttribute;
    }

    @Override
    public boolean isMain() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isMain() : this.isMain;
    }

    @Override
    public Optional<FeatureStoreAttribute> getIdAttribute() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getIdAttribute() : this.idAttribute;
    }

    @Override
    public List<String> getPath() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getPath() : this.path;
    }

    public ImmutableList<FeatureStoreRelation> getInstanceConnection() {
        return this.instanceConnection;
    }

    @Override
    public String getInstanceContainerName() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getInstanceContainerName() : this.instanceContainerName;
    }

    @Override
    public List<String> getSortKeys() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getSortKeys() : this.sortKeys;
    }

    public final ImmutableFeatureStoreRelatedContainer withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableFeatureStoreRelatedContainer(newValue, this.sortKey, this.attributes, this.instanceConnection);
    }

    public final ImmutableFeatureStoreRelatedContainer withSortKey(String value) {
        String newValue = Objects.requireNonNull(value, "sortKey");
        if (this.sortKey.equals(newValue)) {
            return this;
        }
        return new ImmutableFeatureStoreRelatedContainer(this.name, newValue, this.attributes, this.instanceConnection);
    }

    public final ImmutableFeatureStoreRelatedContainer withAttributes(FeatureStoreAttribute ... elements) {
        ImmutableList<FeatureStoreAttribute> newValue = ImmutableList.copyOf(elements);
        return new ImmutableFeatureStoreRelatedContainer(this.name, this.sortKey, newValue, this.instanceConnection);
    }

    public final ImmutableFeatureStoreRelatedContainer withAttributes(Iterable<? extends FeatureStoreAttribute> elements) {
        if (this.attributes == elements) {
            return this;
        }
        ImmutableList<FeatureStoreAttribute> newValue = ImmutableList.copyOf(elements);
        return new ImmutableFeatureStoreRelatedContainer(this.name, this.sortKey, newValue, this.instanceConnection);
    }

    public final ImmutableFeatureStoreRelatedContainer withInstanceConnection(FeatureStoreRelation ... elements) {
        ImmutableList<FeatureStoreRelation> newValue = ImmutableList.copyOf(elements);
        return new ImmutableFeatureStoreRelatedContainer(this.name, this.sortKey, this.attributes, newValue);
    }

    public final ImmutableFeatureStoreRelatedContainer withInstanceConnection(Iterable<? extends FeatureStoreRelation> elements) {
        if (this.instanceConnection == elements) {
            return this;
        }
        ImmutableList<FeatureStoreRelation> newValue = ImmutableList.copyOf(elements);
        return new ImmutableFeatureStoreRelatedContainer(this.name, this.sortKey, this.attributes, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFeatureStoreRelatedContainer && this.equalTo((ImmutableFeatureStoreRelatedContainer)another);
    }

    private boolean equalTo(ImmutableFeatureStoreRelatedContainer another) {
        return this.name.equals(another.name) && this.sortKey.equals(another.sortKey) && this.attributes.equals(another.attributes) && this.path.equals(another.path) && this.instanceConnection.equals(another.instanceConnection) && this.instanceContainerName.equals(another.instanceContainerName);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.sortKey.hashCode();
        h += (h << 5) + this.attributes.hashCode();
        h += (h << 5) + this.path.hashCode();
        h += (h << 5) + this.instanceConnection.hashCode();
        h += (h << 5) + this.instanceContainerName.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("FeatureStoreRelatedContainer").omitNullValues().add("name", this.name).add("sortKey", this.sortKey).add("attributes", this.attributes).add("path", this.path).add("instanceConnection", this.instanceConnection).add("instanceContainerName", this.instanceContainerName).toString();
    }

    public static ImmutableFeatureStoreRelatedContainer copyOf(FeatureStoreRelatedContainer instance) {
        if (instance instanceof ImmutableFeatureStoreRelatedContainer) {
            return (ImmutableFeatureStoreRelatedContainer)instance;
        }
        return ImmutableFeatureStoreRelatedContainer.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="FeatureStoreRelatedContainer", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_SORT_KEY = 2L;
        private long initBits = 3L;
        @Nullable
        private String name;
        @Nullable
        private String sortKey;
        private ImmutableList.Builder<FeatureStoreAttribute> attributes = ImmutableList.builder();
        private ImmutableList.Builder<FeatureStoreRelation> instanceConnection = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(FeatureStoreAttributesContainer instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(FeatureStoreRelatedContainer instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            FeatureStoreAttributesContainer instance;
            if (object instanceof FeatureStoreAttributesContainer) {
                instance = (FeatureStoreAttributesContainer)object;
                this.name(instance.getName());
                this.addAllAttributes(instance.getAttributes());
                this.sortKey(instance.getSortKey());
            }
            if (object instanceof FeatureStoreRelatedContainer) {
                instance = (FeatureStoreRelatedContainer)object;
                this.addAllInstanceConnection(instance.getInstanceConnection());
            }
        }

        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sortKey(String sortKey) {
            this.sortKey = Objects.requireNonNull(sortKey, "sortKey");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAttributes(FeatureStoreAttribute element) {
            element = ImmutableFeatureStoreAttribute.copyOf(element);
            this.attributes.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAttributes(FeatureStoreAttribute ... elements) {
            for (FeatureStoreAttribute element : elements) {
                element = ImmutableFeatureStoreAttribute.copyOf(element);
                this.attributes.add((Object)Objects.requireNonNull(element, "attributes element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder attributes(Iterable<? extends FeatureStoreAttribute> elements) {
            this.attributes = ImmutableList.builder();
            return this.addAllAttributes(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllAttributes(Iterable<? extends FeatureStoreAttribute> elements) {
            for (FeatureStoreAttribute featureStoreAttribute : elements) {
                ImmutableFeatureStoreAttribute immutableFeatureStoreAttribute = ImmutableFeatureStoreAttribute.copyOf(featureStoreAttribute);
                this.attributes.add((Object)Objects.requireNonNull(immutableFeatureStoreAttribute, "attributes element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addInstanceConnection(FeatureStoreRelation element) {
            element = ImmutableFeatureStoreRelation.copyOf(element);
            this.instanceConnection.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addInstanceConnection(FeatureStoreRelation ... elements) {
            for (FeatureStoreRelation element : elements) {
                element = ImmutableFeatureStoreRelation.copyOf(element);
                this.instanceConnection.add((Object)Objects.requireNonNull(element, "instanceConnection element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder instanceConnection(Iterable<? extends FeatureStoreRelation> elements) {
            this.instanceConnection = ImmutableList.builder();
            return this.addAllInstanceConnection(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllInstanceConnection(Iterable<? extends FeatureStoreRelation> elements) {
            for (FeatureStoreRelation featureStoreRelation : elements) {
                ImmutableFeatureStoreRelation immutableFeatureStoreRelation = ImmutableFeatureStoreRelation.copyOf(featureStoreRelation);
                this.instanceConnection.add((Object)Objects.requireNonNull(immutableFeatureStoreRelation, "instanceConnection element"));
            }
            return this;
        }

        public ImmutableFeatureStoreRelatedContainer build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableFeatureStoreRelatedContainer(this.name, this.sortKey, (ImmutableList<FeatureStoreAttribute>)this.attributes.build(), (ImmutableList<FeatureStoreRelation>)this.instanceConnection.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("sortKey");
            }
            return "Cannot build FeatureStoreRelatedContainer, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="FeatureStoreRelatedContainer", generator="Immutables")
    private final class InitShim {
        private byte pathStringBuildStage = 0;
        private String pathString;
        private byte attributePathsBuildStage = 0;
        private List<List<String>> attributePaths;
        private byte isSpatialBuildStage = 0;
        private boolean isSpatial;
        private byte spatialAttributeBuildStage = 0;
        private Optional<FeatureStoreAttribute> spatialAttribute;
        private byte isMainBuildStage = 0;
        private boolean isMain;
        private byte idAttributeBuildStage = 0;
        private Optional<FeatureStoreAttribute> idAttribute;
        private byte pathBuildStage = 0;
        private List<String> path;
        private byte instanceContainerNameBuildStage = 0;
        private String instanceContainerName;
        private byte sortKeysBuildStage = 0;
        private List<String> sortKeys;

        private InitShim() {
        }

        String getPathString() {
            if (this.pathStringBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.pathStringBuildStage == 0) {
                this.pathStringBuildStage = (byte)-1;
                this.pathString = Objects.requireNonNull(ImmutableFeatureStoreRelatedContainer.this.getPathStringInitialize(), "pathString");
                this.pathStringBuildStage = 1;
            }
            return this.pathString;
        }

        List<List<String>> getAttributePaths() {
            if (this.attributePathsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.attributePathsBuildStage == 0) {
                this.attributePathsBuildStage = (byte)-1;
                this.attributePaths = Objects.requireNonNull(ImmutableFeatureStoreRelatedContainer.this.getAttributePathsInitialize(), "attributePaths");
                this.attributePathsBuildStage = 1;
            }
            return this.attributePaths;
        }

        boolean isSpatial() {
            if (this.isSpatialBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isSpatialBuildStage == 0) {
                this.isSpatialBuildStage = (byte)-1;
                this.isSpatial = ImmutableFeatureStoreRelatedContainer.this.isSpatialInitialize();
                this.isSpatialBuildStage = 1;
            }
            return this.isSpatial;
        }

        Optional<FeatureStoreAttribute> getSpatialAttribute() {
            if (this.spatialAttributeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.spatialAttributeBuildStage == 0) {
                this.spatialAttributeBuildStage = (byte)-1;
                this.spatialAttribute = Objects.requireNonNull(ImmutableFeatureStoreRelatedContainer.this.getSpatialAttributeInitialize(), "spatialAttribute");
                this.spatialAttributeBuildStage = 1;
            }
            return this.spatialAttribute;
        }

        boolean isMain() {
            if (this.isMainBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isMainBuildStage == 0) {
                this.isMainBuildStage = (byte)-1;
                this.isMain = ImmutableFeatureStoreRelatedContainer.this.isMainInitialize();
                this.isMainBuildStage = 1;
            }
            return this.isMain;
        }

        Optional<FeatureStoreAttribute> getIdAttribute() {
            if (this.idAttributeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.idAttributeBuildStage == 0) {
                this.idAttributeBuildStage = (byte)-1;
                this.idAttribute = Objects.requireNonNull(ImmutableFeatureStoreRelatedContainer.this.getIdAttributeInitialize(), "idAttribute");
                this.idAttributeBuildStage = 1;
            }
            return this.idAttribute;
        }

        List<String> getPath() {
            if (this.pathBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.pathBuildStage == 0) {
                this.pathBuildStage = (byte)-1;
                this.path = Objects.requireNonNull(ImmutableFeatureStoreRelatedContainer.this.getPathInitialize(), "path");
                this.pathBuildStage = 1;
            }
            return this.path;
        }

        String getInstanceContainerName() {
            if (this.instanceContainerNameBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.instanceContainerNameBuildStage == 0) {
                this.instanceContainerNameBuildStage = (byte)-1;
                this.instanceContainerName = Objects.requireNonNull(ImmutableFeatureStoreRelatedContainer.this.getInstanceContainerNameInitialize(), "instanceContainerName");
                this.instanceContainerNameBuildStage = 1;
            }
            return this.instanceContainerName;
        }

        List<String> getSortKeys() {
            if (this.sortKeysBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sortKeysBuildStage == 0) {
                this.sortKeysBuildStage = (byte)-1;
                this.sortKeys = Objects.requireNonNull(ImmutableFeatureStoreRelatedContainer.this.getSortKeysInitialize(), "sortKeys");
                this.sortKeysBuildStage = 1;
            }
            return this.sortKeys;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.pathStringBuildStage == -1) {
                attributes.add("pathString");
            }
            if (this.attributePathsBuildStage == -1) {
                attributes.add("attributePaths");
            }
            if (this.isSpatialBuildStage == -1) {
                attributes.add("isSpatial");
            }
            if (this.spatialAttributeBuildStage == -1) {
                attributes.add("spatialAttribute");
            }
            if (this.isMainBuildStage == -1) {
                attributes.add("isMain");
            }
            if (this.idAttributeBuildStage == -1) {
                attributes.add("idAttribute");
            }
            if (this.pathBuildStage == -1) {
                attributes.add("path");
            }
            if (this.instanceContainerNameBuildStage == -1) {
                attributes.add("instanceContainerName");
            }
            if (this.sortKeysBuildStage == -1) {
                attributes.add("sortKeys");
            }
            return "Cannot build FeatureStoreRelatedContainer, attribute initializers form cycle " + attributes;
        }
    }
}

