/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.domain;

import de.ii.xtraplatform.features.domain.FeatureStoreAttribute;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import shadow.com.google.common.base.MoreObjects;
import shadow.com.google.common.collect.ImmutableList;
import shadow.com.google.common.primitives.Booleans;
import shadow.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.javax.annotation.CheckReturnValue;
import shadow.javax.annotation.Nullable;
import shadow.javax.annotation.ParametersAreNonnullByDefault;
import shadow.javax.annotation.concurrent.Immutable;
import shadow.javax.annotation.concurrent.NotThreadSafe;
import shadow.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="FeatureStoreAttribute", generator="Immutables")
@Immutable
public final class ImmutableFeatureStoreAttribute
implements FeatureStoreAttribute {
    private final String name;
    private final ImmutableList<String> path;
    private final String queryable;
    private final boolean isId;
    private final boolean isSpatial;
    private final boolean isTemporal;
    @Nullable
    private final String constantValue;
    private final transient boolean isConstant;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableFeatureStoreAttribute(Builder builder) {
        this.name = builder.name;
        this.path = builder.path.build();
        this.constantValue = builder.constantValue;
        if (builder.queryable != null) {
            this.initShim.queryable(builder.queryable);
        }
        if (builder.isIdIsSet()) {
            this.initShim.isId(builder.isId);
        }
        if (builder.isSpatialIsSet()) {
            this.initShim.isSpatial(builder.isSpatial);
        }
        if (builder.isTemporalIsSet()) {
            this.initShim.isTemporal(builder.isTemporal);
        }
        this.queryable = this.initShim.getQueryable();
        this.isId = this.initShim.isId();
        this.isSpatial = this.initShim.isSpatial();
        this.isTemporal = this.initShim.isTemporal();
        this.isConstant = this.initShim.isConstant();
        this.initShim = null;
    }

    private ImmutableFeatureStoreAttribute(String name, ImmutableList<String> path, String queryable, boolean isId, boolean isSpatial, boolean isTemporal, @Nullable String constantValue) {
        this.name = name;
        this.path = path;
        this.initShim.queryable(queryable);
        this.initShim.isId(isId);
        this.initShim.isSpatial(isSpatial);
        this.initShim.isTemporal(isTemporal);
        this.constantValue = constantValue;
        this.queryable = this.initShim.getQueryable();
        this.isId = this.initShim.isId();
        this.isSpatial = this.initShim.isSpatial();
        this.isTemporal = this.initShim.isTemporal();
        this.isConstant = this.initShim.isConstant();
        this.initShim = null;
    }

    private String getQueryableInitialize() {
        return FeatureStoreAttribute.super.getQueryable();
    }

    private boolean isIdInitialize() {
        return FeatureStoreAttribute.super.isId();
    }

    private boolean isSpatialInitialize() {
        return FeatureStoreAttribute.super.isSpatial();
    }

    private boolean isTemporalInitialize() {
        return FeatureStoreAttribute.super.isTemporal();
    }

    private boolean isConstantInitialize() {
        return FeatureStoreAttribute.super.isConstant();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public ImmutableList<String> getPath() {
        return this.path;
    }

    @Override
    public String getQueryable() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getQueryable() : this.queryable;
    }

    @Override
    public boolean isId() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isId() : this.isId;
    }

    @Override
    public boolean isSpatial() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isSpatial() : this.isSpatial;
    }

    @Override
    public boolean isTemporal() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isTemporal() : this.isTemporal;
    }

    @Override
    public Optional<String> getConstantValue() {
        return Optional.ofNullable(this.constantValue);
    }

    @Override
    public boolean isConstant() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isConstant() : this.isConstant;
    }

    public final ImmutableFeatureStoreAttribute withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableFeatureStoreAttribute(newValue, this.path, this.queryable, this.isId, this.isSpatial, this.isTemporal, this.constantValue);
    }

    public final ImmutableFeatureStoreAttribute withPath(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableFeatureStoreAttribute(this.name, newValue, this.queryable, this.isId, this.isSpatial, this.isTemporal, this.constantValue);
    }

    public final ImmutableFeatureStoreAttribute withPath(Iterable<String> elements) {
        if (this.path == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableFeatureStoreAttribute(this.name, newValue, this.queryable, this.isId, this.isSpatial, this.isTemporal, this.constantValue);
    }

    public final ImmutableFeatureStoreAttribute withQueryable(String value) {
        String newValue = Objects.requireNonNull(value, "queryable");
        if (this.queryable.equals(newValue)) {
            return this;
        }
        return new ImmutableFeatureStoreAttribute(this.name, this.path, newValue, this.isId, this.isSpatial, this.isTemporal, this.constantValue);
    }

    public final ImmutableFeatureStoreAttribute withIsId(boolean value) {
        if (this.isId == value) {
            return this;
        }
        return new ImmutableFeatureStoreAttribute(this.name, this.path, this.queryable, value, this.isSpatial, this.isTemporal, this.constantValue);
    }

    public final ImmutableFeatureStoreAttribute withIsSpatial(boolean value) {
        if (this.isSpatial == value) {
            return this;
        }
        return new ImmutableFeatureStoreAttribute(this.name, this.path, this.queryable, this.isId, value, this.isTemporal, this.constantValue);
    }

    public final ImmutableFeatureStoreAttribute withIsTemporal(boolean value) {
        if (this.isTemporal == value) {
            return this;
        }
        return new ImmutableFeatureStoreAttribute(this.name, this.path, this.queryable, this.isId, this.isSpatial, value, this.constantValue);
    }

    public final ImmutableFeatureStoreAttribute withConstantValue(String value) {
        String newValue = Objects.requireNonNull(value, "constantValue");
        if (Objects.equals(this.constantValue, newValue)) {
            return this;
        }
        return new ImmutableFeatureStoreAttribute(this.name, this.path, this.queryable, this.isId, this.isSpatial, this.isTemporal, newValue);
    }

    public final ImmutableFeatureStoreAttribute withConstantValue(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.constantValue, value)) {
            return this;
        }
        return new ImmutableFeatureStoreAttribute(this.name, this.path, this.queryable, this.isId, this.isSpatial, this.isTemporal, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFeatureStoreAttribute && this.equalTo((ImmutableFeatureStoreAttribute)another);
    }

    private boolean equalTo(ImmutableFeatureStoreAttribute another) {
        return this.name.equals(another.name) && this.path.equals(another.path) && this.queryable.equals(another.queryable) && this.isId == another.isId && this.isSpatial == another.isSpatial && this.isTemporal == another.isTemporal && Objects.equals(this.constantValue, another.constantValue) && this.isConstant == another.isConstant;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.path.hashCode();
        h += (h << 5) + this.queryable.hashCode();
        h += (h << 5) + Booleans.hashCode(this.isId);
        h += (h << 5) + Booleans.hashCode(this.isSpatial);
        h += (h << 5) + Booleans.hashCode(this.isTemporal);
        h += (h << 5) + Objects.hashCode(this.constantValue);
        h += (h << 5) + Booleans.hashCode(this.isConstant);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("FeatureStoreAttribute").omitNullValues().add("name", this.name).add("path", this.path).add("queryable", this.queryable).add("isId", this.isId).add("isSpatial", this.isSpatial).add("isTemporal", this.isTemporal).add("constantValue", this.constantValue).add("isConstant", this.isConstant).toString();
    }

    public static ImmutableFeatureStoreAttribute copyOf(FeatureStoreAttribute instance) {
        if (instance instanceof ImmutableFeatureStoreAttribute) {
            return (ImmutableFeatureStoreAttribute)instance;
        }
        return ImmutableFeatureStoreAttribute.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="FeatureStoreAttribute", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long OPT_BIT_IS_ID = 1L;
        private static final long OPT_BIT_IS_SPATIAL = 2L;
        private static final long OPT_BIT_IS_TEMPORAL = 4L;
        private long initBits = 1L;
        private long optBits;
        @Nullable
        private String name;
        private ImmutableList.Builder<String> path = ImmutableList.builder();
        @Nullable
        private String queryable;
        private boolean isId;
        private boolean isSpatial;
        private boolean isTemporal;
        @Nullable
        private String constantValue;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(FeatureStoreAttribute instance) {
            Objects.requireNonNull(instance, "instance");
            this.name(instance.getName());
            this.addAllPath(instance.getPath());
            this.queryable(instance.getQueryable());
            this.isId(instance.isId());
            this.isSpatial(instance.isSpatial());
            this.isTemporal(instance.isTemporal());
            Optional<String> constantValueOptional = instance.getConstantValue();
            if (constantValueOptional.isPresent()) {
                this.constantValue(constantValueOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addPath(String element) {
            this.path.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addPath(String ... elements) {
            this.path.add(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder path(Iterable<String> elements) {
            this.path = ImmutableList.builder();
            return this.addAllPath(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllPath(Iterable<String> elements) {
            this.path.addAll((Iterable)elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder queryable(String queryable) {
            this.queryable = Objects.requireNonNull(queryable, "queryable");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder isId(boolean isId) {
            this.isId = isId;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder isSpatial(boolean isSpatial) {
            this.isSpatial = isSpatial;
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder isTemporal(boolean isTemporal) {
            this.isTemporal = isTemporal;
            this.optBits |= 4L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder constantValue(String constantValue) {
            this.constantValue = Objects.requireNonNull(constantValue, "constantValue");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder constantValue(Optional<String> constantValue) {
            this.constantValue = constantValue.orElse(null);
            return this;
        }

        public ImmutableFeatureStoreAttribute build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableFeatureStoreAttribute(this);
        }

        private boolean isIdIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean isSpatialIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean isTemporalIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build FeatureStoreAttribute, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="FeatureStoreAttribute", generator="Immutables")
    private final class InitShim {
        private byte queryableBuildStage = 0;
        private String queryable;
        private byte isIdBuildStage = 0;
        private boolean isId;
        private byte isSpatialBuildStage = 0;
        private boolean isSpatial;
        private byte isTemporalBuildStage = 0;
        private boolean isTemporal;
        private byte isConstantBuildStage = 0;
        private boolean isConstant;

        private InitShim() {
        }

        String getQueryable() {
            if (this.queryableBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.queryableBuildStage == 0) {
                this.queryableBuildStage = (byte)-1;
                this.queryable = Objects.requireNonNull(ImmutableFeatureStoreAttribute.this.getQueryableInitialize(), "queryable");
                this.queryableBuildStage = 1;
            }
            return this.queryable;
        }

        void queryable(String queryable) {
            this.queryable = queryable;
            this.queryableBuildStage = 1;
        }

        boolean isId() {
            if (this.isIdBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isIdBuildStage == 0) {
                this.isIdBuildStage = (byte)-1;
                this.isId = ImmutableFeatureStoreAttribute.this.isIdInitialize();
                this.isIdBuildStage = 1;
            }
            return this.isId;
        }

        void isId(boolean isId) {
            this.isId = isId;
            this.isIdBuildStage = 1;
        }

        boolean isSpatial() {
            if (this.isSpatialBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isSpatialBuildStage == 0) {
                this.isSpatialBuildStage = (byte)-1;
                this.isSpatial = ImmutableFeatureStoreAttribute.this.isSpatialInitialize();
                this.isSpatialBuildStage = 1;
            }
            return this.isSpatial;
        }

        void isSpatial(boolean isSpatial) {
            this.isSpatial = isSpatial;
            this.isSpatialBuildStage = 1;
        }

        boolean isTemporal() {
            if (this.isTemporalBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isTemporalBuildStage == 0) {
                this.isTemporalBuildStage = (byte)-1;
                this.isTemporal = ImmutableFeatureStoreAttribute.this.isTemporalInitialize();
                this.isTemporalBuildStage = 1;
            }
            return this.isTemporal;
        }

        void isTemporal(boolean isTemporal) {
            this.isTemporal = isTemporal;
            this.isTemporalBuildStage = 1;
        }

        boolean isConstant() {
            if (this.isConstantBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isConstantBuildStage == 0) {
                this.isConstantBuildStage = (byte)-1;
                this.isConstant = ImmutableFeatureStoreAttribute.this.isConstantInitialize();
                this.isConstantBuildStage = 1;
            }
            return this.isConstant;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.queryableBuildStage == -1) {
                attributes.add("queryable");
            }
            if (this.isIdBuildStage == -1) {
                attributes.add("isId");
            }
            if (this.isSpatialBuildStage == -1) {
                attributes.add("isSpatial");
            }
            if (this.isTemporalBuildStage == -1) {
                attributes.add("isTemporal");
            }
            if (this.isConstantBuildStage == -1) {
                attributes.add("isConstant");
            }
            return "Cannot build FeatureStoreAttribute, attribute initializers form cycle " + attributes;
        }
    }
}

