/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.domain;

import de.ii.xtraplatform.features.domain.FeatureSchema;
import de.ii.xtraplatform.features.domain.ImmutableSchemaConstraints;
import de.ii.xtraplatform.features.domain.SchemaBase;
import de.ii.xtraplatform.features.domain.SchemaConstraints;
import de.ii.xtraplatform.features.domain.Tuple;
import de.ii.xtraplatform.features.domain.transform.ImmutablePropertyTransformation;
import de.ii.xtraplatform.features.domain.transform.PropertyTransformation;
import de.ii.xtraplatform.geometries.domain.SimpleFeatureGeometry;
import de.ii.xtraplatform.store.domain.entities.maptobuilder.BuildableMap;
import de.ii.xtraplatform.store.domain.entities.maptobuilder.ImmutableBuildableMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import shadow.com.fasterxml.jackson.annotation.JsonAlias;
import shadow.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.com.fasterxml.jackson.annotation.JsonMerge;
import shadow.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import shadow.com.fasterxml.jackson.annotation.OptBoolean;
import shadow.com.google.common.base.MoreObjects;
import shadow.com.google.common.collect.ImmutableList;
import shadow.com.google.common.collect.ImmutableMap;
import shadow.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.javax.annotation.CheckReturnValue;
import shadow.javax.annotation.Nullable;
import shadow.javax.annotation.ParametersAreNonnullByDefault;
import shadow.javax.annotation.concurrent.Immutable;
import shadow.javax.annotation.concurrent.NotThreadSafe;
import shadow.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="FeatureSchema", generator="Immutables")
@Immutable
public final class ImmutableFeatureSchema
implements FeatureSchema {
    private final transient List<String> effectiveSourcePaths;
    private final transient boolean isForcePolygonCCW;
    private final transient List<FeatureSchema> allNestedProperties;
    private final transient List<FeatureSchema> allObjects;
    private final transient Optional<FeatureSchema> idProperty;
    private final transient Optional<FeatureSchema> primaryGeometry;
    private final transient Optional<FeatureSchema> primaryInstant;
    private final transient Optional<Tuple<FeatureSchema, FeatureSchema>> primaryInterval;
    private final transient List<String> fullPath;
    private final transient String fullPathAsString;
    private final transient Set<String> valueNames;
    private final transient boolean isObject;
    private final transient boolean isArray;
    private final transient boolean isValue;
    private final transient boolean isSpatial;
    private final transient boolean isTemporal;
    private final transient boolean isId;
    private final transient boolean isPrimaryGeometry;
    private final transient boolean isPrimaryInstant;
    private final transient boolean isPrimaryIntervalStart;
    private final transient boolean isPrimaryIntervalEnd;
    private final transient boolean isType;
    private final transient boolean isRequired;
    private final String name;
    private final ImmutableList<String> path;
    private final ImmutableList<String> parentPath;
    @Nullable
    private final String sourcePath;
    private final ImmutableList<String> sourcePaths;
    private final SchemaBase.Type type;
    @Nullable
    private final SchemaBase.Role role;
    @Nullable
    private final SchemaBase.Type valueType;
    @Nullable
    private final SimpleFeatureGeometry geometryType;
    @Nullable
    private final String objectType;
    @Nullable
    private final String label;
    @Nullable
    private final String description;
    @Nullable
    private final String constantValue;
    private final ImmutableList<PropertyTransformation> transformations;
    @Nullable
    private final SchemaConstraints constraints;
    @Nullable
    private final Boolean forcePolygonCCW;
    private final BuildableMap<FeatureSchema, Builder> propertyMap;
    private final ImmutableMap<String, String> additionalInfo;
    private final transient List<FeatureSchema> properties;
    private final transient boolean isFeature;
    private final transient boolean isConstant;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableFeatureSchema(Builder builder) {
        this.name = builder.name;
        this.path = builder.path.build();
        this.parentPath = builder.parentPath.build();
        this.sourcePath = builder.sourcePath;
        this.sourcePaths = builder.sourcePaths.build();
        this.role = builder.role;
        this.valueType = builder.valueType;
        this.geometryType = builder.geometryType;
        this.objectType = builder.objectType;
        this.label = builder.label;
        this.description = builder.description;
        this.constantValue = builder.constantValue;
        this.transformations = ImmutableList.copyOf(ImmutableFeatureSchema.convertToValueTypede_ii_xtraplatform_features_domain_transform_ImmutablePropertyTransformation(builder.transformations.build()));
        this.constraints = ImmutableFeatureSchema.convertToValueTypede_ii_xtraplatform_features_domain_ImmutableSchemaConstraints(builder.constraints);
        this.forcePolygonCCW = builder.forcePolygonCCW;
        this.propertyMap = builder.propertyMap_build();
        this.additionalInfo = builder.additionalInfo.build();
        if (builder.type != null) {
            this.initShim.type(builder.type);
        }
        this.effectiveSourcePaths = this.initShim.getEffectiveSourcePaths();
        this.isForcePolygonCCW = this.initShim.isForcePolygonCCW();
        this.allNestedProperties = this.initShim.getAllNestedProperties();
        this.allObjects = this.initShim.getAllObjects();
        this.idProperty = this.initShim.getIdProperty();
        this.primaryGeometry = this.initShim.getPrimaryGeometry();
        this.primaryInstant = this.initShim.getPrimaryInstant();
        this.primaryInterval = this.initShim.getPrimaryInterval();
        this.fullPath = this.initShim.getFullPath();
        this.fullPathAsString = this.initShim.getFullPathAsString();
        this.valueNames = this.initShim.getValueNames();
        this.isObject = this.initShim.isObject();
        this.isArray = this.initShim.isArray();
        this.isValue = this.initShim.isValue();
        this.isSpatial = this.initShim.isSpatial();
        this.isTemporal = this.initShim.isTemporal();
        this.isId = this.initShim.isId();
        this.isPrimaryGeometry = this.initShim.isPrimaryGeometry();
        this.isPrimaryInstant = this.initShim.isPrimaryInstant();
        this.isPrimaryIntervalStart = this.initShim.isPrimaryIntervalStart();
        this.isPrimaryIntervalEnd = this.initShim.isPrimaryIntervalEnd();
        this.isType = this.initShim.isType();
        this.isRequired = this.initShim.isRequired();
        this.type = this.initShim.getType();
        this.properties = this.initShim.getProperties();
        this.isFeature = this.initShim.isFeature();
        this.isConstant = this.initShim.isConstant();
        this.initShim = null;
    }

    private ImmutableFeatureSchema(String name, ImmutableList<String> path, ImmutableList<String> parentPath, @Nullable String sourcePath, ImmutableList<String> sourcePaths, SchemaBase.Type type, @Nullable SchemaBase.Role role, @Nullable SchemaBase.Type valueType, @Nullable SimpleFeatureGeometry geometryType, @Nullable String objectType, @Nullable String label, @Nullable String description, @Nullable String constantValue, ImmutableList<PropertyTransformation> transformations, @Nullable SchemaConstraints constraints, @Nullable Boolean forcePolygonCCW, BuildableMap<FeatureSchema, Builder> propertyMap, ImmutableMap<String, String> additionalInfo) {
        this.name = name;
        this.path = path;
        this.parentPath = parentPath;
        this.sourcePath = sourcePath;
        this.sourcePaths = sourcePaths;
        this.initShim.type(type);
        this.role = role;
        this.valueType = valueType;
        this.geometryType = geometryType;
        this.objectType = objectType;
        this.label = label;
        this.description = description;
        this.constantValue = constantValue;
        this.transformations = transformations;
        this.constraints = constraints;
        this.forcePolygonCCW = forcePolygonCCW;
        this.propertyMap = propertyMap;
        this.additionalInfo = additionalInfo;
        this.effectiveSourcePaths = this.initShim.getEffectiveSourcePaths();
        this.isForcePolygonCCW = this.initShim.isForcePolygonCCW();
        this.allNestedProperties = this.initShim.getAllNestedProperties();
        this.allObjects = this.initShim.getAllObjects();
        this.idProperty = this.initShim.getIdProperty();
        this.primaryGeometry = this.initShim.getPrimaryGeometry();
        this.primaryInstant = this.initShim.getPrimaryInstant();
        this.primaryInterval = this.initShim.getPrimaryInterval();
        this.fullPath = this.initShim.getFullPath();
        this.fullPathAsString = this.initShim.getFullPathAsString();
        this.valueNames = this.initShim.getValueNames();
        this.isObject = this.initShim.isObject();
        this.isArray = this.initShim.isArray();
        this.isValue = this.initShim.isValue();
        this.isSpatial = this.initShim.isSpatial();
        this.isTemporal = this.initShim.isTemporal();
        this.isId = this.initShim.isId();
        this.isPrimaryGeometry = this.initShim.isPrimaryGeometry();
        this.isPrimaryInstant = this.initShim.isPrimaryInstant();
        this.isPrimaryIntervalStart = this.initShim.isPrimaryIntervalStart();
        this.isPrimaryIntervalEnd = this.initShim.isPrimaryIntervalEnd();
        this.isType = this.initShim.isType();
        this.isRequired = this.initShim.isRequired();
        this.type = this.initShim.getType();
        this.properties = this.initShim.getProperties();
        this.isFeature = this.initShim.isFeature();
        this.isConstant = this.initShim.isConstant();
        this.initShim = null;
    }

    private List<String> getEffectiveSourcePathsInitialize() {
        return FeatureSchema.super.getEffectiveSourcePaths();
    }

    private boolean isForcePolygonCCWInitialize() {
        return FeatureSchema.super.isForcePolygonCCW();
    }

    private List<FeatureSchema> getAllNestedPropertiesInitialize() {
        return FeatureSchema.super.getAllNestedProperties();
    }

    private List<FeatureSchema> getAllObjectsInitialize() {
        return FeatureSchema.super.getAllObjects();
    }

    private Optional<FeatureSchema> getIdPropertyInitialize() {
        return FeatureSchema.super.getIdProperty();
    }

    private Optional<FeatureSchema> getPrimaryGeometryInitialize() {
        return FeatureSchema.super.getPrimaryGeometry();
    }

    private Optional<FeatureSchema> getPrimaryInstantInitialize() {
        return FeatureSchema.super.getPrimaryInstant();
    }

    private Optional<Tuple<FeatureSchema, FeatureSchema>> getPrimaryIntervalInitialize() {
        return FeatureSchema.super.getPrimaryInterval();
    }

    private List<String> getFullPathInitialize() {
        return FeatureSchema.super.getFullPath();
    }

    private String getFullPathAsStringInitialize() {
        return FeatureSchema.super.getFullPathAsString();
    }

    private Set<String> getValueNamesInitialize() {
        return FeatureSchema.super.getValueNames();
    }

    private boolean isObjectInitialize() {
        return FeatureSchema.super.isObject();
    }

    private boolean isArrayInitialize() {
        return FeatureSchema.super.isArray();
    }

    private boolean isValueInitialize() {
        return FeatureSchema.super.isValue();
    }

    private boolean isSpatialInitialize() {
        return FeatureSchema.super.isSpatial();
    }

    private boolean isTemporalInitialize() {
        return FeatureSchema.super.isTemporal();
    }

    private boolean isIdInitialize() {
        return FeatureSchema.super.isId();
    }

    private boolean isPrimaryGeometryInitialize() {
        return FeatureSchema.super.isPrimaryGeometry();
    }

    private boolean isPrimaryInstantInitialize() {
        return FeatureSchema.super.isPrimaryInstant();
    }

    private boolean isPrimaryIntervalStartInitialize() {
        return FeatureSchema.super.isPrimaryIntervalStart();
    }

    private boolean isPrimaryIntervalEndInitialize() {
        return FeatureSchema.super.isPrimaryIntervalEnd();
    }

    private boolean isTypeInitialize() {
        return FeatureSchema.super.isType();
    }

    private boolean isRequiredInitialize() {
        return FeatureSchema.super.isRequired();
    }

    private SchemaBase.Type getTypeInitialize() {
        return FeatureSchema.super.getType();
    }

    private List<FeatureSchema> getPropertiesInitialize() {
        return FeatureSchema.super.getProperties();
    }

    private boolean isFeatureInitialize() {
        return FeatureSchema.super.isFeature();
    }

    private boolean isConstantInitialize() {
        return FeatureSchema.super.isConstant();
    }

    @Override
    @JsonProperty(value="effectiveSourcePaths")
    @JsonIgnore
    public List<String> getEffectiveSourcePaths() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getEffectiveSourcePaths() : this.effectiveSourcePaths;
    }

    @Override
    @JsonProperty(value="isForcePolygonCCW")
    @JsonIgnore
    public boolean isForcePolygonCCW() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isForcePolygonCCW() : this.isForcePolygonCCW;
    }

    @Override
    @JsonProperty(value="allNestedProperties")
    @JsonIgnore
    public List<FeatureSchema> getAllNestedProperties() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getAllNestedProperties() : this.allNestedProperties;
    }

    @Override
    @JsonProperty(value="allObjects")
    @JsonIgnore
    public List<FeatureSchema> getAllObjects() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getAllObjects() : this.allObjects;
    }

    @Override
    @JsonProperty(value="idProperty")
    @JsonIgnore
    public Optional<FeatureSchema> getIdProperty() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getIdProperty() : this.idProperty;
    }

    @Override
    @JsonProperty(value="primaryGeometry")
    @JsonIgnore
    public Optional<FeatureSchema> getPrimaryGeometry() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getPrimaryGeometry() : this.primaryGeometry;
    }

    @Override
    @JsonProperty(value="primaryInstant")
    @JsonIgnore
    public Optional<FeatureSchema> getPrimaryInstant() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getPrimaryInstant() : this.primaryInstant;
    }

    @Override
    @JsonProperty(value="primaryInterval")
    @JsonIgnore
    public Optional<Tuple<FeatureSchema, FeatureSchema>> getPrimaryInterval() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getPrimaryInterval() : this.primaryInterval;
    }

    @Override
    @JsonProperty(value="fullPath")
    @JsonIgnore
    public List<String> getFullPath() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getFullPath() : this.fullPath;
    }

    @Override
    @JsonProperty(value="fullPathAsString")
    @JsonIgnore
    public String getFullPathAsString() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getFullPathAsString() : this.fullPathAsString;
    }

    @Override
    @JsonProperty(value="valueNames")
    @JsonIgnore
    public Set<String> getValueNames() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getValueNames() : this.valueNames;
    }

    @Override
    @JsonProperty(value="isObject")
    @JsonIgnore
    public boolean isObject() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isObject() : this.isObject;
    }

    @Override
    @JsonProperty(value="isArray")
    @JsonIgnore
    public boolean isArray() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isArray() : this.isArray;
    }

    @Override
    @JsonProperty(value="isValue")
    @JsonIgnore
    public boolean isValue() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isValue() : this.isValue;
    }

    @Override
    @JsonProperty(value="isSpatial")
    @JsonIgnore
    public boolean isSpatial() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isSpatial() : this.isSpatial;
    }

    @Override
    @JsonProperty(value="isTemporal")
    @JsonIgnore
    public boolean isTemporal() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isTemporal() : this.isTemporal;
    }

    @Override
    @JsonProperty(value="isId")
    @JsonIgnore
    public boolean isId() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isId() : this.isId;
    }

    @Override
    @JsonProperty(value="isPrimaryGeometry")
    @JsonIgnore
    public boolean isPrimaryGeometry() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isPrimaryGeometry() : this.isPrimaryGeometry;
    }

    @Override
    @JsonProperty(value="isPrimaryInstant")
    @JsonIgnore
    public boolean isPrimaryInstant() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isPrimaryInstant() : this.isPrimaryInstant;
    }

    @Override
    @JsonProperty(value="isPrimaryIntervalStart")
    @JsonIgnore
    public boolean isPrimaryIntervalStart() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isPrimaryIntervalStart() : this.isPrimaryIntervalStart;
    }

    @Override
    @JsonProperty(value="isPrimaryIntervalEnd")
    @JsonIgnore
    public boolean isPrimaryIntervalEnd() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isPrimaryIntervalEnd() : this.isPrimaryIntervalEnd;
    }

    @Override
    @JsonProperty(value="isType")
    @JsonIgnore
    public boolean isType() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isType() : this.isType;
    }

    @Override
    @JsonProperty(value="isRequired")
    @JsonIgnore
    public boolean isRequired() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isRequired() : this.isRequired;
    }

    @Override
    @JsonProperty(value="name")
    @JsonIgnore
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="path")
    @JsonIgnore
    public ImmutableList<String> getPath() {
        return this.path;
    }

    @JsonProperty(value="parentPath")
    @JsonIgnore
    public ImmutableList<String> getParentPath() {
        return this.parentPath;
    }

    @Override
    @JsonProperty(value="sourcePath")
    @JsonAlias(value={"path"})
    public Optional<String> getSourcePath() {
        return Optional.ofNullable(this.sourcePath);
    }

    @JsonMerge(value=OptBoolean.FALSE)
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    public ImmutableList<String> getSourcePaths() {
        return this.sourcePaths;
    }

    @Override
    @JsonProperty(value="type")
    public SchemaBase.Type getType() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getType() : this.type;
    }

    @Override
    @JsonProperty(value="role")
    public Optional<SchemaBase.Role> getRole() {
        return Optional.ofNullable(this.role);
    }

    @Override
    @JsonProperty(value="valueType")
    public Optional<SchemaBase.Type> getValueType() {
        return Optional.ofNullable(this.valueType);
    }

    @Override
    @JsonProperty(value="geometryType")
    public Optional<SimpleFeatureGeometry> getGeometryType() {
        return Optional.ofNullable(this.geometryType);
    }

    @Override
    @JsonProperty(value="objectType")
    public Optional<String> getObjectType() {
        return Optional.ofNullable(this.objectType);
    }

    @Override
    @JsonProperty(value="label")
    public Optional<String> getLabel() {
        return Optional.ofNullable(this.label);
    }

    @Override
    @JsonProperty(value="description")
    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    @Override
    @JsonProperty(value="constantValue")
    public Optional<String> getConstantValue() {
        return Optional.ofNullable(this.constantValue);
    }

    @JsonProperty(value="transformations")
    public ImmutableList<PropertyTransformation> getTransformations() {
        return this.transformations;
    }

    @Override
    @JsonProperty(value="constraints")
    public Optional<SchemaConstraints> getConstraints() {
        return Optional.ofNullable(this.constraints);
    }

    @Override
    @JsonProperty(value="forcePolygonCCW")
    public Optional<Boolean> getForcePolygonCCW() {
        return Optional.ofNullable(this.forcePolygonCCW);
    }

    @Override
    @JsonProperty(value="properties")
    public BuildableMap<FeatureSchema, Builder> getPropertyMap() {
        return this.propertyMap;
    }

    @JsonProperty(value="additionalInfo")
    public ImmutableMap<String, String> getAdditionalInfo() {
        return this.additionalInfo;
    }

    @Override
    @JsonProperty(value="properties")
    @JsonIgnore
    public List<FeatureSchema> getProperties() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getProperties() : this.properties;
    }

    @Override
    @JsonProperty(value="isFeature")
    @JsonIgnore
    public boolean isFeature() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isFeature() : this.isFeature;
    }

    @Override
    @JsonProperty(value="isConstant")
    @JsonIgnore
    public boolean isConstant() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isConstant() : this.isConstant;
    }

    public final ImmutableFeatureSchema withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return ImmutableFeatureSchema.validate(new ImmutableFeatureSchema(newValue, this.path, this.parentPath, this.sourcePath, this.sourcePaths, this.type, this.role, this.valueType, this.geometryType, this.objectType, this.label, this.description, this.constantValue, this.transformations, this.constraints, this.forcePolygonCCW, this.propertyMap, this.additionalInfo));
    }

    public final ImmutableFeatureSchema withPath(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return ImmutableFeatureSchema.validate(new ImmutableFeatureSchema(this.name, newValue, this.parentPath, this.sourcePath, this.sourcePaths, this.type, this.role, this.valueType, this.geometryType, this.objectType, this.label, this.description, this.constantValue, this.transformations, this.constraints, this.forcePolygonCCW, this.propertyMap, this.additionalInfo));
    }

    public final ImmutableFeatureSchema withPath(Iterable<String> elements) {
        if (this.path == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return ImmutableFeatureSchema.validate(new ImmutableFeatureSchema(this.name, newValue, this.parentPath, this.sourcePath, this.sourcePaths, this.type, this.role, this.valueType, this.geometryType, this.objectType, this.label, this.description, this.constantValue, this.transformations, this.constraints, this.forcePolygonCCW, this.propertyMap, this.additionalInfo));
    }

    public final ImmutableFeatureSchema withParentPath(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return ImmutableFeatureSchema.validate(new ImmutableFeatureSchema(this.name, this.path, newValue, this.sourcePath, this.sourcePaths, this.type, this.role, this.valueType, this.geometryType, this.objectType, this.label, this.description, this.constantValue, this.transformations, this.constraints, this.forcePolygonCCW, this.propertyMap, this.additionalInfo));
    }

    public final ImmutableFeatureSchema withParentPath(Iterable<String> elements) {
        if (this.parentPath == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return ImmutableFeatureSchema.validate(new ImmutableFeatureSchema(this.name, this.path, newValue, this.sourcePath, this.sourcePaths, this.type, this.role, this.valueType, this.geometryType, this.objectType, this.label, this.description, this.constantValue, this.transformations, this.constraints, this.forcePolygonCCW, this.propertyMap, this.additionalInfo));
    }

    public final ImmutableFeatureSchema withSourcePath(String value) {
        String newValue = Objects.requireNonNull(value, "sourcePath");
        if (Objects.equals(this.sourcePath, newValue)) {
            return this;
        }
        return ImmutableFeatureSchema.validate(new ImmutableFeatureSchema(this.name, this.path, this.parentPath, newValue, this.sourcePaths, this.type, this.role, this.valueType, this.geometryType, this.objectType, this.label, this.description, this.constantValue, this.transformations, this.constraints, this.forcePolygonCCW, this.propertyMap, this.additionalInfo));
    }

    public final ImmutableFeatureSchema withSourcePath(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.sourcePath, value)) {
            return this;
        }
        return ImmutableFeatureSchema.validate(new ImmutableFeatureSchema(this.name, this.path, this.parentPath, value, this.sourcePaths, this.type, this.role, this.valueType, this.geometryType, this.objectType, this.label, this.description, this.constantValue, this.transformations, this.constraints, this.forcePolygonCCW, this.propertyMap, this.additionalInfo));
    }

    public final ImmutableFeatureSchema withSourcePaths(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return ImmutableFeatureSchema.validate(new ImmutableFeatureSchema(this.name, this.path, this.parentPath, this.sourcePath, newValue, this.type, this.role, this.valueType, this.geometryType, this.objectType, this.label, this.description, this.constantValue, this.transformations, this.constraints, this.forcePolygonCCW, this.propertyMap, this.additionalInfo));
    }

    public final ImmutableFeatureSchema withSourcePaths(Iterable<String> elements) {
        if (this.sourcePaths == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return ImmutableFeatureSchema.validate(new ImmutableFeatureSchema(this.name, this.path, this.parentPath, this.sourcePath, newValue, this.type, this.role, this.valueType, this.geometryType, this.objectType, this.label, this.description, this.constantValue, this.transformations, this.constraints, this.forcePolygonCCW, this.propertyMap, this.additionalInfo));
    }

    public final ImmutableFeatureSchema withType(SchemaBase.Type value) {
        if (this.type == value) {
            return this;
        }
        SchemaBase.Type newValue = Objects.requireNonNull(value, "type");
        if (this.type.equals((Object)newValue)) {
            return this;
        }
        return ImmutableFeatureSchema.validate(new ImmutableFeatureSchema(this.name, this.path, this.parentPath, this.sourcePath, this.sourcePaths, newValue, this.role, this.valueType, this.geometryType, this.objectType, this.label, this.description, this.constantValue, this.transformations, this.constraints, this.forcePolygonCCW, this.propertyMap, this.additionalInfo));
    }

    public final ImmutableFeatureSchema withRole(SchemaBase.Role value) {
        SchemaBase.Role newValue = Objects.requireNonNull(value, "role");
        if (this.role == newValue) {
            return this;
        }
        return ImmutableFeatureSchema.validate(new ImmutableFeatureSchema(this.name, this.path, this.parentPath, this.sourcePath, this.sourcePaths, this.type, newValue, this.valueType, this.geometryType, this.objectType, this.label, this.description, this.constantValue, this.transformations, this.constraints, this.forcePolygonCCW, this.propertyMap, this.additionalInfo));
    }

    public final ImmutableFeatureSchema withRole(Optional<? extends SchemaBase.Role> optional) {
        SchemaBase.Role value = optional.orElse(null);
        if (Objects.equals((Object)this.role, (Object)value)) {
            return this;
        }
        return ImmutableFeatureSchema.validate(new ImmutableFeatureSchema(this.name, this.path, this.parentPath, this.sourcePath, this.sourcePaths, this.type, value, this.valueType, this.geometryType, this.objectType, this.label, this.description, this.constantValue, this.transformations, this.constraints, this.forcePolygonCCW, this.propertyMap, this.additionalInfo));
    }

    public final ImmutableFeatureSchema withValueType(SchemaBase.Type value) {
        SchemaBase.Type newValue = Objects.requireNonNull(value, "valueType");
        if (this.valueType == newValue) {
            return this;
        }
        return ImmutableFeatureSchema.validate(new ImmutableFeatureSchema(this.name, this.path, this.parentPath, this.sourcePath, this.sourcePaths, this.type, this.role, newValue, this.geometryType, this.objectType, this.label, this.description, this.constantValue, this.transformations, this.constraints, this.forcePolygonCCW, this.propertyMap, this.additionalInfo));
    }

    public final ImmutableFeatureSchema withValueType(Optional<? extends SchemaBase.Type> optional) {
        SchemaBase.Type value = optional.orElse(null);
        if (Objects.equals((Object)this.valueType, (Object)value)) {
            return this;
        }
        return ImmutableFeatureSchema.validate(new ImmutableFeatureSchema(this.name, this.path, this.parentPath, this.sourcePath, this.sourcePaths, this.type, this.role, value, this.geometryType, this.objectType, this.label, this.description, this.constantValue, this.transformations, this.constraints, this.forcePolygonCCW, this.propertyMap, this.additionalInfo));
    }

    public final ImmutableFeatureSchema withGeometryType(SimpleFeatureGeometry value) {
        SimpleFeatureGeometry newValue = Objects.requireNonNull(value, "geometryType");
        if (this.geometryType == newValue) {
            return this;
        }
        return ImmutableFeatureSchema.validate(new ImmutableFeatureSchema(this.name, this.path, this.parentPath, this.sourcePath, this.sourcePaths, this.type, this.role, this.valueType, newValue, this.objectType, this.label, this.description, this.constantValue, this.transformations, this.constraints, this.forcePolygonCCW, this.propertyMap, this.additionalInfo));
    }

    public final ImmutableFeatureSchema withGeometryType(Optional<? extends SimpleFeatureGeometry> optional) {
        SimpleFeatureGeometry value = optional.orElse(null);
        if (Objects.equals((Object)this.geometryType, (Object)value)) {
            return this;
        }
        return ImmutableFeatureSchema.validate(new ImmutableFeatureSchema(this.name, this.path, this.parentPath, this.sourcePath, this.sourcePaths, this.type, this.role, this.valueType, value, this.objectType, this.label, this.description, this.constantValue, this.transformations, this.constraints, this.forcePolygonCCW, this.propertyMap, this.additionalInfo));
    }

    public final ImmutableFeatureSchema withObjectType(String value) {
        String newValue = Objects.requireNonNull(value, "objectType");
        if (Objects.equals(this.objectType, newValue)) {
            return this;
        }
        return ImmutableFeatureSchema.validate(new ImmutableFeatureSchema(this.name, this.path, this.parentPath, this.sourcePath, this.sourcePaths, this.type, this.role, this.valueType, this.geometryType, newValue, this.label, this.description, this.constantValue, this.transformations, this.constraints, this.forcePolygonCCW, this.propertyMap, this.additionalInfo));
    }

    public final ImmutableFeatureSchema withObjectType(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.objectType, value)) {
            return this;
        }
        return ImmutableFeatureSchema.validate(new ImmutableFeatureSchema(this.name, this.path, this.parentPath, this.sourcePath, this.sourcePaths, this.type, this.role, this.valueType, this.geometryType, value, this.label, this.description, this.constantValue, this.transformations, this.constraints, this.forcePolygonCCW, this.propertyMap, this.additionalInfo));
    }

    public final ImmutableFeatureSchema withLabel(String value) {
        String newValue = Objects.requireNonNull(value, "label");
        if (Objects.equals(this.label, newValue)) {
            return this;
        }
        return ImmutableFeatureSchema.validate(new ImmutableFeatureSchema(this.name, this.path, this.parentPath, this.sourcePath, this.sourcePaths, this.type, this.role, this.valueType, this.geometryType, this.objectType, newValue, this.description, this.constantValue, this.transformations, this.constraints, this.forcePolygonCCW, this.propertyMap, this.additionalInfo));
    }

    public final ImmutableFeatureSchema withLabel(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.label, value)) {
            return this;
        }
        return ImmutableFeatureSchema.validate(new ImmutableFeatureSchema(this.name, this.path, this.parentPath, this.sourcePath, this.sourcePaths, this.type, this.role, this.valueType, this.geometryType, this.objectType, value, this.description, this.constantValue, this.transformations, this.constraints, this.forcePolygonCCW, this.propertyMap, this.additionalInfo));
    }

    public final ImmutableFeatureSchema withDescription(String value) {
        String newValue = Objects.requireNonNull(value, "description");
        if (Objects.equals(this.description, newValue)) {
            return this;
        }
        return ImmutableFeatureSchema.validate(new ImmutableFeatureSchema(this.name, this.path, this.parentPath, this.sourcePath, this.sourcePaths, this.type, this.role, this.valueType, this.geometryType, this.objectType, this.label, newValue, this.constantValue, this.transformations, this.constraints, this.forcePolygonCCW, this.propertyMap, this.additionalInfo));
    }

    public final ImmutableFeatureSchema withDescription(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.description, value)) {
            return this;
        }
        return ImmutableFeatureSchema.validate(new ImmutableFeatureSchema(this.name, this.path, this.parentPath, this.sourcePath, this.sourcePaths, this.type, this.role, this.valueType, this.geometryType, this.objectType, this.label, value, this.constantValue, this.transformations, this.constraints, this.forcePolygonCCW, this.propertyMap, this.additionalInfo));
    }

    public final ImmutableFeatureSchema withConstantValue(String value) {
        String newValue = Objects.requireNonNull(value, "constantValue");
        if (Objects.equals(this.constantValue, newValue)) {
            return this;
        }
        return ImmutableFeatureSchema.validate(new ImmutableFeatureSchema(this.name, this.path, this.parentPath, this.sourcePath, this.sourcePaths, this.type, this.role, this.valueType, this.geometryType, this.objectType, this.label, this.description, newValue, this.transformations, this.constraints, this.forcePolygonCCW, this.propertyMap, this.additionalInfo));
    }

    public final ImmutableFeatureSchema withConstantValue(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.constantValue, value)) {
            return this;
        }
        return ImmutableFeatureSchema.validate(new ImmutableFeatureSchema(this.name, this.path, this.parentPath, this.sourcePath, this.sourcePaths, this.type, this.role, this.valueType, this.geometryType, this.objectType, this.label, this.description, value, this.transformations, this.constraints, this.forcePolygonCCW, this.propertyMap, this.additionalInfo));
    }

    public final ImmutableFeatureSchema withTransformations(PropertyTransformation ... elements) {
        ImmutableList<PropertyTransformation> newValue = ImmutableList.copyOf(elements);
        return ImmutableFeatureSchema.validate(new ImmutableFeatureSchema(this.name, this.path, this.parentPath, this.sourcePath, this.sourcePaths, this.type, this.role, this.valueType, this.geometryType, this.objectType, this.label, this.description, this.constantValue, newValue, this.constraints, this.forcePolygonCCW, this.propertyMap, this.additionalInfo));
    }

    public final ImmutableFeatureSchema withTransformations(Iterable<? extends PropertyTransformation> elements) {
        if (this.transformations == elements) {
            return this;
        }
        ImmutableList<PropertyTransformation> newValue = ImmutableList.copyOf(elements);
        return ImmutableFeatureSchema.validate(new ImmutableFeatureSchema(this.name, this.path, this.parentPath, this.sourcePath, this.sourcePaths, this.type, this.role, this.valueType, this.geometryType, this.objectType, this.label, this.description, this.constantValue, newValue, this.constraints, this.forcePolygonCCW, this.propertyMap, this.additionalInfo));
    }

    public final ImmutableFeatureSchema withConstraints(SchemaConstraints value) {
        SchemaConstraints newValue = Objects.requireNonNull(value, "constraints");
        if (this.constraints == newValue) {
            return this;
        }
        return ImmutableFeatureSchema.validate(new ImmutableFeatureSchema(this.name, this.path, this.parentPath, this.sourcePath, this.sourcePaths, this.type, this.role, this.valueType, this.geometryType, this.objectType, this.label, this.description, this.constantValue, this.transformations, newValue, this.forcePolygonCCW, this.propertyMap, this.additionalInfo));
    }

    public final ImmutableFeatureSchema withConstraints(Optional<? extends SchemaConstraints> optional) {
        SchemaConstraints value = optional.orElse(null);
        if (this.constraints == value) {
            return this;
        }
        return ImmutableFeatureSchema.validate(new ImmutableFeatureSchema(this.name, this.path, this.parentPath, this.sourcePath, this.sourcePaths, this.type, this.role, this.valueType, this.geometryType, this.objectType, this.label, this.description, this.constantValue, this.transformations, value, this.forcePolygonCCW, this.propertyMap, this.additionalInfo));
    }

    public final ImmutableFeatureSchema withForcePolygonCCW(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.forcePolygonCCW, newValue)) {
            return this;
        }
        return ImmutableFeatureSchema.validate(new ImmutableFeatureSchema(this.name, this.path, this.parentPath, this.sourcePath, this.sourcePaths, this.type, this.role, this.valueType, this.geometryType, this.objectType, this.label, this.description, this.constantValue, this.transformations, this.constraints, newValue, this.propertyMap, this.additionalInfo));
    }

    public final ImmutableFeatureSchema withForcePolygonCCW(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.forcePolygonCCW, value)) {
            return this;
        }
        return ImmutableFeatureSchema.validate(new ImmutableFeatureSchema(this.name, this.path, this.parentPath, this.sourcePath, this.sourcePaths, this.type, this.role, this.valueType, this.geometryType, this.objectType, this.label, this.description, this.constantValue, this.transformations, this.constraints, value, this.propertyMap, this.additionalInfo));
    }

    public ImmutableFeatureSchema withPropertyMap(BuildableMap<FeatureSchema, Builder> value) {
        BuildableMap<FeatureSchema, Builder> newValue = value;
        if (this.propertyMap == newValue) {
            return this;
        }
        return ImmutableFeatureSchema.validate(new ImmutableFeatureSchema(this.name, this.path, this.parentPath, this.sourcePath, this.sourcePaths, this.type, this.role, this.valueType, this.geometryType, this.objectType, this.label, this.description, this.constantValue, this.transformations, this.constraints, this.forcePolygonCCW, newValue, this.additionalInfo));
    }

    public final ImmutableFeatureSchema withAdditionalInfo(Map<String, ? extends String> entries) {
        if (this.additionalInfo == entries) {
            return this;
        }
        ImmutableMap<String, String> newValue = ImmutableMap.copyOf(entries);
        return ImmutableFeatureSchema.validate(new ImmutableFeatureSchema(this.name, this.path, this.parentPath, this.sourcePath, this.sourcePaths, this.type, this.role, this.valueType, this.geometryType, this.objectType, this.label, this.description, this.constantValue, this.transformations, this.constraints, this.forcePolygonCCW, this.propertyMap, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFeatureSchema && this.equalTo((ImmutableFeatureSchema)another);
    }

    private boolean equalTo(ImmutableFeatureSchema another) {
        return this.name.equals(another.name) && this.path.equals(another.path) && this.parentPath.equals(another.parentPath) && Objects.equals(this.sourcePath, another.sourcePath) && this.sourcePaths.equals(another.sourcePaths) && this.type.equals((Object)another.type) && Objects.equals((Object)this.role, (Object)another.role) && Objects.equals((Object)this.valueType, (Object)another.valueType) && Objects.equals((Object)this.geometryType, (Object)another.geometryType) && Objects.equals(this.objectType, another.objectType) && Objects.equals(this.label, another.label) && Objects.equals(this.description, another.description) && Objects.equals(this.constantValue, another.constantValue) && this.transformations.equals(another.transformations) && Objects.equals(this.constraints, another.constraints) && Objects.equals(this.forcePolygonCCW, another.forcePolygonCCW) && this.getPropertyMap().equals(another.getPropertyMap()) && this.additionalInfo.equals(another.additionalInfo);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.path.hashCode();
        h += (h << 5) + this.parentPath.hashCode();
        h += (h << 5) + Objects.hashCode(this.sourcePath);
        h += (h << 5) + this.sourcePaths.hashCode();
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + Objects.hashCode((Object)this.role);
        h += (h << 5) + Objects.hashCode((Object)this.valueType);
        h += (h << 5) + Objects.hashCode((Object)this.geometryType);
        h += (h << 5) + Objects.hashCode(this.objectType);
        h += (h << 5) + Objects.hashCode(this.label);
        h += (h << 5) + Objects.hashCode(this.description);
        h += (h << 5) + Objects.hashCode(this.constantValue);
        h += (h << 5) + this.transformations.hashCode();
        h += (h << 5) + Objects.hashCode(this.constraints);
        h += (h << 5) + Objects.hashCode(this.forcePolygonCCW);
        h += (h << 5) + this.getPropertyMap().hashCode();
        h += (h << 5) + this.additionalInfo.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("FeatureSchema").omitNullValues().add("name", this.name).add("path", this.path).add("parentPath", this.parentPath).add("sourcePath", this.sourcePath).add("sourcePaths", this.sourcePaths).add("type", (Object)this.type).add("role", (Object)this.role).add("valueType", (Object)this.valueType).add("geometryType", (Object)this.geometryType).add("objectType", this.objectType).add("label", this.label).add("description", this.description).add("constantValue", this.constantValue).add("transformations", this.transformations).add("constraints", this.constraints).add("forcePolygonCCW", this.forcePolygonCCW).add("propertyMap", this.getPropertyMap().toString()).add("additionalInfo", this.additionalInfo).toString();
    }

    private static ImmutableFeatureSchema validate(ImmutableFeatureSchema instance) {
        instance = (ImmutableFeatureSchema)instance.primaryInterval();
        instance = (ImmutableFeatureSchema)instance.primaryInstant();
        instance = (ImmutableFeatureSchema)instance.primaryGeometry();
        instance = (ImmutableFeatureSchema)instance.backwardsCompatibility();
        instance = (ImmutableFeatureSchema)instance.normalizeConstants();
        return instance;
    }

    public static ImmutableFeatureSchema copyOf(FeatureSchema instance) {
        if (instance instanceof ImmutableFeatureSchema) {
            return (ImmutableFeatureSchema)instance;
        }
        return new Builder().from(instance).build();
    }

    @Nullable
    private static ImmutablePropertyTransformation convertToValueTypede_ii_xtraplatform_features_domain_transform_ImmutablePropertyTransformation(@Nullable ImmutablePropertyTransformation.Builder builder) {
        if (builder == null) {
            return null;
        }
        return builder.build();
    }

    @Nullable
    private static PropertyTransformation convertToValueTypede_ii_xtraplatform_features_domain_transform_ImmutablePropertyTransformation(@Nullable PropertyTransformation value) {
        if (value == null) {
            return null;
        }
        return new ImmutablePropertyTransformation.Builder().from(value).build();
    }

    @Nullable
    private static ImmutablePropertyTransformation.Builder convertToBuilderTypede_ii_xtraplatform_features_domain_transform_ImmutablePropertyTransformation(@Nullable PropertyTransformation value) {
        if (value == null) {
            return null;
        }
        return new ImmutablePropertyTransformation.Builder().from(value);
    }

    @Nullable
    private static ImmutableSchemaConstraints convertToValueTypede_ii_xtraplatform_features_domain_ImmutableSchemaConstraints(@Nullable ImmutableSchemaConstraints.Builder builder) {
        if (builder == null) {
            return null;
        }
        return builder.build();
    }

    @Nullable
    private static SchemaConstraints convertToValueTypede_ii_xtraplatform_features_domain_ImmutableSchemaConstraints(@Nullable SchemaConstraints value) {
        if (value == null) {
            return null;
        }
        return new ImmutableSchemaConstraints.Builder().from(value).build();
    }

    @Nullable
    private static ImmutableSchemaConstraints.Builder convertToBuilderTypede_ii_xtraplatform_features_domain_ImmutableSchemaConstraints(@Nullable SchemaConstraints value) {
        if (value == null) {
            return null;
        }
        return new ImmutableSchemaConstraints.Builder().from(value);
    }

    private static List<PropertyTransformation> convertToValueTypede_ii_xtraplatform_features_domain_transform_ImmutablePropertyTransformation(Iterable<? extends ImmutablePropertyTransformation.Builder> builderList) {
        ImmutableList.Builder list = ImmutableList.builder();
        for (ImmutablePropertyTransformation.Builder builder : builderList) {
            list.add(builder.build());
        }
        return list.build();
    }

    private static List<PropertyTransformation> convertToValueTypede_ii_xtraplatform_features_domain_transform_ImmutablePropertyTransformation(ImmutablePropertyTransformation.Builder ... builderArray) {
        ImmutableList.Builder list = ImmutableList.builder();
        for (ImmutablePropertyTransformation.Builder element : builderArray) {
            list.add(element.build());
        }
        return list.build();
    }

    private static List<ImmutablePropertyTransformation.Builder> convertToBuilderTypede_ii_xtraplatform_features_domain_transform_ImmutablePropertyTransformation(Iterable<? extends ImmutablePropertyTransformation> valueList) {
        ImmutableList.Builder list = ImmutableList.builder();
        for (ImmutablePropertyTransformation immutablePropertyTransformation : valueList) {
            list.add(new ImmutablePropertyTransformation.Builder().from(immutablePropertyTransformation));
        }
        return list.build();
    }

    private static List<ImmutablePropertyTransformation.Builder> convertToBuilderTypede_ii_xtraplatform_features_domain_transform_ImmutablePropertyTransformation(ImmutablePropertyTransformation ... valueArray) {
        ImmutableList.Builder list = ImmutableList.builder();
        for (ImmutablePropertyTransformation element : valueArray) {
            list.add(new ImmutablePropertyTransformation.Builder().from(element));
        }
        return list.build();
    }

    @JsonPropertyOrder(value={"sourcePath", "type", "role", "valueType", "geometryType", "objectType", "label", "description", "transformations", "constraints", "properties"})
    @Generated(from="FeatureSchema", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    extends FeatureSchema.Builder {
        private static final long INIT_BIT_NAME = 1L;
        private long initBits = 1L;
        private Map<String, Builder> propertyMap_builderMap = new LinkedHashMap<String, Builder>();
        @Nullable
        private String name;
        private ImmutableList.Builder<String> path = ImmutableList.builder();
        private ImmutableList.Builder<String> parentPath = ImmutableList.builder();
        @Nullable
        private String sourcePath;
        private ImmutableList.Builder<String> sourcePaths = ImmutableList.builder();
        @Nullable
        private SchemaBase.Type type;
        @Nullable
        private SchemaBase.Role role;
        @Nullable
        private SchemaBase.Type valueType;
        @Nullable
        private SimpleFeatureGeometry geometryType;
        @Nullable
        private String objectType;
        @Nullable
        private String label;
        @Nullable
        private String description;
        @Nullable
        private String constantValue;
        private ImmutableList.Builder<ImmutablePropertyTransformation.Builder> transformations = ImmutableList.builder();
        @Nullable
        private ImmutableSchemaConstraints.Builder constraints;
        @Nullable
        private Boolean forcePolygonCCW;
        private ImmutableMap.Builder<String, String> additionalInfo = ImmutableMap.builder();

        @Override
        @CanIgnoreReturnValue
        public final Builder from(FeatureSchema instance) {
            Optional<Boolean> forcePolygonCCWOptional;
            Optional<String> constantValueOptional;
            Optional<String> descriptionOptional;
            Optional<String> labelOptional;
            Optional<String> objectTypeOptional;
            Optional<SimpleFeatureGeometry> geometryTypeOptional;
            Optional<SchemaBase.Type> valueTypeOptional;
            Objects.requireNonNull(instance, "instance");
            this.name(instance.getName());
            this.addAllPath(instance.getPath());
            this.addAllParentPath(instance.getParentPath());
            Optional<String> sourcePathOptional = instance.getSourcePath();
            if (sourcePathOptional.isPresent()) {
                this.sourcePath(sourcePathOptional);
            }
            this.addAllSourcePaths(instance.getSourcePaths());
            this.type(instance.getType());
            Optional<SchemaBase.Role> roleOptional = instance.getRole();
            if (roleOptional.isPresent()) {
                this.role(roleOptional);
            }
            if ((valueTypeOptional = instance.getValueType()).isPresent()) {
                this.valueType(valueTypeOptional);
            }
            if ((geometryTypeOptional = instance.getGeometryType()).isPresent()) {
                this.geometryType(geometryTypeOptional);
            }
            if ((objectTypeOptional = instance.getObjectType()).isPresent()) {
                this.objectType(objectTypeOptional);
            }
            if ((labelOptional = instance.getLabel()).isPresent()) {
                this.label(labelOptional);
            }
            if ((descriptionOptional = instance.getDescription()).isPresent()) {
                this.description(descriptionOptional);
            }
            if ((constantValueOptional = instance.getConstantValue()).isPresent()) {
                this.constantValue(constantValueOptional);
            }
            this.addAllTransformations(instance.getTransformations());
            Optional<SchemaConstraints> constraintsOptional = instance.getConstraints();
            if (constraintsOptional.isPresent()) {
                this.constraints(constraintsOptional);
            }
            if ((forcePolygonCCWOptional = instance.getForcePolygonCCW()).isPresent()) {
                this.forcePolygonCCW(forcePolygonCCWOptional);
            }
            this.propertyMap(instance.getPropertyMap());
            this.putAllAdditionalInfo(instance.getAdditionalInfo());
            return this;
        }

        @JsonProperty(value="name")
        @JsonIgnore
        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addPath(String element) {
            this.path.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addPath(String ... elements) {
            this.path.add(elements);
            return this;
        }

        @JsonProperty(value="path")
        @JsonIgnore
        @CanIgnoreReturnValue
        public final Builder path(Iterable<String> elements) {
            this.path = ImmutableList.builder();
            return this.addAllPath(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllPath(Iterable<String> elements) {
            this.path.addAll((Iterable)elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addParentPath(String element) {
            this.parentPath.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addParentPath(String ... elements) {
            this.parentPath.add(elements);
            return this;
        }

        @JsonProperty(value="parentPath")
        @JsonIgnore
        @CanIgnoreReturnValue
        public final Builder parentPath(Iterable<String> elements) {
            this.parentPath = ImmutableList.builder();
            return this.addAllParentPath(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllParentPath(Iterable<String> elements) {
            this.parentPath.addAll((Iterable)elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sourcePath(String sourcePath) {
            this.sourcePath = Objects.requireNonNull(sourcePath, "sourcePath");
            return this;
        }

        @JsonProperty(value="sourcePath")
        @JsonAlias(value={"path"})
        @CanIgnoreReturnValue
        public final Builder sourcePath(Optional<String> sourcePath) {
            this.sourcePath = sourcePath.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSourcePaths(String element) {
            this.sourcePaths.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSourcePaths(String ... elements) {
            this.sourcePaths.add(elements);
            return this;
        }

        @JsonMerge(value=OptBoolean.FALSE)
        @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
        @CanIgnoreReturnValue
        public final Builder sourcePaths(Iterable<String> elements) {
            this.sourcePaths = ImmutableList.builder();
            return this.addAllSourcePaths(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllSourcePaths(Iterable<String> elements) {
            this.sourcePaths.addAll((Iterable)elements);
            return this;
        }

        @JsonProperty(value="type")
        @CanIgnoreReturnValue
        public final Builder type(SchemaBase.Type type) {
            this.type = Objects.requireNonNull(type, "type");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder role(SchemaBase.Role role) {
            this.role = Objects.requireNonNull(role, "role");
            return this;
        }

        @JsonProperty(value="role")
        @CanIgnoreReturnValue
        public final Builder role(Optional<? extends SchemaBase.Role> role) {
            this.role = role.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder valueType(SchemaBase.Type valueType) {
            this.valueType = Objects.requireNonNull(valueType, "valueType");
            return this;
        }

        @JsonProperty(value="valueType")
        @CanIgnoreReturnValue
        public final Builder valueType(Optional<? extends SchemaBase.Type> valueType) {
            this.valueType = valueType.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder geometryType(SimpleFeatureGeometry geometryType) {
            this.geometryType = Objects.requireNonNull(geometryType, "geometryType");
            return this;
        }

        @JsonProperty(value="geometryType")
        @CanIgnoreReturnValue
        public final Builder geometryType(Optional<? extends SimpleFeatureGeometry> geometryType) {
            this.geometryType = geometryType.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder objectType(String objectType) {
            this.objectType = Objects.requireNonNull(objectType, "objectType");
            return this;
        }

        @JsonProperty(value="objectType")
        @CanIgnoreReturnValue
        public final Builder objectType(Optional<String> objectType) {
            this.objectType = objectType.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder label(String label) {
            this.label = Objects.requireNonNull(label, "label");
            return this;
        }

        @JsonProperty(value="label")
        @CanIgnoreReturnValue
        public final Builder label(Optional<String> label) {
            this.label = label.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder description(String description) {
            this.description = Objects.requireNonNull(description, "description");
            return this;
        }

        @JsonProperty(value="description")
        @CanIgnoreReturnValue
        public final Builder description(Optional<String> description) {
            this.description = description.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder constantValue(String constantValue) {
            this.constantValue = Objects.requireNonNull(constantValue, "constantValue");
            return this;
        }

        @JsonProperty(value="constantValue")
        @CanIgnoreReturnValue
        public final Builder constantValue(Optional<String> constantValue) {
            this.constantValue = constantValue.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTransformations(PropertyTransformation element) {
            element = Builder.convertToValueTypede_ii_xtraplatform_features_domain_transform_ImmutablePropertyTransformation(element);
            this.transformations.add((Object)new ImmutablePropertyTransformation.Builder().from(element));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTransformations(PropertyTransformation ... elements) {
            for (PropertyTransformation element : elements) {
                element = Builder.convertToValueTypede_ii_xtraplatform_features_domain_transform_ImmutablePropertyTransformation(element);
                this.transformations.add((Object)new ImmutablePropertyTransformation.Builder().from(Objects.requireNonNull(element, "transformations element")));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final ImmutablePropertyTransformation.Builder addTransformationsBuilder() {
            ImmutablePropertyTransformation.Builder builder = new ImmutablePropertyTransformation.Builder();
            this.transformations.add((Object)builder);
            return builder;
        }

        @CanIgnoreReturnValue
        public final Builder addAllTransformationsBuilders(ImmutablePropertyTransformation.Builder ... elements) {
            for (ImmutablePropertyTransformation.Builder element : elements) {
                this.transformations.add((Object)Objects.requireNonNull(element, "transformations element"));
            }
            return this;
        }

        public final List<ImmutablePropertyTransformation.Builder> transformationsBuilders() {
            return this.transformations.build();
        }

        @JsonProperty(value="transformations")
        @CanIgnoreReturnValue
        public final Builder transformations(Iterable<? extends PropertyTransformation> elements) {
            this.transformations = ImmutableList.builder();
            return this.addAllTransformations(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllTransformations(Iterable<? extends PropertyTransformation> elements) {
            for (PropertyTransformation propertyTransformation : elements) {
                PropertyTransformation propertyTransformation2 = Builder.convertToValueTypede_ii_xtraplatform_features_domain_transform_ImmutablePropertyTransformation(propertyTransformation);
                this.transformations.add((Object)new ImmutablePropertyTransformation.Builder().from(Objects.requireNonNull(propertyTransformation2, "transformations element")));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAllTransformationsBuilders(Iterable<ImmutablePropertyTransformation.Builder> elements) {
            for (ImmutablePropertyTransformation.Builder element : elements) {
                this.transformations.add((Object)Objects.requireNonNull(element, "transformations element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder constraints(SchemaConstraints constraints) {
            this.constraints = new ImmutableSchemaConstraints.Builder().from(Objects.requireNonNull(constraints, "constraints"));
            return this;
        }

        @JsonProperty(value="constraints")
        public final ImmutableSchemaConstraints.Builder constraintsBuilder() {
            if (this.constraints == null) {
                this.constraints = new ImmutableSchemaConstraints.Builder();
            }
            return this.constraints;
        }

        @JsonProperty(value="constraints")
        @CanIgnoreReturnValue
        public final Builder constraintsBuilder(ImmutableSchemaConstraints.Builder constraints) {
            this.constraints = constraints;
            return this;
        }

        @JsonProperty(value="constraints")
        @CanIgnoreReturnValue
        public final Builder constraints(Optional<? extends SchemaConstraints> constraints) {
            this.constraints = Builder.convertToBuilderTypede_ii_xtraplatform_features_domain_ImmutableSchemaConstraints(constraints.orElse(null));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder forcePolygonCCW(boolean forcePolygonCCW) {
            this.forcePolygonCCW = forcePolygonCCW;
            return this;
        }

        @JsonProperty(value="forcePolygonCCW")
        @CanIgnoreReturnValue
        public final Builder forcePolygonCCW(Optional<Boolean> forcePolygonCCW) {
            this.forcePolygonCCW = forcePolygonCCW.orElse(null);
            return this;
        }

        @JsonIgnore
        @JsonProperty(value="properties")
        @CanIgnoreReturnValue
        public Builder propertyMap(Map<String, FeatureSchema> values) {
            this.propertyMap_builderMap = new LinkedHashMap<String, Builder>();
            values.forEach(this::putPropertyMap);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder putPropertyMap(String key, FeatureSchema value) {
            this.propertyMap_builderMap.put(key, value.getBuilder());
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder putPropertyMap(String key, Builder builder) {
            this.propertyMap_builderMap.put(key, builder);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder putAllPropertyMap(Map<String, FeatureSchema> values) {
            values.forEach(this::putPropertyMap);
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public Builder setPropertyMap(Map<String, Builder> builders) {
            this.propertyMap_builderMap.putAll(builders);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putAdditionalInfo(String key, String value) {
            this.additionalInfo.put(key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putAdditionalInfo(Map.Entry<String, ? extends String> entry) {
            this.additionalInfo.put(entry);
            return this;
        }

        @JsonProperty(value="additionalInfo")
        @CanIgnoreReturnValue
        public final Builder additionalInfo(Map<String, ? extends String> entries) {
            this.additionalInfo = ImmutableMap.builder();
            return this.putAllAdditionalInfo(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllAdditionalInfo(Map<String, ? extends String> entries) {
            this.additionalInfo.putAll(entries);
            return this;
        }

        @Override
        public ImmutableFeatureSchema build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableFeatureSchema.validate(new ImmutableFeatureSchema(this));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build FeatureSchema, some of required attributes are not set " + attributes;
        }

        private BuildableMap<FeatureSchema, Builder> propertyMap_build() {
            return new ImmutableBuildableMap.Builder().builders(this.propertyMap_builderMap).build();
        }

        @JsonProperty
        public Map<String, Builder> getPropertyMap() {
            return this.propertyMap_builderMap;
        }

        @Nullable
        private static ImmutablePropertyTransformation convertToValueTypede_ii_xtraplatform_features_domain_transform_ImmutablePropertyTransformation(@Nullable ImmutablePropertyTransformation.Builder builder) {
            if (builder == null) {
                return null;
            }
            return builder.build();
        }

        @Nullable
        private static PropertyTransformation convertToValueTypede_ii_xtraplatform_features_domain_transform_ImmutablePropertyTransformation(@Nullable PropertyTransformation value) {
            if (value == null) {
                return null;
            }
            return new ImmutablePropertyTransformation.Builder().from(value).build();
        }

        @Nullable
        private static ImmutablePropertyTransformation.Builder convertToBuilderTypede_ii_xtraplatform_features_domain_transform_ImmutablePropertyTransformation(@Nullable PropertyTransformation value) {
            if (value == null) {
                return null;
            }
            return new ImmutablePropertyTransformation.Builder().from(value);
        }

        @Nullable
        private static ImmutableSchemaConstraints convertToValueTypede_ii_xtraplatform_features_domain_ImmutableSchemaConstraints(@Nullable ImmutableSchemaConstraints.Builder builder) {
            if (builder == null) {
                return null;
            }
            return builder.build();
        }

        @Nullable
        private static SchemaConstraints convertToValueTypede_ii_xtraplatform_features_domain_ImmutableSchemaConstraints(@Nullable SchemaConstraints value) {
            if (value == null) {
                return null;
            }
            return new ImmutableSchemaConstraints.Builder().from(value).build();
        }

        @Nullable
        private static ImmutableSchemaConstraints.Builder convertToBuilderTypede_ii_xtraplatform_features_domain_ImmutableSchemaConstraints(@Nullable SchemaConstraints value) {
            if (value == null) {
                return null;
            }
            return new ImmutableSchemaConstraints.Builder().from(value);
        }

        private static List<PropertyTransformation> convertToValueTypede_ii_xtraplatform_features_domain_transform_ImmutablePropertyTransformation(Iterable<? extends ImmutablePropertyTransformation.Builder> builderList) {
            ImmutableList.Builder list = ImmutableList.builder();
            for (ImmutablePropertyTransformation.Builder builder : builderList) {
                list.add(builder.build());
            }
            return list.build();
        }

        private static List<PropertyTransformation> convertToValueTypede_ii_xtraplatform_features_domain_transform_ImmutablePropertyTransformation(ImmutablePropertyTransformation.Builder ... builderArray) {
            ImmutableList.Builder list = ImmutableList.builder();
            for (ImmutablePropertyTransformation.Builder element : builderArray) {
                list.add(element.build());
            }
            return list.build();
        }

        private static List<ImmutablePropertyTransformation.Builder> convertToBuilderTypede_ii_xtraplatform_features_domain_transform_ImmutablePropertyTransformation(Iterable<? extends ImmutablePropertyTransformation> valueList) {
            ImmutableList.Builder list = ImmutableList.builder();
            for (ImmutablePropertyTransformation immutablePropertyTransformation : valueList) {
                list.add(new ImmutablePropertyTransformation.Builder().from(immutablePropertyTransformation));
            }
            return list.build();
        }

        private static List<ImmutablePropertyTransformation.Builder> convertToBuilderTypede_ii_xtraplatform_features_domain_transform_ImmutablePropertyTransformation(ImmutablePropertyTransformation ... valueArray) {
            ImmutableList.Builder list = ImmutableList.builder();
            for (ImmutablePropertyTransformation element : valueArray) {
                list.add(new ImmutablePropertyTransformation.Builder().from(element));
            }
            return list.build();
        }
    }

    @Generated(from="FeatureSchema", generator="Immutables")
    private final class InitShim {
        private byte effectiveSourcePathsBuildStage = 0;
        private List<String> effectiveSourcePaths;
        private byte isForcePolygonCCWBuildStage = 0;
        private boolean isForcePolygonCCW;
        private byte allNestedPropertiesBuildStage = 0;
        private List<FeatureSchema> allNestedProperties;
        private byte allObjectsBuildStage = 0;
        private List<FeatureSchema> allObjects;
        private byte idPropertyBuildStage = 0;
        private Optional<FeatureSchema> idProperty;
        private byte primaryGeometryBuildStage = 0;
        private Optional<FeatureSchema> primaryGeometry;
        private byte primaryInstantBuildStage = 0;
        private Optional<FeatureSchema> primaryInstant;
        private byte primaryIntervalBuildStage = 0;
        private Optional<Tuple<FeatureSchema, FeatureSchema>> primaryInterval;
        private byte fullPathBuildStage = 0;
        private List<String> fullPath;
        private byte fullPathAsStringBuildStage = 0;
        private String fullPathAsString;
        private byte valueNamesBuildStage = 0;
        private Set<String> valueNames;
        private byte isObjectBuildStage = 0;
        private boolean isObject;
        private byte isArrayBuildStage = 0;
        private boolean isArray;
        private byte isValueBuildStage = 0;
        private boolean isValue;
        private byte isSpatialBuildStage = 0;
        private boolean isSpatial;
        private byte isTemporalBuildStage = 0;
        private boolean isTemporal;
        private byte isIdBuildStage = 0;
        private boolean isId;
        private byte isPrimaryGeometryBuildStage = 0;
        private boolean isPrimaryGeometry;
        private byte isPrimaryInstantBuildStage = 0;
        private boolean isPrimaryInstant;
        private byte isPrimaryIntervalStartBuildStage = 0;
        private boolean isPrimaryIntervalStart;
        private byte isPrimaryIntervalEndBuildStage = 0;
        private boolean isPrimaryIntervalEnd;
        private byte isTypeBuildStage = 0;
        private boolean isType;
        private byte isRequiredBuildStage = 0;
        private boolean isRequired;
        private byte typeBuildStage = 0;
        private SchemaBase.Type type;
        private byte propertiesBuildStage = 0;
        private List<FeatureSchema> properties;
        private byte isFeatureBuildStage = 0;
        private boolean isFeature;
        private byte isConstantBuildStage = 0;
        private boolean isConstant;

        private InitShim() {
        }

        List<String> getEffectiveSourcePaths() {
            if (this.effectiveSourcePathsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.effectiveSourcePathsBuildStage == 0) {
                this.effectiveSourcePathsBuildStage = (byte)-1;
                this.effectiveSourcePaths = Objects.requireNonNull(ImmutableFeatureSchema.this.getEffectiveSourcePathsInitialize(), "effectiveSourcePaths");
                this.effectiveSourcePathsBuildStage = 1;
            }
            return this.effectiveSourcePaths;
        }

        boolean isForcePolygonCCW() {
            if (this.isForcePolygonCCWBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isForcePolygonCCWBuildStage == 0) {
                this.isForcePolygonCCWBuildStage = (byte)-1;
                this.isForcePolygonCCW = ImmutableFeatureSchema.this.isForcePolygonCCWInitialize();
                this.isForcePolygonCCWBuildStage = 1;
            }
            return this.isForcePolygonCCW;
        }

        List<FeatureSchema> getAllNestedProperties() {
            if (this.allNestedPropertiesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.allNestedPropertiesBuildStage == 0) {
                this.allNestedPropertiesBuildStage = (byte)-1;
                this.allNestedProperties = Objects.requireNonNull(ImmutableFeatureSchema.this.getAllNestedPropertiesInitialize(), "allNestedProperties");
                this.allNestedPropertiesBuildStage = 1;
            }
            return this.allNestedProperties;
        }

        List<FeatureSchema> getAllObjects() {
            if (this.allObjectsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.allObjectsBuildStage == 0) {
                this.allObjectsBuildStage = (byte)-1;
                this.allObjects = Objects.requireNonNull(ImmutableFeatureSchema.this.getAllObjectsInitialize(), "allObjects");
                this.allObjectsBuildStage = 1;
            }
            return this.allObjects;
        }

        Optional<FeatureSchema> getIdProperty() {
            if (this.idPropertyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.idPropertyBuildStage == 0) {
                this.idPropertyBuildStage = (byte)-1;
                this.idProperty = Objects.requireNonNull(ImmutableFeatureSchema.this.getIdPropertyInitialize(), "idProperty");
                this.idPropertyBuildStage = 1;
            }
            return this.idProperty;
        }

        Optional<FeatureSchema> getPrimaryGeometry() {
            if (this.primaryGeometryBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.primaryGeometryBuildStage == 0) {
                this.primaryGeometryBuildStage = (byte)-1;
                this.primaryGeometry = Objects.requireNonNull(ImmutableFeatureSchema.this.getPrimaryGeometryInitialize(), "primaryGeometry");
                this.primaryGeometryBuildStage = 1;
            }
            return this.primaryGeometry;
        }

        Optional<FeatureSchema> getPrimaryInstant() {
            if (this.primaryInstantBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.primaryInstantBuildStage == 0) {
                this.primaryInstantBuildStage = (byte)-1;
                this.primaryInstant = Objects.requireNonNull(ImmutableFeatureSchema.this.getPrimaryInstantInitialize(), "primaryInstant");
                this.primaryInstantBuildStage = 1;
            }
            return this.primaryInstant;
        }

        Optional<Tuple<FeatureSchema, FeatureSchema>> getPrimaryInterval() {
            if (this.primaryIntervalBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.primaryIntervalBuildStage == 0) {
                this.primaryIntervalBuildStage = (byte)-1;
                this.primaryInterval = Objects.requireNonNull(ImmutableFeatureSchema.this.getPrimaryIntervalInitialize(), "primaryInterval");
                this.primaryIntervalBuildStage = 1;
            }
            return this.primaryInterval;
        }

        List<String> getFullPath() {
            if (this.fullPathBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.fullPathBuildStage == 0) {
                this.fullPathBuildStage = (byte)-1;
                this.fullPath = Objects.requireNonNull(ImmutableFeatureSchema.this.getFullPathInitialize(), "fullPath");
                this.fullPathBuildStage = 1;
            }
            return this.fullPath;
        }

        String getFullPathAsString() {
            if (this.fullPathAsStringBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.fullPathAsStringBuildStage == 0) {
                this.fullPathAsStringBuildStage = (byte)-1;
                this.fullPathAsString = Objects.requireNonNull(ImmutableFeatureSchema.this.getFullPathAsStringInitialize(), "fullPathAsString");
                this.fullPathAsStringBuildStage = 1;
            }
            return this.fullPathAsString;
        }

        Set<String> getValueNames() {
            if (this.valueNamesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.valueNamesBuildStage == 0) {
                this.valueNamesBuildStage = (byte)-1;
                this.valueNames = Objects.requireNonNull(ImmutableFeatureSchema.this.getValueNamesInitialize(), "valueNames");
                this.valueNamesBuildStage = 1;
            }
            return this.valueNames;
        }

        boolean isObject() {
            if (this.isObjectBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isObjectBuildStage == 0) {
                this.isObjectBuildStage = (byte)-1;
                this.isObject = ImmutableFeatureSchema.this.isObjectInitialize();
                this.isObjectBuildStage = 1;
            }
            return this.isObject;
        }

        boolean isArray() {
            if (this.isArrayBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isArrayBuildStage == 0) {
                this.isArrayBuildStage = (byte)-1;
                this.isArray = ImmutableFeatureSchema.this.isArrayInitialize();
                this.isArrayBuildStage = 1;
            }
            return this.isArray;
        }

        boolean isValue() {
            if (this.isValueBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isValueBuildStage == 0) {
                this.isValueBuildStage = (byte)-1;
                this.isValue = ImmutableFeatureSchema.this.isValueInitialize();
                this.isValueBuildStage = 1;
            }
            return this.isValue;
        }

        boolean isSpatial() {
            if (this.isSpatialBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isSpatialBuildStage == 0) {
                this.isSpatialBuildStage = (byte)-1;
                this.isSpatial = ImmutableFeatureSchema.this.isSpatialInitialize();
                this.isSpatialBuildStage = 1;
            }
            return this.isSpatial;
        }

        boolean isTemporal() {
            if (this.isTemporalBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isTemporalBuildStage == 0) {
                this.isTemporalBuildStage = (byte)-1;
                this.isTemporal = ImmutableFeatureSchema.this.isTemporalInitialize();
                this.isTemporalBuildStage = 1;
            }
            return this.isTemporal;
        }

        boolean isId() {
            if (this.isIdBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isIdBuildStage == 0) {
                this.isIdBuildStage = (byte)-1;
                this.isId = ImmutableFeatureSchema.this.isIdInitialize();
                this.isIdBuildStage = 1;
            }
            return this.isId;
        }

        boolean isPrimaryGeometry() {
            if (this.isPrimaryGeometryBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isPrimaryGeometryBuildStage == 0) {
                this.isPrimaryGeometryBuildStage = (byte)-1;
                this.isPrimaryGeometry = ImmutableFeatureSchema.this.isPrimaryGeometryInitialize();
                this.isPrimaryGeometryBuildStage = 1;
            }
            return this.isPrimaryGeometry;
        }

        boolean isPrimaryInstant() {
            if (this.isPrimaryInstantBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isPrimaryInstantBuildStage == 0) {
                this.isPrimaryInstantBuildStage = (byte)-1;
                this.isPrimaryInstant = ImmutableFeatureSchema.this.isPrimaryInstantInitialize();
                this.isPrimaryInstantBuildStage = 1;
            }
            return this.isPrimaryInstant;
        }

        boolean isPrimaryIntervalStart() {
            if (this.isPrimaryIntervalStartBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isPrimaryIntervalStartBuildStage == 0) {
                this.isPrimaryIntervalStartBuildStage = (byte)-1;
                this.isPrimaryIntervalStart = ImmutableFeatureSchema.this.isPrimaryIntervalStartInitialize();
                this.isPrimaryIntervalStartBuildStage = 1;
            }
            return this.isPrimaryIntervalStart;
        }

        boolean isPrimaryIntervalEnd() {
            if (this.isPrimaryIntervalEndBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isPrimaryIntervalEndBuildStage == 0) {
                this.isPrimaryIntervalEndBuildStage = (byte)-1;
                this.isPrimaryIntervalEnd = ImmutableFeatureSchema.this.isPrimaryIntervalEndInitialize();
                this.isPrimaryIntervalEndBuildStage = 1;
            }
            return this.isPrimaryIntervalEnd;
        }

        boolean isType() {
            if (this.isTypeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isTypeBuildStage == 0) {
                this.isTypeBuildStage = (byte)-1;
                this.isType = ImmutableFeatureSchema.this.isTypeInitialize();
                this.isTypeBuildStage = 1;
            }
            return this.isType;
        }

        boolean isRequired() {
            if (this.isRequiredBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isRequiredBuildStage == 0) {
                this.isRequiredBuildStage = (byte)-1;
                this.isRequired = ImmutableFeatureSchema.this.isRequiredInitialize();
                this.isRequiredBuildStage = 1;
            }
            return this.isRequired;
        }

        SchemaBase.Type getType() {
            if (this.typeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.typeBuildStage == 0) {
                this.typeBuildStage = (byte)-1;
                this.type = Objects.requireNonNull(ImmutableFeatureSchema.this.getTypeInitialize(), "type");
                this.typeBuildStage = 1;
            }
            return this.type;
        }

        void type(SchemaBase.Type type) {
            this.type = type;
            this.typeBuildStage = 1;
        }

        List<FeatureSchema> getProperties() {
            if (this.propertiesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.propertiesBuildStage == 0) {
                this.propertiesBuildStage = (byte)-1;
                this.properties = Objects.requireNonNull(ImmutableFeatureSchema.this.getPropertiesInitialize(), "properties");
                this.propertiesBuildStage = 1;
            }
            return this.properties;
        }

        boolean isFeature() {
            if (this.isFeatureBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isFeatureBuildStage == 0) {
                this.isFeatureBuildStage = (byte)-1;
                this.isFeature = ImmutableFeatureSchema.this.isFeatureInitialize();
                this.isFeatureBuildStage = 1;
            }
            return this.isFeature;
        }

        boolean isConstant() {
            if (this.isConstantBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isConstantBuildStage == 0) {
                this.isConstantBuildStage = (byte)-1;
                this.isConstant = ImmutableFeatureSchema.this.isConstantInitialize();
                this.isConstantBuildStage = 1;
            }
            return this.isConstant;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.effectiveSourcePathsBuildStage == -1) {
                attributes.add("effectiveSourcePaths");
            }
            if (this.isForcePolygonCCWBuildStage == -1) {
                attributes.add("isForcePolygonCCW");
            }
            if (this.allNestedPropertiesBuildStage == -1) {
                attributes.add("allNestedProperties");
            }
            if (this.allObjectsBuildStage == -1) {
                attributes.add("allObjects");
            }
            if (this.idPropertyBuildStage == -1) {
                attributes.add("idProperty");
            }
            if (this.primaryGeometryBuildStage == -1) {
                attributes.add("primaryGeometry");
            }
            if (this.primaryInstantBuildStage == -1) {
                attributes.add("primaryInstant");
            }
            if (this.primaryIntervalBuildStage == -1) {
                attributes.add("primaryInterval");
            }
            if (this.fullPathBuildStage == -1) {
                attributes.add("fullPath");
            }
            if (this.fullPathAsStringBuildStage == -1) {
                attributes.add("fullPathAsString");
            }
            if (this.valueNamesBuildStage == -1) {
                attributes.add("valueNames");
            }
            if (this.isObjectBuildStage == -1) {
                attributes.add("isObject");
            }
            if (this.isArrayBuildStage == -1) {
                attributes.add("isArray");
            }
            if (this.isValueBuildStage == -1) {
                attributes.add("isValue");
            }
            if (this.isSpatialBuildStage == -1) {
                attributes.add("isSpatial");
            }
            if (this.isTemporalBuildStage == -1) {
                attributes.add("isTemporal");
            }
            if (this.isIdBuildStage == -1) {
                attributes.add("isId");
            }
            if (this.isPrimaryGeometryBuildStage == -1) {
                attributes.add("isPrimaryGeometry");
            }
            if (this.isPrimaryInstantBuildStage == -1) {
                attributes.add("isPrimaryInstant");
            }
            if (this.isPrimaryIntervalStartBuildStage == -1) {
                attributes.add("isPrimaryIntervalStart");
            }
            if (this.isPrimaryIntervalEndBuildStage == -1) {
                attributes.add("isPrimaryIntervalEnd");
            }
            if (this.isTypeBuildStage == -1) {
                attributes.add("isType");
            }
            if (this.isRequiredBuildStage == -1) {
                attributes.add("isRequired");
            }
            if (this.typeBuildStage == -1) {
                attributes.add("type");
            }
            if (this.propertiesBuildStage == -1) {
                attributes.add("properties");
            }
            if (this.isFeatureBuildStage == -1) {
                attributes.add("isFeature");
            }
            if (this.isConstantBuildStage == -1) {
                attributes.add("isConstant");
            }
            return "Cannot build FeatureSchema, attribute initializers form cycle " + attributes;
        }
    }
}

