/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.domain;

import de.ii.xtraplatform.cql.domain.CqlFilter;
import de.ii.xtraplatform.crs.domain.EpsgCrs;
import de.ii.xtraplatform.features.domain.FeatureQuery;
import de.ii.xtraplatform.features.domain.FeatureQueryExtension;
import de.ii.xtraplatform.features.domain.SortKey;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import shadow.com.google.common.base.MoreObjects;
import shadow.com.google.common.collect.ImmutableList;
import shadow.com.google.common.primitives.Booleans;
import shadow.com.google.common.primitives.Doubles;
import shadow.com.google.common.primitives.Ints;
import shadow.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.javax.annotation.CheckReturnValue;
import shadow.javax.annotation.Nullable;
import shadow.javax.annotation.ParametersAreNonnullByDefault;
import shadow.javax.annotation.concurrent.Immutable;
import shadow.javax.annotation.concurrent.NotThreadSafe;
import shadow.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="FeatureQuery", generator="Immutables")
@Immutable
public final class ImmutableFeatureQuery
extends FeatureQuery {
    private final String type;
    @Nullable
    private final EpsgCrs crs;
    private final int limit;
    private final int offset;
    @Nullable
    private final CqlFilter filter;
    private final ImmutableList<SortKey> sortKeys;
    private final boolean hitsOnly;
    private final boolean propertyOnly;
    private final double maxAllowableOffset;
    private final ImmutableList<Integer> geometryPrecision;
    private final ImmutableList<String> fields;
    private final boolean skipGeometry;
    private final boolean returnsSingleFeature;
    private final ImmutableList<FeatureQueryExtension> extensions;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableFeatureQuery(Builder builder) {
        this.type = builder.type;
        this.crs = builder.crs;
        this.filter = builder.filter;
        this.sortKeys = builder.sortKeys.build();
        this.extensions = builder.extensions.build();
        if (builder.limitIsSet()) {
            this.initShim.limit(builder.limit);
        }
        if (builder.offsetIsSet()) {
            this.initShim.offset(builder.offset);
        }
        if (builder.hitsOnlyIsSet()) {
            this.initShim.hitsOnly(builder.hitsOnly);
        }
        if (builder.propertyOnlyIsSet()) {
            this.initShim.propertyOnly(builder.propertyOnly);
        }
        if (builder.maxAllowableOffsetIsSet()) {
            this.initShim.maxAllowableOffset(builder.maxAllowableOffset);
        }
        if (builder.geometryPrecisionIsSet()) {
            this.initShim.geometryPrecision((ImmutableList<Integer>)builder.geometryPrecision.build());
        }
        if (builder.fieldsIsSet()) {
            this.initShim.fields((ImmutableList<String>)builder.fields.build());
        }
        if (builder.skipGeometryIsSet()) {
            this.initShim.skipGeometry(builder.skipGeometry);
        }
        if (builder.returnsSingleFeatureIsSet()) {
            this.initShim.returnsSingleFeature(builder.returnsSingleFeature);
        }
        this.limit = this.initShim.getLimit();
        this.offset = this.initShim.getOffset();
        this.hitsOnly = this.initShim.hitsOnly();
        this.propertyOnly = this.initShim.propertyOnly();
        this.maxAllowableOffset = this.initShim.getMaxAllowableOffset();
        this.geometryPrecision = this.initShim.getGeometryPrecision();
        this.fields = this.initShim.getFields();
        this.skipGeometry = this.initShim.skipGeometry();
        this.returnsSingleFeature = this.initShim.returnsSingleFeature();
        this.initShim = null;
    }

    private ImmutableFeatureQuery(String type, @Nullable EpsgCrs crs, int limit, int offset, @Nullable CqlFilter filter, ImmutableList<SortKey> sortKeys, boolean hitsOnly, boolean propertyOnly, double maxAllowableOffset, ImmutableList<Integer> geometryPrecision, ImmutableList<String> fields, boolean skipGeometry, boolean returnsSingleFeature, ImmutableList<FeatureQueryExtension> extensions) {
        this.type = type;
        this.crs = crs;
        this.limit = limit;
        this.offset = offset;
        this.filter = filter;
        this.sortKeys = sortKeys;
        this.hitsOnly = hitsOnly;
        this.propertyOnly = propertyOnly;
        this.maxAllowableOffset = maxAllowableOffset;
        this.geometryPrecision = geometryPrecision;
        this.fields = fields;
        this.skipGeometry = skipGeometry;
        this.returnsSingleFeature = returnsSingleFeature;
        this.extensions = extensions;
        this.initShim = null;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public Optional<EpsgCrs> getCrs() {
        return Optional.ofNullable(this.crs);
    }

    @Override
    public int getLimit() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getLimit() : this.limit;
    }

    @Override
    public int getOffset() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getOffset() : this.offset;
    }

    @Override
    public Optional<CqlFilter> getFilter() {
        return Optional.ofNullable(this.filter);
    }

    public ImmutableList<SortKey> getSortKeys() {
        return this.sortKeys;
    }

    @Override
    public boolean hitsOnly() {
        InitShim shim = this.initShim;
        return shim != null ? shim.hitsOnly() : this.hitsOnly;
    }

    @Override
    public boolean propertyOnly() {
        InitShim shim = this.initShim;
        return shim != null ? shim.propertyOnly() : this.propertyOnly;
    }

    @Override
    public double getMaxAllowableOffset() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getMaxAllowableOffset() : this.maxAllowableOffset;
    }

    public ImmutableList<Integer> getGeometryPrecision() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getGeometryPrecision() : this.geometryPrecision;
    }

    public ImmutableList<String> getFields() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getFields() : this.fields;
    }

    @Override
    public boolean skipGeometry() {
        InitShim shim = this.initShim;
        return shim != null ? shim.skipGeometry() : this.skipGeometry;
    }

    @Override
    public boolean returnsSingleFeature() {
        InitShim shim = this.initShim;
        return shim != null ? shim.returnsSingleFeature() : this.returnsSingleFeature;
    }

    public ImmutableList<FeatureQueryExtension> getExtensions() {
        return this.extensions;
    }

    public final ImmutableFeatureQuery withType(String value) {
        String newValue = Objects.requireNonNull(value, "type");
        if (this.type.equals(newValue)) {
            return this;
        }
        return new ImmutableFeatureQuery(newValue, this.crs, this.limit, this.offset, this.filter, this.sortKeys, this.hitsOnly, this.propertyOnly, this.maxAllowableOffset, this.geometryPrecision, this.fields, this.skipGeometry, this.returnsSingleFeature, this.extensions);
    }

    public final ImmutableFeatureQuery withCrs(EpsgCrs value) {
        EpsgCrs newValue = Objects.requireNonNull(value, "crs");
        if (this.crs == newValue) {
            return this;
        }
        return new ImmutableFeatureQuery(this.type, newValue, this.limit, this.offset, this.filter, this.sortKeys, this.hitsOnly, this.propertyOnly, this.maxAllowableOffset, this.geometryPrecision, this.fields, this.skipGeometry, this.returnsSingleFeature, this.extensions);
    }

    public final ImmutableFeatureQuery withCrs(Optional<? extends EpsgCrs> optional) {
        EpsgCrs value = optional.orElse(null);
        if (this.crs == value) {
            return this;
        }
        return new ImmutableFeatureQuery(this.type, value, this.limit, this.offset, this.filter, this.sortKeys, this.hitsOnly, this.propertyOnly, this.maxAllowableOffset, this.geometryPrecision, this.fields, this.skipGeometry, this.returnsSingleFeature, this.extensions);
    }

    public final ImmutableFeatureQuery withLimit(int value) {
        if (this.limit == value) {
            return this;
        }
        return new ImmutableFeatureQuery(this.type, this.crs, value, this.offset, this.filter, this.sortKeys, this.hitsOnly, this.propertyOnly, this.maxAllowableOffset, this.geometryPrecision, this.fields, this.skipGeometry, this.returnsSingleFeature, this.extensions);
    }

    public final ImmutableFeatureQuery withOffset(int value) {
        if (this.offset == value) {
            return this;
        }
        return new ImmutableFeatureQuery(this.type, this.crs, this.limit, value, this.filter, this.sortKeys, this.hitsOnly, this.propertyOnly, this.maxAllowableOffset, this.geometryPrecision, this.fields, this.skipGeometry, this.returnsSingleFeature, this.extensions);
    }

    public final ImmutableFeatureQuery withFilter(CqlFilter value) {
        CqlFilter newValue = Objects.requireNonNull(value, "filter");
        if (this.filter == newValue) {
            return this;
        }
        return new ImmutableFeatureQuery(this.type, this.crs, this.limit, this.offset, newValue, this.sortKeys, this.hitsOnly, this.propertyOnly, this.maxAllowableOffset, this.geometryPrecision, this.fields, this.skipGeometry, this.returnsSingleFeature, this.extensions);
    }

    public final ImmutableFeatureQuery withFilter(Optional<? extends CqlFilter> optional) {
        CqlFilter value = optional.orElse(null);
        if (this.filter == value) {
            return this;
        }
        return new ImmutableFeatureQuery(this.type, this.crs, this.limit, this.offset, value, this.sortKeys, this.hitsOnly, this.propertyOnly, this.maxAllowableOffset, this.geometryPrecision, this.fields, this.skipGeometry, this.returnsSingleFeature, this.extensions);
    }

    public final ImmutableFeatureQuery withSortKeys(SortKey ... elements) {
        ImmutableList<SortKey> newValue = ImmutableList.copyOf(elements);
        return new ImmutableFeatureQuery(this.type, this.crs, this.limit, this.offset, this.filter, newValue, this.hitsOnly, this.propertyOnly, this.maxAllowableOffset, this.geometryPrecision, this.fields, this.skipGeometry, this.returnsSingleFeature, this.extensions);
    }

    public final ImmutableFeatureQuery withSortKeys(Iterable<? extends SortKey> elements) {
        if (this.sortKeys == elements) {
            return this;
        }
        ImmutableList<SortKey> newValue = ImmutableList.copyOf(elements);
        return new ImmutableFeatureQuery(this.type, this.crs, this.limit, this.offset, this.filter, newValue, this.hitsOnly, this.propertyOnly, this.maxAllowableOffset, this.geometryPrecision, this.fields, this.skipGeometry, this.returnsSingleFeature, this.extensions);
    }

    public final ImmutableFeatureQuery withHitsOnly(boolean value) {
        if (this.hitsOnly == value) {
            return this;
        }
        return new ImmutableFeatureQuery(this.type, this.crs, this.limit, this.offset, this.filter, this.sortKeys, value, this.propertyOnly, this.maxAllowableOffset, this.geometryPrecision, this.fields, this.skipGeometry, this.returnsSingleFeature, this.extensions);
    }

    public final ImmutableFeatureQuery withPropertyOnly(boolean value) {
        if (this.propertyOnly == value) {
            return this;
        }
        return new ImmutableFeatureQuery(this.type, this.crs, this.limit, this.offset, this.filter, this.sortKeys, this.hitsOnly, value, this.maxAllowableOffset, this.geometryPrecision, this.fields, this.skipGeometry, this.returnsSingleFeature, this.extensions);
    }

    public final ImmutableFeatureQuery withMaxAllowableOffset(double value) {
        if (Double.doubleToLongBits(this.maxAllowableOffset) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableFeatureQuery(this.type, this.crs, this.limit, this.offset, this.filter, this.sortKeys, this.hitsOnly, this.propertyOnly, value, this.geometryPrecision, this.fields, this.skipGeometry, this.returnsSingleFeature, this.extensions);
    }

    public final ImmutableFeatureQuery withGeometryPrecision(int ... elements) {
        ImmutableList<Integer> newValue = ImmutableList.copyOf(Ints.asList(elements));
        return new ImmutableFeatureQuery(this.type, this.crs, this.limit, this.offset, this.filter, this.sortKeys, this.hitsOnly, this.propertyOnly, this.maxAllowableOffset, newValue, this.fields, this.skipGeometry, this.returnsSingleFeature, this.extensions);
    }

    public final ImmutableFeatureQuery withGeometryPrecision(Iterable<Integer> elements) {
        if (this.geometryPrecision == elements) {
            return this;
        }
        ImmutableList<Integer> newValue = ImmutableList.copyOf(elements);
        return new ImmutableFeatureQuery(this.type, this.crs, this.limit, this.offset, this.filter, this.sortKeys, this.hitsOnly, this.propertyOnly, this.maxAllowableOffset, newValue, this.fields, this.skipGeometry, this.returnsSingleFeature, this.extensions);
    }

    public final ImmutableFeatureQuery withFields(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableFeatureQuery(this.type, this.crs, this.limit, this.offset, this.filter, this.sortKeys, this.hitsOnly, this.propertyOnly, this.maxAllowableOffset, this.geometryPrecision, newValue, this.skipGeometry, this.returnsSingleFeature, this.extensions);
    }

    public final ImmutableFeatureQuery withFields(Iterable<String> elements) {
        if (this.fields == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableFeatureQuery(this.type, this.crs, this.limit, this.offset, this.filter, this.sortKeys, this.hitsOnly, this.propertyOnly, this.maxAllowableOffset, this.geometryPrecision, newValue, this.skipGeometry, this.returnsSingleFeature, this.extensions);
    }

    public final ImmutableFeatureQuery withSkipGeometry(boolean value) {
        if (this.skipGeometry == value) {
            return this;
        }
        return new ImmutableFeatureQuery(this.type, this.crs, this.limit, this.offset, this.filter, this.sortKeys, this.hitsOnly, this.propertyOnly, this.maxAllowableOffset, this.geometryPrecision, this.fields, value, this.returnsSingleFeature, this.extensions);
    }

    public final ImmutableFeatureQuery withReturnsSingleFeature(boolean value) {
        if (this.returnsSingleFeature == value) {
            return this;
        }
        return new ImmutableFeatureQuery(this.type, this.crs, this.limit, this.offset, this.filter, this.sortKeys, this.hitsOnly, this.propertyOnly, this.maxAllowableOffset, this.geometryPrecision, this.fields, this.skipGeometry, value, this.extensions);
    }

    public final ImmutableFeatureQuery withExtensions(FeatureQueryExtension ... elements) {
        ImmutableList<FeatureQueryExtension> newValue = ImmutableList.copyOf(elements);
        return new ImmutableFeatureQuery(this.type, this.crs, this.limit, this.offset, this.filter, this.sortKeys, this.hitsOnly, this.propertyOnly, this.maxAllowableOffset, this.geometryPrecision, this.fields, this.skipGeometry, this.returnsSingleFeature, newValue);
    }

    public final ImmutableFeatureQuery withExtensions(Iterable<? extends FeatureQueryExtension> elements) {
        if (this.extensions == elements) {
            return this;
        }
        ImmutableList<FeatureQueryExtension> newValue = ImmutableList.copyOf(elements);
        return new ImmutableFeatureQuery(this.type, this.crs, this.limit, this.offset, this.filter, this.sortKeys, this.hitsOnly, this.propertyOnly, this.maxAllowableOffset, this.geometryPrecision, this.fields, this.skipGeometry, this.returnsSingleFeature, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFeatureQuery && this.equalTo((ImmutableFeatureQuery)another);
    }

    private boolean equalTo(ImmutableFeatureQuery another) {
        return this.type.equals(another.type) && Objects.equals(this.crs, another.crs) && this.limit == another.limit && this.offset == another.offset && Objects.equals(this.filter, another.filter) && this.sortKeys.equals(another.sortKeys) && this.hitsOnly == another.hitsOnly && this.propertyOnly == another.propertyOnly && Double.doubleToLongBits(this.maxAllowableOffset) == Double.doubleToLongBits(another.maxAllowableOffset) && this.geometryPrecision.equals(another.geometryPrecision) && this.fields.equals(another.fields) && this.skipGeometry == another.skipGeometry && this.returnsSingleFeature == another.returnsSingleFeature && this.extensions.equals(another.extensions);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + Objects.hashCode(this.crs);
        h += (h << 5) + this.limit;
        h += (h << 5) + this.offset;
        h += (h << 5) + Objects.hashCode(this.filter);
        h += (h << 5) + this.sortKeys.hashCode();
        h += (h << 5) + Booleans.hashCode(this.hitsOnly);
        h += (h << 5) + Booleans.hashCode(this.propertyOnly);
        h += (h << 5) + Doubles.hashCode(this.maxAllowableOffset);
        h += (h << 5) + this.geometryPrecision.hashCode();
        h += (h << 5) + this.fields.hashCode();
        h += (h << 5) + Booleans.hashCode(this.skipGeometry);
        h += (h << 5) + Booleans.hashCode(this.returnsSingleFeature);
        h += (h << 5) + this.extensions.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("FeatureQuery").omitNullValues().add("type", this.type).add("crs", this.crs).add("limit", this.limit).add("offset", this.offset).add("filter", this.filter).add("sortKeys", this.sortKeys).add("hitsOnly", this.hitsOnly).add("propertyOnly", this.propertyOnly).add("maxAllowableOffset", this.maxAllowableOffset).add("geometryPrecision", this.geometryPrecision).add("fields", this.fields).add("skipGeometry", this.skipGeometry).add("returnsSingleFeature", this.returnsSingleFeature).add("extensions", this.extensions).toString();
    }

    public static ImmutableFeatureQuery copyOf(FeatureQuery instance) {
        if (instance instanceof ImmutableFeatureQuery) {
            return (ImmutableFeatureQuery)instance;
        }
        return ImmutableFeatureQuery.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="FeatureQuery", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long OPT_BIT_LIMIT = 1L;
        private static final long OPT_BIT_OFFSET = 2L;
        private static final long OPT_BIT_HITS_ONLY = 4L;
        private static final long OPT_BIT_PROPERTY_ONLY = 8L;
        private static final long OPT_BIT_MAX_ALLOWABLE_OFFSET = 16L;
        private static final long OPT_BIT_GEOMETRY_PRECISION = 32L;
        private static final long OPT_BIT_FIELDS = 64L;
        private static final long OPT_BIT_SKIP_GEOMETRY = 128L;
        private static final long OPT_BIT_RETURNS_SINGLE_FEATURE = 256L;
        private long initBits = 1L;
        private long optBits;
        @Nullable
        private String type;
        @Nullable
        private EpsgCrs crs;
        private int limit;
        private int offset;
        @Nullable
        private CqlFilter filter;
        private ImmutableList.Builder<SortKey> sortKeys = ImmutableList.builder();
        private boolean hitsOnly;
        private boolean propertyOnly;
        private double maxAllowableOffset;
        private ImmutableList.Builder<Integer> geometryPrecision = ImmutableList.builder();
        private ImmutableList.Builder<String> fields = ImmutableList.builder();
        private boolean skipGeometry;
        private boolean returnsSingleFeature;
        private ImmutableList.Builder<FeatureQueryExtension> extensions = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(FeatureQuery instance) {
            Objects.requireNonNull(instance, "instance");
            this.type(instance.getType());
            Optional<EpsgCrs> crsOptional = instance.getCrs();
            if (crsOptional.isPresent()) {
                this.crs(crsOptional);
            }
            this.limit(instance.getLimit());
            this.offset(instance.getOffset());
            Optional<CqlFilter> filterOptional = instance.getFilter();
            if (filterOptional.isPresent()) {
                this.filter(filterOptional);
            }
            this.addAllSortKeys(instance.getSortKeys());
            this.hitsOnly(instance.hitsOnly());
            this.propertyOnly(instance.propertyOnly());
            this.maxAllowableOffset(instance.getMaxAllowableOffset());
            this.addAllGeometryPrecision(instance.getGeometryPrecision());
            this.addAllFields(instance.getFields());
            this.skipGeometry(instance.skipGeometry());
            this.returnsSingleFeature(instance.returnsSingleFeature());
            this.addAllExtensions(instance.getExtensions());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder type(String type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder crs(EpsgCrs crs) {
            this.crs = Objects.requireNonNull(crs, "crs");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder crs(Optional<? extends EpsgCrs> crs) {
            this.crs = crs.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder limit(int limit) {
            this.limit = limit;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder offset(int offset) {
            this.offset = offset;
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder filter(CqlFilter filter) {
            this.filter = Objects.requireNonNull(filter, "filter");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder filter(Optional<? extends CqlFilter> filter) {
            this.filter = filter.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSortKeys(SortKey element) {
            this.sortKeys.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSortKeys(SortKey ... elements) {
            this.sortKeys.add(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sortKeys(Iterable<? extends SortKey> elements) {
            this.sortKeys = ImmutableList.builder();
            return this.addAllSortKeys(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllSortKeys(Iterable<? extends SortKey> elements) {
            this.sortKeys.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder hitsOnly(boolean hitsOnly) {
            this.hitsOnly = hitsOnly;
            this.optBits |= 4L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder propertyOnly(boolean propertyOnly) {
            this.propertyOnly = propertyOnly;
            this.optBits |= 8L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder maxAllowableOffset(double maxAllowableOffset) {
            this.maxAllowableOffset = maxAllowableOffset;
            this.optBits |= 0x10L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addGeometryPrecision(int element) {
            this.geometryPrecision.add((Object)element);
            this.optBits |= 0x20L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addGeometryPrecision(int ... elements) {
            this.geometryPrecision.addAll(Ints.asList(elements));
            this.optBits |= 0x20L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder geometryPrecision(Iterable<Integer> elements) {
            this.geometryPrecision = ImmutableList.builder();
            return this.addAllGeometryPrecision(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllGeometryPrecision(Iterable<Integer> elements) {
            this.geometryPrecision.addAll((Iterable)elements);
            this.optBits |= 0x20L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addFields(String element) {
            this.fields.add((Object)element);
            this.optBits |= 0x40L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addFields(String ... elements) {
            this.fields.add(elements);
            this.optBits |= 0x40L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder fields(Iterable<String> elements) {
            this.fields = ImmutableList.builder();
            return this.addAllFields(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllFields(Iterable<String> elements) {
            this.fields.addAll((Iterable)elements);
            this.optBits |= 0x40L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder skipGeometry(boolean skipGeometry) {
            this.skipGeometry = skipGeometry;
            this.optBits |= 0x80L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder returnsSingleFeature(boolean returnsSingleFeature) {
            this.returnsSingleFeature = returnsSingleFeature;
            this.optBits |= 0x100L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addExtensions(FeatureQueryExtension element) {
            this.extensions.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addExtensions(FeatureQueryExtension ... elements) {
            this.extensions.add(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder extensions(Iterable<? extends FeatureQueryExtension> elements) {
            this.extensions = ImmutableList.builder();
            return this.addAllExtensions(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllExtensions(Iterable<? extends FeatureQueryExtension> elements) {
            this.extensions.addAll(elements);
            return this;
        }

        public ImmutableFeatureQuery build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableFeatureQuery(this);
        }

        private boolean limitIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean offsetIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean hitsOnlyIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean propertyOnlyIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean maxAllowableOffsetIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean geometryPrecisionIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean fieldsIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }

        private boolean skipGeometryIsSet() {
            return (this.optBits & 0x80L) != 0L;
        }

        private boolean returnsSingleFeatureIsSet() {
            return (this.optBits & 0x100L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("type");
            }
            return "Cannot build FeatureQuery, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="FeatureQuery", generator="Immutables")
    private final class InitShim {
        private byte limitBuildStage = 0;
        private int limit;
        private byte offsetBuildStage = 0;
        private int offset;
        private byte hitsOnlyBuildStage = 0;
        private boolean hitsOnly;
        private byte propertyOnlyBuildStage = 0;
        private boolean propertyOnly;
        private byte maxAllowableOffsetBuildStage = 0;
        private double maxAllowableOffset;
        private byte geometryPrecisionBuildStage = 0;
        private ImmutableList<Integer> geometryPrecision;
        private byte fieldsBuildStage = 0;
        private ImmutableList<String> fields;
        private byte skipGeometryBuildStage = 0;
        private boolean skipGeometry;
        private byte returnsSingleFeatureBuildStage = 0;
        private boolean returnsSingleFeature;

        private InitShim() {
        }

        int getLimit() {
            if (this.limitBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.limitBuildStage == 0) {
                this.limitBuildStage = (byte)-1;
                this.limit = ImmutableFeatureQuery.super.getLimit();
                this.limitBuildStage = 1;
            }
            return this.limit;
        }

        void limit(int limit) {
            this.limit = limit;
            this.limitBuildStage = 1;
        }

        int getOffset() {
            if (this.offsetBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.offsetBuildStage == 0) {
                this.offsetBuildStage = (byte)-1;
                this.offset = ImmutableFeatureQuery.super.getOffset();
                this.offsetBuildStage = 1;
            }
            return this.offset;
        }

        void offset(int offset) {
            this.offset = offset;
            this.offsetBuildStage = 1;
        }

        boolean hitsOnly() {
            if (this.hitsOnlyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hitsOnlyBuildStage == 0) {
                this.hitsOnlyBuildStage = (byte)-1;
                this.hitsOnly = ImmutableFeatureQuery.super.hitsOnly();
                this.hitsOnlyBuildStage = 1;
            }
            return this.hitsOnly;
        }

        void hitsOnly(boolean hitsOnly) {
            this.hitsOnly = hitsOnly;
            this.hitsOnlyBuildStage = 1;
        }

        boolean propertyOnly() {
            if (this.propertyOnlyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.propertyOnlyBuildStage == 0) {
                this.propertyOnlyBuildStage = (byte)-1;
                this.propertyOnly = ImmutableFeatureQuery.super.propertyOnly();
                this.propertyOnlyBuildStage = 1;
            }
            return this.propertyOnly;
        }

        void propertyOnly(boolean propertyOnly) {
            this.propertyOnly = propertyOnly;
            this.propertyOnlyBuildStage = 1;
        }

        double getMaxAllowableOffset() {
            if (this.maxAllowableOffsetBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.maxAllowableOffsetBuildStage == 0) {
                this.maxAllowableOffsetBuildStage = (byte)-1;
                this.maxAllowableOffset = ImmutableFeatureQuery.super.getMaxAllowableOffset();
                this.maxAllowableOffsetBuildStage = 1;
            }
            return this.maxAllowableOffset;
        }

        void maxAllowableOffset(double maxAllowableOffset) {
            this.maxAllowableOffset = maxAllowableOffset;
            this.maxAllowableOffsetBuildStage = 1;
        }

        ImmutableList<Integer> getGeometryPrecision() {
            if (this.geometryPrecisionBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.geometryPrecisionBuildStage == 0) {
                this.geometryPrecisionBuildStage = (byte)-1;
                this.geometryPrecision = ImmutableList.copyOf(ImmutableFeatureQuery.super.getGeometryPrecision());
                this.geometryPrecisionBuildStage = 1;
            }
            return this.geometryPrecision;
        }

        void geometryPrecision(ImmutableList<Integer> geometryPrecision) {
            this.geometryPrecision = geometryPrecision;
            this.geometryPrecisionBuildStage = 1;
        }

        ImmutableList<String> getFields() {
            if (this.fieldsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.fieldsBuildStage == 0) {
                this.fieldsBuildStage = (byte)-1;
                this.fields = ImmutableList.copyOf(ImmutableFeatureQuery.super.getFields());
                this.fieldsBuildStage = 1;
            }
            return this.fields;
        }

        void fields(ImmutableList<String> fields) {
            this.fields = fields;
            this.fieldsBuildStage = 1;
        }

        boolean skipGeometry() {
            if (this.skipGeometryBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.skipGeometryBuildStage == 0) {
                this.skipGeometryBuildStage = (byte)-1;
                this.skipGeometry = ImmutableFeatureQuery.super.skipGeometry();
                this.skipGeometryBuildStage = 1;
            }
            return this.skipGeometry;
        }

        void skipGeometry(boolean skipGeometry) {
            this.skipGeometry = skipGeometry;
            this.skipGeometryBuildStage = 1;
        }

        boolean returnsSingleFeature() {
            if (this.returnsSingleFeatureBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.returnsSingleFeatureBuildStage == 0) {
                this.returnsSingleFeatureBuildStage = (byte)-1;
                this.returnsSingleFeature = ImmutableFeatureQuery.super.returnsSingleFeature();
                this.returnsSingleFeatureBuildStage = 1;
            }
            return this.returnsSingleFeature;
        }

        void returnsSingleFeature(boolean returnsSingleFeature) {
            this.returnsSingleFeature = returnsSingleFeature;
            this.returnsSingleFeatureBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.limitBuildStage == -1) {
                attributes.add("limit");
            }
            if (this.offsetBuildStage == -1) {
                attributes.add("offset");
            }
            if (this.hitsOnlyBuildStage == -1) {
                attributes.add("hitsOnly");
            }
            if (this.propertyOnlyBuildStage == -1) {
                attributes.add("propertyOnly");
            }
            if (this.maxAllowableOffsetBuildStage == -1) {
                attributes.add("maxAllowableOffset");
            }
            if (this.geometryPrecisionBuildStage == -1) {
                attributes.add("geometryPrecision");
            }
            if (this.fieldsBuildStage == -1) {
                attributes.add("fields");
            }
            if (this.skipGeometryBuildStage == -1) {
                attributes.add("skipGeometry");
            }
            if (this.returnsSingleFeatureBuildStage == -1) {
                attributes.add("returnsSingleFeature");
            }
            return "Cannot build FeatureQuery, attribute initializers form cycle " + attributes;
        }
    }
}

