/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.domain;

import de.ii.xtraplatform.features.domain.FeatureProperty;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import shadow.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.com.google.common.base.MoreObjects;
import shadow.com.google.common.collect.ImmutableMap;
import shadow.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.javax.annotation.CheckReturnValue;
import shadow.javax.annotation.Nullable;
import shadow.javax.annotation.ParametersAreNonnullByDefault;
import shadow.javax.annotation.concurrent.Immutable;
import shadow.javax.annotation.concurrent.NotThreadSafe;
import shadow.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="FeatureProperty", generator="Immutables")
@Immutable
public final class ImmutableFeatureProperty
implements FeatureProperty {
    private final String name;
    private final String path;
    private final FeatureProperty.Type type;
    @Nullable
    private final FeatureProperty.Role role;
    @Nullable
    private final String constantValue;
    private final ImmutableMap<String, String> additionalInfo;
    private final transient boolean isId;
    private final transient boolean isType;
    private final transient boolean isSpatial;
    private final transient boolean isTemporal;
    private final transient boolean isReference;
    private final transient boolean isReferenceEmbed;
    private final transient boolean isForceReversePolygon;
    private final transient boolean hasDoubleColumn;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableFeatureProperty(Builder builder) {
        this.name = builder.name;
        this.path = builder.path;
        this.role = builder.role;
        this.constantValue = builder.constantValue;
        this.additionalInfo = builder.additionalInfo.build();
        if (builder.type != null) {
            this.initShim.type(builder.type);
        }
        this.type = this.initShim.getType();
        this.isId = this.initShim.isId();
        this.isType = this.initShim.isType();
        this.isSpatial = this.initShim.isSpatial();
        this.isTemporal = this.initShim.isTemporal();
        this.isReference = this.initShim.isReference();
        this.isReferenceEmbed = this.initShim.isReferenceEmbed();
        this.isForceReversePolygon = this.initShim.isForceReversePolygon();
        this.hasDoubleColumn = this.initShim.hasDoubleColumn();
        this.initShim = null;
    }

    private ImmutableFeatureProperty(String name, String path, FeatureProperty.Type type, @Nullable FeatureProperty.Role role, @Nullable String constantValue, ImmutableMap<String, String> additionalInfo) {
        this.name = name;
        this.path = path;
        this.initShim.type(type);
        this.role = role;
        this.constantValue = constantValue;
        this.additionalInfo = additionalInfo;
        this.type = this.initShim.getType();
        this.isId = this.initShim.isId();
        this.isType = this.initShim.isType();
        this.isSpatial = this.initShim.isSpatial();
        this.isTemporal = this.initShim.isTemporal();
        this.isReference = this.initShim.isReference();
        this.isReferenceEmbed = this.initShim.isReferenceEmbed();
        this.isForceReversePolygon = this.initShim.isForceReversePolygon();
        this.hasDoubleColumn = this.initShim.hasDoubleColumn();
        this.initShim = null;
    }

    private FeatureProperty.Type getTypeInitialize() {
        return FeatureProperty.super.getType();
    }

    private boolean isIdInitialize() {
        return FeatureProperty.super.isId();
    }

    private boolean isTypeInitialize() {
        return FeatureProperty.super.isType();
    }

    private boolean isSpatialInitialize() {
        return FeatureProperty.super.isSpatial();
    }

    private boolean isTemporalInitialize() {
        return FeatureProperty.super.isTemporal();
    }

    private boolean isReferenceInitialize() {
        return FeatureProperty.super.isReference();
    }

    private boolean isReferenceEmbedInitialize() {
        return FeatureProperty.super.isReferenceEmbed();
    }

    private boolean isForceReversePolygonInitialize() {
        return FeatureProperty.super.isForceReversePolygon();
    }

    private boolean hasDoubleColumnInitialize() {
        return FeatureProperty.super.hasDoubleColumn();
    }

    @Override
    @JsonProperty(value="name")
    @JsonIgnore
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="path")
    public String getPath() {
        return this.path;
    }

    @Override
    @JsonProperty(value="type")
    public FeatureProperty.Type getType() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getType() : this.type;
    }

    @Override
    @JsonProperty(value="role")
    public Optional<FeatureProperty.Role> getRole() {
        return Optional.ofNullable(this.role);
    }

    @Override
    @JsonProperty(value="constantValue")
    public Optional<String> getConstantValue() {
        return Optional.ofNullable(this.constantValue);
    }

    @JsonProperty(value="additionalInfo")
    public ImmutableMap<String, String> getAdditionalInfo() {
        return this.additionalInfo;
    }

    @Override
    @JsonProperty(value="isId")
    @JsonIgnore
    public boolean isId() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isId() : this.isId;
    }

    @Override
    @JsonProperty(value="isType")
    @JsonIgnore
    public boolean isType() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isType() : this.isType;
    }

    @Override
    @JsonProperty(value="isSpatial")
    @JsonIgnore
    public boolean isSpatial() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isSpatial() : this.isSpatial;
    }

    @Override
    @JsonProperty(value="isTemporal")
    @JsonIgnore
    public boolean isTemporal() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isTemporal() : this.isTemporal;
    }

    @Override
    @JsonProperty(value="isReference")
    @JsonIgnore
    public boolean isReference() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isReference() : this.isReference;
    }

    @Override
    @JsonProperty(value="isReferenceEmbed")
    @JsonIgnore
    public boolean isReferenceEmbed() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isReferenceEmbed() : this.isReferenceEmbed;
    }

    @Override
    @JsonProperty(value="isForceReversePolygon")
    @JsonIgnore
    public boolean isForceReversePolygon() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isForceReversePolygon() : this.isForceReversePolygon;
    }

    @Override
    @JsonProperty(value="hasDoubleColumn")
    @JsonIgnore
    @Deprecated
    public boolean hasDoubleColumn() {
        InitShim shim = this.initShim;
        return shim != null ? shim.hasDoubleColumn() : this.hasDoubleColumn;
    }

    public final ImmutableFeatureProperty withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableFeatureProperty(newValue, this.path, this.type, this.role, this.constantValue, this.additionalInfo);
    }

    public final ImmutableFeatureProperty withPath(String value) {
        String newValue = Objects.requireNonNull(value, "path");
        if (this.path.equals(newValue)) {
            return this;
        }
        return new ImmutableFeatureProperty(this.name, newValue, this.type, this.role, this.constantValue, this.additionalInfo);
    }

    public final ImmutableFeatureProperty withType(FeatureProperty.Type value) {
        if (this.type == value) {
            return this;
        }
        FeatureProperty.Type newValue = Objects.requireNonNull(value, "type");
        if (this.type.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableFeatureProperty(this.name, this.path, newValue, this.role, this.constantValue, this.additionalInfo);
    }

    public final ImmutableFeatureProperty withRole(FeatureProperty.Role value) {
        FeatureProperty.Role newValue = Objects.requireNonNull(value, "role");
        if (this.role == newValue) {
            return this;
        }
        return new ImmutableFeatureProperty(this.name, this.path, this.type, newValue, this.constantValue, this.additionalInfo);
    }

    public final ImmutableFeatureProperty withRole(Optional<? extends FeatureProperty.Role> optional) {
        FeatureProperty.Role value = optional.orElse(null);
        if (Objects.equals((Object)this.role, (Object)value)) {
            return this;
        }
        return new ImmutableFeatureProperty(this.name, this.path, this.type, value, this.constantValue, this.additionalInfo);
    }

    public final ImmutableFeatureProperty withConstantValue(String value) {
        String newValue = Objects.requireNonNull(value, "constantValue");
        if (Objects.equals(this.constantValue, newValue)) {
            return this;
        }
        return new ImmutableFeatureProperty(this.name, this.path, this.type, this.role, newValue, this.additionalInfo);
    }

    public final ImmutableFeatureProperty withConstantValue(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.constantValue, value)) {
            return this;
        }
        return new ImmutableFeatureProperty(this.name, this.path, this.type, this.role, value, this.additionalInfo);
    }

    public final ImmutableFeatureProperty withAdditionalInfo(Map<String, ? extends String> entries) {
        if (this.additionalInfo == entries) {
            return this;
        }
        ImmutableMap<String, String> newValue = ImmutableMap.copyOf(entries);
        return new ImmutableFeatureProperty(this.name, this.path, this.type, this.role, this.constantValue, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFeatureProperty && this.equalTo((ImmutableFeatureProperty)another);
    }

    private boolean equalTo(ImmutableFeatureProperty another) {
        return this.name.equals(another.name) && this.path.equals(another.path) && this.type.equals((Object)another.type) && Objects.equals((Object)this.role, (Object)another.role) && Objects.equals(this.constantValue, another.constantValue) && this.additionalInfo.equals(another.additionalInfo);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.path.hashCode();
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + Objects.hashCode((Object)this.role);
        h += (h << 5) + Objects.hashCode(this.constantValue);
        h += (h << 5) + this.additionalInfo.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("FeatureProperty").omitNullValues().add("name", this.name).add("path", this.path).add("type", (Object)this.type).add("role", (Object)this.role).add("constantValue", this.constantValue).add("additionalInfo", this.additionalInfo).toString();
    }

    public static ImmutableFeatureProperty copyOf(FeatureProperty instance) {
        if (instance instanceof ImmutableFeatureProperty) {
            return (ImmutableFeatureProperty)instance;
        }
        return new Builder().from(instance).build();
    }

    @Generated(from="FeatureProperty", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    extends FeatureProperty.Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_PATH = 2L;
        private long initBits = 3L;
        @Nullable
        private String name;
        @Nullable
        private String path;
        @Nullable
        private FeatureProperty.Type type;
        @Nullable
        private FeatureProperty.Role role;
        @Nullable
        private String constantValue;
        private ImmutableMap.Builder<String, String> additionalInfo = ImmutableMap.builder();

        @Override
        @CanIgnoreReturnValue
        public final Builder from(FeatureProperty instance) {
            Optional<String> constantValueOptional;
            Objects.requireNonNull(instance, "instance");
            this.name(instance.getName());
            this.path(instance.getPath());
            this.type(instance.getType());
            Optional<FeatureProperty.Role> roleOptional = instance.getRole();
            if (roleOptional.isPresent()) {
                this.role(roleOptional);
            }
            if ((constantValueOptional = instance.getConstantValue()).isPresent()) {
                this.constantValue(constantValueOptional);
            }
            this.putAllAdditionalInfo(instance.getAdditionalInfo());
            return this;
        }

        @JsonProperty(value="name")
        @JsonIgnore
        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="path")
        @CanIgnoreReturnValue
        public final Builder path(String path) {
            this.path = Objects.requireNonNull(path, "path");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="type")
        @CanIgnoreReturnValue
        public final Builder type(FeatureProperty.Type type) {
            this.type = Objects.requireNonNull(type, "type");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder role(FeatureProperty.Role role) {
            this.role = Objects.requireNonNull(role, "role");
            return this;
        }

        @JsonProperty(value="role")
        @CanIgnoreReturnValue
        public final Builder role(Optional<? extends FeatureProperty.Role> role) {
            this.role = role.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder constantValue(String constantValue) {
            this.constantValue = Objects.requireNonNull(constantValue, "constantValue");
            return this;
        }

        @JsonProperty(value="constantValue")
        @CanIgnoreReturnValue
        public final Builder constantValue(Optional<String> constantValue) {
            this.constantValue = constantValue.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putAdditionalInfo(String key, String value) {
            this.additionalInfo.put(key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putAdditionalInfo(Map.Entry<String, ? extends String> entry) {
            this.additionalInfo.put(entry);
            return this;
        }

        @JsonProperty(value="additionalInfo")
        @CanIgnoreReturnValue
        public final Builder additionalInfo(Map<String, ? extends String> entries) {
            this.additionalInfo = ImmutableMap.builder();
            return this.putAllAdditionalInfo(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllAdditionalInfo(Map<String, ? extends String> entries) {
            this.additionalInfo.putAll(entries);
            return this;
        }

        @Override
        public ImmutableFeatureProperty build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableFeatureProperty(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("path");
            }
            return "Cannot build FeatureProperty, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="FeatureProperty", generator="Immutables")
    private final class InitShim {
        private byte typeBuildStage = 0;
        private FeatureProperty.Type type;
        private byte isIdBuildStage = 0;
        private boolean isId;
        private byte isTypeBuildStage = 0;
        private boolean isType;
        private byte isSpatialBuildStage = 0;
        private boolean isSpatial;
        private byte isTemporalBuildStage = 0;
        private boolean isTemporal;
        private byte isReferenceBuildStage = 0;
        private boolean isReference;
        private byte isReferenceEmbedBuildStage = 0;
        private boolean isReferenceEmbed;
        private byte isForceReversePolygonBuildStage = 0;
        private boolean isForceReversePolygon;
        private byte hasDoubleColumnBuildStage = 0;
        private boolean hasDoubleColumn;

        private InitShim() {
        }

        FeatureProperty.Type getType() {
            if (this.typeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.typeBuildStage == 0) {
                this.typeBuildStage = (byte)-1;
                this.type = Objects.requireNonNull(ImmutableFeatureProperty.this.getTypeInitialize(), "type");
                this.typeBuildStage = 1;
            }
            return this.type;
        }

        void type(FeatureProperty.Type type) {
            this.type = type;
            this.typeBuildStage = 1;
        }

        boolean isId() {
            if (this.isIdBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isIdBuildStage == 0) {
                this.isIdBuildStage = (byte)-1;
                this.isId = ImmutableFeatureProperty.this.isIdInitialize();
                this.isIdBuildStage = 1;
            }
            return this.isId;
        }

        boolean isType() {
            if (this.isTypeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isTypeBuildStage == 0) {
                this.isTypeBuildStage = (byte)-1;
                this.isType = ImmutableFeatureProperty.this.isTypeInitialize();
                this.isTypeBuildStage = 1;
            }
            return this.isType;
        }

        boolean isSpatial() {
            if (this.isSpatialBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isSpatialBuildStage == 0) {
                this.isSpatialBuildStage = (byte)-1;
                this.isSpatial = ImmutableFeatureProperty.this.isSpatialInitialize();
                this.isSpatialBuildStage = 1;
            }
            return this.isSpatial;
        }

        boolean isTemporal() {
            if (this.isTemporalBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isTemporalBuildStage == 0) {
                this.isTemporalBuildStage = (byte)-1;
                this.isTemporal = ImmutableFeatureProperty.this.isTemporalInitialize();
                this.isTemporalBuildStage = 1;
            }
            return this.isTemporal;
        }

        boolean isReference() {
            if (this.isReferenceBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isReferenceBuildStage == 0) {
                this.isReferenceBuildStage = (byte)-1;
                this.isReference = ImmutableFeatureProperty.this.isReferenceInitialize();
                this.isReferenceBuildStage = 1;
            }
            return this.isReference;
        }

        boolean isReferenceEmbed() {
            if (this.isReferenceEmbedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isReferenceEmbedBuildStage == 0) {
                this.isReferenceEmbedBuildStage = (byte)-1;
                this.isReferenceEmbed = ImmutableFeatureProperty.this.isReferenceEmbedInitialize();
                this.isReferenceEmbedBuildStage = 1;
            }
            return this.isReferenceEmbed;
        }

        boolean isForceReversePolygon() {
            if (this.isForceReversePolygonBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isForceReversePolygonBuildStage == 0) {
                this.isForceReversePolygonBuildStage = (byte)-1;
                this.isForceReversePolygon = ImmutableFeatureProperty.this.isForceReversePolygonInitialize();
                this.isForceReversePolygonBuildStage = 1;
            }
            return this.isForceReversePolygon;
        }

        boolean hasDoubleColumn() {
            if (this.hasDoubleColumnBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hasDoubleColumnBuildStage == 0) {
                this.hasDoubleColumnBuildStage = (byte)-1;
                this.hasDoubleColumn = ImmutableFeatureProperty.this.hasDoubleColumnInitialize();
                this.hasDoubleColumnBuildStage = 1;
            }
            return this.hasDoubleColumn;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.typeBuildStage == -1) {
                attributes.add("type");
            }
            if (this.isIdBuildStage == -1) {
                attributes.add("isId");
            }
            if (this.isTypeBuildStage == -1) {
                attributes.add("isType");
            }
            if (this.isSpatialBuildStage == -1) {
                attributes.add("isSpatial");
            }
            if (this.isTemporalBuildStage == -1) {
                attributes.add("isTemporal");
            }
            if (this.isReferenceBuildStage == -1) {
                attributes.add("isReference");
            }
            if (this.isReferenceEmbedBuildStage == -1) {
                attributes.add("isReferenceEmbed");
            }
            if (this.isForceReversePolygonBuildStage == -1) {
                attributes.add("isForceReversePolygon");
            }
            if (this.hasDoubleColumnBuildStage == -1) {
                attributes.add("hasDoubleColumn");
            }
            return "Cannot build FeatureProperty, attribute initializers form cycle " + attributes;
        }
    }
}

