/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.domain;

import de.ii.xtraplatform.features.domain.FeatureSchema;
import de.ii.xtraplatform.features.domain.ImmutableFeatureSchema;
import de.ii.xtraplatform.features.domain.ImmutableFeatureTypeV2;
import de.ii.xtraplatform.store.domain.entities.maptobuilder.Buildable;
import de.ii.xtraplatform.store.domain.entities.maptobuilder.BuildableBuilder;
import de.ii.xtraplatform.store.domain.entities.maptobuilder.BuildableMap;
import de.ii.xtraplatform.store.domain.entities.maptobuilder.encoding.BuildableMapEncodingEnabled;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import shadow.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.com.fasterxml.jackson.annotation.JsonMerge;
import shadow.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.com.google.common.base.Splitter;
import shadow.com.google.common.collect.ImmutableCollection;
import shadow.com.google.common.collect.ImmutableList;
import shadow.org.immutables.value.Value;

@JsonDeserialize(builder=ImmutableFeatureTypeV2.Builder.class)
@Value.Immutable
@Value.Style(deepImmutablesDetection=true, builder="new", attributeBuilderDetection=true)
@BuildableMapEncodingEnabled
public interface FeatureTypeV2
extends Buildable<FeatureTypeV2> {
    @JsonIgnore
    public String getName();

    public String getPath();

    public Optional<String> getLabel();

    public Optional<String> getDescription();

    @JsonMerge
    public BuildableMap<FeatureSchema, ImmutableFeatureSchema.Builder> getProperties();

    public Map<String, String> getAdditionalInfo();

    default public ImmutableFeatureTypeV2.Builder getBuilder() {
        return new ImmutableFeatureTypeV2.Builder().from(this);
    }

    @JsonIgnore
    @Value.Derived
    default public Map<List<String>, List<FeatureSchema>> getPropertiesByPath() {
        LinkedHashMap<List<String>, List<FeatureSchema>> builder = new LinkedHashMap<List<String>, List<FeatureSchema>>();
        this.getProperties().values().forEach(featureProperty -> {
            List path = Splitter.on('/').omitEmptyStrings().splitToList(featureProperty.getSourcePath().orElse("")).stream().map(element -> {
                String resolvedElement = element.replaceAll("\\{.*?\\}", "");
                for (Map.Entry<String, String> entry : this.getAdditionalInfo().entrySet()) {
                    String prefix = entry.getKey();
                    String uri = entry.getValue();
                    resolvedElement = resolvedElement.replaceAll(prefix + ":", uri + ":");
                }
                return resolvedElement;
            }).collect(Collectors.toList());
            String column = (String)path.get(path.size() - 1);
            if (column.contains(":")) {
                List<String> columns = Splitter.on(':').splitToList(column);
                List parentPath = path.subList(0, path.size() - 1);
                ImmutableCollection path1 = ((ImmutableList.Builder)((ImmutableList.Builder)new ImmutableList.Builder().addAll((Iterable)parentPath)).add(columns.get(0))).build();
                ImmutableCollection path2 = ((ImmutableList.Builder)((ImmutableList.Builder)new ImmutableList.Builder().addAll((Iterable)parentPath)).add(columns.get(1))).build();
                builder.putIfAbsent((List<String>)((Object)path1), new ArrayList());
                ((List)builder.get(path1)).add(featureProperty);
                builder.putIfAbsent((List<String>)((Object)path2), new ArrayList());
                ((List)builder.get(path2)).add(featureProperty);
                return;
            }
            builder.putIfAbsent(path, new ArrayList());
            ((List)builder.get(path)).add(featureProperty);
        });
        return builder;
    }

    default public List<FeatureSchema> findPropertiesForPath(List<String> path) {
        return this.getPropertiesByPath().getOrDefault(path, ImmutableList.of());
    }

    public static abstract class Builder
    implements BuildableBuilder<FeatureTypeV2> {
        public abstract ImmutableFeatureTypeV2.Builder putProperties(String var1, ImmutableFeatureSchema.Builder var2);

        @JsonProperty(value="properties")
        public ImmutableFeatureTypeV2.Builder putProperties2(String key, ImmutableFeatureSchema.Builder builder) {
            return this.putProperties(key, builder.name(key));
        }
    }
}

