/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.domain;

import de.ii.xtraplatform.features.domain.FeatureProperty;
import de.ii.xtraplatform.features.domain.ImmutableFeatureProperty;
import de.ii.xtraplatform.features.domain.ImmutableFeatureType;
import de.ii.xtraplatform.store.domain.entities.maptobuilder.Buildable;
import de.ii.xtraplatform.store.domain.entities.maptobuilder.BuildableBuilder;
import de.ii.xtraplatform.store.domain.entities.maptobuilder.BuildableMap;
import de.ii.xtraplatform.store.domain.entities.maptobuilder.encoding.BuildableMapEncodingEnabled;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import shadow.com.fasterxml.jackson.annotation.JsonAnyGetter;
import shadow.com.fasterxml.jackson.annotation.JsonAnySetter;
import shadow.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.com.fasterxml.jackson.annotation.JsonMerge;
import shadow.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.com.google.common.base.Splitter;
import shadow.com.google.common.collect.ImmutableCollection;
import shadow.com.google.common.collect.ImmutableList;
import shadow.org.immutables.value.Value;

@JsonDeserialize(builder=ImmutableFeatureType.Builder.class)
@Value.Immutable
@Value.Style(deepImmutablesDetection=true, builder="new", attributeBuilderDetection=true)
@BuildableMapEncodingEnabled
public interface FeatureType
extends Buildable<FeatureType> {
    default public ImmutableFeatureType.Builder getBuilder() {
        return new ImmutableFeatureType.Builder().from(this);
    }

    @JsonAnyGetter
    @JsonMerge
    public BuildableMap<FeatureProperty, ImmutableFeatureProperty.Builder> getProperties();

    @JsonIgnore
    public String getName();

    @JsonIgnore
    @Value.Derived
    default public Map<List<String>, List<FeatureProperty>> getPropertiesByPath() {
        LinkedHashMap<List<String>, List<FeatureProperty>> builder = new LinkedHashMap<List<String>, List<FeatureProperty>>();
        this.getProperties().values().forEach(featureProperty -> {
            List path = Splitter.on('/').omitEmptyStrings().splitToList(featureProperty.getPath().replaceAll("\\{.*?\\}", "")).stream().map(element -> {
                Object resolvedElement = element.replaceAll("\\{.*?\\}", "");
                for (Map.Entry<String, String> entry : this.getAdditionalInfo().entrySet()) {
                    String prefix = entry.getKey();
                    String uri = entry.getValue();
                    if (prefix.isBlank()) {
                        if (!((String)resolvedElement).startsWith(":")) continue;
                        resolvedElement = uri + (String)resolvedElement;
                        continue;
                    }
                    resolvedElement = ((String)resolvedElement).replaceAll(prefix + ":", uri + ":");
                }
                return resolvedElement;
            }).collect(Collectors.toList());
            String root = (String)path.get(0);
            String column = (String)path.get(path.size() - 1);
            if (column.contains(":") && !root.contains(":")) {
                List<String> columns = Splitter.on(':').splitToList(column);
                List parentPath = path.subList(0, path.size() - 1);
                ImmutableCollection path1 = ((ImmutableList.Builder)((ImmutableList.Builder)new ImmutableList.Builder().addAll((Iterable)parentPath)).add(columns.get(0))).build();
                ImmutableCollection path2 = ((ImmutableList.Builder)((ImmutableList.Builder)new ImmutableList.Builder().addAll((Iterable)parentPath)).add(columns.get(1))).build();
                builder.putIfAbsent((List<String>)((Object)path1), new ArrayList());
                ((List)builder.get(path1)).add(featureProperty);
                builder.putIfAbsent((List<String>)((Object)path2), new ArrayList());
                ((List)builder.get(path2)).add(featureProperty);
                return;
            }
            builder.putIfAbsent(path, new ArrayList());
            ((List)builder.get(path)).add(featureProperty);
        });
        return builder;
    }

    public Map<String, String> getAdditionalInfo();

    default public List<FeatureProperty> findPropertiesForPath(List<String> path) {
        return this.getPropertiesByPath().getOrDefault(path, ImmutableList.of());
    }

    public static abstract class Builder
    implements BuildableBuilder<FeatureType> {
        public abstract ImmutableFeatureType.Builder putProperties(String var1, ImmutableFeatureProperty.Builder var2);

        @JsonAnySetter
        @JsonProperty(value="properties")
        public ImmutableFeatureType.Builder putProperties2(String key, ImmutableFeatureProperty.Builder builder) {
            return this.putProperties(key, builder.name(key));
        }
    }
}

