/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.domain;

import de.ii.xtraplatform.codelists.domain.Codelist;
import de.ii.xtraplatform.crs.domain.CrsTransformer;
import de.ii.xtraplatform.features.app.ImmutableCoordinatesWriterFeatureTokens;
import de.ii.xtraplatform.features.domain.FeatureEventHandler;
import de.ii.xtraplatform.features.domain.FeatureSchema;
import de.ii.xtraplatform.features.domain.FeatureTokenTransformer;
import de.ii.xtraplatform.features.domain.SchemaBase;
import de.ii.xtraplatform.features.domain.SchemaMapping;
import de.ii.xtraplatform.features.domain.transform.FeaturePropertyValueTransformer;
import de.ii.xtraplatform.features.domain.transform.PropertyTransformations;
import de.ii.xtraplatform.features.domain.transform.TransformerChain;
import de.ii.xtraplatform.geometries.domain.ImmutableCoordinatesTransformer;
import de.ii.xtraplatform.geometries.domain.SimpleFeatureGeometry;
import java.io.IOException;
import java.time.ZoneId;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class FeatureTokenTransformerValueMappings
extends FeatureTokenTransformer {
    private final PropertyTransformations propertyTransformations;
    private final Map<String, Codelist> codelists;
    private final Optional<ZoneId> nativeTimeZone;
    private final Optional<CrsTransformer> crsTransformer;
    private TransformerChain<String, FeaturePropertyValueTransformer> valueTransformerChain;
    private ImmutableCoordinatesTransformer.Builder coordinatesTransformerBuilder;
    private int targetDimension;

    public FeatureTokenTransformerValueMappings(PropertyTransformations propertyTransformations, Map<String, Codelist> codelists, Optional<ZoneId> nativeTimeZone, Optional<CrsTransformer> crsTransformer) {
        this.propertyTransformations = propertyTransformations;
        this.codelists = codelists;
        this.nativeTimeZone = nativeTimeZone;
        this.crsTransformer = crsTransformer;
    }

    @Override
    public void onStart(FeatureEventHandler.ModifiableContext<FeatureSchema, SchemaMapping> context) {
        SchemaMapping schemaMapping = SchemaMapping.withTargetPaths((SchemaMapping)this.getContext().mapping());
        this.valueTransformerChain = this.propertyTransformations.getValueTransformations(schemaMapping, this.codelists, this.nativeTimeZone, context.valueBuffer()::get);
        super.onStart(context);
    }

    @Override
    public void onObjectStart(FeatureEventHandler.ModifiableContext<FeatureSchema, SchemaMapping> context) {
        if (context.schema().filter(SchemaBase::isSpatial).isPresent() || context.geometryType().isPresent()) {
            this.coordinatesTransformerBuilder = ImmutableCoordinatesTransformer.builder();
            if (this.crsTransformer.isPresent()) {
                this.coordinatesTransformerBuilder.crsTransformer(this.crsTransformer.get());
            }
            int fallbackDimension = context.geometryDimension().orElse(2);
            int sourceDimension = this.crsTransformer.map(CrsTransformer::getSourceDimension).orElse(fallbackDimension);
            this.targetDimension = this.crsTransformer.map(CrsTransformer::getTargetDimension).orElse(fallbackDimension);
            this.coordinatesTransformerBuilder.sourceDimension(sourceDimension);
            this.coordinatesTransformerBuilder.targetDimension(this.targetDimension);
            if (context.query().getMaxAllowableOffset() > 0.0) {
                int minPoints = context.geometryType().get() == SimpleFeatureGeometry.MULTI_POLYGON || context.geometryType().get() == SimpleFeatureGeometry.POLYGON ? 4 : 2;
                this.coordinatesTransformerBuilder.maxAllowableOffset(context.query().getMaxAllowableOffset());
                this.coordinatesTransformerBuilder.minNumberOfCoordinates(minPoints);
            }
            if (context.query().getGeometryPrecision().get(0) > 0) {
                this.coordinatesTransformerBuilder.precision(context.query().getGeometryPrecision());
            }
        }
        this.getDownstream().onObjectStart(context);
    }

    @Override
    public void onValue(FeatureEventHandler.ModifiableContext<FeatureSchema, SchemaMapping> context) {
        if (context.inGeometry()) {
            ImmutableCoordinatesTransformer coordinatesTransformer = this.coordinatesTransformerBuilder.coordinatesWriter(ImmutableCoordinatesWriterFeatureTokens.of(this.getDownstream(), this.targetDimension, context)).build();
            try {
                coordinatesTransformer.write(context.value());
                coordinatesTransformer.close();
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        } else {
            String path = context.pathAsString();
            String value = context.value();
            if (!context.valueBuffer().isEmpty()) {
                this.transformValueBuffer(context, path);
            }
            if (Objects.nonNull(value = this.valueTransformerChain.transform(path, value))) {
                context.setValue(value);
                this.getDownstream().onValue(context);
            }
        }
    }

    private void transformValueBuffer(FeatureEventHandler.ModifiableContext<FeatureSchema, SchemaMapping> context, String path) {
        Iterator<Map.Entry<String, String>> it = context.valueBuffer().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, String> entry = it.next();
            String key = entry.getKey();
            if (!key.startsWith(path + ".")) continue;
            String transformed = this.valueTransformerChain.transform(key, entry.getValue());
            if (Objects.nonNull(transformed)) {
                context.putValueBuffer(key, transformed);
                continue;
            }
            it.remove();
        }
    }
}

