/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.domain;

import de.ii.xtraplatform.features.domain.FeatureEventHandler;
import de.ii.xtraplatform.features.domain.FeatureSchema;
import de.ii.xtraplatform.features.domain.FeatureTokenTransformer;
import de.ii.xtraplatform.features.domain.SchemaMapping;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shadow.com.google.common.collect.ImmutableList;

public class FeatureTokenTransformerSorting
extends FeatureTokenTransformer {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeatureTokenTransformerSorting.class);
    private Map<List<String>, Integer> pathOrder;
    private int lastOrder;
    private List<Integer> lastIndexes;

    @Override
    public void onStart(FeatureEventHandler.ModifiableContext<FeatureSchema, SchemaMapping> context) {
        this.pathOrder = new LinkedHashMap<List<String>, Integer>();
        int counter = 0;
        for (List<String> path : ((SchemaMapping)context.mapping()).getTargetSchemasByPath().keySet()) {
            this.pathOrder.put(path, counter);
            LOGGER.warn("{}: {}", (Object)counter, (Object)path);
            ++counter;
        }
        super.onStart(context);
    }

    @Override
    public void onFeatureStart(FeatureEventHandler.ModifiableContext<FeatureSchema, SchemaMapping> context) {
        this.lastIndexes = ImmutableList.of();
        this.lastOrder = 0;
        super.onFeatureStart(context);
    }

    @Override
    public void onObjectStart(FeatureEventHandler.ModifiableContext<FeatureSchema, SchemaMapping> context) {
        if (this.pathOrder.containsKey(context.path())) {
            this.lastOrder = this.pathOrder.get(context.path());
        }
        this.lastIndexes = context.indexes();
        super.onObjectStart(context);
    }

    @Override
    public void onObjectEnd(FeatureEventHandler.ModifiableContext<FeatureSchema, SchemaMapping> context) {
        super.onObjectEnd(context);
    }

    @Override
    public void onArrayStart(FeatureEventHandler.ModifiableContext<FeatureSchema, SchemaMapping> context) {
        super.onArrayStart(context);
    }

    @Override
    public void onArrayEnd(FeatureEventHandler.ModifiableContext<FeatureSchema, SchemaMapping> context) {
        super.onArrayEnd(context);
    }

    @Override
    public void onValue(FeatureEventHandler.ModifiableContext<FeatureSchema, SchemaMapping> context) {
        int order = this.pathOrder.get(context.path());
        if (order > this.lastOrder + 1 && Objects.equals(this.lastIndexes, context.indexes())) {
            LOGGER.warn("{} - {} - waiting for {}", order, context.path(), this.lastOrder + 1);
        }
        this.lastOrder = order;
        super.onValue(context);
    }
}

